/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.metadata;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataBase;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.ast.SQLDatabaseObjectList;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.metadata.ExecSQLEvent;
import com.adbs.metadata.ExecSQLEventListener;
import com.adbs.metadata.GetFieldsEvent;
import com.adbs.metadata.GetMetadataEventListener;
import com.adbs.metadata.GetObjectNamesEvent;
import com.adbs.metadata.GetRelationsEvent;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventMetadataProvider
extends BaseMetadataProvider {
    private static final long serialVersionUID = 1L;
    protected ArrayList<GetMetadataEventListener> getMetadataEventListenerList = new ArrayList();
    protected ArrayList<ExecSQLEventListener> execSQLEventListenerList = new ArrayList();

    public void addGetObjectsNamesEventListener(GetMetadataEventListener listener) {
        this.getMetadataEventListenerList.add(listener);
    }

    public void removeGetObjectsNamesEventListener(GetMetadataEventListener listener) {
        this.getMetadataEventListenerList.remove(listener);
    }

    protected void fireGetTablesEvent(GetObjectNamesEvent evt) {
        Iterator<GetMetadataEventListener> listeners = this.getMetadataEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().getTables(evt);
        }
    }

    protected void fireGetSystemTablesEvent(GetObjectNamesEvent evt) {
        Iterator<GetMetadataEventListener> listeners = this.getMetadataEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().getSystemTables(evt);
        }
    }

    protected void fireGetViewsEvent(GetObjectNamesEvent evt) {
        Iterator<GetMetadataEventListener> listeners = this.getMetadataEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().getViews(evt);
        }
    }

    protected void fireGetSystemViewsEvent(GetObjectNamesEvent evt) {
        Iterator<GetMetadataEventListener> listeners = this.getMetadataEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().getSystemViews(evt);
        }
    }

    protected void fireGetProceduresEvent(GetObjectNamesEvent evt) {
        Iterator<GetMetadataEventListener> listeners = this.getMetadataEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().getProcedures(evt);
        }
    }

    protected void fireGetSystemProceduresEvent(GetObjectNamesEvent evt) {
        Iterator<GetMetadataEventListener> listeners = this.getMetadataEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().getSystemProcedures(evt);
        }
    }

    protected void fireGetSynonymsEvent(GetObjectNamesEvent evt) {
        Iterator<GetMetadataEventListener> listeners = this.getMetadataEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().getSynonyms(evt);
        }
    }

    protected void fireGetSystemSynonymsEvent(GetObjectNamesEvent evt) {
        Iterator<GetMetadataEventListener> listeners = this.getMetadataEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().getSystemSynonyms(evt);
        }
    }

    protected void fireGetFieldsEvent(GetFieldsEvent evt) {
        Iterator<GetMetadataEventListener> listeners = this.getMetadataEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().getFields(evt);
        }
    }

    protected void fireGetRelationsEvent(GetRelationsEvent evt) {
        Iterator<GetMetadataEventListener> listeners = this.getMetadataEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().getRelations(evt);
        }
    }

    public void addExecSQLEventListener(ExecSQLEventListener listener) {
        this.execSQLEventListenerList.add(listener);
    }

    public void removeExecSQLEventListener(ExecSQLEventListener listener) {
        this.execSQLEventListenerList.remove(listener);
    }

    protected void fireExecSQLEvent(ExecSQLEvent evt) {
        Iterator<ExecSQLEventListener> listeners = this.execSQLEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().execSQLEventOccurred(evt);
        }
    }

    @Override
    public String getDescription() {
        return "Event Metadata Provider";
    }

    @Override
    public boolean canExecSQL() {
        return this.execSQLEventListenerList.size() > 0;
    }

    @Override
    protected ResultSet prepareSQLDatasetInternal(String sql, boolean schemaOnly) throws QueryBuilderException {
        ExecSQLEvent evt = new ExecSQLEvent(this, sql, schemaOnly);
        if (this.canExecSQL()) {
            try {
                this.fireExecSQLEvent(evt);
            }
            catch (Exception e) {
                throw new QueryBuilderException(String.format(Helpers.localizer.getString("strErrorExecQuery", "%2$s\n\nQuery:\n%1$s"), sql, e.getMessage()));
            }
        } else {
            evt.resultSet = null;
        }
        return evt.resultSet;
    }

    private void loadObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLDatabaseObjectList objs, Class objectClass, boolean system) {
        MetadataObject mo = null;
        for (int i = 0; i < objs.getCount(); ++i) {
            try {
                Constructor c = objectClass.getConstructor(MetadataBase.class, BaseSQLContext.class);
                mo = (MetadataObject)c.newInstance(metadataContainer, sqlContext);
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            if (mo == null) continue;
            if (objs.get(i).getCount() > 2) {
                SQLQualifiedName db = objs.get(i).clone(sqlContext);
                db.delete(0);
                db.delete(0);
                mo.setDatabase(db);
            }
            if (objs.get(i).getCount() > 1) {
                mo.setSchema((AstTokenIdentifier)objs.get(i).get(1));
            }
            if (objs.get(i).getCount() > 0) {
                mo.setName((AstTokenIdentifier)objs.get(i).get(0));
            }
            mo.setSystem(system);
            if (!metadataFilter.filterMetadataObject(mo)) continue;
            metadataContainer.add(mo);
            mo = null;
        }
        objs.clear();
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) {
        if (Helpers.isQualifiedNameEmpty(database)) {
            SQLDatabaseObjectList objs = new SQLDatabaseObjectList(sqlContext);
            this.fireGetTablesEvent(new GetObjectNamesEvent(this, objs));
            this.loadObjects(sqlContext, metadataContainer, metadataFilter, objs, MetadataTable.class, false);
            this.fireGetSystemTablesEvent(new GetObjectNamesEvent(this, objs));
            this.loadObjects(sqlContext, metadataContainer, metadataFilter, objs, MetadataTable.class, true);
            this.fireGetViewsEvent(new GetObjectNamesEvent(this, objs));
            this.loadObjects(sqlContext, metadataContainer, metadataFilter, objs, MetadataView.class, false);
            this.fireGetSystemViewsEvent(new GetObjectNamesEvent(this, objs));
            this.loadObjects(sqlContext, metadataContainer, metadataFilter, objs, MetadataView.class, true);
            this.fireGetProceduresEvent(new GetObjectNamesEvent(this, objs));
            this.loadObjects(sqlContext, metadataContainer, metadataFilter, objs, MetadataProcedure.class, false);
            this.fireGetSystemProceduresEvent(new GetObjectNamesEvent(this, objs));
            this.loadObjects(sqlContext, metadataContainer, metadataFilter, objs, MetadataProcedure.class, true);
            this.fireGetSynonymsEvent(new GetObjectNamesEvent(this, objs));
            this.loadObjects(sqlContext, metadataContainer, metadataFilter, objs, MetadataSynonym.class, false);
            this.fireGetSystemSynonymsEvent(new GetObjectNamesEvent(this, objs));
            this.loadObjects(sqlContext, metadataContainer, metadataFilter, objs, MetadataSynonym.class, true);
        } else {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) {
        if (Helpers.isQualifiedNameEmpty(database)) {
            for (int i = 0; i < metadataContainer.getCount(); ++i) {
                MetadataObject mo = metadataContainer.get(i);
                this.fireGetRelationsEvent(new GetRelationsEvent(this, mo));
            }
        } else {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataForTable(BaseSQLContext sqlContext, MetadataTable metadataTable) {
        super.loadMetadataForTable(sqlContext, metadataTable);
        this.fireGetFieldsEvent(new GetFieldsEvent(this, metadataTable));
    }

    @Override
    public void loadMetadataForView(BaseSQLContext sqlContext, MetadataView metadataView) {
        super.loadMetadataForView(sqlContext, metadataView);
        this.fireGetFieldsEvent(new GetFieldsEvent(this, metadataView));
    }

    @Override
    public void loadMetadataForProcedure(BaseSQLContext sqlContext, MetadataProcedure metadataProcedure) {
        super.loadMetadataForProcedure(sqlContext, metadataProcedure);
        this.fireGetFieldsEvent(new GetFieldsEvent(this, metadataProcedure));
    }

    @Override
    public void loadMetadataForSynonym(BaseSQLContext sqlContext, MetadataSynonym metadataSynonym) {
        super.loadMetadataForSynonym(sqlContext, metadataSynonym);
        this.fireGetFieldsEvent(new GetFieldsEvent(this, metadataSynonym));
    }

    static {
        Helpers.metadataProviderList.registerMetadataProvider(EventMetadataProvider.class);
    }
}

