/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataBase;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataRelationList;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetadataSynonym
extends MetadataObject {
    private SQLQualifiedName referencedDatabase;
    private AstTokenIdentifier referencedSchema;
    private AstTokenIdentifier referencedName;
    private SQLQualifiedName referencedSchemedName;
    private SQLQualifiedName referencedFullName;

    public MetadataSynonym(MetadataBase parent, BaseSQLContext sqlContext) {
        super(parent, sqlContext);
        this.referencedDatabase = new SQLQualifiedName(sqlContext);
        this.referencedSchema = new AstTokenIdentifier(sqlContext);
        this.referencedName = new AstTokenIdentifier(sqlContext);
        this.referencedSchemedName = new SQLQualifiedName(sqlContext);
        this.referencedFullName = new SQLQualifiedName(sqlContext);
    }

    @Override
    public void dispose() {
        this.referencedDatabase.dispose();
        this.referencedSchema.dispose();
        this.referencedName.dispose();
        this.referencedSchemedName.dispose();
        this.referencedFullName.dispose();
        super.dispose();
    }

    public SQLQualifiedName getReferencedDatabase() {
        return this.referencedDatabase;
    }

    public void setReferencedDatabase(SQLQualifiedName value) {
        if (value != null) {
            this.referencedDatabase.assign(value);
        } else {
            this.referencedDatabase.clear();
        }
        this.updateReferencedFullName();
        this.notifyUpdated();
    }

    public AstTokenIdentifier getReferencedSchema() {
        return this.referencedSchema;
    }

    public void setReferencedSchema(AstTokenIdentifier value) {
        if (value != null) {
            this.referencedSchema.assign(value);
        } else {
            this.referencedSchema.clear();
        }
        this.updateReferencedFullName();
        this.notifyUpdated();
    }

    public AstTokenIdentifier getReferencedName() {
        return this.referencedName;
    }

    public void setReferencedName(AstTokenIdentifier value) {
        if (value != null) {
            this.referencedName.assign(value);
        } else {
            this.referencedName.clear();
        }
        this.updateReferencedFullName();
        this.notifyUpdated();
    }

    public SQLQualifiedName getReferencedSchemedName() {
        return this.referencedSchemedName;
    }

    public SQLQualifiedName getReferencedFullName() {
        return this.referencedFullName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReferencedFullName(SQLQualifiedName value) {
        this.beginUpdate();
        try {
            if (Helpers.isQualifiedNameEmpty(value)) {
                this.setReferencedName(null);
                this.setReferencedSchema(null);
                this.setReferencedDatabase(null);
            } else {
                AstTokenIdentifier name = (AstTokenIdentifier)Helpers.extractNameFromFullName(value);
                try {
                    AstTokenIdentifier schema = (AstTokenIdentifier)Helpers.extractSchemaFromFullName(value);
                    try {
                        SQLQualifiedName db = Helpers.extractDatabaseFromFullName(value);
                        try {
                            this.setReferencedName(name);
                            this.setReferencedSchema(schema);
                            this.setReferencedDatabase(db);
                        }
                        finally {
                            if (db != null) {
                                db.dispose();
                            }
                        }
                    }
                    finally {
                        if (schema != null) {
                            schema.dispose();
                        }
                    }
                }
                finally {
                    if (name != null) {
                        name.dispose();
                    }
                }
            }
            this.updateReferencedFullName();
            this.notifyUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    public MetadataObject getReferencedObject() {
        if (!this.getReferencedName().isEmpty()) {
            return this.getMetadataContainer().findByNameAndClass(this.getReferencedName(), this.getReferencedSchema(), this.getReferencedDatabase(), MetadataObject.class);
        }
        return null;
    }

    public void updateReferencedFullName() {
        this.referencedSchemedName.clear();
        if (!this.referencedSchema.isEmpty()) {
            this.referencedSchemedName.insert(0, this.referencedSchema.clone(this.sqlContext));
        }
        this.referencedSchemedName.insert(0, this.referencedName.clone(this.sqlContext));
        this.referencedFullName.clear();
        this.referencedFullName.assign(this.referencedDatabase);
        if (!this.referencedSchema.isEmpty()) {
            this.referencedFullName.insert(0, this.referencedSchema.clone(this.sqlContext));
        }
        this.referencedFullName.insert(0, this.referencedName.clone(this.sqlContext));
    }

    @Override
    public MetadataFieldList getFields() {
        if (this.getReferencedObject() != null) {
            return this.getReferencedObject().getFields();
        }
        return super.getFields();
    }

    @Override
    public void setFields(MetadataFieldList value) {
        if (this.getReferencedObject() != null) {
            this.getReferencedObject().setFields(value);
        } else {
            super.setFields(value);
        }
    }

    @Override
    public MetadataRelationList getRelations() {
        if (this.getReferencedObject() != null) {
            return this.getReferencedObject().getRelations();
        }
        return super.getRelations();
    }

    @Override
    public void setRelations(MetadataRelationList value) {
        if (this.getReferencedObject() != null) {
            this.getReferencedObject().setRelations(value);
        } else {
            super.setRelations(value);
        }
    }

    @Override
    String getXMLItemName() {
        return "synonym";
    }

    @Override
    Element getXMLNode(Document doc, String nodeName) {
        Element result = super.getXMLNode(doc, nodeName);
        if (this.getReferencedDatabase().getCount() != 0) {
            result.appendChild(this.getReferencedDatabase().getXMLNode(doc, "ref_database", "item"));
        }
        if (!this.getReferencedSchema().isEmpty()) {
            result.appendChild(this.getReferencedSchema().getXMLNode(doc, "ref_schema"));
        }
        if (!this.getReferencedName().isEmpty()) {
            result.appendChild(this.getReferencedName().getXMLNode(doc, "ref_name"));
        }
        return result;
    }

    @Override
    void loadFromXMLNode(Node node) {
        super.loadFromXMLNode(node);
        Element child = Helpers.findChildElByName("ref_database", node);
        if (child != null) {
            this.getReferencedDatabase().loadFromXMLNode(child, "item");
        }
        if ((child = Helpers.findChildElByName("ref_schema", node)) != null) {
            this.getReferencedSchema().loadFromXMLNode(child);
        }
        if ((child = Helpers.findChildElByName("ref_name", node)) != null) {
            this.getReferencedName().loadFromXMLNode(child);
        }
        this.updateReferencedFullName();
    }

    @Override
    public void assign(Object source) {
        this.beginUpdate();
        try {
            super.assign(source);
            if (source instanceof MetadataSynonym) {
                this.setReferencedDatabase(((MetadataSynonym)source).getReferencedDatabase());
                this.setReferencedSchema(((MetadataSynonym)source).getReferencedSchema());
                this.setReferencedName(((MetadataSynonym)source).getReferencedName());
                this.updateReferencedFullName();
                this.notifyUpdated();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    protected void loadFieldsInternal() throws QueryBuilderException {
        if (this.getReferencedObject() != null) {
            this.getReferencedObject().loadFields();
        } else {
            this.sqlContext.loadMetadataForSynonym(this);
        }
    }

    @Override
    public String getQueryToLoadFields(String fieldName) {
        assert (this.sqlContext.getSyntaxProvider() != null);
        return this.sqlContext.getSyntaxProvider().getQueryToLoadFieldsForSynonym(fieldName, this.getFullName().getQualifiedNameForServer());
    }
}

