/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DeploymentModuleIO;
import oracle.jdeveloper.deploy.DeploymentModuleIOFactory;
import oracle.jdevimpl.deploy.fwk.JarIO;
import oracle.jdevimpl.deploy.stripe.AbstractModuleIO;

public class JarModuleIO
extends AbstractModuleIO {
    DeploymentModuleJarIO jarIO_ = new DeploymentModuleJarIO(this);

    @Override
    public void commitImpl() throws IOException {
        this.jarIO_.setCompressed(this.archive_.isCompressed());
        this.jarIO_.setCompressionLevel(this.archive_.getCompressionLevel());
        this.jarIO_.write(this.archive_, this.getURL(), this.archive_.getPrintWriter());
    }

    @Override
    public void rollback() {
    }

    @Override
    public void load(URL url) {
    }

    @Override
    public void load() {
    }

    @Override
    public boolean isArchiveReadOnly() {
        return false;
    }

    public static class DeploymentModuleJarIO
    extends JarIO {
        AbstractModuleIO moduleIO_;

        public DeploymentModuleJarIO(AbstractModuleIO moduleIO) {
            this.moduleIO_ = moduleIO;
        }

        @Override
        protected InputStream openInputStream(ArchiveEntry entry) throws IOException {
            return this.moduleIO_.openInputStream(entry);
        }

        @Override
        protected boolean canAddEntry(ArchiveEntry entry) {
            return entry != null && ModelUtil.hasLength((String)entry.getName());
        }
    }

    public static class JarModuleIOFactory
    implements DeploymentModuleIOFactory {
        @Override
        public DeploymentModuleIO create(String moduleIO) {
            if ("Persistence.FILE".equals(moduleIO)) {
                return new JarModuleIO();
            }
            return null;
        }
    }
}

