/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.spi;

import oracle.ide.Context;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.ProfileStorage;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.spi.NonmigratedProfile;
import oracle.jdeveloper.deploy.spi.providers.AbstractHashProfileIOProvider;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public class NonmigratedHashProfileIOProvider
extends AbstractHashProfileIOProvider {
    private boolean isNonmigratedProfileEnabled(Context ctx) {
        return NonmigratedProfile.isEnabledInContext(ctx);
    }

    @Override
    protected boolean canRead(Element element, HashStructure hash, ToolkitContext tkCtx, Cookie cookie) {
        if (!this.isNonmigratedProfileEnabled(tkCtx.getIdeContext())) {
            return false;
        }
        if (!(element instanceof DataContainer) && !(element instanceof ProfileStorage)) {
            return false;
        }
        String profileName = hash.getString(Profile.PROFILE_NAME);
        return ModelUtil.hasLength((String)profileName);
    }

    @Override
    protected boolean canWrite(Element element, Profile profile, ToolkitContext tkCtx, Cookie cookie) {
        if (!this.isNonmigratedProfileEnabled(tkCtx.getIdeContext())) {
            return false;
        }
        return profile != null;
    }

    @Override
    protected Profile read(Element element, HashStructure hash, Cookie cookie) {
        assert (element instanceof DataContainer || element instanceof ProfileStorage);
        NonmigratedProfile profile = new NonmigratedProfile(hash);
        if (element instanceof ProfileStorage) {
            profile.setDataContainer(((ProfileStorage)element).getDataContainer());
        }
        if (element instanceof DataContainer) {
            profile.setDataContainer((DataContainer)element);
        }
        return profile;
    }

    @Override
    protected String getName(Element element, HashStructure hash, Cookie cookie) {
        return hash.getString(Profile.PROFILE_NAME);
    }

    @Override
    protected void write(Element element, Profile profile, HashStructure hash, Cookie cookie) {
        profile.getHashStructure().copyTo(hash);
    }
}

