/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.HeadlessMigratorUtil;
import oracle.ide.model.Node;
import oracle.ide.util.Assert;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployShellFactory;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.DeployerListener;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.DeploymentModuleFactory;
import oracle.jdeveloper.deploy.ListenerCondition;
import oracle.jdeveloper.deploy.PlatformDeployable;
import oracle.jdeveloper.deploy.Runnable;
import oracle.jdeveloper.deploy.StatefulDeployment;
import oracle.jdeveloper.deploy.common.BatchDeployer;
import oracle.jdeveloper.deploy.common.DynamicDeployer;
import oracle.jdeveloper.deploy.contrib.ProcessorCache;
import oracle.jdeveloper.deploy.meta.CustomMetaClass;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformRegistry;
import oracle.jdeveloper.deploy.shell.ShellAdapter;
import oracle.jdeveloper.deploy.spi.DefaultDeployShellFactory;
import oracle.jdeveloper.deploy.spi.ProgressEvent;
import oracle.jdeveloper.deploy.spi.ProgressListener;
import oracle.jdevimpl.deploy.fwk.DeployerFactoryStore;
import oracle.jdevimpl.deploy.fwk.ListenerSupport;
import oracle.jdevimpl.deploy.fwk.RunnableImpl;
import oracle.jdevimpl.deploy.fwk.SequenceDeployer;
import oracle.jdevimpl.deploy.fwk.SuperDeployer;
import oracle.jdevimpl.deploy.fwk.TopLevelDeployer;
import oracle.jdevimpl.deploy.res.FwkArb;
import oracle.jdevimpl.deploy.stripe.DeploymentModuleFactoryStore;

public class DeploymentManager {
    final ListenerSupport listenerSupport_ = new ListenerSupport();
    final DeployerFactoryStore factoryStore_ = new DeployerFactoryStore();
    private static final String DEPLOYER = "Deployment.TopLevelDeployer";
    private final DeploymentModuleFactoryStore deployModuleFactoryStore_ = new DeploymentModuleFactoryStore();
    private static final String DEBUG_REGEX = System.getProperty("deployment.debug");

    public DeploymentManager() {
        DefaultDeployShellFactory.getInstance().registerConfigurator(new ShellConfigurator());
    }

    public ListenerSupport getProfileListenerSupport() {
        return this.listenerSupport_;
    }

    public void addDeployerListener(ListenerCondition condition, DeployerListener listener, double priority) {
        this.listenerSupport_.addListener(condition, listener, priority);
    }

    public void removeDeployerListener(DeployerListener listener) {
        this.listenerSupport_.removeListener(listener);
    }

    public boolean removeDeployerListener(ListenerCondition condition, DeployerListener listener) {
        return this.listenerSupport_.removeListener(listener, condition);
    }

    public DeployerFactoryStore getDeployerFactoryStore() {
        return this.factoryStore_;
    }

    public void deploy(int deploySequenceId, Context context) throws Exception {
        DeployShell shell = this.createRootDeployShell(deploySequenceId, context);
        this.deploy(deploySequenceId, shell);
    }

    public void deploy(int deploySequence, Context context, DeployShellFactory factory) throws Exception {
        DeployShell shell = this.createDeployShell(deploySequence, context, factory);
        this.deploy(deploySequence, shell);
    }

    public void deploy(int deploySequence, Context context, DeployShellFactory factory, Object lock) throws DeployException {
        DeployShell shell = this.createDeployShell(deploySequence, context, factory);
        this.deploy(deploySequence, shell, lock);
    }

    private DeployShell createDeployShell(int sequence, Context context, DeployShellFactory factory) throws DeployException {
        DeployShell defaultShell = this.createRootDeployShell(sequence, context);
        DeployShell shell = factory.create(sequence, context, defaultShell);
        return shell;
    }

    public Runnable createRunnable(int deploySequence, final DeployShell shell) {
        DeploymentProgressShellAdapter dpsa = new DeploymentProgressShellAdapter(shell);
        RunnableImpl runner = dpsa.initRunnableIfNeeded(deploySequence, shell);
        runner.addProgressListener(new ProgressListener(){

            @Override
            public void handleEvent(ProgressEvent dpe) {
                if (dpe.getType().equals(ProgressEvent.CANCEL_EVENT_TYPE)) {
                    shell.getLogger().severe(FwkArb.getString(7));
                }
            }
        });
        return runner;
    }

    public Runnable deploy(int deploySequence, DeployShell shell, Object obj) {
        final Runnable runner = this.createRunnable(deploySequence, shell);
        final Object lock = obj == null ? shell.getContext() : obj;
        Assert.check((boolean)DeploymentManager.printDebug("deployment.deploy.lock.object", "<class>" + lock.getClass() + "</class><object>" + lock + "</object>"));
        Thread t = new Thread("Deployment" + new Random().nextInt()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    try {
                        runner.run();
                    }
                    finally {
                        lock.notifyAll();
                    }
                }
            }
        };
        t.start();
        return runner;
    }

    private void printUnwrappedExceptionMessage(Throwable e, Logger logger) {
        Throwable t = e.getCause();
        if (t != null && t != e) {
            if (ModelUtil.hasLength((String)e.getMessage()) && !e.getMessage().equals(t.toString())) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.printUnwrappedExceptionMessage(t, logger);
        } else {
            Object o;
            StringBuffer s = new StringBuffer();
            if (e instanceof DeployException && (o = ((DeployException)e).getSource()) != null) {
                String name = null;
                try {
                    Method getName = o.getClass().getMethod("getName", new Class[0]);
                    Object ret = getName.invoke(o, new Object[0]);
                    if (ret != null) {
                        name = ret.toString();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                name = name == null ? o.getClass().getName() : name;
                s.append(" (");
                s.append(name);
                s.append(")");
            }
            logger.log(Level.SEVERE, e.getMessage() + s.toString(), e);
        }
    }

    public void deploy(int deploySequenceId, DeployShell shell) throws Exception {
        try {
            this.deployImpl(deploySequenceId, shell);
        }
        catch (DeployException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void deployImpl(int deploySequenceId, DeployShell shell) throws Exception {
        boolean isStateful = ShellAdapter.getInstance(shell).isStatefulDeployment();
        HeadlessMigratorUtil.checkAndSetSysPropForDoNoMigration((Node)ShellAdapter.getInstance(shell).getContext().getWorkspace());
        Deployer deployer = null;
        if (isStateful) {
            StatefulDeployment state = StatefulDeployment.getStatefulDeployment(shell);
            assert (state != null);
            assert (state.getDeployer() != null);
            deployer = state.getDeployer();
        } else {
            deployer = this.createDeployer(deploySequenceId, shell);
        }
        int stackLen = shell.getSequenceStack().getLength();
        ProcessorCache.install(shell.getContext());
        try {
            deployer.prepare(deploySequenceId, shell);
            Assert.check((shell.getSequenceStack().getLength() == stackLen ? 1 : 0) != 0, (String)("Sequence stack error: missing pop() in prepare: " + shell.getSequenceStack().getLength()));
            deployer.deploy(deploySequenceId, shell);
            Assert.check((shell.getSequenceStack().getLength() == stackLen ? 1 : 0) != 0, (String)("Sequence stack error: missing pop() in deploy: " + shell.getSequenceStack().getLength()));
        }
        catch (DeployException e) {
            shell.setDeployException(e);
            deployer.cancel(deploySequenceId, shell);
            throw e;
        }
        finally {
            deployer.finish(deploySequenceId, shell);
            ProcessorCache.uninstall(shell.getContext());
        }
    }

    public Deployer createDeployer(int deploySequenceId, DeployShell shell) throws Exception {
        Element elementToDeploy = ShellAdapter.getInstance(shell).getDeployElement();
        if (elementToDeploy == null) {
            Element element = shell.getContext().getElement();
            if (element == null) {
                throw new DeployException("Nothing to deploy");
            }
            Assert.printStackTrace((boolean)false, (String)"Warning: Element.getData() returns null");
            elementToDeploy = element;
        }
        String elementClass = elementToDeploy.getClass().getName();
        Assert.check((boolean)DeploymentManager.printDebug("deployment.deploy.element", "<class>" + elementClass + "</class><element>" + elementToDeploy + "</element>"));
        Deployer deployer = this.resolveDeployer(deploySequenceId, new DynamicDeployer(deploySequenceId), elementClass, shell);
        if (deploySequenceId != DeploymentConstants.DEFAULT_SEQUENCE) {
            deployer = new TopLevelDeployer(deployer);
        }
        return deployer;
    }

    private Deployer resolveDeployer(int deploySequence, Deployer deployer, String current, DeployShell shell) throws Exception {
        if (deployer == null) {
            this.assertNotNullDeployer(deployer, deploySequence);
        }
        if (deployer instanceof SuperDeployer) {
            String parent = this.factoryStore_.getParentClass(current);
            if (parent == null) {
                throw new MetadataException(FwkArb.format(4, this.getDeploymentSequenceName(deploySequence)));
            }
            int newSequence = ((SuperDeployer)deployer).getSequenceId();
            Assert.check((boolean)DeploymentManager.printDebug("deployment.resolve.find.begin", "<find label=\"" + parent + "\" sequence=\"" + this.getDeploymentSequenceName(newSequence) + "\" />"));
            deployer = this.factoryStore_.findDeployer(parent, newSequence, shell);
            Assert.check((boolean)DeploymentManager.printDebug("deployment.resolve.find.end", "<result><deployer>" + deployer + "</deployer></result>"));
            deployer = this.resolveDeployer(newSequence, deployer, parent, shell);
        } else if (deployer instanceof DynamicDeployer) {
            int newSequence = ((DynamicDeployer)deployer).getSequenceId();
            Assert.check((boolean)DeploymentManager.printDebug("deployment.resolve.find.begin", "<find label=\"" + current + "\" sequence=\"" + this.getDeploymentSequenceName(newSequence) + "\" />"));
            deployer = this.factoryStore_.findDeployer(current, newSequence, shell);
            Assert.check((boolean)DeploymentManager.printDebug("deployment.resolve.find.end", "<result><deployer>" + deployer + "</deployer></result>"));
            deployer = this.resolveDeployer(newSequence, deployer, current, shell);
        } else if (deployer instanceof BatchDeployer) {
            int newSequence = ((BatchDeployer)deployer).getSequenceId();
            deployer = this.resolveBatchDeployer(newSequence, (BatchDeployer)deployer, current, shell);
        }
        if (!deployer.canDeploy(deploySequence)) {
            deployer = new SequenceDeployer(deploySequence, deployer);
        }
        return deployer;
    }

    private Deployer resolveBatchDeployer(int deploySequence, Deployer deployer, String current, DeployShell shell) throws Exception {
        Deployer[] deployers = ((BatchDeployer)deployer).getDeployers();
        for (int i = 0; i < deployers.length; ++i) {
            if (deployers[i] instanceof SuperDeployer) {
                deployers[i] = this.resolveDeployer(deploySequence, deployers[i], current, shell);
                continue;
            }
            if (deployers[i] instanceof DynamicDeployer) {
                DynamicDeployer dyn = (DynamicDeployer)deployers[i];
                deployers[i] = this.resolveDeployer(dyn.getSequenceId(), dyn, current, shell);
                continue;
            }
            if (!(deployers[i] instanceof BatchDeployer)) continue;
            BatchDeployer batch = (BatchDeployer)deployers[i];
            deployers[i] = this.resolveBatchDeployer(batch.getSequenceId(), (BatchDeployer)deployers[i], current, shell);
        }
        if (!deployer.canDeploy(deploySequence)) {
            deployer = new SequenceDeployer(deploySequence, deployer);
        }
        return deployer;
    }

    private void assertNotNullDeployer(Deployer deployer, int sequenceId) throws MetadataException {
        if (deployer == null) {
            throw new MetadataException(FwkArb.format(5, this.getDeploymentSequenceName(sequenceId)));
        }
    }

    public DeployShell createRootDeployShell(int deploySequence, Context context) throws DeployException {
        return DeployShellFactory.getInstance().create(deploySequence, context, (DeployShell)null);
    }

    @Deprecated
    public void registerDeployerFactory(MetaClass clazz, MetaClass parentClazz, CustomMetaClass factory) throws MetadataException {
        this.registerDeployerFactory(clazz.getClassName(), parentClazz != null ? parentClazz.getClassName() : null, (CustomMetaClass<DeployerFactory>)factory);
    }

    public void registerDeployerFactory(String clazz, String parentClazz, CustomMetaClass<DeployerFactory> factory) throws MetadataException {
        this.factoryStore_.addFactory(clazz, parentClazz, factory);
    }

    @Deprecated
    public void upgradeDeployerFactory(MetaClass clazz, CustomMetaClass<DeployerFactory> factory) throws MetadataException {
        this.upgradeDeployerFactory(clazz.getClassName(), factory);
    }

    public void upgradeDeployerFactory(String clazz, CustomMetaClass<DeployerFactory> factory) throws MetadataException {
        this.factoryStore_.upgradeFactory(clazz, factory);
    }

    public void registerDeploymentModuleFactory(String elementClass, DeploymentModuleFactory factory) throws MetadataException {
        this.deployModuleFactoryStore_.addFactory(elementClass, factory);
    }

    public void upgradeDeploymentModuleFactory(String elementClass, DeploymentModuleFactory factory) throws MetadataException {
        this.deployModuleFactoryStore_.upgradeFactory(elementClass, factory);
    }

    private String getDeploymentSequenceName(int id) {
        return oracle.jdeveloper.deploy.DeploymentManager.getDeploymentSequenceName(id);
    }

    public static boolean printDebug(String prefix, String msg) {
        if (DEBUG_REGEX != null && prefix.matches(DEBUG_REGEX)) {
            System.out.println("DEBUG <step prefix=\"" + prefix + "\">" + msg + "</step>");
            System.out.flush();
        }
        return true;
    }

    private class ShellConfigurator
    implements DefaultDeployShellFactory.Configurator {
        private ShellConfigurator() {
        }

        @Override
        public void configure(DeployShell shell) throws DeployException {
            ShellAdapter sa = ShellAdapter.getInstance(shell);
            Platform platform = sa.getPlatform();
            if (platform == null) {
                if (platform == null) {
                    Element element = sa.getContext().getElement();
                    if (element instanceof PlatformDeployable) {
                        platform = ((PlatformDeployable)element).getPlatform();
                        if (platform == null && (platform = PlatformRegistry.getDefaultPlatform()) == null) {
                            throw new DeployException("Could not determine a Platform");
                        }
                        sa.setPlatform(platform);
                    }
                } else {
                    sa.setPlatform(platform);
                }
            }
        }
    }

    private class DeploymentProgressShellAdapter
    extends ShellAdapter {
        public DeploymentProgressShellAdapter(DeployShell shell) {
            super(shell);
        }

        public RunnableImpl initRunnableIfNeeded(final int deploySequence, final DeployShell shell) {
            RunnableImpl runner = (RunnableImpl)this.getRoot().get("Deployment.runnableObject");
            if (runner == null) {
                runner = new RunnableImpl(deploySequence, shell){

                    @Override
                    protected void deploy(DeployShell dsh) throws Exception {
                        try {
                            DeploymentManager.this.deploy(deploySequence, dsh);
                        }
                        catch (Exception e) {
                            this.printUnwrappedExceptionMessage(e, shell.getLogger());
                            throw e;
                        }
                    }
                };
                this.getRoot().put("Deployment.runnableObject", runner);
            }
            return runner;
        }
    }
}

