/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.ide.util.Assert;

public class CustomMetaClass<T> {
    final MetaClass<T> metaClass;
    final Class[] argTypes;
    final Object[] args;
    private volatile WeakReference<T> ref;
    static final boolean cachingDisabled = Boolean.getBoolean(CustomMetaClass.class.getName() + ".instanceCache");

    public CustomMetaClass(MetaClass<T> metaClass, Class[] argTypes, Object[] args) {
        this.metaClass = metaClass;
        this.argTypes = argTypes;
        this.args = args;
    }

    public CustomMetaClass(Class template, Object[] args) {
        this(template, CustomMetaClass.makeArgTypes(args), args);
    }

    public CustomMetaClass(Class template, Class[] argTypes, Object[] args) {
        this(CustomMetaClass.makeMetaClass(template.getClassLoader(), template.getName()), argTypes, args);
    }

    public CustomMetaClass(MetaClass<T> metaClass, Object[] args) {
        this(metaClass, CustomMetaClass.makeArgTypes(args), args);
    }

    public CustomMetaClass(MetaClass<T> metaClass) {
        this(metaClass, new Class[0], new Object[0]);
    }

    public CustomMetaClass(ClassLoader classLoader, String className, Class[] argTypes, Object[] args) {
        this(CustomMetaClass.makeMetaClass(classLoader, className), argTypes, args);
    }

    public CustomMetaClass(ClassLoader classLoader, String className, Object[] args) {
        this(CustomMetaClass.makeMetaClass(classLoader, className), args);
    }

    public CustomMetaClass(ClassLoader classLoader, String className) {
        this(CustomMetaClass.makeMetaClass(classLoader, className));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T newInstanceEx() throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class clazz = this.metaClass.toClass();
        Constructor ctor = clazz.getDeclaredConstructor(this.argTypes);
        boolean access = ctor.isAccessible();
        try {
            ctor.setAccessible(true);
            Object t = ctor.newInstance(this.args);
            return t;
        }
        finally {
            ctor.setAccessible(access);
        }
    }

    public T newInstance() {
        try {
            return this.newInstanceEx();
        }
        catch (ClassNotFoundException e) {
            this.printInstantiationError(e);
        }
        catch (InstantiationException e) {
            this.printInstantiationError(e);
        }
        catch (IllegalAccessException e) {
            this.printInstantiationError(e);
        }
        catch (NoSuchMethodException e) {
            this.printInstantiationError(e);
        }
        catch (InvocationTargetException e) {
            this.printInstantiationError(e);
        }
        return null;
    }

    public T getInstance() {
        Object ret;
        if (cachingDisabled) {
            return this.newInstance();
        }
        Object t = ret = this.ref == null ? null : (Object)this.ref.get();
        if (ret == null) {
            ret = this.newInstance();
            this.ref = new WeakReference<Object>(ret);
        }
        return ret;
    }

    public T getInstanceEx() throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object ret;
        if (cachingDisabled) {
            return this.newInstanceEx();
        }
        Object t = ret = this.ref == null ? null : (Object)this.ref.get();
        if (ret == null) {
            ret = this.newInstanceEx();
            this.ref = new WeakReference<Object>(ret);
        }
        return ret;
    }

    private static Class[] makeArgTypes(Object[] args) {
        Class[] ret = new Class[args.length];
        int sz = args.length;
        for (int i = 0; i < sz; ++i) {
            ret[i] = args[i].getClass();
        }
        return ret;
    }

    private static MetaClass makeMetaClass(ClassLoader classLoader, String className) {
        return new MetaClass(classLoader, className);
    }

    public MetaClass<T> getMetaClass() {
        return this.metaClass;
    }

    public Class[] getArgTypes() {
        return this.argTypes;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Class<T> toClass() throws ClassNotFoundException {
        return this.metaClass.toClass();
    }

    public String getClassName() {
        return this.metaClass.getClassName();
    }

    public ClassLoader getClassLoader() {
        return this.metaClass.getClassLoader();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomMetaClass)) {
            return false;
        }
        CustomMetaClass cmc = (CustomMetaClass)obj;
        return this.metaClass.equals(cmc.metaClass) && Arrays.equals(this.argTypes, cmc.argTypes) && Arrays.equals(this.args, cmc.args);
    }

    private void printInstantiationError(Exception e) {
        Logger.getLogger(CustomMetaClass.class.getName()).log(Level.SEVERE, "Unable to instantiate " + this.metaClass.getClassName(), e);
        Assert.printStackTrace((String)("Unable to instantiate " + this.metaClass + ":" + String.valueOf(e)));
    }

    public static boolean isAssignable(MetaClass to, Class from) {
        String mcName = to.getClassName();
        return CustomMetaClass.isMatchingAncestorName(mcName, from);
    }

    private static boolean isMatchingAncestorName(String mcName, Class start) {
        if (start == null || start == Object.class) {
            return false;
        }
        if (mcName.equals(start.getName())) {
            return true;
        }
        if (CustomMetaClass.isMatchingAncestorName(mcName, start.getSuperclass())) {
            return true;
        }
        for (Class<?> cls : start.getInterfaces()) {
            if (!CustomMetaClass.isMatchingAncestorName(mcName, cls)) continue;
            return true;
        }
        return false;
    }
}

