/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.util.Arrays;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.StateException;
import oracle.jdeveloper.deploy.StatefulDeployer;
import oracle.jdeveloper.deploy.common.AbstractStatefulDeployer;
import oracle.jdeveloper.deploy.common.DynamicDeployer;
import oracle.jdeveloper.deploy.contrib.Listener;
import oracle.jdeveloper.deploy.eventhub.EventHandler;
import oracle.jdeveloper.deploy.events.DeployerStateChange;
import oracle.jdevimpl.deploy.fwk.DeploymentManager;

public final class BatchDeployer
extends AbstractStatefulDeployer {
    private final Deployer[] deployers_;
    private final boolean[] deployerPrepared_;
    private final StatefulDeployer.Handle[] listeners_;
    private final boolean[] invalidatedDeployers_;
    private boolean invalidated_ = false;
    private boolean stateListenersEnabled = false;

    public BatchDeployer(int deploySequenceId, int[] deploySequenceIds) {
        super(deploySequenceId);
        Assert.check((deploySequenceIds != null ? 1 : 0) != 0, (String)"Illegal argument: Parameter deployers canot be null");
        this.deployers_ = new Deployer[deploySequenceIds.length];
        this.listeners_ = new StatefulDeployer.Handle[this.deployers_.length];
        this.invalidatedDeployers_ = new boolean[this.deployers_.length];
        for (int i = 0; i < deploySequenceIds.length; ++i) {
            int id = deploySequenceIds[i];
            Assert.check((id != deploySequenceId ? 1 : 0) != 0, (String)"BatchDeployer Id cannot be same as its children.");
            this.deployers_[i] = new DynamicDeployer(deploySequenceIds[i]);
        }
        this.deployerPrepared_ = new boolean[this.deployers_.length];
    }

    public Deployer[] getDeployers() {
        return this.deployers_;
    }

    @Override
    public void prepareImpl(int deploySequenceId, DeployShell shell) throws DeployException {
        for (int i = 0; i < this.deployers_.length; ++i) {
            this.deployerPrepared_[i] = true;
            Assert.check((boolean)DeploymentManager.printDebug("deployer.prepare.begin", this + "(" + i + " of " + this.deployers_.length + ")"));
            this.deployers_[i].prepare(deploySequenceId, shell);
            Assert.check((boolean)DeploymentManager.printDebug("deployer.prepare.end", this + "(" + i + " of " + this.deployers_.length + ")"));
        }
    }

    @Override
    public void deployImpl(int deploySequenceId, DeployShell shell) throws DeployException {
        for (int i = 0; i < this.deployers_.length; ++i) {
            Assert.check((boolean)DeploymentManager.printDebug("deployer.deploy.begin", this + "(" + i + " of " + this.deployers_.length + ")"));
            this.deployers_[i].deploy(deploySequenceId, shell);
            Assert.check((boolean)DeploymentManager.printDebug("deployer.deploy.end", this + "(" + i + " of " + this.deployers_.length + ")"));
        }
    }

    @Override
    public void finishImpl(int deploySequenceId, DeployShell shell) {
        for (int i = 0; i < this.deployers_.length; ++i) {
            if (!this.deployerPrepared_[i]) continue;
            Assert.check((boolean)DeploymentManager.printDebug("deployer.finish.begin", this + "(" + i + " of " + this.deployers_.length + ")"));
            this.deployers_[i].finish(deploySequenceId, shell);
            Assert.check((boolean)DeploymentManager.printDebug("deployer.finish.end", this + "(" + i + " of " + this.deployers_.length + ")"));
        }
    }

    @Override
    public void cancelImpl(int deploySequenceId, DeployShell shell) {
        for (int i = this.deployers_.length - 1; i >= 0; --i) {
            if (!this.deployerPrepared_[i]) continue;
            Assert.check((boolean)DeploymentManager.printDebug("deployer.cancel.end", this + "(" + i + " of " + this.deployers_.length + ")"));
            this.deployers_[i].cancel(deploySequenceId, shell);
            Assert.check((boolean)DeploymentManager.printDebug("deployer.cancel.end", this + "(" + i + " of " + this.deployers_.length + ")"));
        }
    }

    @Override
    public boolean canDeploy(int deploySequenceId) {
        boolean ret = super.canDeploy(deploySequenceId);
        if (!ret) {
            for (int i = 0; i < this.deployers_.length && !(ret = this.deployers_[i].canDeploy(deploySequenceId)); ++i) {
            }
        }
        return ret;
    }

    @Override
    public String toString() {
        return super.toString() + " " + Arrays.toString(this.deployers_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeState() throws StateException {
        Object object = this.stateLockObject();
        synchronized (object) {
            this.disableListeners();
            for (int i = 0; i < this.deployers_.length; ++i) {
                if (!(this.deployers_[i] instanceof StatefulDeployer)) continue;
                StatefulDeployer hasState = (StatefulDeployer)this.deployers_[i];
                hasState.initializeState();
            }
            this.enableListeners();
            super.initializeState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateState() throws StateException {
        this.disableListeners();
        Object object = this.stateLockObject();
        synchronized (object) {
            for (int i = 0; i < this.deployers_.length; ++i) {
                if (!(this.deployers_[i] instanceof StatefulDeployer) || this.invalidatedDeployers_[i]) continue;
                StatefulDeployer hasState = (StatefulDeployer)this.deployers_[i];
                hasState.invalidateState();
            }
            this.invalidated_ = true;
            super.invalidateState();
        }
        this.enableListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseState() {
        Object object = this.stateLockObject();
        synchronized (object) {
            this.disableListeners();
            for (int i = 0; i < this.deployers_.length; ++i) {
                if (!(this.deployers_[i] instanceof StatefulDeployer)) continue;
                StatefulDeployer hasState = (StatefulDeployer)this.deployers_[i];
                hasState.releaseState();
            }
            this.enableListeners();
            super.releaseState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addStateChangeListeners() {
        Object object = this.stateLockObject();
        synchronized (object) {
            this.stateListenersEnabled = true;
            for (int i = 0; i < this.deployers_.length; ++i) {
                if (!(this.deployers_[i] instanceof StatefulDeployer)) continue;
                StatefulDeployer hasState = (StatefulDeployer)this.deployers_[i];
                this.listeners_[i] = hasState.attachStateChangeListener(new Listener<DeployerStateChange>(){

                    @EventHandler
                    public void onStateChanged(Object deployer) {
                        BatchDeployer.this.fireStateChanged();
                    }

                    @EventHandler
                    public void onStateInvalidated(Object deployer) {
                        for (int i = 0; i < BatchDeployer.this.deployers_.length; ++i) {
                            if (BatchDeployer.this.deployers_[i] != deployer) continue;
                            BatchDeployer.this.invalidatedDeployers_[i] = true;
                        }
                        if (!BatchDeployer.this.invalidated_) {
                            BatchDeployer.this.invalidated_ = true;
                            BatchDeployer.this.fireStateInvalidated();
                        }
                    }

                    @EventHandler
                    public void onStateReleased(Object deployer) {
                        assert (false);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeStateChangeListeners() {
        Object object = this.stateLockObject();
        synchronized (object) {
            for (int i = 0; i < this.deployers_.length; ++i) {
                if (this.listeners_[i] == null) continue;
                this.listeners_[i].release();
                this.listeners_[i] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableListeners() {
        Object object = this.stateLockObject();
        synchronized (object) {
            if (!this.stateListenersEnabled) {
                return;
            }
            for (int i = 0; i < this.deployers_.length; ++i) {
                if (this.listeners_[i] == null) continue;
                this.listeners_[i].enable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableListeners() {
        Object object = this.stateLockObject();
        synchronized (object) {
            if (!this.stateListenersEnabled) {
                return;
            }
            for (int i = 0; i < this.deployers_.length; ++i) {
                if (this.listeners_[i] == null) continue;
                this.listeners_[i].disable();
            }
        }
    }
}

