/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.cmd;

import oracle.ide.Ide;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.DeploymentOptions;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.meta.Platform;

public class DeployCommandState
extends HashStructureAdapter {
    protected static final String COMMAND_CLASS_KEY = "commandClass";
    protected static final String COMMAND_ID_KEY = "command";
    protected static final String COMMAND_TYPE_KEY = "commandType";
    protected static final String DEPLOY_SEQUENCE_KEY = "deploySequence";
    protected static final String DEPLOYMENT_OPTIONS_KEY = "deploymentOptions";
    protected static final String COMMAND_PLATFORM_KEY = "platform";

    public DeployCommandState() {
        super(HashStructure.newInstance());
        this._hash.putString(COMMAND_CLASS_KEY, this.getCommandClass().getName());
    }

    public DeployCommandState(HashStructure hash) {
        super(hash);
    }

    protected Class<? extends DeployCommand> getCommandClass() {
        return DeployCommand.class;
    }

    public String getCommandClassName() {
        return DeployCommandState.getCommandClassName(this._hash);
    }

    public static String getCommandClassName(HashStructure hash) {
        return hash.getString(COMMAND_CLASS_KEY);
    }

    public int getCommandId() {
        return DeployCommandState.getCommandId(this._hash);
    }

    public static int getCommandId(HashStructure hash) {
        String command = hash.getString(COMMAND_ID_KEY);
        return Ide.findOrCreateCmdID((String)command);
    }

    public int getDeploySequence() {
        String sequence = this._hash.getString(DEPLOY_SEQUENCE_KEY);
        int seqId = DeploymentManager.getDeploymentSequenceId(sequence);
        return seqId;
    }

    public int getCommandType() {
        return DeployCommandState.getCommandType(this._hash);
    }

    public static int getCommandType(HashStructure hash) {
        return hash.getInt(COMMAND_TYPE_KEY);
    }

    public void setDeploySequence(int sequenceId) {
        this._hash.putString(DEPLOY_SEQUENCE_KEY, DeploymentManager.getDeploymentSequenceName(sequenceId));
    }

    public void setCommandId(int cmdId) {
        this._hash.putString(COMMAND_ID_KEY, Ide.findCmdName((int)cmdId));
    }

    void setCommandType(int type) {
        this._hash.putInt(COMMAND_TYPE_KEY, type);
    }

    public void saveTo(HashStructure hash) {
        this.getHashStructure().copyTo(hash);
    }

    public <T extends DeploymentOptions> void setDeploymentOptions(T options) {
        Object preset = this.getDeploymentOptions(((Object)options).getClass());
        options.copyTo(preset);
    }

    public <T extends DeploymentOptions> T getDeploymentOptions(Class<T> optionsClass) {
        return DeploymentOptions.findOrCreate(this._hash, optionsClass);
    }

    void setPlatform(Platform platform) {
        if (platform == null) {
            this._hash.remove(COMMAND_PLATFORM_KEY);
            return;
        }
        this._hash.putHashStructure(COMMAND_PLATFORM_KEY, Platform.toHashStructure(platform));
    }

    Platform getPlatform() {
        HashStructure hash = this._hash.getHashStructure(COMMAND_PLATFORM_KEY);
        if (hash == null) {
            return null;
        }
        return Platform.fromHashStructure(hash);
    }
}

