/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdRegistry;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.convert.ListConvertedModelsCmd;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public class DelConvertedCmd
extends MigrationCmd {
    public static final String CMDNAME = "delconverted";

    public DelConvertedCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        Object object;
        this.verifyRepository();
        ListConvertedModelsCmd listConvertedModelsCmd = null;
        Long l = null;
        MdConnection mdConnection = null;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        DBObjectId dBObjectId = null;
        if (persistenceManager == null) {
            String string = MigrationAddin.getDefaultMigrationRepository();
            try {
                object = Connections.getInstance().getConnection(string);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            MigrationAddin.openRepository(string);
            persistenceManager = MigrationAddin.getPersistenceManager();
        }
        int n = -1;
        try {
            listConvertedModelsCmd = (ListConvertedModelsCmd)MigrationCmdRegistry.getMigrationCmd("lsconverted", this.getMigrationDetails(), this.getCmdout(), true);
        }
        catch (Exception exception) {
            throw new CMDLineError(CMDNAME, "Problem listing the converted models", exception);
        }
        listConvertedModelsCmd.execute();
        object = this.getMigrationDetails().get("model");
        if (listConvertedModelsCmd.hasSingleConvertedModel() || object != null && "latest".equalsIgnoreCase(((String)object).trim())) {
            l = listConvertedModelsCmd.getLatestConvertedModel();
        } else if (object != null) {
            n = Integer.parseInt((String)object);
            l = listConvertedModelsCmd.getModelIdForIndex(n);
        } else if (!listConvertedModelsCmd.hasSingleConvertedModel() && object == null) {
            listConvertedModelsCmd.printModelList();
            n = this.getCmdout().promptForModelSelection();
            l = listConvertedModelsCmd.getModelIdForIndex(n);
        } else {
            throw new IllegalStateException("There are no valid converted models in the repository");
        }
        if (l == null) {
            throw new IllegalStateException("Unable to locate converted model corresponding to id: " + n);
        }
        dBObjectId = new DBObjectId(l);
        try {
            mdConnection = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId);
        }
        catch (PersistenceException persistenceException) {
            throw new CMDLineError(CMDNAME, "Problem retrieving the connection information", persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new CMDLineError(CMDNAME, "Connection cannot be found", noSuchObjectException);
        }
        try {
            mdConnection.delete(persistenceManager);
        }
        catch (PersistenceException persistenceException) {
            throw new CMDLineError(CMDNAME, "Connection found, but problem encountered deleting", persistenceException);
        }
    }
}

