/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdSequence
extends PersistableObject {
    public static final String TABLE_NAME = "MD_SEQUENCES";
    public static final String COLNAME_SCHEMA_ID_FK = "SCHEMA_ID_FK";
    public static final String COLNAME_NAME = "NAME";
    public static final String COLNAME_SEQ_START = "SEQ_START";
    public static final String COLNAME_INCR = "INCR";
    public static final String COLNAME_NATIVE_SQL = "NATIVE_SQL";
    public static final String COLNAME_NATIVE_KEY = "NATIVE_KEY";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String COLNAME_COMMENTS = "COMMENTS";

    public MdSequence(DBObjectId dBObjectId, String string, Long l, Integer n, String string2) {
        this.setSchemaId(dBObjectId);
        this.setName(string);
        this.setSeqStart(l);
        this.setIncr(n);
        this.setCreatedBy(string2);
    }

    public static MdSequence getExistingInstance(DBObjectId dBObjectId) {
        MdSequence mdSequence = new MdSequence();
        mdSequence.setKey(dBObjectId);
        return mdSequence;
    }

    private MdSequence() {
    }

    public static MdSequence retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdSequence mdSequence = MdSequence.getExistingInstance(dBObjectId);
        mdSequence.retrieve(persistenceManager);
        return mdSequence;
    }

    protected void setSchemaId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SCHEMA_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setName(String string) {
        Field field = new Field(COLNAME_NAME, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    protected void setSeqStart(Long l) {
        Field field = new Field(COLNAME_SEQ_START, "LONG", false);
        field.setValue(l);
        this.setField(field);
    }

    protected void setIncr(Integer n) {
        Field field = new Field(COLNAME_INCR, "INTEGER", false);
        field.setValue(n);
        this.setField(field);
    }

    public void setNativeSql(String string) {
        Field field = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(string);
        field.setValue(clobHelper);
        this.setField(field);
    }

    public void setNativeSql(ClobHelper clobHelper) {
        Field field = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        field.setValue(clobHelper);
        this.setField(field);
    }

    public void setNativeKey(String string) {
        Field field = new Field(COLNAME_NATIVE_KEY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    protected void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setComments(String string) {
        Field field = new Field(COLNAME_COMMENTS, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public DBObjectId getSchemaId() {
        Field field = this.getField(COLNAME_SCHEMA_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getName() {
        Field field = this.getField(COLNAME_NAME);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Integer getSeqStart() {
        return 1;
    }

    public Integer getIncr() {
        Field field = this.getField(COLNAME_INCR);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public ClobHelper getNativeSql() {
        Field field = this.getField(COLNAME_NATIVE_SQL);
        if (field == null) {
            return null;
        }
        return field.getClobHelper();
    }

    public String getNativeKey() {
        Field field = this.getField(COLNAME_NATIVE_KEY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getComments() {
        Field field = this.getField(COLNAME_COMMENTS);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            this.setSchemaId(new DBObjectId(resultSet.getLong(COLNAME_SCHEMA_ID_FK)));
            this.setName(resultSet.getString(COLNAME_NAME));
            this.setSeqStart(resultSet.getLong(COLNAME_SEQ_START));
            this.setIncr(resultSet.getInt(COLNAME_INCR));
            Object object = new ClobHelper(resultSet.getClob(COLNAME_NATIVE_SQL));
            if (resultSet.wasNull()) {
                this.setNativeSql((ClobHelper)null);
            } else {
                this.setNativeSql((ClobHelper)object);
            }
            object = resultSet.getString(COLNAME_NATIVE_KEY);
            if (resultSet.wasNull()) {
                this.setNativeKey(null);
            } else {
                this.setNativeKey((String)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            this.setCreatedBy(resultSet.getString(COLNAME_CREATED_BY));
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
            object = resultSet.getString(COLNAME_COMMENTS);
            if (resultSet.wasNull()) {
                this.setComments(null);
            } else {
                this.setComments((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    public String getObjectName() {
        return this.getName();
    }

    @Override
    public String getObjectNameFieldName() {
        return COLNAME_NAME;
    }

    public void rename(String string) {
        this.setName(string);
    }

    @Override
    public String getContainerFieldName() {
        return COLNAME_SCHEMA_ID_FK;
    }

    @Override
    public DBObjectId getContainerId() {
        return this.getSchemaId();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

