/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.secrets.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetSecretBundleByNameRequest
extends BmcRequest<Void> {
    private String secretName;
    private String vaultId;
    private String opcRequestId;
    private Long versionNumber;
    private String secretVersionName;
    private Stage stage;

    public String getSecretName() {
        return this.secretName;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getSecretVersionName() {
        return this.secretVersionName;
    }

    public Stage getStage() {
        return this.stage;
    }

    public Builder toBuilder() {
        return new Builder().secretName(this.secretName).vaultId(this.vaultId).opcRequestId(this.opcRequestId).versionNumber(this.versionNumber).secretVersionName(this.secretVersionName).stage(this.stage);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",secretName=").append(String.valueOf(this.secretName));
        sb.append(",vaultId=").append(String.valueOf(this.vaultId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",versionNumber=").append(String.valueOf(this.versionNumber));
        sb.append(",secretVersionName=").append(String.valueOf(this.secretVersionName));
        sb.append(",stage=").append(String.valueOf((Object)this.stage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSecretBundleByNameRequest)) {
            return false;
        }
        GetSecretBundleByNameRequest other = (GetSecretBundleByNameRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.secretName, other.secretName) && Objects.equals(this.vaultId, other.vaultId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.versionNumber, other.versionNumber) && Objects.equals(this.secretVersionName, other.secretVersionName) && Objects.equals((Object)this.stage, (Object)other.stage);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.secretName == null ? 43 : this.secretName.hashCode());
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.versionNumber == null ? 43 : this.versionNumber.hashCode());
        result = result * 59 + (this.secretVersionName == null ? 43 : this.secretVersionName.hashCode());
        result = result * 59 + (this.stage == null ? 43 : this.stage.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSecretBundleByNameRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String secretName = null;
        private String vaultId = null;
        private String opcRequestId = null;
        private Long versionNumber = null;
        private String secretVersionName = null;
        private Stage stage = null;

        public Builder secretName(String secretName) {
            this.secretName = secretName;
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public Builder secretVersionName(String secretVersionName) {
            this.secretVersionName = secretVersionName;
            return this;
        }

        public Builder stage(Stage stage) {
            this.stage = stage;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSecretBundleByNameRequest o) {
            this.secretName(o.getSecretName());
            this.vaultId(o.getVaultId());
            this.opcRequestId(o.getOpcRequestId());
            this.versionNumber(o.getVersionNumber());
            this.secretVersionName(o.getSecretVersionName());
            this.stage(o.getStage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSecretBundleByNameRequest build() {
            GetSecretBundleByNameRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSecretBundleByNameRequest buildWithoutInvocationCallback() {
            GetSecretBundleByNameRequest request = new GetSecretBundleByNameRequest();
            request.secretName = this.secretName;
            request.vaultId = this.vaultId;
            request.opcRequestId = this.opcRequestId;
            request.versionNumber = this.versionNumber;
            request.secretVersionName = this.secretVersionName;
            request.stage = this.stage;
            return request;
        }
    }

    public static enum Stage implements BmcEnum
    {
        Current("CURRENT"),
        Pending("PENDING"),
        Latest("LATEST"),
        Previous("PREVIOUS"),
        Deprecated("DEPRECATED");

        private final String value;
        private static Map<String, Stage> map;

        private Stage(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Stage create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Stage: " + key);
        }

        static {
            map = new HashMap<String, Stage>();
            for (Stage v : Stage.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

