/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.io;

import com.oracle.premigration.commons.io.StdUtil;
import com.oracle.premigration.commons.io.ZipContributor;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.exceptions.AccessDeniedException;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.AppVersion;
import com.oracle.premigration.helpers.Utilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipFileHelper {
    static final Language lang = Language.getInstanceWithDefaultResources();

    private ZipFileHelper() {
    }

    public static void generateZipFile(ExecutionContext exeCtx) {
        String zipFileName;
        if (exeCtx == null) {
            return;
        }
        try {
            zipFileName = exeCtx.getOutputFilenamesContainer().getValidatedZipFilePath();
        }
        catch (AccessDeniedException | IOException e) {
            StdUtil.errPrintln(e.getMessage());
            return;
        }
        byte[] buffer = new byte[8192];
        try (FileOutputStream fileOut = new FileOutputStream(zipFileName);
             ZipOutputStream zipOut = new ZipOutputStream(fileOut);){
            zipOut.setComment("Zip file created by CPAT version " + AppVersion.getVersionString() + " on " + Utilities.getISODateTimeString(new Date()));
            zipOut.setMethod(8);
            TreeSet<String> uniqueFolderPaths = ZipFileHelper.collectUniqueFolderPaths(exeCtx.getZipContents());
            for (String folderPath : uniqueFolderPaths) {
                zipOut.putNextEntry(new ZipEntry(folderPath));
                zipOut.closeEntry();
            }
            for (ZipContributor zipContributor : exeCtx.getZipContents()) {
                int amountRead;
                String relativePath = ZipFileHelper.standardizePath(zipContributor.getZipRelativeFilePath());
                zipOut.putNextEntry(new ZipEntry(relativePath));
                InputStream inputStream = zipContributor.getZipEntryStream();
                while ((amountRead = inputStream.read(buffer)) > 0) {
                    zipOut.write(buffer, 0, amountRead);
                }
                zipOut.closeEntry();
            }
            String zipLocationMsg = lang.txt("APP_ZIPFILE_LOCATION_MSG", zipFileName);
            exeCtx.getEnvCtx().getPrintStream().println(zipLocationMsg);
        }
        catch (PremigrationException | IOException e) {
            StdUtil.errPrintln("Exception generating ZipFile:" + e.getMessage());
        }
    }

    private static TreeSet<String> collectUniqueFolderPaths(Set<ZipContributor> zipContributors) {
        TreeSet<String> uniqueFolderPaths = new TreeSet<String>();
        for (ZipContributor zipContributor : zipContributors) {
            String relativePath = ZipFileHelper.standardizePath(zipContributor.getZipRelativeFilePath());
            int fromIndex = 0;
            while (relativePath.indexOf("/", fromIndex) > 0) {
                int separatorLoc = relativePath.indexOf("/", fromIndex);
                String folderPath = relativePath.substring(0, separatorLoc + 1);
                uniqueFolderPaths.add(folderPath);
                fromIndex = separatorLoc + 2;
            }
        }
        return uniqueFolderPaths;
    }

    public static ZipContributor createZipContributorForFile(final String zipRelativeFilePath, final String actualFilePath) {
        return new ZipContributor(){

            @Override
            public String getZipRelativeFilePath() {
                return zipRelativeFilePath;
            }

            @Override
            public InputStream getZipEntryStream() throws IOException {
                return Files.newInputStream(new File(actualFilePath).toPath(), new OpenOption[0]);
            }
        };
    }

    private static String standardizePath(String relativePath) {
        return relativePath.replace("\\", "/");
    }
}

