/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.enums;

import com.oracle.premigration.cli.HelpOption;
import com.oracle.premigration.dbinspector.CheckResult;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public enum ResultLevel implements HelpOption
{
    R0(CheckResult.PASS),
    R1(CheckResult.INFORMATIONAL),
    R2(CheckResult.WARNING),
    R3(CheckResult.BLOCKER);

    private final CheckResult correspondingResult;

    private ResultLevel(CheckResult correspondingResult) {
        this.correspondingResult = correspondingResult;
    }

    public static Set<CheckResult> fromResultLevel(ResultLevel resultLevel) {
        int checkResultLevel = resultLevel.getCheckResult().getExitCode();
        HashSet<CheckResult> checkResults = new HashSet<CheckResult>(EnumSet.allOf(CheckResult.class));
        if (checkResultLevel >= 3) {
            checkResults.remove((Object)CheckResult.WARNING);
        }
        if (checkResultLevel >= 2) {
            checkResults.remove((Object)CheckResult.INFORMATIONAL);
        }
        if (checkResultLevel >= 1) {
            checkResults.remove((Object)CheckResult.PASS);
        }
        return checkResults;
    }

    public CheckResult getCheckResult() {
        return this.correspondingResult;
    }

    @Override
    public boolean showInHelp() {
        return true;
    }

    @Override
    public String getHelpName() {
        return this.name().toLowerCase();
    }
}

