/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.uieditor;

import java.net.URL;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.ExtensionSource;
import oracle.ide.extension.URLPathHandler;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.uieditor.UIManager;

public class UIEditorHookHandler
extends ExtensionHook {
    public static final String UIEDITOR_NS = "http://xmlns.oracle.com/jdeveloper/1013/jdev-uieditor";
    private static final String CLS_NAME = "Class-name";
    private static final String PROXY_NAME = "Proxy-name";
    private static final String PROXY_PATH = "Proxy-path";
    private static final ElementVisitor LAYOUT_HANDLER = new LayoutManagerHandler();
    private static final ElementVisitor PROXY_HANDLER = new ConcreteProxyHandler();

    public void start(ElementStartContext context) {
        context.registerChildVisitor(new ElementName(UIEDITOR_NS, "layoutManager"), LAYOUT_HANDLER);
        context.registerChildVisitor(new ElementName(UIEDITOR_NS, "concreteProxy"), PROXY_HANDLER);
    }

    private static final class LayoutManagerHandler
    extends ElementVisitor {
        private LayoutManagerHandler() {
        }

        public void start(ElementStartContext context) {
            String layoutCls = context.getAttributeValue("layoutCls");
            String libID = context.getAttributeValue("libID");
            String assistantCls = context.getAttributeValue("assistantCls");
            ClassLoader loader = (ClassLoader)context.getScopeData().get("classLoader");
            UIManager.registerLayoutManager(layoutCls, libID, assistantCls, loader);
        }
    }

    private static final class ConcreteProxyHandler
    extends URLPathHandler {
        private ConcreteProxyHandler() {
        }

        public void start(ElementStartContext context) {
            super.start(context);
            String clsName = context.getAttributeValue("clsName");
            String proxyName = context.getAttributeValue("proxyCls");
            String proxyPath = context.getAttributeValue("proxyPath");
            context.getScopeData().put(UIEditorHookHandler.CLS_NAME, clsName);
            context.getScopeData().put(UIEditorHookHandler.PROXY_NAME, proxyName);
            context.getScopeData().put(UIEditorHookHandler.PROXY_PATH, proxyPath);
        }

        public void end(ElementEndContext context) {
            String clsName = (String)context.getScopeData().get(UIEditorHookHandler.CLS_NAME);
            String proxyName = (String)context.getScopeData().get(UIEditorHookHandler.PROXY_NAME);
            String proxyPath = (String)context.getScopeData().get(UIEditorHookHandler.PROXY_PATH);
            URLPath urlPath = new URLPath();
            if (proxyPath != null) {
                this.getURLPaths(urlPath, proxyPath, this.getDirPath((ElementContext)context));
            } else {
                try {
                    ExtensionSource source = (ExtensionSource)context.getScopeData().get("extSource");
                    URL url = source.getURI().toURL();
                    if (url != null && JarUtil.isJarURL((URL)url)) {
                        url = JarUtil.getJarFileURL((URL)url);
                        url = URLFactory.newJarURL((URL)url, (String)"");
                        urlPath.add(url);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            UIManager.registerConcreteProxy(clsName, proxyName, urlPath);
        }
    }
}

