/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.WorkspaceChangeEvent;
import oracle.ide.model.WorkspaceChangeListener;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaClassNode;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.config.JProjectPaths;
import oracle.jdevimpl.jar.JarNode;

public final class JavaProject
extends HashStructureAdapter {
    public static final String EXT = ".jpr";
    public static final String SOURCEPATH_PROPERTY = "sourcePath";
    public static final String CLASSPATH_PROPERTY = "classPath";
    public static final String PROJECT_SOURCEPATH_PROPERTY = "projectSourcePath";
    public static final String DOCPATH_PROPERTY = "docPath";
    public static final int SRC_PATH_EXIST = 0;
    public static final int SRC_PATH_ADD = 1;
    public static final int SRC_PATH_CANCEL_ADD = 2;
    public static final int SRC_PATH_NOT_ADDED = 3;
    private static final int DEBUG_LEVEL = Integer.getInteger("ProjectChangeListener.debug.level", 0);
    private static ProjectChangeListener _sourcepathListener;
    private static ProjectChangeListener _projectSourcepathListener;
    private static ProjectChangeListener _classpathListener;
    private static ProjectChangeListener _docpathListener;
    private static ProjectChangeListener _exportedRefListener;
    private final Project _project;
    private final HashStructure _user;
    public static final String OUTPUT_DIRECTORY_LOCAL_KEY = "outputDirectory";
    public static final String OUTPUT_DIRECTORY;
    public static final String DEFAULT_PACKAGE = "defaultPackage";
    private static final String MOST_RECENT_PACKAGE = "mostRecentPackage";
    private static final String RECENT_PACKAGES = "recentlyUsedPackages";

    private JavaProject(Project project, HashStructure hash) {
        super(hash);
        this._project = project;
        HashStructure userProps = project.getUserPropertiesOnly();
        this._user = userProps != null ? userProps : HashStructure.newInstance();
    }

    public static JavaProject getInstance(Project project) {
        return new JavaProject(project, project.getProperties());
    }

    public static JavaProject getInstance(Project project, HashStructure hash) {
        return new JavaProject(project, hash);
    }

    public URL getOutputDirectory() {
        URL out = this._hash.getURL(OUTPUT_DIRECTORY);
        if (out == null) {
            URL projectDirURL;
            URL url = this._project.getURL();
            if (url != null && (projectDirURL = URLFileSystem.getParent((URL)url)) != null) {
                out = URLFactory.newDirURL((URL)projectDirURL, (String)"classes");
            }
        } else if (!URLFileSystem.isDirectoryPath((URL)out)) {
            out = URLFactory.replacePathPart((URL)out, (String)(out.getPath() + "/"));
        }
        return out;
    }

    public void setOutputDirectory(URL outputDirectory) {
        if (!URLFileSystem.isDirectoryPath((URL)outputDirectory)) {
            throw new IllegalArgumentException(outputDirectory.toString() + " is not a directory URL.  URLFactory.newDirURL() must be used to create directory URLs.");
        }
        this._hash.putURL(OUTPUT_DIRECTORY, outputDirectory);
    }

    public String getDefaultPackage() {
        String pkg = this._hash.getString(DEFAULT_PACKAGE);
        if (pkg == null) {
            pkg = JavaProject.generateDefaultPackageName(this._project);
        }
        return pkg;
    }

    public static String generateDefaultPackageName(Project project) {
        if (project == null) {
            return ModelArb.getString((int)4);
        }
        return JavaProject.generateDefaultPackageName(project.getShortLabel());
    }

    public static String generateDefaultPackageName(String projectName) {
        String pkg;
        String projectLabel = projectName.toLowerCase();
        int len = projectLabel.length();
        int extLen = EXT.length();
        String name = projectLabel.endsWith(EXT) && len > extLen ? projectLabel.substring(0, len - EXT.length()) : projectLabel;
        if (IdeUtil.isPackageIdentifier((String)name)) {
            pkg = name;
        } else {
            int textLen;
            StringBuffer sb = new StringBuffer(name.length());
            char[] characters = name.toCharArray();
            int maxLen = characters.length - 1;
            for (int i = 0; i <= maxLen && (textLen = sb.length()) != 15; ++i) {
                if (textLen == 0 && Character.isJavaIdentifierStart(characters[i]) || textLen > 0 && Character.isJavaIdentifierPart(characters[i])) {
                    sb.append(characters[i]);
                    continue;
                }
                if (textLen != 0 || i != maxLen) continue;
                sb.append(ModelArb.getString((int)5));
                i = -1;
            }
            pkg = sb.toString();
        }
        return pkg;
    }

    public void setDefaultPackage(String defaultPackage) {
        this._hash.putString(DEFAULT_PACKAGE, defaultPackage);
        this.setMostRecentPackage(defaultPackage);
    }

    public String getMostRecentPackage() {
        String pkg = this._user.getString(MOST_RECENT_PACKAGE);
        if (pkg == null) {
            pkg = this.getDefaultPackage();
            this.setMostRecentPackage(pkg);
        }
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMostRecentPackage(String mostRecentPackage) {
        ListStructure recentPkgs;
        this._user.putString(MOST_RECENT_PACKAGE, mostRecentPackage);
        ListStructure listStructure = recentPkgs = this.getRecentPackages();
        synchronized (listStructure) {
            int idx = recentPkgs.indexOf((Object)mostRecentPackage);
            if (idx == -1) {
                recentPkgs.add(0, (Object)mostRecentPackage);
            } else if (idx > 0) {
                recentPkgs.remove(idx);
                recentPkgs.add(0, (Object)mostRecentPackage);
            }
        }
    }

    public ListStructure getRecentPackages() {
        return this.getOrCreateRecentPackages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecentPackages(List pkgs) {
        ListStructure recentPkgs;
        ListStructure listStructure = recentPkgs = this.getOrCreateRecentPackages();
        synchronized (listStructure) {
            recentPkgs.mirror(pkgs);
        }
    }

    private ListStructure getOrCreateRecentPackages() {
        HashStructure shared = this._project.getSharedPropertiesOnly();
        boolean initializeFromMigratedSettings = !this._user.containsKey(RECENT_PACKAGES) && shared.containsKey(RECENT_PACKAGES);
        ListStructure recentPackages = this._user.getOrCreateListStructure(RECENT_PACKAGES);
        if (initializeFromMigratedSettings) {
            try {
                ListStructure migratedRecentPackages = shared.getListStructure(RECENT_PACKAGES);
                migratedRecentPackages.copyTo(recentPackages);
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
        return recentPackages;
    }

    public int addToProjectSourcePath(JavaSourceNode node) {
        boolean[] ask = new boolean[]{true};
        return this.addToProjectSourcePath(node, ask);
    }

    public int addToProjectSourcePath(URL srcURL) {
        return this.addToProjectSourcePath(srcURL, true);
    }

    public int addToProjectSourcePath(URL srcURL, boolean askToAdd) {
        if (srcURL == null || !URLFileSystem.isDirectory((URL)srcURL)) {
            return 3;
        }
        boolean[] ask = new boolean[]{askToAdd};
        URLPath urlPath = PathsConfiguration.getInstance((Project)this._project).getProjectSourcePath();
        if (urlPath.toRelativePath(srcURL) != null) {
            return 0;
        }
        return this.addProjectSourcePath(srcURL, ask);
    }

    public void addToProject(Collection elements, boolean askToAdd) {
        if (elements.size() > 0) {
            boolean addSrcPath = true;
            boolean addClsPath = true;
            boolean[] ask1 = new boolean[]{askToAdd};
            boolean[] ask2 = new boolean[]{askToAdd};
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (!this._project.canAdd(element)) {
                    iterator.remove();
                    continue;
                }
                if (!(element instanceof Locatable)) continue;
                Locatable locatable = (Locatable)element;
                if (addSrcPath && locatable instanceof JavaSourceNode) {
                    switch (this.addToProjectSourcePath((JavaSourceNode)locatable, ask1)) {
                        case 2: {
                            addSrcPath = false;
                            break;
                        }
                    }
                    continue;
                }
                if ((!addClsPath || !(locatable instanceof JarNode)) && !(locatable instanceof JavaClassNode)) continue;
                switch (this.addToAdditionalClassPath(locatable.getURL(), ask2)) {
                    case 2: {
                        addClsPath = false;
                        break;
                    }
                }
            }
        }
    }

    private int addToAdditionalClassPath(URL url, boolean[] ask) {
        JProjectPaths jProjectPaths = JProjectPaths.getInstance((PropertyStorage)this._project);
        URLPath classPath = jProjectPaths.getAdditionalClassPath();
        if (classPath.contains(url = this.validateJarURL(url))) {
            return 0;
        }
        if (ask[0]) {
            ask[0] = false;
            String msg = JProjectArb.getString((int)194);
            String title = JProjectArb.getString((int)195);
            if (!MessageDialog.optionalConfirm((String)title, (Component)Ide.getMainWindow(), (Object)msg, (String)title, null)) {
                return 2;
            }
        }
        classPath.add(url);
        jProjectPaths.setAdditionalClassPath(classPath);
        return 1;
    }

    private URL validateJarURL(URL url) {
        if (JarUtil.isArchive((String)url.getPath())) {
            return URLFactory.newJarURL((URL)url, (String)"");
        }
        return url;
    }

    private int addToProjectSourcePath(JavaSourceNode node, boolean[] ask) {
        URL nodeURL;
        URLPath urlPath = PathsConfiguration.getInstance((Project)this._project).getProjectSourcePath();
        if (urlPath.toRelativePath(nodeURL = node.getURL()) != null) {
            return 0;
        }
        URL parentURL = URLFileSystem.getParent((URL)nodeURL);
        String pack = node.getPackage(this._project);
        if (ModelUtil.hasLength((String)pack)) {
            pack = pack.replace('.', '/');
            pack = pack.concat("/");
            File packFile = new File(pack);
            URL[] entries = urlPath.getEntries();
            for (int i = 0; i < entries.length; ++i) {
                File parent;
                URL entryURL = entries[i];
                String relPath = URLFileSystem.toRelativeSpec((URL)node.getURL(), (URL)entryURL, (boolean)true);
                if (!ModelUtil.hasLength((String)relPath) || (parent = new File(relPath).getParentFile()) == null || packFile.compareTo(parent) != 0) continue;
                return 0;
            }
        } else if (urlPath.contains(parentURL)) {
            return 0;
        }
        URL srcPathURL = JProjectUtil.determineSourceRoot(node, true, new boolean[]{false});
        return this.addProjectSourcePath(srcPathURL, ask);
    }

    private int addProjectSourcePath(URL srcPathURL, boolean[] ask) {
        if (srcPathURL == null) {
            return 3;
        }
        if (ask[0]) {
            ask[0] = false;
            if (!JavaProject.askDynamicProjectSourcePathUpdate()) {
                return 2;
            }
        }
        PathsConfiguration pathsConfig = PathsConfiguration.getInstance((Project)this._project);
        URLPath paths = pathsConfig.getProjectSourcePath();
        paths.add(srcPathURL);
        pathsConfig.setProjectSourcePath(paths);
        return 1;
    }

    public static boolean askDynamicProjectSourcePathUpdate() {
        String msg = JProjectArb.getString((int)107);
        String title = JProjectArb.getString((int)108);
        return MessageDialog.optionalConfirm((String)title, (Component)Ide.getMainWindow(), (Object)msg, (String)title, null);
    }

    public static void init() {
        JavaProject.initSourcepathListener();
        JavaProject.initProjectSourcepathListener();
        JavaProject.initClasspathListener();
        JavaProject.initDocpathListener();
        JavaProject.initExportedRefListener();
    }

    private static void fireEvents(Project project, PropertyChangeEvent[] pces, Object origin) {
        UpdateMessage.firePropertiesChanged((Subject)project, (PropertyChangeEvent[])pces, (Object)origin);
    }

    private static void initSourcepathListener() {
        if (_sourcepathListener == null) {
            _sourcepathListener = new NonCachingProjectChangeListener(){

                @Override
                protected String getUpdateMessageName() {
                    return JavaProject.SOURCEPATH_PROPERTY;
                }
            };
            Project.addProjectChangeListener((String)PathsConfiguration.JAVA_CONTENT_SET_KEY, (ProjectChangeListener)_sourcepathListener);
            JavaProject.registerJDKLibrariesDependencies(_sourcepathListener);
            JavaProject.registerApplicationLibraries(new WorkspacePropertyListener(SOURCEPATH_PROPERTY));
        }
    }

    private static void initProjectSourcepathListener() {
        if (_projectSourcepathListener == null) {
            _projectSourcepathListener = new CachingProjectChangeListener(){

                @Override
                protected Object getValue(Project project) {
                    return PathsConfiguration.getInstance((Project)project).getProjectSourcePath();
                }

                @Override
                protected String getUpdateMessageName() {
                    return JavaProject.PROJECT_SOURCEPATH_PROPERTY;
                }
            };
            Project.addProjectChangeListener((String)PathsConfiguration.JAVA_CONTENT_SET_KEY, (ProjectChangeListener)_projectSourcepathListener);
        }
    }

    private static void initClasspathListener() {
        if (_classpathListener == null) {
            _classpathListener = new NonCachingProjectChangeListener(){

                @Override
                protected String getUpdateMessageName() {
                    return JavaProject.CLASSPATH_PROPERTY;
                }
            };
            Project.addProjectChangeListener((String)OUTPUT_DIRECTORY, (ProjectChangeListener)_classpathListener);
            Project.addProjectChangeListener((String)(JProjectPaths.DATA_KEY + "/additionalClassPath"), (ProjectChangeListener)_classpathListener);
            JavaProject.registerJDKLibrariesDependencies(_classpathListener);
            JavaProject.registerApplicationLibraries(new WorkspacePropertyListener(CLASSPATH_PROPERTY));
        }
    }

    private static void initDocpathListener() {
        if (_docpathListener == null) {
            _docpathListener = new NonCachingProjectChangeListener(){

                @Override
                protected String getUpdateMessageName() {
                    return JavaProject.DOCPATH_PROPERTY;
                }
            };
            JavaProject.registerJDKLibrariesDependencies(_docpathListener);
            JavaProject.registerApplicationLibraries(new WorkspacePropertyListener(DOCPATH_PROPERTY));
        }
    }

    private static void initExportedRefListener() {
        if (_exportedRefListener == null) {
            _exportedRefListener = new CachingProjectChangeListener(){

                @Override
                protected Object getValue(Project project) {
                    return JProjectLibraries.getInstance((PropertyStorage)project).getExports();
                }

                @Override
                protected String getUpdateMessageName() {
                    return "exportedReferences";
                }
            };
            Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/exportedReferences", (ProjectChangeListener)_exportedRefListener);
        }
    }

    private static void registerJDKLibrariesDependencies(ProjectChangeListener listener) {
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/jdkReference", (ProjectChangeListener)listener);
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/libraryReferences", (ProjectChangeListener)listener);
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/internalDefinitions", (ProjectChangeListener)listener);
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/overrideApplicationLibraries", (ProjectChangeListener)listener);
        Project.addProjectChangeListener((String)(DependencyConfiguration.DATA_KEY + "/dependencyList"), (ProjectChangeListener)listener);
    }

    private static void registerApplicationLibraries(WorkspaceChangeListener listener) {
        Workspace.addWorkspaceChangeListener((String)"oracle.jdeveloper.model.ApplicationLibraries/libraryReferences", (WorkspaceChangeListener)listener);
        Workspace.addWorkspaceChangeListener((String)"oracle.jdeveloper.model.ApplicationLibraries/modulePathLibraryReferences", (WorkspaceChangeListener)listener);
        Workspace.addWorkspaceChangeListener((String)"oracle.jdeveloper.model.ApplicationLibraries/internalDefinitions", (WorkspaceChangeListener)listener);
    }

    static {
        OUTPUT_DIRECTORY = JProjectPaths.DATA_KEY + "/outputDirectory";
    }

    private static class WorkspacePropertyListener
    implements WorkspaceChangeListener {
        private final String updateMessageName;

        private WorkspacePropertyListener(String updateMessageName) {
            this.updateMessageName = updateMessageName;
        }

        public final void workspacePropertiesChanged(WorkspaceChangeEvent event) {
            if (event.hasNonPlaceholderChange()) {
                if (DEBUG_LEVEL > 0) {
                    System.out.println(">>>>> Updated " + this.updateMessageName);
                }
                for (Project project : event.getWorkspace().projects()) {
                    PropertyChangeEvent pce = new PropertyChangeEvent(project, this.updateMessageName, null, null);
                    JavaProject.fireEvents(project, new PropertyChangeEvent[]{pce}, this);
                }
            }
        }
    }

    private static abstract class NonCachingProjectChangeListener
    extends ProjectChangeListener {
        private NonCachingProjectChangeListener() {
        }

        protected abstract String getUpdateMessageName();

        public final void projectPropertiesChanged(ProjectChangeEvent event) {
            if (event.hasNonPlaceholderChange()) {
                Project project = event.getProject();
                String updateMessageName = this.getUpdateMessageName();
                if (DEBUG_LEVEL > 0) {
                    System.out.println(">>>>> Updated " + updateMessageName);
                }
                PropertyChangeEvent pce = new PropertyChangeEvent(project, updateMessageName, null, null);
                PropertyChangeEvent[] pces = new PropertyChangeEvent[]{pce};
                JavaProject.fireEvents(project, pces, (Object)this);
            }
        }
    }

    private static abstract class CachingProjectChangeListener
    extends ProjectChangeListener {
        private CachingProjectChangeListener() {
        }

        protected abstract Object getValue(Project var1);

        protected abstract String getUpdateMessageName();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void projectOpened(Project project) {
            Object initialValue = this.getValue(project);
            Map tp = project.getTransientProperties();
            String key = this.getUpdateMessageName();
            Map map = tp;
            synchronized (map) {
                tp.put(key, initialValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void projectPropertiesChanged(ProjectChangeEvent event) {
            Project project = event.getProject();
            Map tp = project.getTransientProperties();
            String key = this.getUpdateMessageName();
            Object curValue = this.getValue(project);
            Map map = tp;
            synchronized (map) {
                Object lastValue = tp.get(key);
                if (ModelUtil.areDifferent(lastValue, (Object)curValue)) {
                    tp.put(key, curValue);
                    String updateMessageName = this.getUpdateMessageName();
                    if (DEBUG_LEVEL > 0) {
                        System.out.println(">>>>> Updated " + updateMessageName);
                    }
                    PropertyChangeEvent pce = new PropertyChangeEvent(project, updateMessageName, lastValue, curValue);
                    PropertyChangeEvent[] pces = new PropertyChangeEvent[]{pce};
                    JavaProject.fireEvents(project, pces, (Object)this);
                }
            }
        }
    }
}

