/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.event;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.builder.event.EventSetModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.controls.PackagePopup;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public class EventSetPanel
extends JPanel
implements BaliWizardPanel {
    private JLabel _nameLabel = new JLabel();
    private JTextField _nameField = new JTextField();
    private JLabel _packageLabel = new JLabel();
    private PackagePopup _packagePopup = new PackagePopup();
    private JButton _browseButton = new JButton();
    private ControlBar _controlBar = new ControlBar();
    private JLabel _listenerLabel = new JLabel();
    private JTextField _listenerField = new JTextField();
    private JLabel _objectLabel = new JLabel();
    private JTextField _objectField = new JTextField();
    private JLabel _eventsListLabel = new JLabel();
    private JButton _addButton = new JButton();
    private JButton _removeButton = new JButton();
    private JButton _editButton = new JButton();
    private DefaultListModel _listModel = new DefaultListModel();
    private JList _eventsList = new JList(this._listModel);
    private EventSetModel _dataModel;

    public EventSetPanel() {
        super(new GridBagLayout());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initializeFromState(BaliWizardState state) {
        this._dataModel = (EventSetModel)state;
        this._packagePopup.setProject(this._dataModel.getProject());
        String eventSetName = this._dataModel.getEventSetName();
        this._nameField.setText(eventSetName.length() > 0 ? eventSetName : "newEvent");
        this._packagePopup.setText(this._dataModel.getPackage());
    }

    public boolean validateAndWriteToState(BaliWizardState state) {
        EventSetModel model = (EventSetModel)state;
        String pkgName = this._packagePopup.getText().trim();
        String clsName = this._nameField.getText().trim();
        int size = this._listModel.getSize();
        String[] events = new String[size];
        for (int i = 0; i < size; ++i) {
            events[i] = (String)this._listModel.getElementAt(i);
        }
        boolean result = false;
        try {
            model.setPackage(pkgName);
            model.setEventSetName(clsName);
            model.setEvents(events);
            result = true;
        }
        catch (ClassBuilderModel.DuplicateClassException ex) {
            this._nameField.requestFocus();
        }
        catch (ClassBuilderModel.IllegalClassNameException ex) {
            model.reportError(BuilderArb.getString(30), BuilderArb.format(180, clsName), "f1_idedclassnameinvalid_html");
            this._nameField.requestFocus();
        }
        catch (ClassBuilderModel.IllegalPackageNameException ex) {
            model.reportError(BuilderArb.getString(31), BuilderArb.format(179, pkgName), "f1_idedclassnameinvalid_html");
            this._packagePopup.requestFocus();
        }
        catch (ClassBuilderModel.InvalidFileException ex) {
            model.reportError(BuilderArb.getString(23), BuilderArb.format(138, ex.getPath()), null);
        }
        return result;
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this._nameLabel, (Component)this._nameField, (String)BuilderArb.getString(60));
        ResourceUtils.resLabel((JLabel)this._packageLabel, (Component)this._packagePopup, (String)BuilderArb.getString(61));
        ResourceUtils.resButton((AbstractButton)this._browseButton, (String)BuilderArb.getString(62));
        ResourceUtils.resLabel((JLabel)this._eventsListLabel, (Component)this._eventsList, (String)BuilderArb.getString(63));
        ResourceUtils.resLabel((JLabel)this._listenerLabel, null, (String)BuilderArb.getString(64));
        ResourceUtils.resLabel((JLabel)this._objectLabel, null, (String)BuilderArb.getString(65));
        this._addButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this._addButton.setToolTipText(BuilderArb.getString(67));
        this._editButton.setIcon(OracleIcons.getIcon((String)"edit.png"));
        this._editButton.setToolTipText(BuilderArb.getString(68));
        this._removeButton.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this._removeButton.setToolTipText(BuilderArb.getString(69));
        this._browseButton.addActionListener(this._packagePopup);
        ButtonClickListener listener = new ButtonClickListener();
        this._addButton.addActionListener(listener);
        this._removeButton.addActionListener(listener);
        this._editButton.addActionListener(listener);
        this._eventsList.addListSelectionListener(new EventSelectionListener());
        this._eventsList.addMouseListener(new DoubleClickListener());
        this._nameField.getDocument().addDocumentListener(new NameChangeListener());
        this._listenerField.setEditable(false);
        this._objectField.setEditable(false);
        this._controlBar.setAlignment(4);
        this._controlBar.add((Component)this._addButton);
        this._controlBar.add((Component)this._editButton);
        this._controlBar.add((Component)this._removeButton);
        this._editButton.setEnabled(false);
        this._removeButton.setEnabled(false);
        this._eventsList.setSelectionMode(0);
        this._listModel.addElement("stateChanged");
        this._eventsList.setSelectedIndex(0);
        JScrollPane scrollPane = new JScrollPane(this._eventsList);
        ComponentWithTitlebar titledList = new ComponentWithTitlebar((JComponent)scrollPane, this._eventsListLabel, this._controlBar);
        this.add((Component)this._nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this._nameField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this._listenerLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this._listenerField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this._objectLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this._objectField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this._packageLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this._packagePopup, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this._browseButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)titledList, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void editEvent(int selectionIndex) {
        EventPanel editEventPanel = new EventPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)editEventPanel, "f1_bndeditevent_html");
        String item = this._listModel.getElementAt(selectionIndex).toString();
        editEventPanel.setEditItem(item);
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)editEventPanel, (Component)editEventPanel.getDefaultComponent(), (String)BuilderArb.getString(68), (int)7);
        dialog.addVetoableChangeListener((VetoableChangeListener)editEventPanel);
        if (dialog.runDialog()) {
            this._listModel.setElementAt(editEventPanel.getEventName(), selectionIndex);
        }
    }

    private class ButtonClickListener
    implements ActionListener {
        private ButtonClickListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selection = EventSetPanel.this._eventsList.getSelectedIndices();
            int index = selection.length == 1 ? selection[0] : -1;
            Object source = e.getSource();
            if (source == EventSetPanel.this._addButton) {
                EventPanel content = new EventPanel();
                HelpSystem.getHelpSystem().registerTopic((JComponent)content, "f1_bndaddevent_html");
                JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)EventSetPanel.this, (Component)content, (Component)content.getDefaultComponent(), (String)BuilderArb.getString(67), (int)7);
                dialog.addVetoableChangeListener((VetoableChangeListener)content);
                if (dialog.runDialog()) {
                    String newEvent = content.getEventName();
                    EventSetPanel.this._listModel.addElement(newEvent);
                    EventSetPanel.this._eventsList.setSelectedIndex(EventSetPanel.this._listModel.indexOf(newEvent));
                }
            } else if (source == EventSetPanel.this._removeButton) {
                if (index != -1) {
                    EventSetPanel.this._listModel.remove(index);
                    int listSize = EventSetPanel.this._listModel.size();
                    if (index < listSize) {
                        EventSetPanel.this._eventsList.setSelectedIndex(index);
                    } else if (listSize > 0) {
                        EventSetPanel.this._eventsList.setSelectedIndex(listSize - 1);
                    } else {
                        EventSetPanel.this._editButton.setEnabled(false);
                        EventSetPanel.this._removeButton.setEnabled(false);
                    }
                }
            } else if (source == EventSetPanel.this._editButton && selection.length > 0) {
                EventSetPanel.this.editEvent(selection[0]);
            }
        }
    }

    private class EventSelectionListener
    implements ListSelectionListener {
        private EventSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && EventSetPanel.this._eventsList == e.getSource()) {
                int index = e.getFirstIndex();
                EventSetPanel.this._removeButton.setEnabled(index != -1);
                EventSetPanel.this._editButton.setEnabled(index != -1);
            }
        }
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                int index = EventSetPanel.this._eventsList.getSelectedIndex();
                EventSetPanel.this.editEvent(index);
            }
        }
    }

    private class NameChangeListener
    implements DocumentListener {
        private NameChangeListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.enableOK(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.enableOK(e);
            this.updateClassNames();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.enableOK(e);
            this.updateClassNames();
        }

        private void updateClassNames() {
            String eventName = EventSetPanel.this._nameField.getText().trim();
            EventSetPanel.this._objectField.setText(EventSetPanel.this._dataModel.getEventObjectName(eventName));
            EventSetPanel.this._listenerField.setText(EventSetPanel.this._dataModel.getListenerName(eventName));
        }

        private void enableOK(DocumentEvent de) {
            Document doc = de.getDocument();
            try {
                boolean enable = doc.getText(0, doc.getLength()).trim().length() > 0;
                EventSetPanel.this._dataModel.getBuilderDialog().setOKButtonEnabled(enable);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private class EventPanel
    extends JPanel
    implements VetoableChangeListener {
        private JLabel _name;
        private JTextField _field;
        private String _editItem;

        public EventPanel() {
            super(new GridBagLayout());
            this._name = new JLabel();
            this._field = new JTextField();
            this._editItem = null;
            try {
                ResourceUtils.resLabel((JLabel)this._name, (Component)this._field, (String)BuilderArb.getString(60));
                this.add((Component)this._name, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this._field, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 20, 0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void setEditItem(String itemName) {
            this._editItem = itemName;
            this._field.setText(this._editItem);
        }

        boolean isEditMode() {
            return this._editItem != null;
        }

        Component getDefaultComponent() {
            return this._field;
        }

        String getEventName() {
            return this._field.getText().trim();
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                String eventName = this.getEventName();
                if (eventName.length() == 0 || !NamingUtil.isJavaIdentifier((String)eventName) || NamingUtil.isJavaKeyword((String)eventName) || NamingUtil.isJavaReservedWord((String)eventName)) {
                    String title = BuilderArb.getString(70);
                    String message = BuilderArb.getString(71);
                    MessageDialog.error((Component)EventSetPanel.this, (Object)message, (String)title, null);
                    throw new PropertyVetoException(message, evt);
                }
                int count = EventSetPanel.this._listModel.getSize();
                for (int i = 0; i < count; ++i) {
                    if (!EventSetPanel.this._listModel.getElementAt(i).equals(eventName)) continue;
                    if (eventName.equals(this._editItem)) break;
                    String title = BuilderArb.getString(72);
                    String message = BuilderArb.getString(73);
                    MessageDialog.error((Component)EventSetPanel.this, (Object)message, (String)title, null);
                    throw new PropertyVetoException(message, evt);
                }
            }
        }
    }
}

