/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.xml;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.ide.extension.Extension;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.ExtensionRegistry;
import oracle.ide.ceditor.UndoableEditCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdeveloper.audit.xml.XmlModelAdapter;
import oracle.jdeveloper.audit.xml.XmlTransformContext;

public class XmlTransformAdapter
extends TransformAdapter {
    private final boolean standard;
    private final boolean customization;
    private volatile XmlModel xmlModel;
    private Method tipNodeMethod;
    private boolean tipNodeMethodInitialized;

    public XmlTransformAdapter() {
        this(true, false);
    }

    public static XmlTransformAdapter newStandardModeAdapter() {
        return new XmlTransformAdapter(true, false);
    }

    public static XmlTransformAdapter newCustomizationModeAdapter() {
        return new XmlTransformAdapter(false, true);
    }

    public static XmlTransformAdapter newStandardAndCustomizationModeAdapter() {
        return new XmlTransformAdapter(true, true);
    }

    private XmlTransformAdapter(boolean standard, boolean customization) {
        this.standard = standard;
        this.customization = customization;
    }

    protected XmlTransformContext createContext(TransformContext.Shape shape, Transform transform, Violation violation, Location location, URL pendingLocation, Project pendingProject, Workspace pendingWorkspace) {
        return new XmlTransformContext(this, shape, transform, violation, location, pendingLocation, pendingProject, pendingWorkspace);
    }

    public boolean isTransformable(ModelAdapter model) {
        model.verifyReadTransaction();
        if (!(model instanceof XmlModelAdapter)) {
            return false;
        }
        XmlModel xmlModel = ((XmlModelAdapter)model).getXmlModel();
        if (xmlModel.getTipCustomizationLayer() == null) {
            return this.standard && !xmlModel.getDomModel().isReadOnly();
        }
        return this.customization && !xmlModel.getDomModel().isReadOnly();
    }

    public Boolean makeTransformable(TransformContext context) throws Exception {
        XmlModelAdapter model = (XmlModelAdapter)context.getModel();
        model.verifyReadTransaction();
        XmlModel xmlModel = model.getXmlModel();
        if (xmlModel.getTipCustomizationLayer() == null) {
            assert (this.standard);
            return super.makeTransformable(context);
        }
        assert (this.customization);
        XMLSourceNode node = this.tipNode((XMLSourceNode)context.getNode(), context.getProject(), context.getWorkspace());
        return node == null || super.makeWritable((Node)node, context.getProject(), context.getWorkspace()) != false;
    }

    public void beginTransform(TransformContext context) throws Exception {
        if (this.xmlModel != null) {
            throw new IllegalStateException("transaction already active");
        }
        UndoableEditCommand beginCommand = new UndoableEditCommand("transform-begin-command", (TextNode)context.getNode(), context.getProject(), context.getWorkspace());
        CommandProcessor.getInstance().invoke((Command)beginCommand);
        XmlModelAdapter model = (XmlModelAdapter)context.getModel();
        model.verifyReadTransaction();
        TextBuffer buffer = model.getTextBuffer();
        this.xmlModel = model.getXmlModel();
        int count = buffer.getChangeId();
        this.xmlModel.releaseReadLock();
        this.xmlModel.startTransaction(context.getTransform().boundLabel(context));
        this.xmlModel.acquireReadLock();
        if (count != buffer.getChangeId()) {
            this.xmlModel.rollbackTransaction();
            URL url = model.getUrl();
            this.xmlModel = null;
            throw new ExpiredTextBufferException(((Object)((Object)this)).getClass(), (Object)url);
        }
    }

    public XmlModel getXmlModel() {
        if (this.xmlModel == null) {
            throw new IllegalStateException("no transaction active");
        }
        return this.xmlModel;
    }

    public void endTransform(TransformContext context) throws Exception {
        if (this.xmlModel == null) {
            throw new IllegalStateException("no transaction active");
        }
        this.xmlModel.commitTransaction(false);
        this.xmlModel = null;
        Location selection = this.getSelection();
        if (selection != null) {
            UndoableEditCommand endCommand = new UndoableEditCommand("transform-end-command", (TextNode)context.getNode(), context.getProject(), context.getWorkspace(), false);
            endCommand.setSelection(selection.getModel().getUrl(), selection.getOffset(), selection.getEndOffset() - selection.getOffset());
            CommandProcessor.getInstance().invoke((Command)endCommand);
        }
    }

    public void cancelTransform(TransformContext context) {
        if (this.xmlModel != null) {
            this.xmlModel.rollbackTransaction();
        }
        this.xmlModel = null;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.standard == ((XmlTransformAdapter)((Object)object)).standard && this.customization == ((XmlTransformAdapter)((Object)object)).customization;
    }

    public int hashCode() {
        int code = super.hashCode();
        code = 31 * code + (this.standard ? 1 : 0);
        code = 31 * code + (this.customization ? 1 : 0);
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLSourceNode tipNode(XMLSourceNode baseNode, Project project, Workspace workspace) {
        if (this.tipNodeMethod == null) {
            if (this.tipNodeMethodInitialized) {
                return null;
            }
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            Extension extension = registry.findExtension("oracle.mds-dt");
            if (extension == null || !registry.isFullyLoaded(extension)) {
                return null;
            }
            try {
                Class<?> clas = Class.forName("oracle.mds.internal.dt.IdeUtils", true, registry.getClassLoader("oracle.mds-dt"));
                this.tipNodeMethod = clas.getMethod("getTipCustNode", XMLSourceNode.class, Project.class, Workspace.class);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                XMLSourceNode xMLSourceNode = null;
                return xMLSourceNode;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                XMLSourceNode xMLSourceNode = null;
                return xMLSourceNode;
            }
            finally {
                this.tipNodeMethodInitialized = true;
            }
        }
        try {
            return (XMLSourceNode)((Object)this.tipNodeMethod.invoke(null, new Object[]{baseNode, project, workspace}));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            this.tipNodeMethod = null;
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.tipNodeMethod = null;
            return null;
        }
    }
}

