/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.AuthorityInfoAccess;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.ocsp.OCSP;
import oracle.security.crypto.ocsp.OCSPUtils;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class ServiceLocatorExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = OCSP.id_pkix_ocsp_service_locator;
    private X500Principal issuer;
    private AuthorityInfoAccess access = null;

    public ServiceLocatorExtension() {
        super(TYPE);
    }

    public ServiceLocatorExtension(X500Principal issuer) {
        this(issuer, false);
    }

    public ServiceLocatorExtension(X500Principal issuer, boolean critical) {
        super(TYPE, critical);
        this.issuer = issuer;
        this.setValue(this.toByteArray());
    }

    public ServiceLocatorExtension(X500Principal issuer, AuthorityInfoAccess access) {
        this(issuer, access, false);
    }

    public ServiceLocatorExtension(X500Principal issuer, AuthorityInfoAccess access, boolean critical) {
        super(TYPE, critical);
        this.issuer = issuer;
        this.setLocatorAccessInfo(access);
    }

    public ServiceLocatorExtension(InputStream is) throws IOException {
        super(is);
    }

    public X500Principal getIssuer() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.issuer;
    }

    public void setLocatorAccessInfo(AuthorityInfoAccess access) {
        this.access = access;
        this.setValue(this.toByteArray());
    }

    public AuthorityInfoAccess getLocatorAccessInfo() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.access;
    }

    private byte[] toByteArray() {
        ASN1Sequence seq = new ASN1Sequence();
        seq.addElement((ASN1Object)new X500Name(OCSPUtils.formatX500Name(this.issuer)));
        if (this.access != null) {
            seq.addElement((ASN1Object)this.access);
        }
        byte[] b = Utils.toBytes((Streamable)seq);
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)is);
            this.issuer = new X500Principal(new X500Name((InputStream)sis).toString());
            this.access = sis.hasMoreData() ? new AuthorityInfoAccess((InputStream)sis) : null;
            sis.terminate();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        return "Service Locator Extension: issuer = " + this.issuer + (this.access != null ? "; AuthorityInfoAccess = " + this.access : "");
    }
}

