/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.DataObject;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public final class Qualifier
extends DataObject {
    private BaseMetadataObjectReference m_Dimension = null;
    private TypedExpression m_Expression = null;

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        this.m_Dimension.toSyntax(syntaxPrintingContext);
        syntaxPrintingContext.append(" = ");
        syntaxPrintingContext.print(this.getExpression());
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_Expression = validationContext.validateExp(this.m_Expression);
        this.m_Dimension = (BaseMetadataObjectReference)validationContext.validate(this.m_Dimension);
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.m_Dimension.isDefinitionComplete()) {
            return false;
        }
        if (!this.getExpression().isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    public Qualifier(MdmPrimaryDimension mdmPrimaryDimension, TypedExpression typedExpression) {
        Qualifier.validateValue(mdmPrimaryDimension);
        Qualifier.validateValue(typedExpression);
        this.m_Dimension = new MetadataObjectReference(mdmPrimaryDimension, MdmPrimaryDimension.class);
        this.m_Expression = typedExpression;
        this.initialize();
    }

    public Qualifier(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, TypedExpression typedExpression) {
        Qualifier.validateValue(baseMetadataObjectReference);
        Qualifier.validateValue(typedExpression);
        this.m_Dimension = baseMetadataObjectReference;
        this.m_Expression = typedExpression;
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitQualifier(this, object);
    }

    public MdmPrimaryDimension getDimension() {
        return (MdmPrimaryDimension)this.m_Dimension.getBaseMetadataObject();
    }

    public String getDimensionID() {
        return this.m_Dimension.getIdentifier().toString();
    }

    public TypedExpression getExpression() {
        return this.m_Expression;
    }

    @Override
    public boolean isCompositeObject() {
        return true;
    }
}

