/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.tsp;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.cert.Attribute;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.cert.ext.ExtKeyUsageExtension;
import oracle.security.crypto.cmp.PKIStatusInfo;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSSignedDataContentInfo;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.cms.ESSCertID;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.tsp.MessageImprint;
import oracle.security.crypto.tsp.TSP;
import oracle.security.crypto.tsp.TSPException;
import oracle.security.crypto.tsp.TSPTimeStampResp;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class TSPUtils {
    private static Hashtable algoNamemap = null;
    private static Hashtable algoIdmap = null;
    private static Hashtable algoOIDmap = null;
    public static final String DEFAULT_RandomGenerator_ALGO = "SHA1PRNG";
    public static final String HASH_ALG_MD5 = "MD5";
    public static final String HASH_ALG_MD2 = "MD2";
    public static final String HASH_ALG_SHA_1 = "SHA1";

    public static void verifyKeyPurposeID(X509Certificate cert) throws TSPException, IOException {
        ExtKeyUsageExtension ekue = new ExtKeyUsageExtension();
        X509ExtensionSet extensions = TSPUtils.getExtensionSet(cert);
        if (extensions == null) {
            throw new TSPException("KeyPurposeID id-kp-timeStamping not present in signing certificate.");
        }
        if ((ekue = (ExtKeyUsageExtension)extensions.getExtension(ekue.getType())) == null) {
            throw new TSPException("KeyPurposeID id-kp-timeStamping not present in signing certificate.");
        }
        if (!ekue.hasKeyPurpose(PKIX.id_kp_timeStamping)) {
            throw new TSPException("KeyPurposeID id-kp-timeStamping not present in signing certificate.");
        }
        if (!ekue.getCritical()) {
            throw new TSPException("KeyPurposeID id-kp-timeStamping is present in signing certificate but extended key usage fiels extension is not marked  critical.");
        }
    }

    public static void validateMessageImprint(MessageImprint mi) throws TSPException, NoSuchAlgorithmException {
        int hmLength;
        AlgorithmIdentifier hashAlgorithm = mi.getHashAlgorithm();
        byte[] hashedMessage = mi.getHashedMessage();
        int digLength = MessageDigest.getInstance(TSPUtils.getAlgoName(hashAlgorithm)).getDigestLength();
        if (digLength != (hmLength = hashedMessage.length)) {
            throw new TSPException("Length of hashedMessage (" + hmLength + ") does not match length specified by hashAlgorithm " + hashAlgorithm + ": (" + digLength + ") for the messageImprint field.");
        }
    }

    public static void validateStatus(TSPTimeStampResp tsr) throws TSPException {
        PKIStatusInfo status = tsr.getStatus();
        if (status == null) {
            throw new TSPException("status field is not set");
        }
        int statusVal = status.getStatus().getValue();
        if (statusVal < 0 || statusVal > 5) {
            throw new TSPException("Unsupported value for PKIStatus: " + statusVal);
        }
        CMSSignedDataContentInfo timeStampToken = tsr.getTimeStampToken();
        if (timeStampToken == null && (statusVal == PKIStatusInfo.Status.GRANTED.getValue() || statusVal == PKIStatusInfo.Status.GRANTED_WITH_MODS.getValue())) {
            throw new TSPException("timeStampToken MUST be present when status contains a PKIStatus value of " + statusVal);
        }
        if (timeStampToken != null && statusVal != PKIStatusInfo.Status.GRANTED.getValue() && statusVal != PKIStatusInfo.Status.GRANTED_WITH_MODS.getValue()) {
            throw new TSPException("timeStampToken MUST NOT be present when status contains a PKIStatus value of " + statusVal);
        }
        if (timeStampToken == null) {
            PKIStatusInfo.Failure[] failInfo = status.getFailures();
            if (failInfo == null) {
                throw new TSPException("failInfo missing from status field when timeStampToken is not present");
            }
            int length = failInfo.length;
            block3: for (int i = 0; i < length; ++i) {
                int failureVal = failInfo[i].getValue();
                switch (failureVal) {
                    case 0: 
                    case 2: 
                    case 5: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 25: {
                        continue block3;
                    }
                    default: {
                        throw new TSPException("Unsupported value for PKIFailureInfo: " + failureVal);
                    }
                }
            }
        }
    }

    public static void verifyTimeStampTokenSignature(CMSSignedDataContentInfo timeStampToken, X509Certificate tsaCert) throws TSPException {
        Enumeration signers = timeStampToken.signers();
        if (signers == null) {
            throw new TSPException("No signatures found.");
        }
        CMSSignerInfo firstSignature = (CMSSignerInfo)signers.nextElement();
        if (firstSignature != null && signers.hasMoreElements()) {
            throw new TSPException("Multiple signatures found.");
        }
        Attribute attr = null;
        ESSCertID essCertID = null;
        AttributeSet ua = firstSignature.getUnsignedAttributes();
        AttributeSet aa = firstSignature.getSignedAttributes();
        if (ua != null && (attr = ua.getAttribute(TSP.id_aa_signingCertificate)) == null && aa != null) {
            attr = aa.getAttribute(TSP.id_aa_signingCertificate);
        }
        if (attr == null) {
            throw new TSPException("id-aa-signingCertificate attribute not present");
        }
        Vector vals = attr.getValues();
        if (vals == null || vals.size() == 0) {
            throw new TSPException("Value for id-aa-signingCertificate attribute not found");
        }
        try {
            essCertID = new ESSCertID(Utils.toStream((Streamable)((ASN1Object)vals.elementAt(0))));
        }
        catch (IOException ex) {
            throw new TSPException(ex.getMessage());
        }
        try {
            if (!essCertID.compareTo(tsaCert)) {
                throw new TSPException("id-aa-signingCertificate attribute does not correspond to given certificate");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TSPException(ex.getMessage());
        }
        catch (CertificateEncodingException ex) {
            throw new TSPException(ex.toString());
        }
        try {
            timeStampToken.verifySignature(tsaCert);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TSPException("Unsupported algorithm.");
        }
        catch (AuthenticationException ex) {
            throw new TSPException("Signature could not be verified.");
        }
        catch (SignatureException ex) {
            throw new TSPException("Signature does not correspond to certificate.");
        }
        catch (IOException ex) {
            throw new TSPException("IO Exception : Certificate could not be encoded");
        }
        catch (CertificateEncodingException ex) {
            throw new TSPException("CertificateEncoding Exception : Certificate could not be encoded.");
        }
    }

    public static X509ExtensionSet getExtensionSet(X509Certificate cert) throws IOException {
        try {
            X509 X509cert = new X509(cert.getEncoded());
            return X509cert.getExtensionSet();
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(ex.toString());
        }
    }

    private static void setMapping() {
        algoNamemap = new Hashtable();
        algoIdmap = new Hashtable();
        TSPUtils.setAlgoName(HASH_ALG_SHA_1, CMS.sha_1);
        TSPUtils.setAlgoName(HASH_ALG_MD5, CMS.md5);
        TSPUtils.setAlgoName("SHA-1withDSA", CMS.id_dsa_with_sha_1);
        TSPUtils.setAlgoName("SHAwithDSA", CMS.dsaWithSHA);
        TSPUtils.setAlgoName("RSA/ /NoPadding", CMS.rsaEncryption);
        TSPUtils.setAlgoName("RSA", CMS.rsaEncryption);
        TSPUtils.setAlgoName("DESede/ /PKCS5Padding", CMS.id_alg_CMS3DESwrap);
        TSPUtils.setAlgoName("DESede", CMS.id_alg_CMS3DESwrap);
        TSPUtils.setAlgoName("DES/CBC/PKCS5Padding", AlgID.desCBC);
        TSPUtils.setAlgoName("DES/CBC/NoPadding", AlgID.desCBC);
        TSPUtils.setAlgoName("RC2/ /PKCS5Padding", CMS.id_alg_CMSRC2wrap);
        TSPUtils.setAlgoName("RC2", CMS.id_alg_CMSRC2wrap);
        TSPUtils.setAlgoName("DESede/CBC/PKCS5Padding", CMS.des_ede3_cbc);
        TSPUtils.setAlgoName("DESede/CBC/NoPadding", CMS.des_ede3_cbc);
        TSPUtils.setAlgoName("RC2/CBC/PKCS5Padding", CMS.rc2_cbc);
        TSPUtils.setAlgoName("RC2/CBC/NoPadding", CMS.rc2_cbc);
        TSPUtils.setAlgoName("HmacSHA1", CMS.hmac_SHA_1);
    }

    private static void setOIDMapping() {
        algoOIDmap = new Hashtable();
        algoOIDmap.put(CMS.sha_1.getOID(), "SHA-1");
        algoOIDmap.put(CMS.md5.getOID(), HASH_ALG_MD5);
        algoOIDmap.put(CMS.id_dsa_with_sha_1.getOID(), "SHA-1withDSA");
        algoOIDmap.put(CMS.dsaWithSHA.getOID(), "SHAwithDSA");
        algoOIDmap.put(CMS.rsaEncryption.getOID(), "RSA");
        algoOIDmap.put(CMS.id_alg_CMS3DESwrap.getOID(), "DESede");
        algoOIDmap.put(AlgID.desCBC.getOID(), "DES/CBC/NoPadding");
        algoOIDmap.put(CMS.id_alg_CMSRC2wrap.getOID(), "RC2");
        algoOIDmap.put(CMS.des_ede3_cbc.getOID(), "DESede/CBC/NoPadding");
        algoOIDmap.put(CMS.rc2_cbc.getOID(), "RC2/CBC/NoPadding");
        algoOIDmap.put(CMS.hmac_SHA_1.getOID(), "HmacSHA1");
    }

    private static AlgorithmIdentifier setAlgoName(String name, AlgorithmIdentifier oid) {
        algoNamemap.put(oid, name);
        return algoIdmap.put(name.toUpperCase(), oid);
    }

    public static AlgorithmIdentifier getAlgoID(String name) throws NoSuchAlgorithmException {
        AlgorithmIdentifier oid;
        if (algoIdmap == null) {
            TSPUtils.setMapping();
        }
        if ((oid = (AlgorithmIdentifier)algoIdmap.get(name.toUpperCase())) == null) {
            throw new NoSuchAlgorithmException();
        }
        return oid;
    }

    public static String getAlgoName(AlgorithmIdentifier oid) throws NoSuchAlgorithmException {
        return TSPUtils.getAlgoName(oid, false);
    }

    public static String getAlgoName(AlgorithmIdentifier oid, boolean removeMode) throws NoSuchAlgorithmException {
        String name;
        if (algoNamemap == null) {
            TSPUtils.setMapping();
        }
        if ((name = (String)algoNamemap.get(oid)) == null) {
            if (algoOIDmap == null) {
                TSPUtils.setOIDMapping();
            }
            if ((name = (String)algoOIDmap.get(oid.getOID())) == null) {
                throw new NoSuchAlgorithmException("Algorithmid " + oid + "is not supported");
            }
            if (removeMode) {
                return TSPUtils.removeMode(name);
            }
            return name;
        }
        if (removeMode) {
            return TSPUtils.removeMode(name);
        }
        return name;
    }

    private static String removeMode(String name) {
        int index = name.indexOf(47);
        String algoName = null;
        if (index != -1) {
            algoName = name.substring(0, index);
            return algoName;
        }
        return name;
    }

    public static X509 convertX509(X509Certificate cert) throws CertificateEncodingException {
        try {
            X509 certificate = new X509(cert.getEncoded());
            return certificate;
        }
        catch (IOException ex) {
            throw new CertificateEncodingException("IO Exception occured while encoding the certificate");
        }
    }
}

