/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.java.locator.ModularizedJdkBaseLocator;
import oracle.jdeveloper.java.locator.ModularizedJdkClassLocator;
import oracle.jdeveloper.java.locator.ModularizedJdkURLFileSystemHelper;
import oracle.jdeveloper.java.locator.ModularizedPackageEntry;

public class ModularizedJdkJrtfsLocator
extends ModularizedJdkClassLocator {
    private static final String MODULES_PATH_NAME = "/modules/";
    private String actualModulesPathName;
    private static final Map<String, ModularizedJdkJrtfsLocator> INSTANCES = new HashMap<String, ModularizedJdkJrtfsLocator>();
    private final URL _jrtfsjar;
    private FileSystem _fs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModularizedJdkJrtfsLocator getInstance(URL jrtfsjar) {
        Map<String, ModularizedJdkJrtfsLocator> map = INSTANCES;
        synchronized (map) {
            String filePath = ModularizedJdkJrtfsLocator.getJrtfsFilePath(jrtfsjar);
            ModularizedJdkJrtfsLocator locator = INSTANCES.get(filePath);
            if (locator != null) {
                return locator;
            }
            locator = new ModularizedJdkJrtfsLocator(jrtfsjar);
            INSTANCES.put(filePath, locator);
            return locator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModularizedJdkJrtfsLocator getInstance(String filePath) {
        Map<String, ModularizedJdkJrtfsLocator> map = INSTANCES;
        synchronized (map) {
            ModularizedJdkJrtfsLocator locator = INSTANCES.get(filePath);
            return locator;
        }
    }

    private static String getJrtfsFilePath(URL jrtfsjar) {
        return URLFileSystem.getPath((URL)jrtfsjar);
    }

    private ModularizedJdkJrtfsLocator(URL jrtfsjar) {
        this._jrtfsjar = URLFactory.intern((URL)jrtfsjar);
        this._lastModified = URLFileSystem.lastModified((URL)this._jrtfsjar);
    }

    protected void finalize() throws Throwable {
        if (this._fs != null) {
            this._fs.close();
        }
    }

    @Override
    protected String getUrlLocatorFilePath() {
        return ModularizedJdkJrtfsLocator.getJrtfsFilePath(this._jrtfsjar);
    }

    @Override
    public URLPath getClassPath() {
        this.buildIndex();
        URL rootURL = ModularizedJdkURLFileSystemHelper.createDirURL(this.getUrlLocatorFilePath(), this.getLocatorType(), "");
        return rootURL == null ? new URLPath() : new URLPath(rootURL);
    }

    @Override
    protected boolean isLocal() {
        return URLFileSystem.isLocal((URL)this._jrtfsjar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void buildIndexImpl(boolean checkInterrupt) throws InterruptedException {
        if (checkInterrupt) {
            ModularizedJdkJrtfsLocator.checkInterrupt();
        }
        if (this._packageMap != null) {
            return;
        }
        ModularizedJdkJrtfsLocator modularizedJdkJrtfsLocator = this;
        synchronized (modularizedJdkJrtfsLocator) {
            if (this._packageMap != null) {
                return;
            }
            this._moduleNames = new ArrayList();
            HashMap<String, String> _moduleToIndex = new HashMap<String, String>();
            try {
                URLClassLoader loader = new URLClassLoader(new URL[]{this._jrtfsjar});
                this._fs = FileSystems.newFileSystem(URI.create("jrt:/"), Collections.emptyMap(), (ClassLoader)loader);
                HashMap<String, Map<String, ModularizedJdkBaseLocator.ClassDetails>> packageToClassDetails = new HashMap<String, Map<String, ModularizedJdkBaseLocator.ClassDetails>>(512);
                HashMap<String, Collection<String>> packageToSubMap = new HashMap<String, Collection<String>>(512);
                for (Path rootDir : this._fs.getRootDirectories()) {
                    if (checkInterrupt) {
                        ModularizedJdkJrtfsLocator.checkInterrupt();
                    }
                    Stream<Path> rootDirStream = Files.list(rootDir);
                    Iterator rootDirIter = rootDirStream.iterator();
                    while (rootDirIter.hasNext()) {
                        Path rootDirPath;
                        String rootDirPathString;
                        if (checkInterrupt) {
                            ModularizedJdkJrtfsLocator.checkInterrupt();
                        }
                        if (!MODULES_PATH_NAME.equals((rootDirPathString = (rootDirPath = (Path)rootDirIter.next()).toString()).replace('\\', '/') + "/")) continue;
                        this.actualModulesPathName = rootDirPathString;
                        Stream<Path> moduleStream = Files.list(rootDirPath);
                        Iterator moduleIter = moduleStream.iterator();
                        while (moduleIter.hasNext()) {
                            String moduleIndex;
                            Path modulePath;
                            String moduleName;
                            if (checkInterrupt) {
                                ModularizedJdkJrtfsLocator.checkInterrupt();
                            }
                            if ((moduleName = (modulePath = (Path)moduleIter.next()).toString()).startsWith(this.actualModulesPathName)) {
                                moduleName = moduleName.substring(this.actualModulesPathName.length() + 1);
                            }
                            if ((moduleIndex = (String)_moduleToIndex.get(moduleName)) == null) {
                                moduleIndex = Integer.toHexString(this._moduleNames.size());
                                this._moduleNames.add(moduleName);
                                _moduleToIndex.put(moduleName, moduleIndex);
                            }
                            this.indexClasses(moduleIndex, moduleName, modulePath, packageToClassDetails, packageToSubMap, checkInterrupt);
                        }
                    }
                }
                ArraySortedSet allKeys = new ArraySortedSet(100);
                allKeys.addAll(packageToClassDetails.keySet());
                allKeys.addAll(packageToSubMap.keySet());
                HashMap<String, ModularizedPackageEntry> finalPackageMap = new HashMap<String, ModularizedPackageEntry>(allKeys.size());
                for (String packageName : allKeys) {
                    if (checkInterrupt) {
                        ModularizedJdkJrtfsLocator.checkInterrupt();
                    }
                    Map classNamesToDetails = (Map)packageToClassDetails.get(packageName);
                    Collection subs = (Collection)packageToSubMap.get(packageName);
                    if ((classNamesToDetails == null || classNamesToDetails.isEmpty()) && (subs == null || subs.isEmpty())) continue;
                    finalPackageMap.put(packageName, new ModularizedPackageEntry(packageName, classNamesToDetails, (Collection<String>)subs));
                }
                ArrayList<String> packedModuleNames = new ArrayList<String>(this._moduleNames.size());
                for (String moduleName : this._moduleNames) {
                    packedModuleNames.add(moduleName);
                }
                this._moduleNames = packedModuleNames;
                this._packageMap = finalPackageMap;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected byte[] getBytes(String moduleIndex, String className) throws IOException {
        this.buildIndex();
        Path classPath = this.getExistingPath(moduleIndex, className);
        if (classPath != null) {
            try (InputStream inputStream = Files.newInputStream(classPath, StandardOpenOption.READ);){
                int read;
                byte[] bytes = new byte[16384];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((read = inputStream.read(bytes)) >= 0) {
                    out.write(bytes, 0, read);
                }
                byte[] byArray = out.toByteArray();
                return byArray;
            }
        }
        return new byte[0];
    }

    @Override
    protected long getLength(String moduleIndex, String className) throws IOException {
        this.buildIndex();
        if ("module-info".equals(className)) {
            Path classPath = this.getExistingPath(moduleIndex, className);
            if (classPath != null) {
                return Files.size(classPath);
            }
            return -1L;
        }
        return this.getLengthForClass(className.replace('\\', '.').replace('/', '.'));
    }

    @Override
    protected ModularizedJdkURLFileSystemHelper.LocatorType getLocatorType() {
        return ModularizedJdkURLFileSystemHelper.LocatorType.JRT_LOCATOR;
    }

    private void indexClasses(String moduleIndex, String moduleName, Path dirPath, Map<String, Map<String, ModularizedJdkBaseLocator.ClassDetails>> packageToClassDetails, Map<String, Collection<String>> packageToSubMap, boolean checkInterrupt) throws IOException, InterruptedException {
        if (Files.isDirectory(dirPath, LinkOption.NOFOLLOW_LINKS)) {
            if (checkInterrupt) {
                ModularizedJdkJrtfsLocator.checkInterrupt();
            }
            Stream<Path> stream = Files.list(dirPath);
            Iterator streamIter = stream.iterator();
            while (streamIter.hasNext()) {
                Path path;
                String pathName;
                if (checkInterrupt) {
                    ModularizedJdkJrtfsLocator.checkInterrupt();
                }
                if ((pathName = (path = (Path)streamIter.next()).toString()).endsWith(".class")) {
                    String moduleRootPath = this.getModuleRootPath(moduleName);
                    this.indexClassMaps(moduleIndex, moduleName, pathName.substring(moduleRootPath.length()), Files.size(path), packageToClassDetails, packageToSubMap);
                    continue;
                }
                this.indexClasses(moduleIndex, moduleName, path, packageToClassDetails, packageToSubMap, checkInterrupt);
            }
        }
    }

    private Path getExistingPath(String moduleIndex, String className) {
        String moduleName = this.getModuleName(moduleIndex);
        if (moduleName == null) {
            moduleName = this.getModuleNameOfClass(((String)className).replace('\\', '.').replace('/', '.'));
        }
        if (moduleName == null) {
            return null;
        }
        className = (String)className + ".class";
        String[] pieces = ((String)className).replace('\\', '/').split("/");
        String[] allPieces = new String[1 + pieces.length];
        allPieces[0] = moduleName;
        for (int x = 0; x < pieces.length; ++x) {
            allPieces[1 + x] = pieces[x];
        }
        return this._fs.getPath(this.actualModulesPathName, allPieces);
    }

    private String getModuleRootPath(String moduleName) {
        return this.actualModulesPathName + "/" + moduleName + "/";
    }

    @Override
    public URLPath getExpandedClassPath() {
        URL[] jmods;
        URLPath path = new URLPath();
        URL url = URLFileSystem.getParent((URL)this._jrtfsjar);
        url = URLFileSystem.getParent((URL)url);
        url = URLFactory.newURL((URL)url, (String)"jmods");
        for (URL jmod : jmods = URLFileSystem.list((URL)url)) {
            if (!URLFileSystem.hasSuffix((URL)jmod, (String)".jmod")) continue;
            URL rootPath = URLFactory.newJarURL((URL)jmod, (String)"classes/");
            path.add(rootPath);
        }
        return path;
    }
}

