/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITRevisionSelector
extends Observable {
    private static final String F1_HELP_ID = "f1_git_select_revision_html";
    private JEWTDialog _dialog;
    private String _revisionTo;
    private URL _root;

    GITRevisionSelector(String revisionTo, URL root) {
        this._revisionTo = revisionTo;
        this._root = root;
    }

    void showLister() {
        GitRevisionInfo[] revisions = this.getRevisions();
        if (revisions != null && revisions.length > 0) {
            final GITRevisionPanel panel = new GITRevisionPanel(revisions);
            this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)panel.getDefaultComp(), (String)Resource.get("CHECKOUT_REVISION_TITLE"), (int)7);
            this._dialog.setOKButtonEnabled(false);
            this._dialog.setName("Revision Selector");
            this._dialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                        if (this.getSelectedRevision() != null) {
                            GITRevisionSelector.this.setChanged();
                        }
                        GITRevisionSelector.this.notifyObservers(this.getSelectedRevision());
                    }
                }

                private String getSelectedRevision() {
                    return panel.getSelectedRevision();
                }
            });
            try {
                this._dialog.runDialog();
            }
            finally {
                this._dialog.dispose();
            }
        }
    }

    private void selectionMade() {
        this._dialog.setOKButtonEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GitRevisionInfo[] getRevisions() {
        GitClient client = null;
        GitRevisionInfo[] revisions = null;
        try {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Log");
            client = GITClientAdaptor.getClient(this._root);
            SearchCriteria sc = new SearchCriteria();
            File[] files = new File[]{new File(this._root.toURI())};
            sc.setFiles(files);
            sc.setRevisionTo(this._revisionTo);
            revisions = client.log(sc, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)monitor.getError(), (String)Resource.get("REVISION_ERROR_TITLE"), null);
            }
        }
        catch (Exception f) {
            ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)f, (String)Resource.get("PROCESS_EXCEPTION_REVISIONS"));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return revisions;
    }

    private class GITRevisionPanel
    extends JPanel {
        private GenericTable _table;

        private GITRevisionPanel(GitRevisionInfo[] revisions) {
            RevsionTableModel model = new RevsionTableModel(revisions);
            this._table = new GenericTable((TableModel)model);
            this._table.setSelectionMode(0);
            this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    GITRevisionSelector.this.selectionMade();
                }
            });
            this.initLayout();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, GITRevisionSelector.F1_HELP_ID);
        }

        private Component getDefaultComp() {
            return this._table;
        }

        private void initLayout() {
            Insets ins = new Insets(5, 5, 5, 5);
            this.setLayout(new GridBagLayout());
            this.add((Component)new JScrollPane((Component)this._table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
        }

        private String getSelectedRevision() {
            int selected = this._table.getSelectedRowInModel();
            return ((RevsionTableModel)this._table.getModel()).getSelectedRevision(selected);
        }
    }

    private static class RevsionTableModel
    extends DefaultTableModel {
        private List<GitRevisionInfo> _revisions = new ArrayList<GitRevisionInfo>();
        private String[] _columns = new String[]{Resource.get("REVISION_COLUMN1"), Resource.get("REVISION_COLUMN2"), Resource.get("REVISION_COLUMN3"), Resource.get("REVISION_COLUMN4")};

        RevsionTableModel(GitRevisionInfo[] revisions) {
            for (GitRevisionInfo revision : revisions) {
                this._revisions.add(revision);
            }
        }

        private String getSelectedRevision(int row) {
            GitRevisionInfo revision = this._revisions.get(row);
            return revision.getRevision();
        }

        @Override
        public int getRowCount() {
            if (this._revisions != null) {
                return this._revisions.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return this._columns.length;
        }

        @Override
        public String getColumnName(int column) {
            if (column < this._columns.length) {
                return this._columns[column];
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            GitRevisionInfo revision = this._revisions.get(row);
            if (revision != null) {
                if (column == 0) {
                    return revision.getRevision();
                }
                if (column == 1) {
                    return new Date(revision.getCommitTime());
                }
                if (column == 2) {
                    return revision.getCommitter();
                }
                if (column == 3) {
                    return revision.getShortMessage();
                }
            }
            return null;
        }
    }
}

