/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.macro;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.ide.Context;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.macro.MacroExpander;
import oracle.ide.externaltools.macro.MacroPicker;
import oracle.ide.externaltools.macro.MacroRegistry;
import oracle.ide.externaltools.macro.Parameter;
import oracle.ide.externaltools.macro.ParameterizedMacro;
import oracle.ideimpl.externaltools.ExternalToolsHook;
import oracle.ideimpl.externaltools.ui.MacroPickerImpl;

public class MacroRegistryImpl
extends MacroRegistry {
    private Map<String, MacroExpander> m_macroMap = null;

    @Override
    public Collection<MacroExpander> getMacros() {
        return Collections.unmodifiableCollection(this.getMap().values());
    }

    @Override
    public void register(MacroExpander expander) {
        this.getMap().put(expander.getMacro(), expander);
    }

    @Override
    public void deregister(MacroExpander expander) {
        this.getMap().remove(expander.getMacro());
    }

    private Map<String, MacroExpander> getMap() {
        if (this.m_macroMap == null) {
            this.m_macroMap = new TreeMap<String, MacroExpander>();
            for (MacroExpander macro : ExternalToolsHook.getDeclaredExternalTools().getMacros()) {
                this.m_macroMap.put(macro.getMacro(), macro);
            }
        }
        return this.m_macroMap;
    }

    @Override
    public String expand(String text, Context context, boolean isSample) {
        if (text == null) {
            return "";
        }
        StringBuffer outBuffer = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '$' && i + 1 < text.length() && text.charAt(i + 1) == '{') {
                int stop = text.indexOf(125, i + 1);
                if (stop == -1) {
                    outBuffer.append('$');
                    continue;
                }
                if (stop == i + 1) {
                    outBuffer.append('$');
                    continue;
                }
                String moniker = text.substring(i + 2, stop);
                MacroExpander macro = null;
                int colonPos = moniker.indexOf(58);
                if (colonPos > 0) {
                    String params = moniker.substring(colonPos + 1);
                    moniker = moniker.substring(0, colonPos);
                    macro = this.getMap().get(moniker);
                    if (macro != null && macro instanceof ParameterizedMacro) {
                        ParameterizedMacro pm = (ParameterizedMacro)macro;
                        for (Parameter p : pm.getSupportedParameters()) {
                            pm.setValue(p, null);
                        }
                        StringTokenizer tk = new StringTokenizer(params, ";");
                        while (tk.hasMoreTokens()) {
                            String token = tk.nextToken();
                            int equalPos = token.indexOf(61);
                            if (equalPos <= 0) continue;
                            String name = token.substring(0, equalPos);
                            String value = token.substring(equalPos + 1);
                            Parameter p = pm.findParameter(name);
                            if (p == null) continue;
                            pm.setValue(p, value);
                        }
                    }
                } else {
                    macro = this.getMap().get(moniker);
                }
                if ((macro = this.getMap().get(moniker)) != null) {
                    String result = isSample ? null : macro.expand(context);
                    if ("null".equals(result)) {
                        return "";
                    }
                    if (result != null) {
                        outBuffer.append(result);
                    }
                    i = stop;
                    continue;
                }
            }
            outBuffer.append(text.charAt(i));
        }
        return outBuffer.toString();
    }

    @Override
    @Deprecated
    public MacroPicker getPicker(ExternalToolType type, boolean onlyDirectories) {
        MacroPickerImpl mpi = new MacroPickerImpl();
        mpi.populate(this, type, onlyDirectories);
        return mpi;
    }

    @Override
    public MacroExpander findMacro(String moniker) {
        return this.getMap().get(moniker);
    }
}

