/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.popup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.popup.PopupWindow;
import oracle.javatools.editor.popup.PopupWindowListener;
import oracle.javatools.ui.GraphicsUtils;

@Deprecated
public class PopupWindowManager
implements EditorPlugin,
FocusListener {
    private EditorListener editorListener = new EditorListener();
    private static final String PWM_KEY = "**PWM_KEY**";
    private BasicEditorPane editorPane;
    private final List<PopupWindow> popupList = new ArrayList<PopupWindow>();
    public static final int WEST = 1;
    public static final int EAST = 2;
    public static final int NORTH = 4;
    public static final int SOUTH = 8;
    private static final int SPACING = 5;
    private int[] LOCATION_COUNT = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PopupWindowManager getPopupWindowManager(BasicEditorPane editor) {
        String string = PWM_KEY;
        synchronized (PWM_KEY) {
            PopupWindowManager pwm = (PopupWindowManager)editor.getProperty(PWM_KEY);
            if (pwm == null) {
                pwm = new PopupWindowManager();
                editor.installPlugin(pwm);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return pwm;
        }
    }

    private PopupWindowManager() {
    }

    protected BasicEditorPane getEditorPane() {
        return this.editorPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(BasicEditorPane editor) {
        String string = PWM_KEY;
        synchronized (PWM_KEY) {
            editor.putProperty(PWM_KEY, this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            editor.addFocusListener(this);
            editor.addAncestorListener(this.editorListener);
            editor.addMouseWheelListener(this.editorListener);
            this.editorPane = editor;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deinstall(BasicEditorPane editor) {
        editor.removeAncestorListener(this.editorListener);
        editor.removeMouseWheelListener(this.editorListener);
        for (PopupWindow popup : this.getPopupWindows()) {
            this.dismissPopup(popup);
            popup.listener = null;
        }
        String string = PWM_KEY;
        synchronized (PWM_KEY) {
            editor.putProperty(PWM_KEY, null);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            editor.removeFocusListener(this);
            this.editorPane = null;
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    public PopupWindow createPopup(Component content, boolean focusable) {
        BasicEditorPane editorPane = this.getEditorPane();
        Window parentWindow = SwingUtilities.getWindowAncestor(editorPane);
        JWindow window = new JWindow(parentWindow);
        GraphicsUtils.setWindowOpacity((Window)window, (float)0.94f);
        Dimension contentSize = content.getPreferredSize();
        window.getContentPane().add(content);
        window.setSize(contentSize);
        window.validate();
        PopupWindow popup = new PopupWindow(content, window);
        window.setFocusableWindowState(focusable);
        return popup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPopup(PopupWindow popup, PopupWindowListener listener) {
        List<PopupWindow> list = this.popupList;
        synchronized (list) {
            popup.listener = listener;
            popup.visible = true;
            this.popupList.add(popup);
        }
        popup.window.setVisible(true);
        this.transferFocusToEditor();
    }

    public void positionPopup(PopupWindow popupWindow, Rectangle relativeToLocation, int[] preferredLocations) {
        this.positionPopup(popupWindow, relativeToLocation, preferredLocations, true);
    }

    public void positionPopup(PopupWindow popupWindow, Rectangle relativeToLocation, int[] preferredLocations, boolean center) {
        Rectangle absoluteLocation = this.convertToAbsolute(relativeToLocation);
        Point absolutePoint = new Point(absoluteLocation.x, absoluteLocation.y);
        Object[] screenInfo = this.getScreenInfo(absolutePoint);
        Rectangle screenBounds = (Rectangle)screenInfo[0];
        Insets screenInsets = (Insets)screenInfo[2];
        screenInsets.top += 5;
        screenInsets.left += 5;
        screenInsets.right += 5;
        screenInsets.bottom += 5;
        absoluteLocation = this.ensureOnScreen(screenBounds, screenInsets, absoluteLocation);
        JWindow window = popupWindow.window;
        Dimension viewSize = new Dimension(window.getWidth(), window.getHeight());
        int[] availableLocations = this.getAvailableLocations(screenBounds, screenInsets, viewSize, absoluteLocation, preferredLocations);
        int locationToUse = availableLocations[0];
        Point viewPosition = this.calculateLocation(screenBounds, screenInsets, absoluteLocation, viewSize, locationToUse, center);
        PopupWindow currentPopup = popupWindow.visible ? popupWindow : null;
        Point adjustedPosition = this.adjustForCollisions(currentPopup, screenBounds, screenInsets, viewPosition, viewSize, locationToUse);
        window.setLocation(adjustedPosition);
    }

    public void changePopupContent(PopupWindow popup, Component content, boolean focusable) {
        Component oldContent = popup.content;
        JWindow window = popup.window;
        window.getContentPane().remove(oldContent);
        popup.content = content;
        window.getContentPane().add(content);
        window.setFocusableWindowState(focusable);
        Dimension contentSize = content.getPreferredSize();
        window.setSize(contentSize);
        window.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismissPopup(PopupWindow popup) {
        List<PopupWindow> list = this.popupList;
        synchronized (list) {
            this.popupList.remove(popup);
        }
        JWindow window = popup.window;
        if (window != null) {
            window.dispose();
            popup.window = null;
            popup.visible = false;
        }
        if (popup.listener != null) {
            popup.listener.popupClosed(popup, 2);
        }
        popup.listener = null;
    }

    @Override
    public void focusGained(FocusEvent event) {
        for (PopupWindow popup : this.getPopupWindows()) {
            popup.listener.editorFocusGained(popup);
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        boolean isTemporary = event.isTemporary();
        PopupWindow[] windows = this.getPopupWindows();
        int numPopups = windows.length;
        Component newFocusComp = event.getOppositeComponent();
        if (newFocusComp != null) {
            for (PopupWindow window : windows) {
                if (window.window != newFocusComp) continue;
                return;
            }
        }
        for (int i = 0; i < numPopups; ++i) {
            PopupWindow popup = windows[i];
            if (popup.listener == null) continue;
            popup.listener.editorFocusLost(popup, isTemporary);
        }
    }

    private int[] getAvailableLocations(Rectangle screenBounds, Insets screenInsets, Dimension viewSize, Rectangle locationRect, int[] preferredLocations) {
        boolean nothingAvailable;
        int available = 0;
        int requested = 0;
        int numRequested = preferredLocations.length;
        for (int i = 0; i < numRequested; ++i) {
            requested |= preferredLocations[i];
        }
        if ((requested & 0xC) != 0) {
            int locationBottom;
            int usableSpaceBelow;
            int viewHeight = viewSize.height;
            nothingAvailable = true;
            int screenTop = screenBounds.y + screenInsets.top;
            int screenBottom = screenBounds.y + screenBounds.height - screenInsets.bottom;
            int usableSpaceAbove = locationRect.y - screenTop - viewHeight;
            if (usableSpaceAbove >= 0) {
                available |= 4;
                nothingAvailable = false;
            }
            if ((usableSpaceBelow = screenBottom - (locationBottom = locationRect.y + locationRect.height) - viewHeight) >= 0) {
                available |= 8;
                nothingAvailable = false;
            }
            if (nothingAvailable) {
                available |= usableSpaceBelow > usableSpaceAbove ? 4 : 8;
            }
        }
        if ((requested & 3) != 0) {
            int locationRight;
            int usableSpaceRight;
            int viewWidth = viewSize.width;
            nothingAvailable = true;
            int screenLeft = screenBounds.x + screenInsets.left;
            int screenRight = screenBounds.x + screenBounds.width - screenInsets.right;
            int usableSpaceLeft = locationRect.x - screenLeft - viewWidth;
            if (usableSpaceLeft >= 0) {
                available |= 1;
                nothingAvailable = false;
            }
            if ((usableSpaceRight = screenRight - (locationRight = locationRect.x + locationRect.width) - viewWidth) >= 0) {
                available |= 2;
                nothingAvailable = false;
            }
            if (nothingAvailable) {
                available |= usableSpaceRight > usableSpaceLeft ? 2 : 1;
            }
        }
        int numAvailable = this.LOCATION_COUNT[available];
        int availIndex = 0;
        int[] availableLocations = new int[numAvailable];
        for (int i = 0; i < numRequested; ++i) {
            if ((preferredLocations[i] & available) == 0) continue;
            availableLocations[availIndex++] = preferredLocations[i];
        }
        return availableLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PopupWindow[] getPopupWindows() {
        PopupWindow[] allPopups;
        List<PopupWindow> list = this.popupList;
        synchronized (list) {
            allPopups = this.popupList.toArray(new PopupWindow[this.popupList.size()]);
        }
        return allPopups;
    }

    private Point adjustForCollisions(PopupWindow currentPopup, Rectangle screenBounds, Insets screenInsets, Point viewPosition, Dimension viewSize, int locationUsed) {
        Rectangle currentRectangle = new Rectangle(viewPosition, viewSize);
        PopupWindow[] allPopups = this.getPopupWindows();
        PopupWindow[] regionPopups = this.findPopupsInRegion(currentPopup, currentRectangle, locationUsed, allPopups);
        PopupWindow[] collidingPopups = this.findCollidingPopups(currentRectangle, regionPopups);
        if (collidingPopups.length > 0) {
            int size = collidingPopups.length;
            for (int i = 0; i < size; ++i) {
                int attempt = i + 1;
                PopupWindow[] attemptPopups = new PopupWindow[attempt];
                System.arraycopy(collidingPopups, 0, attemptPopups, 0, attempt);
                Rectangle collidingRect = this.getPopupSpace(attemptPopups);
                Point attemptPoint = this.avoidCollision(collidingRect, screenBounds, screenInsets, viewPosition, viewSize, locationUsed);
                if (attemptPoint == null) break;
                Rectangle attemptRect = new Rectangle(attemptPoint, viewSize);
                if (this.findCollidingPopups(attemptRect, regionPopups).length != 0) continue;
                return attemptPoint;
            }
        }
        return viewPosition;
    }

    private Point avoidCollision(Rectangle collidingRect, Rectangle screenBounds, Insets screenInsets, Point viewPosition, Dimension viewSize, int locationUsed) {
        int screenLeft = screenBounds.x + screenInsets.left;
        int screenTop = screenBounds.y + screenInsets.top;
        int screenRight = screenBounds.x + screenBounds.width - screenInsets.right;
        int screenBottom = screenBounds.y + screenBounds.height - screenInsets.bottom;
        int spaceAbove = collidingRect.y - screenTop - 5;
        int spaceBelow = screenBottom - (collidingRect.y + collidingRect.height) - 5;
        int spaceLeft = collidingRect.x - screenLeft - 5;
        int spaceRight = screenRight - (collidingRect.x + collidingRect.width) - 5;
        int viewWidth = viewSize.width;
        int viewHeight = viewSize.height;
        block12: for (int dir : switch (locationUsed) {
            case 4 -> new int[]{2, 1, 4};
            case 8 -> new int[]{2, 1, 8};
            case 1 -> new int[]{4, 8, 1};
            case 2 -> new int[]{4, 8, 2};
            default -> throw new IllegalStateException("unknown loc: " + locationUsed);
        }) {
            switch (dir) {
                case 4: {
                    if (spaceAbove <= viewHeight) continue block12;
                    int yPos = collidingRect.y - viewHeight - 1;
                    return new Point(viewPosition.x, yPos);
                }
                case 8: {
                    if (spaceBelow <= viewHeight) continue block12;
                    int yPos = collidingRect.y + collidingRect.height + 1;
                    return new Point(viewPosition.x, yPos);
                }
                case 1: {
                    if (spaceLeft <= viewWidth) continue block12;
                    int xPos = collidingRect.x - viewWidth - 1;
                    return new Point(xPos, viewPosition.y);
                }
                case 2: {
                    if (spaceRight <= viewWidth) continue block12;
                    int xPos = collidingRect.x + collidingRect.width + 1;
                    return new Point(xPos, viewPosition.y);
                }
            }
        }
        return null;
    }

    private Rectangle getPopupSpace(PopupWindow[] popups) {
        Rectangle unionRect = null;
        for (PopupWindow checkPopup : popups) {
            JWindow checkWindow = checkPopup.window;
            unionRect = unionRect == null ? checkWindow.getBounds() : unionRect.union(checkWindow.getBounds());
        }
        if (unionRect != null) {
            this.addPadding(unionRect);
        }
        return unionRect;
    }

    private void addPadding(Rectangle rect) {
        rect.x -= 5;
        rect.y -= 5;
        rect.width += 10;
        rect.height += 10;
    }

    private PopupWindow[] findCollidingPopups(Rectangle currentRect, PopupWindow[] regionPopups) {
        Rectangle checkRect = new Rectangle();
        ArrayList<PopupWindow> regionList = new ArrayList<PopupWindow>();
        for (PopupWindow checkPopup : regionPopups) {
            JWindow checkWindow = checkPopup.window;
            checkWindow.getBounds(checkRect);
            this.addPadding(checkRect);
            if (!checkRect.intersects(currentRect)) continue;
            regionList.add(checkPopup);
        }
        int size = regionList.size();
        return regionList.toArray(new PopupWindow[size]);
    }

    private PopupWindow[] findPopupsInRegion(PopupWindow currentPopup, Rectangle currentRect, int locationUsed, PopupWindow[] allPopups) {
        Rectangle checkRect = new Rectangle();
        ArrayList<PopupWindow> regionList = new ArrayList<PopupWindow>();
        for (PopupWindow checkPopup : allPopups) {
            if (checkPopup == currentPopup) continue;
            JWindow checkWindow = checkPopup.window;
            checkWindow.getBounds(checkRect);
            boolean inRegion = false;
            switch (locationUsed) {
                case 4: {
                    int currentBottom = currentRect.y + currentRect.height;
                    if (checkRect.y >= currentBottom) break;
                    inRegion = true;
                    break;
                }
                case 8: {
                    int checkBottom = checkRect.y + checkRect.height;
                    if (currentRect.y >= checkBottom) break;
                    inRegion = true;
                    break;
                }
                case 2: {
                    int checkRight = checkRect.x + checkRect.width;
                    if (currentRect.x >= checkRight) break;
                    inRegion = true;
                    break;
                }
                case 1: {
                    int currentRight = currentRect.x + currentRect.width;
                    if (checkRect.x >= currentRight) break;
                    inRegion = true;
                }
            }
            if (!inRegion) continue;
            regionList.add(checkPopup);
        }
        int size = regionList.size();
        return regionList.toArray(new PopupWindow[size]);
    }

    private int adjustXForEditor(int xPos, int width) {
        Point editorOrigin = this.getEditorPane().getLocationOnScreen();
        int editorX = editorOrigin.x;
        Rectangle editorRect = this.getEditorPane().getVisibleRect();
        int editorWidth = editorRect.width;
        int editorViewX = editorRect.x;
        int editorLeftEdgeX = editorX + editorViewX;
        int editorRightEdgeX = editorLeftEdgeX + editorWidth;
        int INSET = 2;
        if (width > editorWidth - INSET * 2) {
            xPos = editorX - (width - editorWidth) / 2;
        } else if (xPos < editorLeftEdgeX + INSET) {
            xPos = editorLeftEdgeX + INSET;
        } else if (xPos + width > editorRightEdgeX - INSET) {
            xPos = editorRightEdgeX - INSET - width;
        }
        return xPos;
    }

    private int adjustYForEditor(int yPos, int height) {
        Point editorOrigin = this.getEditorPane().getLocationOnScreen();
        int editorY = editorOrigin.y;
        Rectangle editorRect = this.getEditorPane().getVisibleRect();
        int editorHeight = editorRect.height;
        int editorViewY = editorRect.y;
        int editorTopEdgeY = editorY + editorViewY;
        int editorBottomEdgeY = editorY + editorViewY + editorHeight;
        int INSET = 2;
        if (height > editorHeight - INSET * 2) {
            yPos = editorY - (height - editorHeight) / 2;
        } else if (yPos < editorTopEdgeY + INSET) {
            yPos = editorTopEdgeY + INSET;
        } else if (yPos + height > editorBottomEdgeY - INSET) {
            yPos = editorBottomEdgeY - INSET - height;
        }
        return yPos;
    }

    private Point calculateLocation(Rectangle screenBounds, Insets screenInsets, Rectangle locationRect, Dimension viewSize, int locationToUse, boolean centered) {
        int yPos;
        int xPos;
        int viewHeight = viewSize.height;
        int viewWidth = viewSize.width;
        switch (locationToUse) {
            default: {
                xPos = locationRect.x;
                if (centered) {
                    xPos -= viewWidth / 2;
                }
                xPos = this.adjustXForEditor(xPos, viewWidth);
                break;
            }
            case 2: {
                xPos = locationRect.x + locationRect.width + 5;
                break;
            }
            case 1: {
                xPos = locationRect.x - 5 - viewWidth;
            }
        }
        switch (locationToUse) {
            case 1: 
            case 2: {
                yPos = locationRect.y - viewHeight / 2;
                yPos = this.adjustYForEditor(yPos, viewHeight);
                break;
            }
            case 4: {
                yPos = locationRect.y - viewHeight - 5;
                break;
            }
            default: {
                yPos = locationRect.y + locationRect.height + 5;
            }
        }
        Point viewPos = new Point(xPos, yPos);
        Rectangle calcRect = new Rectangle(viewPos, viewSize);
        calcRect = this.ensureOnScreen(screenBounds, screenInsets, calcRect);
        return new Point(calcRect.x, calcRect.y);
    }

    private Object[] getScreenInfo(Point editorPoint) {
        Rectangle screenBounds;
        Insets screenInsets;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        for (int i = 0; i < gd.length; ++i) {
            GraphicsConfiguration dgc;
            if (gd[i].getType() != 0 || !(dgc = gd[i].getDefaultConfiguration()).getBounds().contains(editorPoint)) continue;
            gc = dgc;
            break;
        }
        if (gc == null) {
            BasicEditorPane component = this.getEditorPane();
            gc = component.getGraphicsConfiguration();
        }
        if (gc != null) {
            screenInsets = toolkit.getScreenInsets(gc);
            screenBounds = gc.getBounds();
        } else {
            screenInsets = new Insets(0, 0, 0, 0);
            screenBounds = new Rectangle(toolkit.getScreenSize());
        }
        Dimension screenSize = new Dimension(screenBounds.width, screenBounds.height);
        return new Object[]{screenBounds, screenSize, screenInsets};
    }

    private Rectangle ensureOnScreen(Rectangle screenBounds, Insets screenInsets, Rectangle absoluteLocation) {
        Rectangle rect = new Rectangle(absoluteLocation);
        int left = screenBounds.x + screenInsets.left;
        int top = screenBounds.y + screenInsets.top;
        int right = screenBounds.x + screenBounds.width - screenInsets.right;
        int bottom = screenBounds.y + screenBounds.height - screenInsets.bottom;
        if (rect.x < left) {
            rect.x = left;
        }
        if (rect.y < top) {
            rect.y = top;
        }
        if (rect.x + rect.width > right) {
            rect.x = right - rect.width;
        }
        if (rect.y + rect.height > bottom) {
            rect.y = bottom - rect.height;
        }
        return rect;
    }

    private Rectangle convertToAbsolute(Rectangle relativeRect) {
        Rectangle absoluteRect = new Rectangle(relativeRect);
        Point editorOrigin = this.getEditorPane().getLocationOnScreen();
        absoluteRect.x = (int)((double)absoluteRect.x + editorOrigin.getX());
        absoluteRect.y = (int)((double)absoluteRect.y + editorOrigin.getY());
        return absoluteRect;
    }

    private void transferFocusToEditor() {
        final BasicEditorPane editorToFocus = this.getEditorPane();
        Runnable focusTask = new Runnable(){

            @Override
            public void run() {
                editorToFocus.requestFocus();
            }
        };
        SwingUtilities.invokeLater(focusTask);
    }

    private class EditorListener
    implements AncestorListener,
    MouseWheelListener {
        private EditorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
            if (event.getAncestorParent() != null && event.getAncestorParent() instanceof JViewport) {
                return;
            }
            this.dismiss();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.dismiss();
        }

        private void dismiss() {
            for (PopupWindow w : PopupWindowManager.this.getPopupWindows()) {
                PopupWindowManager.this.dismissPopup(w);
            }
        }
    }
}

