/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.language.LexerDocumentRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;

public abstract class LexerOffsetsCache {
    private LexerDocumentRenderer documentRenderer;

    public LexerOffsetsCache(LexerDocumentRenderer documentRenderer) {
        this.documentRenderer = documentRenderer;
    }

    public final synchronized int findClosestOffset(Lexer lexer, LexerToken lexerToken, int offset) {
        int offsetToUse = 0;
        try {
            offsetToUse = this.findClosestOffsetInternal(lexer, lexerToken, offset);
        }
        catch (ExpiredTextBufferException ex) {
            throw ex;
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").log(Level.WARNING, "Lexer cache exception.", e);
            try {
                this.invalidateOffsets(0);
                offsetToUse = this.findClosestOffsetInternal(lexer, lexerToken, offset);
            }
            catch (RuntimeException e2) {
                Logger.getLogger("global").log(Level.SEVERE, "Lexer cache irrecoverable.", e2);
                offsetToUse = 0;
            }
        }
        return offsetToUse;
    }

    public final synchronized void invalidateOffsets(int startOffset) {
        this.invalidateOffsetsInternal(startOffset);
    }

    protected abstract int findClosestOffsetInternal(Lexer var1, LexerToken var2, int var3);

    protected abstract void invalidateOffsetsInternal(int var1);

    protected final LexerDocumentRenderer getDocumentRenderer() {
        return this.documentRenderer;
    }
}

