/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.gutter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.Document;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverProperties;
import oracle.ide.hover.HoverProvider;
import oracle.ide.hover.Hoverable;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.IconScaler;
import oracle.javatools.ui.internal.Exceptions;
import oracle.javatools.util.Log;

public class LineGutterPlugin
extends JComponent
implements ComponentListener,
DocumentListener,
EditorPlugin,
Gutter,
MouseListener,
MouseMotionListener,
TextBufferListener,
Hoverable {
    private static final Log LOG = new Log("gutter");
    public static final int SHOW_LINE_NUMBERS_ALWAYS = 1;
    public static final int SHOW_LINE_NUMBERS_NEVER = 2;
    public static final int SHOW_LINE_NUMBERS_DEFAULT = 3;
    protected int _showLineNumberFlag = 3;
    protected static List<Column.Mark> _scratchList = null;
    private static final boolean JUSTIFY_MARKS_RIGHT = true;
    private static final int LEFT_PADDING = 1;
    private static final int RIGHT_PADDING = 3;
    private static final int ICON_SPACING = 2;
    private static final int MINIMUM_DIGITS = 3;
    private int _minimumDigits = 3;
    private List<Column> _columnsList;
    private int _width = -1;
    private int _minWidth = 30;
    private static final int MAX_ICON_WIDTH = 24;
    private CopyOnWriteArrayList<GutterClickListener> _clickListeners;
    private BasicEditorPane _editor;
    private HighlightLayer _highlightLayer;
    private BasicDocument _document;
    private Font _font;
    private int _fontHeight;
    private int _fontAscent;
    private int _fontWidth;
    private int _lineCount;
    private int _rowCount;
    private volatile boolean _gutterResizeNeeded;
    private Dimension _gutterSize;
    private Rectangle _gutterBounds;
    private Rectangle _rolloverBounds;
    private boolean _showLineNumbers;
    private Color _borderColor;
    private int _pressedY;
    private boolean _selectStarted;
    private boolean _inReload;
    private boolean _inCompoundEdits;
    private List<DocumentUpdate> _compoundEdits;
    private int _location = 2;
    private final PropertyChangeListener _editorPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CodeFoldingMargin margin;
            if (evt.getPropertyName().equals("code-folding-margin") && (margin = (CodeFoldingMargin)evt.getNewValue()) != null) {
                margin.addCodeExpansionListener(LineGutterPlugin.this._codeExpansionListener);
            }
        }
    };
    private final CodeExpansionListener _codeExpansionListener = new CodeExpansionListener(){

        @Override
        public void codeExpanded(CodeExpansionEvent event) {
            LineGutterPlugin.this.linesChanged();
        }

        @Override
        public void codeCollapsed(CodeExpansionEvent event) {
            LineGutterPlugin.this.linesChanged();
        }
    };
    private List<Column.Mark> temporaryMarksOnLine = new ArrayList<Column.Mark>();
    private List<String> temporaryOverlaidColumns = new ArrayList<String>();
    private static final int DRAG_SENSITIVITY = 4;
    protected boolean _mouseInGutter = false;
    protected GutterMark _mouseInMark = null;
    protected static final Comparator<GutterMark> MARK_COMPARATOR = new MarkComparator();

    public LineGutterPlugin() {
        this.setFocusable(false);
        this.setOpaque(true);
    }

    @Override
    public void install(BasicEditorPane editor) {
        LOG.trace("installing {0}", (Object)this);
        this._columnsList = new ArrayList<Column>(5);
        this._clickListeners = new CopyOnWriteArrayList();
        this._editor = editor;
        this.installDocument((BasicDocument)editor.getDocument());
        this._inReload = false;
        this._inCompoundEdits = false;
        this._compoundEdits = new ArrayList<DocumentUpdate>();
        this._highlightLayer = editor.createHighlightLayer();
        this._gutterResizeNeeded = true;
        this._gutterSize = new Dimension();
        this._gutterBounds = new Rectangle();
        this._rolloverBounds = new Rectangle();
        this.updateShowLineNumbers();
        this.updateMetrics();
        this.updateColors();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        editor.addComponentListener(this);
        this.setAutoscrolls(this.allowDragging());
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        CodeFoldingMargin margin = (CodeFoldingMargin)editor.getProperty("code-folding-margin");
        if (margin != null) {
            margin.addCodeExpansionListener(this._codeExpansionListener);
        } else {
            editor.addPropertyChangeListener("code-folding-margin", this._editorPropertyChangeListener);
        }
    }

    protected void installDocument(BasicDocument document) {
        this._document = document;
        this._document.addDocumentListener(this);
        LineMap lineMap = document.getLineMap();
        this._lineCount = lineMap.getLineCount();
        TextBuffer textBuffer = document.getTextBuffer();
        textBuffer.addTextBufferListener((TextBufferListener)this);
    }

    @Override
    public void deinstall(BasicEditorPane editor) {
        LOG.trace("deinstalling {0}", (Object)this);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.unregisterComponent(this);
        this.setAutoscrolls(false);
        editor.removeComponentListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.deinstallDocument(this._document);
        this._font = null;
        this._highlightLayer.removeAllHighlights();
        this._editor.destroyHighlightLayer(this._highlightLayer);
        this._highlightLayer = null;
        this._editor = null;
        this._columnsList = null;
        this._clickListeners = null;
        editor.removePropertyChangeListener("code-folding-margin", this._editorPropertyChangeListener);
        CodeFoldingMargin margin = (CodeFoldingMargin)editor.getProperty("code-folding-margin");
        if (margin != null) {
            margin.removeCodeExpansionListener(this._codeExpansionListener);
        }
    }

    protected void deinstallDocument(BasicDocument document) {
        if (document != null && document == this._document) {
            this._document.removeDocumentListener(this);
            TextBuffer textBuffer = this._document.getTextBuffer();
            textBuffer.removeTextBufferListener((TextBufferListener)this);
            this._document = null;
        }
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this._mouseInMark != null) {
            Column column = (Column)this._mouseInMark.getGutterColumn();
            return column.getMarkToolTip(this._mouseInMark, event);
        }
        return null;
    }

    protected void updateShowLineNumbers() {
        boolean oldValue = this._showLineNumbers;
        switch (this._showLineNumberFlag) {
            case 1: {
                this._showLineNumbers = true;
                break;
            }
            case 2: {
                this._showLineNumbers = false;
                break;
            }
            default: {
                this._showLineNumbers = this._editor.getBooleanProperty("show-line-numbers");
            }
        }
        if (this._showLineNumbers != oldValue) {
            this.linesChanged();
        }
    }

    public void setShowLineNumbers(int showFlag) {
        switch (showFlag) {
            case 1: 
            case 2: {
                this._showLineNumberFlag = showFlag;
                break;
            }
            default: {
                this._showLineNumberFlag = 3;
            }
        }
        if (this._editor != null) {
            this.updateShowLineNumbers();
        }
    }

    public void setLocation(int location) {
        this._location = location;
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("show-line-numbers")) {
            this.updateShowLineNumbers();
        } else if (propertyName.equals("gutter-enable-selection")) {
            this.setAutoscrolls(this.allowDragging());
        } else if (propertyName.equals("editor-font")) {
            this.updateMetrics();
        } else if (propertyName.equals("gutter-color-source") || propertyName.equals("gutter-custom-bgcolor") || propertyName.equals("gutter-custom-fgcolor") || propertyName.equals("gutter-default-bordercolor") || propertyName.equals("style-registry")) {
            this.updateColors();
            this.repaint();
        } else if (propertyName.equals("document")) {
            Object newValue;
            Object oldValue = event.getOldValue();
            if (oldValue instanceof Document) {
                this.deinstallDocument(this._document);
            }
            if ((newValue = event.getNewValue()) instanceof Document) {
                this.installDocument((BasicDocument)newValue);
            }
            this.discardAllMarks();
        }
    }

    protected void discardAllMarks() {
        int numColumns = this._columnsList.size();
        for (int i = numColumns - 1; i >= 0; --i) {
            Column column = this._columnsList.get(i);
            column.discardAllGutterMarks();
        }
    }

    protected static synchronized List<Column.Mark> allocateScratchList() {
        List<Column.Mark> listToUse = _scratchList;
        _scratchList = null;
        if (listToUse == null) {
            listToUse = new ArrayList<Column.Mark>(100);
        }
        return listToUse;
    }

    protected static synchronized void freeScratchList(List<Column.Mark> listToFree) {
        if (listToFree != null && _scratchList == null) {
            _scratchList = listToFree;
            listToFree.clear();
        }
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.updateColors();
    }

    public void getMarksOnLine(Collection<Column.Mark> collection, int line) {
        int numColumns = this._columnsList.size();
        for (int i = numColumns - 1; i >= 0; --i) {
            Column column = this._columnsList.get(i);
            column.getMarks(collection, line);
        }
    }

    private void columnsChanged() {
        this._width = -1;
        this.revalidate();
        this.updateMouseInMark(null);
        this.repaint();
    }

    private void markChanged(GutterMark mark, int oldWidth, int newWidth) {
        if (this._width >= 0) {
            int line = mark.getLine();
            if (oldWidth == newWidth) {
                this.repaintLine(line);
            } else {
                Column changedColumn = (Column)mark.getGutterColumn();
                int reservedWidth = 0;
                if (oldWidth <= reservedWidth && newWidth <= reservedWidth) {
                    List<Column> group = changedColumn.group;
                    List<Column.Mark> marks = LineGutterPlugin.allocateScratchList();
                    for (int i = 0; i < group.size(); ++i) {
                        Column column = this._columnsList.get(i);
                        column.getMarks(marks, line);
                        if (marks.size() > 1) break;
                    }
                    if (marks.size() == 1 && mark == marks.get(0)) {
                        LOG.trace("repainting after scanning marks on line {0}", line);
                        this.repaintLine(line);
                    } else {
                        LOG.trace("revalidating after scanning marks on line {0}", line);
                        this.marksChanged();
                    }
                    LineGutterPlugin.freeScratchList(marks);
                } else {
                    LOG.trace("revalidating after width change {0} to {1} on line {2}, reserved {3}", oldWidth, newWidth, line, reservedWidth);
                    this.marksChanged();
                }
            }
        }
    }

    private void marksChanged() {
        this._width = -1;
        this.revalidate();
        this.updateMouseInMark(null);
        this.repaint();
    }

    private void columnMarksRemoved() {
        if (this._width < 0) {
            return;
        }
        this.marksChanged();
        this.repaint();
    }

    private void linesChanged() {
        this.revalidate();
        this.updateMouseInMark(null);
        this.repaint();
    }

    protected void updateColors() {
        Color fgColor;
        Color bgColor;
        if (this._editor == null) {
            return;
        }
        int source = this._editor.getIntegerProperty("gutter-color-source");
        switch (source) {
            case 3: {
                bgColor = (Color)this._editor.getProperty("gutter-custom-bgcolor");
                this._borderColor = fgColor = (Color)this._editor.getProperty("gutter-custom-fgcolor");
                break;
            }
            case 2: {
                StyleRegistry registry = this._editor.getStyleRegistry();
                BaseStyle baseStyle = registry.lookupStyle("base-plain-style");
                bgColor = baseStyle.getBackgroundColor();
                this._borderColor = fgColor = baseStyle.getForegroundColor();
                break;
            }
            default: {
                bgColor = UIManager.getColor("control");
                fgColor = Color.darkGray;
                if (bgColor.equals(fgColor)) {
                    fgColor = Color.lightGray;
                }
                this._borderColor = Color.gray;
            }
        }
        Color defaultBorder = (Color)this._editor.getProperty("gutter-default-bordercolor");
        if (defaultBorder != null) {
            this._borderColor = defaultBorder;
        }
        if (bgColor != null) {
            this.setBackground(bgColor);
        }
        if (fgColor != null) {
            this.setForeground(fgColor);
        }
    }

    protected void updateMetrics() {
        Font currentFont = this._editor.getFont();
        if (this._font == null || currentFont != this._font) {
            this._font = currentFont;
            FontMetrics metrics = this.getFontMetrics(currentFont);
            this._fontHeight = metrics.getHeight();
            this._fontAscent = metrics.getAscent();
            this._fontWidth = metrics.charWidth('0');
            this.linesChanged();
        }
    }

    @Override
    public void revalidate() {
        this._gutterResizeNeeded = true;
        super.revalidate();
    }

    public int getMinimumWidth() {
        return this._minWidth;
    }

    public void setMinimumWidth(int width) {
        this._minWidth = width;
        this.recalculateColumnWidths();
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this._gutterResizeNeeded) {
            return this._gutterSize;
        }
        if (this._editor == null) {
            return new Dimension(0, 0);
        }
        int lineWidth = this.recalculateLineWidths();
        int columnWidth = this.recalculateColumnWidths();
        int editorHeight = this._editor.getHeight();
        this._rowCount = this.getRowCount();
        this._gutterSize.width = Math.max(lineWidth, columnWidth);
        this._gutterSize.height = editorHeight;
        this._gutterResizeNeeded = false;
        return this._gutterSize;
    }

    protected void repaintLine(int line, int extraPixels) {
        if (line <= 0 || line > this._lineCount) {
            return;
        }
        this.updateMouseInMark(null);
        int row = this.getRowFromLine(line);
        int offsetY = (row - 1) * this._fontHeight + this.getTopPadding();
        this.repaint(0, offsetY - extraPixels, this.getWidth(), this._fontHeight + extraPixels * 2);
    }

    protected void repaintLine(int line) {
        this.repaintLine(line, 0);
    }

    @Override
    public void paint(Graphics graphics) {
        int topPadding = this.getTopPadding();
        Rectangle clipRect = graphics.getClipBounds();
        this._gutterBounds.x = 0;
        this._gutterBounds.y = 0;
        this._gutterBounds.width = this.getWidth();
        this._gutterBounds.height = this.getHeight();
        clipRect = clipRect.intersection(this._gutterBounds);
        graphics.setFont(this._font);
        graphics.setColor(this.getBackground());
        if (this.isOpaque()) {
            graphics.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        }
        Color fgColor = this.getForeground();
        if (this._borderColor != null) {
            graphics.setColor(this._borderColor);
        } else {
            graphics.setColor(fgColor);
        }
        if (this._location == 4) {
            graphics.drawLine(this._gutterBounds.x, clipRect.y, this._gutterBounds.x, clipRect.y + clipRect.height - 1);
        } else {
            graphics.drawLine(this._gutterBounds.width - 1, clipRect.y, this._gutterBounds.width - 1, clipRect.y + clipRect.height - 1);
        }
        graphics.setColor(fgColor);
        int startRow = this.getClosestRowFromCoordinate(clipRect.y);
        int endRow = this.getClosestRowFromCoordinate(clipRect.y + clipRect.height);
        int gutterDigits = Math.max(LineGutterPlugin.numDigits(this._lineCount), 3);
        int gutterWidth = this._gutterSize.width - 4;
        int gutterDigitsWidth = gutterDigits * this._fontWidth;
        int digitsStart = this._location == 4 ? 1 : gutterWidth - gutterDigitsWidth + 1;
        List<Column.Mark> marksToPaintList = LineGutterPlugin.allocateScratchList();
        char[] numberChars = new char[gutterDigits];
        int lastLine = 1;
        LineGutterPlugin.setNumber(numberChars, lastLine);
        if (this._editor == null) {
            return;
        }
        boolean useAAText = this._editor.getBooleanProperty("editor-antialiasing");
        Graphics2D graphics2d = useAAText && graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        Object oldAATextValue = null;
        if (graphics2d != null) {
            oldAATextValue = graphics2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        try {
            for (int i = startRow; i <= endRow; ++i) {
                int line = this.getLineFromRow(i);
                this.getVisibleMarks(marksToPaintList, line);
                int rowStart = (i - 1) * this._fontHeight + topPadding;
                boolean iconPainted = false;
                int lastColumnStart = this.getWidth() - 3;
                int numMarks = marksToPaintList.size();
                for (int m = numMarks - 1; m >= 0; --m) {
                    GutterMark mark = marksToPaintList.get(m);
                    Icon icon = mark.getIcon();
                    icon = IconScaler.scaleIcon((Icon)icon, (int)this._fontHeight);
                    int columnWidth = this.markWidth(mark);
                    int columnStart = lastColumnStart - columnWidth;
                    int iconWidth = icon.getIconWidth();
                    int iconHeight = icon.getIconHeight();
                    int iconX = columnStart + (columnWidth - iconWidth >> 1);
                    int iconY = rowStart + (this._fontHeight - iconHeight >> 1);
                    icon.paintIcon(this, graphics, iconX, iconY);
                    iconPainted = true;
                    if (mark == this._mouseInMark) {
                        this.paintRollover(graphics, mark, columnStart, columnWidth, rowStart);
                    }
                    lastColumnStart = columnStart - 2;
                }
                if (iconPainted || !this._showLineNumbers) continue;
                if (line == lastLine + 1) {
                    LineGutterPlugin.incrementNumber(numberChars);
                } else {
                    LineGutterPlugin.setNumber(numberChars, line);
                }
                int digits = LineGutterPlugin.numDigits(numberChars);
                int numSpaces = numberChars.length - digits;
                int lineY = rowStart + this._fontAscent;
                int lineX = digitsStart;
                if (this._location == 2) {
                    lineX += numSpaces * this._fontWidth;
                }
                graphics.drawChars(numberChars, numSpaces, digits, lineX, lineY);
            }
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
        if (graphics2d != null && oldAATextValue != null) {
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAATextValue);
        }
        LineGutterPlugin.freeScratchList(marksToPaintList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getRolloverRectFor(GutterMark markToFind) {
        int line = markToFind.getLine();
        int row = this.getRowFromLine(line);
        int startY = (row - 1) * this._fontHeight + this.getTopPadding();
        List<Column.Mark> marksOnLineList = LineGutterPlugin.allocateScratchList();
        try {
            this.getVisibleMarks(marksOnLineList, line);
            Collections.sort(marksOnLineList, MARK_COMPARATOR);
            int lastColumnStart = this.getWidth() - 3;
            int numMarks = marksOnLineList.size();
            for (int i = numMarks - 1; i >= 0; --i) {
                GutterMark mark = marksOnLineList.get(i);
                int columnWidth = this.markWidth(mark);
                int columnStart = lastColumnStart - columnWidth;
                if (mark == markToFind) {
                    Rectangle rectangle = this.calculateRolloverBounds(new Rectangle(), columnStart, columnWidth, startY);
                    return rectangle;
                }
                lastColumnStart = columnStart - 2;
            }
            Rectangle rectangle = null;
            return rectangle;
        }
        finally {
            LineGutterPlugin.freeScratchList(marksOnLineList);
        }
    }

    private List getVisibleMarks(List<Column.Mark> visibleMarksOnLine, int line) {
        this.temporaryMarksOnLine.clear();
        this.getMarksOnLine(this.temporaryMarksOnLine, line);
        Collections.sort(this.temporaryMarksOnLine, MARK_COMPARATOR);
        List<Column.Mark> marks = this.temporaryMarksOnLine;
        int first = 0;
        int last = this.temporaryMarksOnLine.size();
        return this.filterVisibleMarks(marks, first, last, visibleMarksOnLine);
    }

    private List filterVisibleMarks(List<Column.Mark> marks, int first, int last, List<Column.Mark> visibleMarksOnLine) {
        int i;
        List<String> overlaidColumns = this.temporaryOverlaidColumns;
        overlaidColumns.clear();
        visibleMarksOnLine.clear();
        for (i = first; i < last; ++i) {
            Column column = (Column)marks.get(i).getGutterColumn();
            int constraint = column.getLayoutConstraint();
            String name = column.getLayoutColumn();
            if (constraint != 2 || name == null) continue;
            overlaidColumns.add(name);
        }
        for (i = first; i < last; ++i) {
            GutterColumn column;
            Column.Mark mark = marks.get(i);
            if (!mark.isVisible() || mark.getIcon() == null || overlaidColumns.indexOf((column = mark.getGutterColumn()).getColumnName()) >= 0) continue;
            visibleMarksOnLine.add(mark);
        }
        return visibleMarksOnLine;
    }

    protected Rectangle calculateRolloverBounds(Rectangle bounds, int columnX, int columnWidth, int rowY) {
        bounds.x = columnX - 2;
        bounds.y = rowY;
        bounds.width = columnWidth + 3;
        bounds.height = this._fontHeight - 1;
        if (bounds.x < 0) {
            int shift = Math.abs(bounds.x);
            bounds.x = 0;
            bounds.width -= shift;
        }
        return bounds;
    }

    protected int markWidth(GutterMark mark) {
        if (!mark.isVisible()) {
            return 0;
        }
        Icon icon = mark.getIcon();
        if (icon == null) {
            return 0;
        }
        return Math.min(icon.getIconWidth(), 24);
    }

    protected int reservedColumnWidth(GutterColumn column) {
        int width;
        if (column instanceof Column && (width = ((Column)column).getReservedWidth()) > 0) {
            return Math.min(width, 24);
        }
        return 0;
    }

    protected Rectangle paintRollover(Graphics graphics, GutterMark mark, int columnX, int columnWidth, int rowY) {
        Column column = (Column)mark.getGutterColumn();
        if (column.getMarkSupportsClicks(mark)) {
            this.calculateRolloverBounds(this._rolloverBounds, columnX, columnWidth, rowY);
            Color oldColor = graphics.getColor();
            graphics.setColor(this._borderColor);
            graphics.drawRect(this._rolloverBounds.x, this._rolloverBounds.y, this._rolloverBounds.width, this._rolloverBounds.height);
            graphics.setColor(oldColor);
            return this._rolloverBounds;
        }
        return null;
    }

    protected static void setNumber(char[] buffer, int n) {
        int i = buffer.length;
        if (n >= 0) {
            while (i > 0) {
                buffer[--i] = (char)(48 + n % 10);
                if ((n /= 10) != 0) continue;
                break;
            }
        } else {
            while (i > 0) {
                buffer[--i] = (char)(48 - n % 10);
                if ((n /= 10) != 0) continue;
            }
            if (i > 0) {
                buffer[--i] = 45;
            }
        }
        while (i > 0) {
            buffer[--i] = 32;
        }
    }

    protected static void incrementNumber(char[] number) {
        int numberWidth = number.length;
        int carry = 1;
        for (int i = numberWidth - 1; i >= 0; --i) {
            char c = number[i];
            int digit = c == ' ' ? 0 : c - 48;
            carry = 0;
            if ((digit += carry) > 9) {
                carry = 1;
                digit -= 10;
            }
            number[i] = (char)(digit + 48);
            if (carry == 0) break;
        }
    }

    protected static int numDigits(char[] number) {
        int numberWidth;
        int numDigits = numberWidth = number.length;
        for (int i = 0; i < numberWidth && number[i] == ' '; ++i) {
            --numDigits;
        }
        return numDigits;
    }

    protected int recalculateLineWidths() {
        if (this._showLineNumbers) {
            this._minimumDigits = Math.max(this._minimumDigits, LineGutterPlugin.numDigits(this._lineCount));
            int width = 4 + this._fontWidth * this._minimumDigits;
            return width;
        }
        return 3 + this._fontWidth + 1;
    }

    protected int getRowCount() {
        Insets insets = this._editor.getInsets();
        int insetHeight = insets.top + insets.bottom;
        int editorHeight = this._editor.getPreferredSize().height;
        int numberRows = (editorHeight - insetHeight) / this._fontHeight;
        int blankLines = this._editor.getIntegerProperty("trailing-blank-rows");
        return numberRows - blankLines;
    }

    protected int getLineFromRow(int row) {
        return this._editor.getLineFromRow(row);
    }

    protected int getRowFromLine(int line) {
        return this._editor.getRowForLine(line - 1) + 1;
    }

    protected int getRowFromCoordinate(int y) {
        int topPadding = this.getTopPadding();
        int adjustedY = y - topPadding;
        if (adjustedY < 0) {
            return -1;
        }
        int row = adjustedY / this._fontHeight + 1;
        if (row <= this._rowCount) {
            return row;
        }
        return -1;
    }

    protected int getClosestRowFromCoordinate(int y) {
        int topPadding = this.getTopPadding();
        int adjustedY = y - topPadding;
        adjustedY = Math.max(0, adjustedY);
        int row = adjustedY / this._fontHeight + 1;
        row = Math.min(row, this._rowCount);
        return row;
    }

    protected int getTopPadding() {
        Insets myInsets = this.getInsets();
        if (this._editor == null) {
            return myInsets.top;
        }
        Insets editorInsets = this._editor.getInsets();
        return editorInsets.top - myInsets.top;
    }

    protected int getLeftPadding() {
        Insets myInsets = this.getInsets();
        return 1 - myInsets.left;
    }

    public static int numDigits(int number) {
        if (number < 10) {
            return 1;
        }
        if (number < 100) {
            return 2;
        }
        if (number < 1000) {
            return 3;
        }
        int digits = 0;
        do {
            ++digits;
        } while ((number /= 10) != 0);
        return digits;
    }

    @Override
    public void componentResized(ComponentEvent event) {
        this.linesChanged();
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    @Override
    public void componentHidden(ComponentEvent event) {
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        if (this._inReload) {
            return;
        }
        final DocumentUpdate insertUpdate = new DocumentUpdate(event);
        final boolean delayLineUpdate = this._inCompoundEdits;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (LineGutterPlugin.this._document == null) {
                        return;
                    }
                    LineGutterPlugin.this.processDocumentUpdate(insertUpdate);
                    LineMap lineMap = LineGutterPlugin.this._document.getLineMap();
                    LineGutterPlugin.this._lineCount = lineMap.getLineCount();
                    if (!delayLineUpdate) {
                        LineGutterPlugin.this.linesChanged();
                    }
                }
                catch (ExpiredTextBufferException e) {
                    Exceptions.swallow((Throwable)e);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread() || this._inCompoundEdits) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        if (this._inReload) {
            return;
        }
        final DocumentUpdate removeUpdate = new DocumentUpdate(event);
        final boolean delayLineUpdate = this._inCompoundEdits;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    LineGutterPlugin.this.processDocumentUpdate(removeUpdate);
                    LineMap lineMap = LineGutterPlugin.this._document.getLineMap();
                    LineGutterPlugin.this._lineCount = lineMap.getLineCount();
                    if (!delayLineUpdate) {
                        LineGutterPlugin.this.linesChanged();
                    }
                }
                catch (ExpiredTextBufferException e) {
                    Exceptions.swallow((Throwable)e);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread() || this._inCompoundEdits) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
    }

    private void processDocumentUpdates(List<DocumentUpdate> documentUpdates) {
        try {
            for (DocumentUpdate documentUpdate : documentUpdates) {
                this.processDocumentUpdate(documentUpdate);
            }
            LineMap lineMap = this._document.getLineMap();
            this._lineCount = lineMap.getLineCount();
            this.linesChanged();
        }
        catch (ExpiredTextBufferException e) {
            Exceptions.swallow((Throwable)e);
        }
    }

    private void processDocumentUpdate(DocumentUpdate documentUpdate) {
        if (documentUpdate.isInsertUpdate()) {
            int offset = documentUpdate.getStartOffset();
            int numColumns = this._columnsList.size();
            for (int i = numColumns - 1; i >= 0; --i) {
                Column column = this._columnsList.get(i);
                column.insertUpdate(offset);
            }
        } else if (documentUpdate.isRemoveUpdate()) {
            int offset = documentUpdate.getStartOffset();
            int length = documentUpdate.getEndOffset() - offset;
            int numColumns = this._columnsList.size();
            for (int i = numColumns - 1; i >= 0; --i) {
                Column column = this._columnsList.get(i);
                column.removeUpdate(offset, length);
            }
        }
        documentUpdate.release();
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
    }

    public void attributeUpdate(TextBuffer buffer, final int attribute) {
        switch (attribute) {
            case 3: {
                this._inReload = true;
                break;
            }
            case 6: {
                if (this._inReload) break;
                this._inCompoundEdits = true;
                break;
            }
            case 7: {
                if (!this._inCompoundEdits) break;
                this._inCompoundEdits = false;
                final ArrayList<DocumentUpdate> updates = new ArrayList<DocumentUpdate>(this._compoundEdits);
                this._compoundEdits.clear();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (LineGutterPlugin.this._document == null) {
                            return;
                        }
                        LineGutterPlugin.this.processDocumentUpdates(updates);
                        LineGutterPlugin.this.linesChanged();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                    break;
                }
                SwingUtilities.invokeLater(runnable);
                break;
            }
            case 4: {
                this._inReload = false;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LineMap lineMap = LineGutterPlugin.this._document.getLineMap();
                            LineGutterPlugin.this._lineCount = lineMap.getLineCount();
                            int numColumns = LineGutterPlugin.this._columnsList.size();
                            for (int i = numColumns - 1; i >= 0; --i) {
                                Column column = LineGutterPlugin.this._columnsList.get(i);
                                column.attributeUpdate(attribute);
                            }
                            LineGutterPlugin.this.linesChanged();
                        }
                        catch (ExpiredTextBufferException e) {
                            Exceptions.swallow((Throwable)e);
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                    break;
                }
                SwingUtilities.invokeLater(runnable);
                break;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        int dragRow;
        int pressedRow;
        if (this._pressedY == -1) {
            return;
        }
        int dragY = event.getY();
        if (!this._selectStarted) {
            int diff = Math.abs(dragY - this._pressedY);
            if (diff < 4) {
                return;
            }
            this._selectStarted = true;
        }
        boolean forward = (pressedRow = this.getClosestRowFromCoordinate(this._pressedY) - 1) <= (dragRow = this.getClosestRowFromCoordinate(dragY) - 1);
        int startRow = Math.min(pressedRow, dragRow);
        int endRow = Math.max(pressedRow, dragRow);
        Insets insets = this._editor.getInsets();
        int yStart = startRow * this._fontHeight + insets.top;
        int yEnd = (endRow + 1) * this._fontHeight + insets.top;
        int startOffset = this._editor.viewToModel(new Point(0, yStart));
        int endOffset = this._editor.viewToModel(new Point(0, yEnd));
        if (forward) {
            this._editor.setCaretPosition(startOffset);
            this._editor.moveCaretPosition(endOffset);
        } else {
            this._editor.setCaretPosition(endOffset);
            this._editor.moveCaretPosition(startOffset);
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.updateMouseInMark(event);
    }

    protected boolean allowDragging() {
        boolean allowDragging = this._editor.getBooleanProperty("gutter-enable-selection");
        return allowDragging;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (!this._editor.hasFocus()) {
            this._editor.requestFocus();
        }
        this._pressedY = -1;
        if (this.allowDragging()) {
            this._selectStarted = false;
            this._pressedY = Math.max(event.getY(), 0);
        } else {
            this.processMousePressed(event);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this._pressedY != -1 && !this._selectStarted) {
            this.processMousePressed(event);
            this._pressedY = -1;
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.updateMouseInMark(event);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.updateMouseInMark(event);
    }

    protected void updateMouseInMark(MouseEvent event) {
        int id;
        int y;
        int x;
        if (event != null) {
            x = event.getX();
            y = event.getY();
            id = event.getID();
        } else {
            try {
                Point mousePosition = this.getMousePosition(true);
                if (mousePosition == null) {
                    return;
                }
                id = 503;
                x = mousePosition.x;
                y = mousePosition.y;
            }
            catch (NullPointerException npe) {
                return;
            }
        }
        GutterMark oldMouseInMark = this._mouseInMark;
        switch (id) {
            case 505: {
                this._mouseInGutter = false;
                this._mouseInMark = null;
                break;
            }
            case 504: {
                this._mouseInGutter = true;
                this._mouseInMark = null;
                break;
            }
        }
        GutterMark newMouseInMark = null;
        if (this._mouseInGutter) {
            newMouseInMark = this.getMarkAtLocation(y, x);
        }
        this._mouseInMark = newMouseInMark;
        if (oldMouseInMark != newMouseInMark) {
            if (oldMouseInMark != null) {
                this.repaintLine(oldMouseInMark.getLine(), 5);
            }
            if (newMouseInMark != null) {
                this.repaintLine(newMouseInMark.getLine(), 5);
            }
        }
    }

    public BasicEditorPane getEditor() {
        return this._editor;
    }

    public GutterMark getMarkAtLocation(int mouseY, int mouseX) {
        GutterMark newMouseInMark = null;
        int mouseLine = this.getLineFromRow(this.getRowFromCoordinate(mouseY));
        if (mouseLine > 0) {
            List<Column.Mark> marksOnLineList = LineGutterPlugin.allocateScratchList();
            this.getVisibleMarks(marksOnLineList, mouseLine);
            int columnEnd = this.getWidth() - 3;
            int numMarks = marksOnLineList.size();
            for (int i = numMarks - 1; i >= 0; --i) {
                GutterMark mark = marksOnLineList.get(i);
                int columnWidth = this.markWidth(mark);
                int columnStart = columnEnd - columnWidth;
                if (columnStart <= mouseX && mouseX <= columnEnd) {
                    newMouseInMark = mark;
                    break;
                }
                columnEnd = columnStart - 2;
            }
            LineGutterPlugin.freeScratchList(marksOnLineList);
        }
        return newMouseInMark;
    }

    public Hover hover(Point p, List<HoverFlavor> flavors) {
        Object markObject;
        SwingUtilities.convertPointFromScreen(p, this);
        GutterMark mark = this.getMarkAtLocation(p.y, p.x);
        if (mark != null && (markObject = mark.getUserData()) instanceof HoverProvider) {
            Hover hover = ((HoverProvider)markObject).hover((JComponent)this, p, flavors);
            if (hover instanceof HoverProperties) {
                ((HoverProperties)hover).setProperty(HoverProperties.Property.RECTANGLE, (Object)this.getRolloverRectFor(mark));
            }
            if (hover != null) {
                hover.showHover();
            }
            return hover;
        }
        return null;
    }

    protected void processMousePressed(MouseEvent event) {
        this.updateMouseInMark(event);
        int x = event.getX();
        if (x > this.getWidth() - 3 || x <= 1) {
            return;
        }
        int line = this.getLineFromRow(this.getRowFromCoordinate(event.getY()));
        this.processMousePressed(event, line, this._mouseInMark);
        this.updateMouseInMark(event);
    }

    protected void processMousePressed(MouseEvent event, int line, GutterMark mark) {
        if (mark != null) {
            Column column = (Column)mark.getGutterColumn();
            if (column.getMarkSupportsClicks(mark)) {
                column.fireMarkClicked(event, mark, line);
            }
        } else {
            for (GutterClickListener listener : this._clickListeners) {
                try {
                    listener.lineClicked(this, line, event);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public GutterColumn createGutterColumn(String columnName, GutterColumnListener listener) {
        assert (SwingUtilities.isEventDispatchThread());
        GutterColumn existingColumn = this.lookupGutterColumn(columnName);
        if (existingColumn != null) {
            return null;
        }
        LOG.trace("creating column {0} in {1}", (Object)columnName, (Object)this);
        Column column = this.createGutterColumnImpl(columnName, listener);
        this._columnsList.add(column);
        this.columnsChanged();
        return column;
    }

    protected Column createGutterColumnImpl(String columnName, GutterColumnListener listener) {
        return new Column(columnName, listener);
    }

    @Override
    public GutterColumn lookupGutterColumn(String columnName) {
        if (columnName == null || this._columnsList == null) {
            return null;
        }
        for (Column column : this._columnsList) {
            if (!column.getColumnName().equals(columnName)) continue;
            return column;
        }
        return null;
    }

    @Override
    public void removeGutterColumn(GutterColumn column) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this._columnsList.contains(column)) {
            LOG.trace("removing column {0} from {1}", (Object)column, (Object)this);
            column.removeAllGutterMarks();
            this._columnsList.remove(column);
            this.columnsChanged();
        }
    }

    @Override
    public void removeAllGutterColumns() {
        try {
            assert (SwingUtilities.isEventDispatchThread());
            LOG.trace("removing all columns in {0}", (Object)this);
            int numColumns = this._columnsList.size();
            for (int i = numColumns - 1; i >= 0; --i) {
                Column column = this._columnsList.get(i);
                column.removeAllGutterMarksImpl();
            }
            this._columnsList.clear();
            this.columnsChanged();
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAllMarkHighlights() {
        this._document.readLock();
        try {
            int numColumns = this._columnsList.size();
            for (int i = numColumns - 1; i >= 0; --i) {
                Column column = this._columnsList.get(i);
                column.updateAllMarkHighlights();
            }
        }
        finally {
            this._document.readUnlock();
        }
    }

    protected int recalculateColumnWidths() {
        if (this._width < 0) {
            LOG.trace("recalculating preferred width");
            int columnCount = this._columnsList.size();
            int maxMultiColumnWidth = 0;
            List<Column.Mark> marksList = LineGutterPlugin.allocateScratchList();
            for (int i = 0; i < columnCount; ++i) {
                Column column = this._columnsList.get(i);
                column.getAllMarks(marksList);
            }
            int marksSize = marksList.size();
            if (marksSize > 0) {
                Collections.sort(marksList, MARK_COMPARATOR);
                int first = 0;
                int lastLine = marksList.get(0).getLine();
                ArrayList<Column.Mark> visibleMarks = new ArrayList<Column.Mark>();
                for (int i = 1; i <= marksSize; ++i) {
                    int line;
                    int n = line = i < marksSize ? ((GutterMark)marksList.get(i)).getLine() : Integer.MAX_VALUE;
                    if (line == lastLine) continue;
                    this.filterVisibleMarks(marksList, first, i, visibleMarks);
                    int multiColumnWidth = 0;
                    int singleColumnWidth = 0;
                    for (int j = 0; j < visibleMarks.size(); ++j) {
                        GutterMark mark = (GutterMark)visibleMarks.get(j);
                        int markWidth = this.markWidth(mark);
                        if (multiColumnWidth > 0) {
                            multiColumnWidth += 2;
                        }
                        multiColumnWidth += markWidth;
                        singleColumnWidth = Math.max(singleColumnWidth, markWidth);
                    }
                    maxMultiColumnWidth = Math.max(maxMultiColumnWidth, multiColumnWidth);
                    lastLine = line;
                    first = i;
                }
            }
            this._width = 1 + maxMultiColumnWidth + 3;
            this._width = Math.max(this._width, this._minWidth);
            LineGutterPlugin.freeScratchList(marksList);
        }
        return this._width;
    }

    @Override
    public void addGutterClickListener(GutterClickListener listener) {
        this._clickListeners.addIfAbsent(listener);
    }

    @Override
    public void removeGutterClickListener(GutterClickListener listener) {
        this._clickListeners.remove(listener);
    }

    @Override
    public String toString() {
        return "Gutter#" + System.identityHashCode(this);
    }

    public class Column
    implements GutterColumn {
        protected String _columnName;
        protected GutterColumnListener _columnListener;
        protected int _reservedWidth;
        protected String _layoutColumn;
        protected int _layoutConstraint = 0;
        protected List<Mark> _marksList;
        private volatile boolean _inBlockUpdate;
        protected List<Column> group;
        protected int groupIndex;

        protected Column(String columnName, GutterColumnListener columnListener) {
            this._columnName = columnName;
            this._columnListener = columnListener;
            this._marksList = new ArrayList<Mark>(10);
        }

        @Override
        @Deprecated
        public void setReservedWidth(int width) {
            if (width != this._reservedWidth) {
                this._reservedWidth = width;
                LineGutterPlugin.this.columnsChanged();
            }
        }

        protected int getReservedWidth() {
            return this._reservedWidth;
        }

        @Override
        public void setLayoutConstraint(String columnName, int constraint) {
            if (constraint == 0) {
                columnName = null;
            } else {
                if (columnName == null) {
                    throw new IllegalArgumentException("columnName null");
                }
                if (columnName.equals(this._columnName)) {
                    throw new IllegalArgumentException("columnName circular");
                }
            }
            if (columnName == null ? this._layoutColumn != null : !columnName.equals(this._layoutColumn) || constraint != this._layoutConstraint) {
                this._layoutColumn = columnName;
                this._layoutConstraint = constraint;
                LineGutterPlugin.this.columnsChanged();
            }
        }

        protected String getLayoutColumn() {
            return this._layoutColumn;
        }

        protected int getLayoutConstraint() {
            return this._layoutConstraint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateAllMarkHighlights() {
            LineGutterPlugin.this._document.readLock();
            try {
                LineMap lineMap = LineGutterPlugin.this._document.getLineMap();
                int numMarks = this._marksList.size();
                for (int i = 0; i < numMarks; ++i) {
                    Mark mark = this._marksList.get(i);
                    mark.updateHighlight(lineMap);
                }
            }
            finally {
                LineGutterPlugin.this._document.readUnlock();
            }
        }

        protected void discardAllGutterMarks() {
            assert (SwingUtilities.isEventDispatchThread());
            int numMarks = this._marksList.size();
            for (int i = numMarks - 1; i >= 0; --i) {
                Mark mark = this._marksList.get(i);
                mark.removeHighlight();
                mark.removeMarkInFileOverviewMargin();
                try {
                    int oldLine = mark.getLine();
                    if (mark.isOptionSet(2)) continue;
                    this._columnListener.markRemoved(mark, oldLine);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            this._marksList.clear();
            LOG.trace("revalidating after discarding all marks in column {0}", (Object)this);
            LineGutterPlugin.this.columnMarksRemoved();
        }

        protected int getMarkCount() {
            return this._marksList.size();
        }

        protected void getAllMarks(Collection<Mark> collection) {
            collection.addAll(this._marksList);
        }

        protected void getMarks(Collection<Mark> collection, int line) {
            int numMarks = this._marksList.size();
            for (int i = 0; i < numMarks; ++i) {
                Mark mark = this._marksList.get(i);
                if (mark.getLine() != line) continue;
                collection.add(mark);
            }
        }

        protected int removeAllGutterMarksImpl() {
            int numMarks = this._marksList.size();
            for (int i = numMarks - 1; i >= 0; --i) {
                Mark mark = this._marksList.get(i);
                mark.removeHighlight();
                mark.removeMarkInFileOverviewMargin();
            }
            this._marksList.clear();
            return numMarks;
        }

        protected boolean getMarkSupportsClicks(GutterMark gutterMark) {
            Mark mark = (Mark)gutterMark;
            return mark.isOptionSet(1);
        }

        public String getMarkToolTip(GutterMark mark, MouseEvent event) {
            return this._columnListener.getMarkToolTip(mark, event);
        }

        protected void fireMarkClicked(MouseEvent event, GutterMark mark, int line) {
            this._columnListener.markClicked(mark, mark.getLine(), event);
        }

        protected void insertUpdate(DocumentEvent event) {
            this.insertUpdate(event.getOffset());
        }

        private void insertUpdate(int insertOffset) {
            int oldMarkLine;
            LineMap lineMap = LineGutterPlugin.this._document.getLineMap();
            int linesAdded = lineMap.getLineCount() - LineGutterPlugin.this._lineCount;
            ArrayList<Mark> movedList = new ArrayList<Mark>();
            for (Mark mark : this._marksList) {
                int markOffset = mark.getOffset();
                if (insertOffset > markOffset || mark.isOptionSet(2)) continue;
                oldMarkLine = mark.getLine();
                if (linesAdded == 0) {
                    markOffset = lineMap.getLineStartOffset(oldMarkLine - 1);
                    mark.setOffset(markOffset);
                    continue;
                }
                int newMarkLine = oldMarkLine + linesAdded;
                markOffset = lineMap.getLineStartOffset(newMarkLine - 1);
                mark.setOffset(markOffset);
                mark.setLine(newMarkLine);
                movedList.add(mark);
            }
            for (Mark mark : movedList) {
                int newMarkLine = mark.getLine();
                oldMarkLine = newMarkLine - linesAdded;
                mark.moveMarkInFileOverviewMargin();
                try {
                    this._columnListener.markMoved(mark, oldMarkLine, newMarkLine);
                }
                catch (RuntimeException runtimeException) {}
            }
            this.updateAllMarkHighlights();
        }

        public void removeUpdate(DocumentEvent event) {
            this.removeUpdate(event.getOffset(), event.getLength());
        }

        private void removeUpdate(int removeOffset, int removeLength) {
            int oldMarkLine;
            LineMap lineMap = LineGutterPlugin.this._document.getLineMap();
            int removeLine = lineMap.getLineFromOffset(removeOffset);
            int removeLineStart = lineMap.getLineStartOffset(removeLine);
            int linesRemoved = LineGutterPlugin.this._lineCount - lineMap.getLineCount();
            ArrayList<Mark> movedList = new ArrayList<Mark>();
            ArrayList<Mark> removedList = new ArrayList<Mark>();
            Iterator<Mark> i = this._marksList.iterator();
            while (i.hasNext()) {
                Mark mark = i.next();
                int markOffset = mark.getOffset();
                if (removeOffset > markOffset || mark.isOptionSet(2)) continue;
                oldMarkLine = mark.getLine();
                if (linesRemoved == 0) {
                    markOffset = lineMap.getLineStartOffset(oldMarkLine - 1);
                    mark.setOffset(markOffset);
                    continue;
                }
                boolean removeMark = false;
                if (removeOffset <= markOffset && removeOffset + removeLength > markOffset) {
                    removeMark = true;
                } else if (removeOffset + removeLength == markOffset && removeOffset != removeLineStart) {
                    removeMark = true;
                }
                if (removeMark) {
                    i.remove();
                    removedList.add(mark);
                    mark.removeHighlight();
                    continue;
                }
                int newMarkLine = oldMarkLine - linesRemoved;
                int newMarkOffset = lineMap.getLineStartOffset(newMarkLine - 1);
                mark.setOffset(newMarkOffset);
                mark.setLine(newMarkLine);
                movedList.add(mark);
            }
            for (Mark mark : movedList) {
                int newMarkLine = mark.getLine();
                oldMarkLine = newMarkLine + linesRemoved;
                mark.moveMarkInFileOverviewMargin();
                try {
                    this._columnListener.markMoved(mark, oldMarkLine, newMarkLine);
                }
                catch (RuntimeException runtimeException) {}
            }
            for (Mark mark : removedList) {
                int oldMarkLine2 = mark.getLine();
                mark.removeMarkInFileOverviewMargin();
                try {
                    this._columnListener.markRemoved(mark, oldMarkLine2);
                }
                catch (RuntimeException runtimeException) {}
            }
            this.updateAllMarkHighlights();
        }

        public void attributeUpdate(int attribute) {
            if (attribute == 4) {
                LineMap lineMap = LineGutterPlugin.this._document.getLineMap();
                ArrayList<Mark> removedList = new ArrayList<Mark>();
                Iterator<Mark> i = this._marksList.iterator();
                while (i.hasNext()) {
                    Mark mark = i.next();
                    if (mark.isOptionSet(2)) continue;
                    int oldLine = mark.getLine() - 1;
                    if (oldLine < LineGutterPlugin.this._lineCount) {
                        int markOffset = lineMap.getLineStartOffset(oldLine);
                        mark.setOffset(markOffset);
                        continue;
                    }
                    removedList.add(mark);
                    i.remove();
                    mark.removeHighlight();
                }
                for (Mark mark : removedList) {
                    mark.removeMarkInFileOverviewMargin();
                    int oldMarkLine = mark.getLine();
                    try {
                        this._columnListener.markRemoved(mark, oldMarkLine);
                    }
                    catch (RuntimeException runtimeException) {}
                }
                this.updateAllMarkHighlights();
            }
        }

        @Override
        public Gutter getGutter() {
            return LineGutterPlugin.this;
        }

        @Override
        public String getColumnName() {
            return this._columnName;
        }

        @Override
        public void beginBlockAdd() {
            LineGutterPlugin.this._document.readLock();
            if (this._inBlockUpdate) {
                throw new IllegalStateException("block add already active");
            }
            this._inBlockUpdate = true;
        }

        @Override
        public void endBlockAdd() {
            if (!this._inBlockUpdate) {
                throw new IllegalStateException("block add not active");
            }
            this._inBlockUpdate = false;
            LineGutterPlugin.this._document.readUnlock();
            LineGutterPlugin.this.marksChanged();
        }

        public GutterMark addGutterMark(int line, Icon icon, HighlightStyle highlightStyle, int markOrder, int markOptions) {
            Color overviewColor = highlightStyle != null ? highlightStyle.getBackgroundColor() : null;
            return this.addGutterMark(line, icon, highlightStyle, markOrder, markOptions, overviewColor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GutterMark addGutterMark(int line, Icon icon, HighlightStyle highlightStyle, int markOrder, int markOptions, Color overviewColor) {
            assert (SwingUtilities.isEventDispatchThread());
            Mark mark = null;
            boolean alreadyLocked = this._inBlockUpdate;
            if (!alreadyLocked) {
                LineGutterPlugin.this._document.readLock();
            }
            try {
                LineMap lineMap = LineGutterPlugin.this._document.getLineMap();
                int lineCount = lineMap.getLineCount();
                int adjustedLine = line - 1;
                if (adjustedLine >= 0 && adjustedLine < lineCount) {
                    int startOffset = lineMap.getLineStartOffset(adjustedLine);
                    mark = new Mark(line, startOffset, icon, highlightStyle, markOrder, markOptions, overviewColor);
                    mark.updateHighlight(lineMap);
                    this._marksList.add(mark);
                    int width = LineGutterPlugin.this.markWidth(mark);
                    if (!this._inBlockUpdate) {
                        LineGutterPlugin.this.markChanged(mark, 0, width);
                    }
                    LOG.trace("adding mark of width {0} to column {1} in {2}", width, (Object)this, (Object)LineGutterPlugin.this);
                }
            }
            finally {
                if (!alreadyLocked) {
                    LineGutterPlugin.this._document.readUnlock();
                }
            }
            return mark;
        }

        public GutterMark[] lookupGutterMarks(int line) {
            ArrayList<Mark> markList = new ArrayList<Mark>();
            this.getMarks(markList, line);
            int numMarks = markList.size();
            GutterMark[] markResults = new GutterMark[numMarks];
            return markList.toArray(markResults);
        }

        @Override
        public void removeGutterMark(final GutterMark mark) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    int existingIndex = Column.this._marksList.indexOf(mark);
                    if (existingIndex != -1) {
                        int oldWidth = LineGutterPlugin.this.markWidth(mark);
                        Column.this._marksList.remove(existingIndex);
                        Mark m = (Mark)mark;
                        m.removeHighlight();
                        m.removeMarkInFileOverviewMargin();
                        if (!Column.this._inBlockUpdate) {
                            LineGutterPlugin.this.markChanged(mark, oldWidth, 0);
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }

        @Override
        public void removeAllGutterMarks() {
            assert (SwingUtilities.isEventDispatchThread());
            int marksRemoved = this.removeAllGutterMarksImpl();
            if (marksRemoved > 0) {
                LineGutterPlugin.this.columnMarksRemoved();
                LOG.trace("revalidating after removing all marks in column {0}", (Object)this);
            }
        }

        public String toString() {
            String width = "?";
            return "column " + this._columnName + "{group " + this.group + ", width " + width + "}";
        }

        public class Mark
        implements GutterMark {
            private int _line;
            private int _lineStart;
            private Icon _icon;
            private HighlightStyle _style;
            private HighlightedText _highlight;
            private int _order;
            private int _options;
            private boolean _visible;
            private Object _userData;
            private OverviewMark _overviewMark;

            protected Mark(int line, int lineStart, Icon icon, HighlightStyle highlightStyle, int markOrder, int markOptions, Color overviewColor) {
                this._line = line;
                this._lineStart = lineStart;
                this._icon = icon;
                this._style = highlightStyle;
                this._order = markOrder;
                this._options = markOptions;
                this._highlight = null;
                this._visible = true;
                this._userData = null;
                this.createMarkInFileOverviewMargin(overviewColor);
            }

            protected void updateHighlight(final LineMap lineMap) {
                if (this._style != null) {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Mark.this.updateHighlight(lineMap);
                            }
                        });
                        return;
                    }
                    if (this._highlight == null) {
                        this._highlight = LineGutterPlugin.this._highlightLayer.addLineHighlight(this._style, this._line - 1);
                    } else {
                        int lineStart = lineMap.getLineStartOffset(this._line - 1);
                        int lineEnd = lineMap.getLineEndOffset(this._line - 1);
                        if (this._highlight.getStartOffset() != lineStart || this._highlight.getEndOffset() != lineEnd) {
                            LineGutterPlugin.this._highlightLayer.changeHighlight(this._highlight, lineStart, lineEnd);
                        }
                    }
                }
            }

            protected void removeHighlight() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(() -> this.removeHighlight());
                    return;
                }
                if (this._highlight != null) {
                    if (LineGutterPlugin.this._highlightLayer != null) {
                        LineGutterPlugin.this._highlightLayer.removeHighlight(this._highlight);
                    }
                    this._highlight = null;
                }
                if (LineGutterPlugin.this._mouseInMark == this) {
                    LineGutterPlugin.this._mouseInMark = null;
                }
            }

            protected void setLine(int newLine) {
                this._line = newLine;
            }

            protected int getOffset() {
                return this._lineStart;
            }

            protected void setOffset(int offset) {
                this._lineStart = offset;
            }

            public boolean isOptionSet(int optionFlag) {
                return (this._options & optionFlag) != 0;
            }

            public int getOptions() {
                return this._options;
            }

            public void setOptions(int options) {
                this._options = options;
            }

            @Override
            public GutterColumn getGutterColumn() {
                return Column.this;
            }

            @Override
            public Gutter getGutter() {
                return Column.this.getGutter();
            }

            @Override
            public Icon getIcon() {
                return this._icon;
            }

            @Override
            public void setIcon(Icon icon) {
                int oldWidth = LineGutterPlugin.this.markWidth(this);
                this._icon = icon;
                if (!Column.this._inBlockUpdate) {
                    LineGutterPlugin.this.markChanged(this, oldWidth, LineGutterPlugin.this.markWidth(this));
                }
            }

            @Override
            public HighlightStyle getHighlightStyle() {
                return this._style;
            }

            @Override
            public int getLine() {
                return this._line;
            }

            @Override
            public int getOrder() {
                return this._order;
            }

            @Override
            public void setVisible(boolean visible) {
                int oldWidth = LineGutterPlugin.this.markWidth(this);
                this._visible = visible;
                if (!Column.this._inBlockUpdate) {
                    LineGutterPlugin.this.markChanged(this, oldWidth, LineGutterPlugin.this.markWidth(this));
                }
            }

            @Override
            public boolean isVisible() {
                return this._visible;
            }

            public Object getUserData() {
                return this._userData;
            }

            public void setUserData(Object userData) {
                this._userData = userData;
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                return Column.this.getMarkToolTip(this, mouseEvent);
            }

            public int getSelectionStart() {
                return this.getOffset();
            }

            public int getSelectionLength() {
                return 0;
            }

            private void createMarkInFileOverviewMargin(Color overviewColor) {
                BasicEditorOverview overview;
                if (this.isOptionSet(4) && (overview = (BasicEditorOverview)((Object)LineGutterPlugin.this._editor.getProperty("overview"))) != null) {
                    float priority = this.getHighlightStyle() == null ? 0.0f : (float)this.getHighlightStyle().getPriority();
                    this._overviewMark = new OverviewMark(LineGutterPlugin.this._editor, (Integer)this.getSelectionStart(), (Integer)(this.getSelectionStart() + this.getSelectionLength()), priority, overviewColor, this.isOptionSet(2));
                    overview.addMark(this._overviewMark);
                }
            }

            private void moveMarkInFileOverviewMargin() {
                this.removeMarkInFileOverviewMargin();
                if (this._overviewMark != null) {
                    this.createMarkInFileOverviewMargin(this._overviewMark.getColor());
                }
            }

            private void removeMarkInFileOverviewMargin() {
                BasicEditorOverview overview = (BasicEditorOverview)((Object)LineGutterPlugin.this._editor.getProperty("overview"));
                try {
                    if (overview != null && this._overviewMark != null) {
                        overview.removeMark(this._overviewMark);
                    }
                }
                catch (ExpiredTextBufferException expiredTextBufferException) {
                    // empty catch block
                }
            }

            private class OverviewMark
            extends BasicEditorOverviewMark {
                public OverviewMark(BasicEditorPane editor, Integer startOffset, Integer endOffset, float priority, Color color, boolean isStationary) {
                    super(editor, startOffset, endOffset, priority, color, isStationary);
                }

                protected JComponent getTipComponent() {
                    Icon icon = Mark.this.getIcon();
                    String text = Mark.this.getToolTipText(null);
                    if (icon == null && text == null) {
                        return null;
                    }
                    return new JLabel(text, icon, 10);
                }
            }
        }
    }

    private class DocumentUpdate {
        final OffsetMark startOffset;
        final OffsetMark endOffset;
        final DocumentEvent.EventType type;

        public DocumentUpdate(DocumentEvent event) {
            this.startOffset = LineGutterPlugin.this._document.getTextBuffer().addOffsetMark(event.getOffset());
            this.endOffset = LineGutterPlugin.this._document.getTextBuffer().addOffsetMark(event.getOffset() + event.getLength());
            this.type = event.getType();
        }

        public DocumentEvent.EventType getType() {
            return this.type;
        }

        public boolean isInsertUpdate() {
            return this.type == DocumentEvent.EventType.INSERT;
        }

        public boolean isRemoveUpdate() {
            return this.type == DocumentEvent.EventType.REMOVE;
        }

        public int getStartOffset() throws ExpiredTextBufferException {
            return this.startOffset.getOffset();
        }

        public int getEndOffset() throws ExpiredTextBufferException {
            return this.endOffset.getOffset();
        }

        public void release() {
            try {
                LineGutterPlugin.this._document.getTextBuffer().removeOffsetMark(this.startOffset);
                LineGutterPlugin.this._document.getTextBuffer().removeOffsetMark(this.endOffset);
            }
            catch (ExpiredTextBufferException e) {
                Exceptions.swallow((Throwable)e);
            }
        }
    }

    protected static final class MarkComparator
    implements Comparator<GutterMark> {
        protected MarkComparator() {
        }

        @Override
        public int compare(GutterMark m1, GutterMark m2) {
            int comparison = m1.getLine() - m2.getLine();
            if (comparison == 0) {
                comparison = m1.getOrder() - m2.getOrder();
            }
            return comparison;
        }
    }
}

