/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.util.TranslationControl;

public class BaseMessageDialog
extends JEWTDialog {
    public static final int TYPE_APPLICATION_ERROR = 1;
    public static final int TYPE_INFORMATION = 2;
    public static final int TYPE_ALERT = 3;
    public static final int TYPE_CONFIRMATION = 4;
    public static final int TYPE_CONFIRM_OR_CANCEL = 5;
    private MessagePanel m_content;
    private JButton m_yesButton;
    private JButton m_noButton;
    private boolean m_yesClicked = false;
    private boolean m_noClicked = false;

    boolean isYesClicked() {
        return this.m_yesClicked;
    }

    boolean isNoClicked() {
        return this.m_noClicked;
    }

    JButton getYesButton() {
        return this.m_yesButton;
    }

    JButton getNoButton() {
        return this.m_noButton;
    }

    protected BaseMessageDialog(Frame owner, String title, int buttonMask) {
        super(owner, title, buttonMask);
        this.initContent();
    }

    protected BaseMessageDialog(Dialog owner, String title, int buttonMask) {
        super(owner, title, buttonMask);
        this.initContent();
    }

    public static BaseMessageDialog createMessageDialogImpl(Component parent, String title, int messageType) {
        BaseMessageDialog d = null;
        while (parent != null) {
            if (parent instanceof Dialog) {
                d = new BaseMessageDialog((Dialog)parent, title, 7);
                break;
            }
            if (parent instanceof Frame) {
                d = new BaseMessageDialog((Frame)parent, title, 7);
                break;
            }
            parent = SwingUtilities.getWindowAncestor(parent);
        }
        if (d == null) {
            d = new BaseMessageDialog((Frame)null, title, 7);
        }
        d.setMessageType(messageType);
        return d;
    }

    private void initContent() {
        this.m_content = new MessagePanel();
        this.setContent(this.m_content);
    }

    public void setMessage(Object msg) {
        this.m_content.setMessage(msg);
    }

    public void setMessageText(String message) {
        this.m_content.setMessageText(message);
    }

    public void setMessageText(String message, Object[] substitute) {
        this.setMessageText(MessageFormat.format(message, substitute));
    }

    public void setMessageType(int type) {
        ResourceBundle bundle = ResourceBundle.getBundle("oracle.javatools.resource.DialogsBundle", (ResourceBundle.Control)TranslationControl.getClassFormatTranslationControl());
        switch (type) {
            case 1: {
                this.setButtonMask(1);
                this.m_content.setMessageType(type);
                break;
            }
            case 2: {
                this.setButtonMask(1);
                this.m_content.setMessageType(type);
                break;
            }
            case 3: {
                this.setButtonMask(1);
                this.m_content.setMessageType(type);
                break;
            }
            case 4: {
                this.setButtonMask(3);
                this.setOKButtonText(bundle.getString("MD_YES"));
                this.setOKButtonMnemonic(bundle.getString("MD_YES_MNEMONIC").charAt(0));
                this.setCancelButtonText(bundle.getString("MD_NO"));
                this.setCancelButtonMnemonic(bundle.getString("MD_NO_MNEMONIC").charAt(0));
                this.m_content.setMessageType(type);
                break;
            }
            case 5: {
                this.setButtonMask(2);
                this.m_yesButton = new JButton();
                String yesTranslatedText = bundle.getString("MD_YES");
                String yesMnemonic = bundle.getString("MD_YES_MNEMONIC");
                this.setMnemonicAndText(this.m_yesButton, yesTranslatedText, yesMnemonic != null ? (int)yesMnemonic.charAt(0) : -1);
                this.m_noButton = new JButton();
                String noTranslatedText = bundle.getString("MD_NO");
                String noMnemonic = bundle.getString("MD_NO_MNEMONIC");
                this.setMnemonicAndText(this.m_noButton, noTranslatedText, noMnemonic != null ? (int)noMnemonic.charAt(0) : -1);
                this.m_yesClicked = false;
                this.m_noClicked = false;
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        BaseMessageDialog.this.m_yesClicked = ae.getSource() == BaseMessageDialog.this.m_yesButton;
                        BaseMessageDialog.this.m_noClicked = ae.getSource() == BaseMessageDialog.this.m_noButton;
                        BaseMessageDialog.this.m_yesButton.removeActionListener(this);
                        BaseMessageDialog.this.m_noButton.removeActionListener(this);
                        BaseMessageDialog.this.m_yesButton = null;
                        BaseMessageDialog.this.m_noButton = null;
                        BaseMessageDialog.this.dismissDialog(false);
                    }
                };
                this.m_yesButton.addActionListener(al);
                this.m_noButton.addActionListener(al);
                this.addCustomButton(this.m_yesButton);
                this.addCustomButton(this.m_noButton);
                this.m_content.setMessageType(4);
            }
        }
    }

    void setDefaultButton(JButton button) {
        JButton b = this.getRootPane().getDefaultButton();
        if (b != null) {
            b.setDefaultCapable(false);
        }
        this.getRootPane().setDefaultButton(button);
        if (button != null) {
            button.setDefaultCapable(true);
        }
    }

    public void setHelpTopic(String id) {
        HelpUtils.setHelpID((JComponent)this.m_content, (String)id);
    }

    public void addMessageComponent(Component component) {
        this.m_content.addMessageComponent(component);
    }

    protected boolean runActualDialog() {
        char c = (char)this.getOKButtonMnemonic();
        this.getContent().addKeyListener(new SimpleKeyListener(c){

            @Override
            public void doAction(KeyEvent ke) {
                BaseMessageDialog.this.dismissDialog(false);
            }
        });
        c = (char)this.getCancelButtonMnemonic();
        this.getContent().addKeyListener(new SimpleKeyListener(c){

            @Override
            public void doAction(KeyEvent ke) {
                BaseMessageDialog.this.dismissDialog(true);
            }
        });
        boolean result = super.runDialog();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseMessageDialog.this.dispose();
            }
        });
        return result;
    }

    public boolean runDialog() {
        return this.doInvoke(new JEWTDialogInvoker(){

            @Override
            public boolean doIt() {
                return BaseMessageDialog.this.runActualDialog();
            }
        });
    }

    private boolean doInvoke(JEWTDialogInvoker invoker) {
        if (EventQueue.isDispatchThread()) {
            invoker.run();
        } else {
            try {
                EventQueue.invokeAndWait(invoker);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return invoker.getResponse();
    }

    private void setMnemonicAndText(JButton button, String translatedText, int mnemonic) {
        if (translatedText == null) {
            return;
        }
        button.setText(StringUtils.stripMnemonic((String)translatedText));
        if (translatedText != null && translatedText.contains("&")) {
            button.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        } else if (mnemonic >= 0) {
            button.setMnemonic(mnemonic);
        }
    }

    private abstract class JEWTDialogInvoker
    implements Runnable {
        private boolean m_response;

        private JEWTDialogInvoker() {
        }

        @Override
        public void run() {
            this.m_response = this.doIt();
        }

        public boolean getResponse() {
            return this.m_response;
        }

        public abstract boolean doIt();
    }

    private abstract class SimpleKeyListener
    extends KeyAdapter {
        private char m_key;

        SimpleKeyListener(char key) {
            this.m_key = key;
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (Character.toUpperCase(this.m_key) == Character.toUpperCase(event.getKeyChar())) {
                this.doAction(event);
            }
        }

        public abstract void doAction(KeyEvent var1);
    }
}

