/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.MenuUtils;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewBias;
import oracle.javatools.compare.ContributorCache;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.BaseCompareDifference;
import oracle.javatools.compare.algorithm.BaseCompareModel;
import oracle.javatools.compare.algorithm.EditableContributor;
import oracle.javatools.compare.algorithm.ExpirableContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.ActionMenuView;
import oracle.javatools.compare.view.BaseOverview;
import oracle.javatools.compare.view.ColorConstants;
import oracle.javatools.compare.view.ComparePopupManager;
import oracle.javatools.compare.view.CompareToolTipProvider;
import oracle.javatools.compare.view.CompareViewAnnotate;
import oracle.javatools.compare.view.CompareViewDecoration;
import oracle.javatools.compare.view.CompareViewUtil;
import oracle.javatools.compare.view.CustomHorizontalScrollView;
import oracle.javatools.compare.view.DiffGutter;
import oracle.javatools.compare.view.EditableView;
import oracle.javatools.compare.view.NavigableConflictsView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.compare.view.SplitPanel;
import oracle.javatools.compare.view.SplitPanelLayout;
import oracle.javatools.compare.view.SplitPanelView;
import oracle.javatools.compare.view.StatusView;
import oracle.javatools.compare.view.ToolTipView;
import oracle.javatools.compare.view.ViewEdit;
import oracle.javatools.compare.view.ViewEditEvent;
import oracle.javatools.compare.view.ViewEditListener;
import oracle.javatools.compare.view.ViewMemento;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.resource.CompareResource;
import oracle.javatools.util.deferred.Thunk;

public abstract class BaseCompareView
implements CompareView,
NavigableView,
NavigableConflictsView,
StatusView,
EditableView,
ToolTipView,
SplitPanelView,
CustomHorizontalScrollView,
ActionMenuView {
    private ThreadPoolExecutor _executor;
    private boolean _disposed;
    private boolean _syncVerticalScroll = true;
    protected BaseOverview _leftOverview;
    protected BaseOverview _rightOverview;
    private static JScrollBar _overviewScroll;
    public static final String GUI_VERTICAL_SCROLLBAR = "verticalScrollbar";
    public static final String GUI_VERTICAL_SPACER = "verticalSpacer";
    private static final Collection<Thunk<Class<? extends CompareViewDecoration>>> _decorationClasses;
    private static final Collection<Thunk<Class<? extends CompareViewAnnotate>>> _annotateClasses;
    private final Collection<CompareViewDecoration> _decorations = new ArrayList<CompareViewDecoration>();
    private final Collection<CompareViewAnnotate> _annotations = new ArrayList<CompareViewAnnotate>();
    private CompareMode _compareMode;
    private CompareModel _compareModel;
    private final Collection _positionChangeListeners = new ArrayList();
    private final Collection _statusListeners = new ArrayList();
    protected JScrollPane _leftScrollPane;
    protected JScrollPane _rightScrollPane;
    protected JScrollPane _centerScrollPane;
    private final JScrollBar _verticalScrollbar = new JScrollBar(1);
    private final CardLayout _verticalScrollCardLayout;
    private final JPanel _verticalScrollPanel;
    protected final JLabel _leftTitle = new JLabel();
    protected final JLabel _rightTitle = new JLabel();
    protected final JLabel _centerTitle = new JLabel();
    private boolean _editLocked = false;
    private final Collection _undoableEditListeners = new ArrayList();
    private CompareToolTipProvider _toolTipProvider;
    private SplitPanel _panel;
    protected DiffGutter _leftDiffGutter;
    protected DiffGutter _rightDiffGutter;
    private JPanel _horizontalScrollPanel;
    private CompareViewBias _compareViewBias;
    private ComparePopupManager _popupManager;
    private Component _gui;
    private static final int EDIT_UPDATE_DELAY = 500;
    private ContributorListener _contributorListener;
    private Icon _editRemoveIcon = null;
    private Icon _editLeftIcon = null;
    private Icon _editRightIcon = null;
    private Icon _editAcceptIcon = null;

    private final ThreadPoolExecutor getExecutor() {
        if (this._executor == null) {
            this._executor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                private final ThreadFactory _delegate = Executors.defaultThreadFactory();

                @Override
                public final Thread newThread(Runnable r) {
                    Thread t = this._delegate.newThread(r);
                    t.setName("BaseCompareView");
                    return t;
                }
            });
        }
        return this._executor;
    }

    public Component getFocusComponent() {
        return this._gui;
    }

    public void setSyncVerticalScroll(boolean sync) {
        this._syncVerticalScroll = sync;
    }

    protected boolean isSyncVerticalScroll() {
        return this._syncVerticalScroll;
    }

    protected BaseOverview getLeftOverview() {
        return this._leftOverview;
    }

    protected BaseOverview getRightOverview() {
        return this._rightOverview;
    }

    protected Component getOverviewLeftEditor() {
        return null;
    }

    protected Component getOverviewRightEditor() {
        return null;
    }

    protected Component getFocusableCenterEditor() {
        return null;
    }

    private void repaintOverviews() {
        if (this._leftOverview != null) {
            this._leftOverview.repaint();
        }
        if (this._rightOverview != null) {
            this._rightOverview.repaint();
        }
    }

    private void updateOverviews() {
        if (this._leftOverview != null) {
            this._leftOverview.updateAccessibleText();
        }
        if (this._rightOverview != null) {
            this._rightOverview.updateAccessibleText();
        }
        this.repaintOverviews();
    }

    protected void createOverviews() {
    }

    protected void initializeOverview(BaseOverview overview) {
    }

    public static final void registerViewDecoration(Class<? extends CompareViewDecoration> decorationClass) {
        BaseCompareView.registerViewDecoration((Thunk<Class<? extends CompareViewDecoration>>)Thunk.directReference(decorationClass));
    }

    public static final void registerViewDecoration(Thunk<Class<? extends CompareViewDecoration>> decorationClass) {
        _decorationClasses.add(decorationClass);
    }

    public static final void registerViewAnnotate(Thunk<Class<? extends CompareViewAnnotate>> annotateClass) {
        _annotateClasses.add(annotateClass);
    }

    protected static int getOverviewWidth() {
        if (_overviewScroll == null) {
            _overviewScroll = new JScrollBar(1);
        }
        return BaseCompareView._overviewScroll.getPreferredSize().width;
    }

    protected final void resetGUI() {
        this._gui = null;
    }

    protected CompareViewBias getBias() {
        return this._compareViewBias;
    }

    protected boolean isAddition(BaseCompareDifference difference, ContributorKind firstContributor, ContributorKind secondContributor) {
        return CompareViewUtil.isAddition(difference, firstContributor, secondContributor, this._compareViewBias);
    }

    protected boolean isRemoval(BaseCompareDifference difference, ContributorKind firstContributor, ContributorKind secondContributor) {
        return CompareViewUtil.isRemoval(difference, firstContributor, secondContributor, this._compareViewBias);
    }

    protected JScrollPane getLeftScrollPane() {
        return this._leftScrollPane;
    }

    protected void setLeftScrollPane(JScrollPane leftScrollPane) {
        this._leftScrollPane = leftScrollPane;
    }

    protected JScrollPane getRightScrollPane() {
        return this._rightScrollPane;
    }

    protected void setRightScrollPane(JScrollPane rightScrollPane) {
        this._rightScrollPane = rightScrollPane;
    }

    protected JScrollPane getCenterScrollPane() {
        return this._centerScrollPane;
    }

    protected void setCenterScrollPane(JScrollPane centerScrollPane) {
        this._centerScrollPane = centerScrollPane;
    }

    protected JScrollBar getVerticalScrollBar() {
        return this._verticalScrollbar;
    }

    protected CardLayout getVerticalScrollCardLayout() {
        return this._verticalScrollCardLayout;
    }

    protected JPanel getVerticalScrollPanel() {
        return this._verticalScrollPanel;
    }

    protected JLabel getLeftTitle() {
        return this._leftTitle;
    }

    protected JLabel getRightTitle() {
        return this._rightTitle;
    }

    protected JLabel getCenterTitle() {
        return this._centerTitle;
    }

    protected boolean isEditLocked() {
        return this._editLocked;
    }

    protected void setEditLocked(boolean editLocked) {
        this._editLocked = editLocked;
    }

    protected Collection getUndoableEditListeners() {
        return this._undoableEditListeners;
    }

    public DiffGutter getLeftDiffGutter() {
        return this._leftDiffGutter;
    }

    protected void setLeftDiffGutter(DiffGutter leftDiffGutter) {
        this._leftDiffGutter = leftDiffGutter;
    }

    protected DiffGutter getRightDiffGutter() {
        return this._rightDiffGutter;
    }

    protected void setRightDiffGutter(DiffGutter rightDiffGutter) {
        this._rightDiffGutter = rightDiffGutter;
    }

    public static final int calculateRightEditorInset() {
        int inset = 0;
        inset += BaseCompareView.getOverviewWidth();
        return inset += new JScrollBar((int)1).getPreferredSize().width;
    }

    public void setModel(CompareModel compareModel) {
        this.shutdownExecutor(true);
        if (this.getCompareModel() != null) {
            if (this._contributorListener == null) {
                return;
            }
            this.getContributor(ContributorKind.FIRST).removePropertyChangeListener((PropertyChangeListener)this._contributorListener);
            this.getContributor(ContributorKind.SECOND).removePropertyChangeListener((PropertyChangeListener)this._contributorListener);
            if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
                this.getContributor(ContributorKind.ANCESTOR).removePropertyChangeListener((PropertyChangeListener)this._contributorListener);
            }
            this.detachContributorChangeListeners();
            this._contributorListener = null;
        }
        if (compareModel != null) {
            try {
                CompareDifference[] differences = CompareDifference.cloneDifferences((CompareDifference[])compareModel.getDifferences());
                compareModel = this.createModel(compareModel, differences);
            }
            catch (CloneNotSupportedException differences) {
                // empty catch block
            }
        }
        this.setCompareModel(this.createMutableModel(compareModel));
        this.initializeView(this.getCompareModel());
        this.updateViewDecorations(this.getCompareModel());
        this.updateViewAnnotations();
        FocusTraversalPolicy policy = this.createFocusTraversalPolicy();
        if (policy != null) {
            this._panel.setFocusTraversalPolicy(policy);
            this._panel.setFocusCycleRoot(true);
        }
        if (this.getCompareModel() != null) {
            this._contributorListener = new ContributorListener();
            this.getContributor(ContributorKind.FIRST).addPropertyChangeListener((PropertyChangeListener)this._contributorListener);
            this.getContributor(ContributorKind.SECOND).addPropertyChangeListener((PropertyChangeListener)this._contributorListener);
            if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
                this.getContributor(ContributorKind.ANCESTOR).addPropertyChangeListener((PropertyChangeListener)this._contributorListener);
            }
            this.attachContributorChangeListeners();
            this.updateTitles();
            this.updateOverviews();
        }
        this.fireStatusChanged();
    }

    protected void attachContributorChangeListeners() {
        if (this.getContributor(ContributorKind.FIRST) instanceof TextCompareContributor) {
            ((TextCompareContributor)this.getContributor(ContributorKind.FIRST)).addChangeListener((ChangeListener)this._contributorListener);
        }
        if (this.getContributor(ContributorKind.SECOND) instanceof TextCompareContributor) {
            ((TextCompareContributor)this.getContributor(ContributorKind.SECOND)).addChangeListener((ChangeListener)this._contributorListener);
        }
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE && this.getContributor(ContributorKind.ANCESTOR) instanceof TextCompareContributor) {
            ((TextCompareContributor)this.getContributor(ContributorKind.ANCESTOR)).addChangeListener((ChangeListener)this._contributorListener);
        }
        ((JComponent)this.getGUI()).addAncestorListener(this._contributorListener);
    }

    protected void detachContributorChangeListeners() {
        if (this.getContributor(ContributorKind.FIRST) instanceof TextCompareContributor) {
            ((TextCompareContributor)this.getContributor(ContributorKind.FIRST)).removeChangeListener((ChangeListener)this._contributorListener);
        }
        if (this.getContributor(ContributorKind.SECOND) instanceof TextCompareContributor) {
            ((TextCompareContributor)this.getContributor(ContributorKind.SECOND)).removeChangeListener((ChangeListener)this._contributorListener);
        }
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE && this.getContributor(ContributorKind.ANCESTOR) instanceof TextCompareContributor) {
            ((TextCompareContributor)this.getContributor(ContributorKind.ANCESTOR)).removeChangeListener((ChangeListener)this._contributorListener);
        }
        ((JComponent)this.getGUI()).removeAncestorListener(this._contributorListener);
    }

    protected void initializeView(CompareModel compareModel) {
    }

    public SplitPanel getSplitPanel() {
        if (this._panel == null) {
            this._panel = new SplitPanel();
        }
        return this._panel;
    }

    protected FocusTraversalPolicy createFocusTraversalPolicy() {
        if (this.getLeftOverview() == null && this.getRightOverview() == null) {
            return null;
        }
        ArrayList<Component> components = new ArrayList<Component>();
        if (this.getLeftOverview() != null) {
            components.add(this.getLeftOverview());
            components.add(this.getOverviewLeftEditor());
        }
        if (this.getRightOverview() != null) {
            components.add(this.getRightOverview());
            components.add(this.getOverviewRightEditor());
        }
        if (this.getFocusableCenterEditor() != null) {
            components.add(this.getFocusableCenterEditor());
        }
        for (Component c : this.getSplitPanel().getComponents()) {
            if (components.contains(c) || !c.isFocusable()) continue;
            components.add(c);
        }
        return new CustomFocusTraversalPolicy(components);
    }

    protected void setSplitPanel(SplitPanel splitPanel) {
        this._panel = splitPanel;
    }

    public Component getGUI() {
        if (this._gui == null) {
            Component gui = this.getSplitPanel();
            for (CompareViewDecoration decoration : this._decorations) {
                if (!decoration.canDecorate()) continue;
                gui = decoration.decorate(this, gui);
                decoration.update();
            }
            this._gui = gui;
        }
        return this._gui;
    }

    @Override
    public Component getLeftOrCenterSplitter() {
        return ((SplitPanelLayout)this.getSplitPanel().getLayout()).getComponent("leftSplitTop");
    }

    @Override
    public Component getRightSplitter() {
        return ((SplitPanelLayout)this.getSplitPanel().getLayout()).getComponent("centerSplitTop");
    }

    @Override
    public void setSplitterLocation(Component splitter, int location) {
        this.setSplitterLocation(splitter, location, null);
    }

    public void setSplitterLocation(Component splitter, int location, Component parent) {
        this.getSplitPanel().moveSplitter(splitter, location, splitter == this.getRightSplitter(), parent);
    }

    @Override
    public int getSplitterLocation(Component splitter) {
        return splitter.getLocation().x + 25;
    }

    protected BaseCompareView() {
        this(CompareMode.TWO_WAY_COMPARE);
    }

    protected BaseCompareView(CompareMode compareMode) {
        this(compareMode, CompareViewBias.RIGHT);
    }

    protected BaseCompareView(CompareMode compareMode, CompareViewBias compareViewBias) {
        this._compareMode = compareMode;
        this._compareViewBias = compareViewBias;
        this._verticalScrollbar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                BaseCompareView.this.verticalScrollTo(ae.getValue());
            }
        });
        JPanel verticalSpacer = new JPanel();
        verticalSpacer.setBackground(UIManager.getColor("control"));
        verticalSpacer.setBorder(BorderFactory.createLineBorder(UIManager.getColor("controlDkShadow")));
        this._verticalScrollCardLayout = new CardLayout();
        this._verticalScrollPanel = new JPanel(this._verticalScrollCardLayout);
        this._verticalScrollPanel.add((Component)this._verticalScrollbar, GUI_VERTICAL_SCROLLBAR);
        this._verticalScrollPanel.add((Component)verticalSpacer, GUI_VERTICAL_SPACER);
        Color borderColor = UIManager.getColor("controlShadow");
        CompoundBorder titleBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, borderColor), BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this._leftTitle.setBorder(titleBorder);
        this._centerTitle.setBorder(titleBorder);
        this._rightTitle.setBorder(titleBorder);
        this.createOverviews();
        if (this._leftOverview != null) {
            this._leftOverview.getAccessibleContext().setAccessibleDescription(this.getBundle().getString("ACC_OVERVIEW_LEFT"));
            this.initializeOverview(this._leftOverview);
        }
        if (this._rightOverview != null) {
            this._rightOverview.getAccessibleContext().setAccessibleDescription(this.getBundle().getString("ACC_OVERVIEW_RIGHT"));
            this.initializeOverview(this._rightOverview);
        }
        try {
            for (Thunk<Class<? extends CompareViewDecoration>> decorationClass : _decorationClasses) {
                if (decorationClass == null) continue;
                CompareViewDecoration decoration = (CompareViewDecoration)((Class)decorationClass.get()).newInstance();
                this._decorations.add(decoration);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            for (Thunk<Class<? extends CompareViewAnnotate>> annotateClass : _annotateClasses) {
                if (annotateClass == null) continue;
                CompareViewAnnotate annotate = (CompareViewAnnotate)((Class)annotateClass.get()).newInstance();
                this._annotations.add(annotate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateTitles() {
        try {
            this.updateTitle(this.getCompareModel().getContributor(ContributorKind.FIRST), this.getLeftTitle());
            this.updateTitle(this.getCompareModel().getContributor(ContributorKind.SECOND), this.getRightTitle());
            this.updateTitle(this.getCompareModel().getContributor(ContributorKind.ANCESTOR), this.getCenterTitle());
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
    }

    private void updateTitle(CompareContributor contributor, JLabel title) {
        if (contributor == null) {
            return;
        }
        boolean isReadOnly = true;
        boolean isModified = false;
        if (contributor instanceof EditableContributor) {
            if (!this.isEditLocked()) {
                isReadOnly = !((EditableContributor)contributor).isEditable();
            }
            isModified = ((EditableContributor)contributor).isModified();
        }
        String shortLabel = null;
        String longLabel = null;
        if (isReadOnly) {
            shortLabel = MessageFormat.format(this.getBundle().getString("TITLE_READ_ONLY"), contributor.getShortLabel());
            longLabel = MessageFormat.format(this.getBundle().getString("TOOLTIP_READ_ONLY"), contributor.getLongLabel());
        } else if (isModified) {
            shortLabel = contributor.getShortLabel();
            longLabel = MessageFormat.format(this.getBundle().getString("TOOLTIP_MODIFIED"), contributor.getLongLabel());
        } else {
            shortLabel = MessageFormat.format(this.getBundle().getString("TITLE_EDITABLE"), contributor.getShortLabel());
            longLabel = MessageFormat.format(this.getBundle().getString("TOOLTIP_EDITABLE"), contributor.getLongLabel());
        }
        title.setText(shortLabel);
        title.setToolTipText(longLabel);
        Font labelFont = UIManager.getFont("Label.font");
        if (isModified && !this.isMultByte(shortLabel)) {
            title.setFont(new Font(labelFont.getName(), 2, labelFont.getSize()));
        } else {
            title.setFont(labelFont);
        }
    }

    public CompareMode getCompareMode() {
        return this._compareMode;
    }

    protected CompareModel createMutableModel(CompareModel compareModel) {
        return compareModel;
    }

    @Override
    public void addViewEditListener(ViewEditListener l) {
        this._undoableEditListeners.add(l);
    }

    @Override
    public void removeViewEditListener(ViewEditListener l) {
        this._undoableEditListeners.remove(l);
    }

    protected ViewEditListener[] getViewEditListeners() {
        return this._undoableEditListeners.toArray(new ViewEditListener[0]);
    }

    protected void fireViewEditEvent(ViewEditEvent vee) {
        ViewEditListener[] l = this.getViewEditListeners();
        for (int i = l.length - 1; i >= 0; --i) {
            l[i].viewEditHappened(vee);
        }
        this.fireStatusChanged();
    }

    @Override
    public void setToolTipProvider(CompareToolTipProvider toolTipProvider) {
        this._toolTipProvider = toolTipProvider;
    }

    protected CompareToolTipProvider getToolTipProvider() {
        return this._toolTipProvider;
    }

    protected void updateModel(CompareModel model) {
        this.setCompareModel(model);
        this.repaintDiffGutters();
        this.repaintOverviews();
        this.updateModelImpl();
        this.updateViewDecorations(model);
        this.fireStatusChanged();
    }

    private boolean isMultByte(String str) {
        char[] cArray;
        for (char c : cArray = str.toCharArray()) {
            String cString = Character.toString(c);
            try {
                byte[] bArray = cString.getBytes("UTF-8");
                if (bArray.length <= 1) continue;
                return true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return false;
    }

    private final void updateViewDecorations(CompareModel model) {
        if (!(model instanceof BaseCompareModel)) {
            return;
        }
        for (CompareViewDecoration decoration : this._decorations) {
            decoration.setModel((BaseCompareModel)model);
            if (!decoration.canDecorate() || this._gui == null) continue;
            decoration.update();
        }
    }

    private final void updateViewAnnotations() {
        for (CompareViewAnnotate annotate : this._annotations) {
            annotate.setView(this);
        }
    }

    protected void repaintDiffGutters() {
        if (this._leftDiffGutter != null) {
            this._leftDiffGutter.repaint();
        }
        if (this._rightDiffGutter != null) {
            this._rightDiffGutter.repaint();
        }
    }

    protected abstract void updateModelImpl();

    protected ViewMemento createMemento() {
        if (this.getCompareMode() != CompareMode.THREE_WAY_MERGE) {
            return null;
        }
        ViewMemento memento = new ViewMemento();
        try {
            memento.setDifferences(CompareDifference.cloneDifferences((CompareDifference[])this.getCompareModel().getDifferences()));
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
        return memento;
    }

    @Override
    public void setMemento(ViewMemento memento) {
        if (this.getCompareMode() != CompareMode.THREE_WAY_MERGE) {
            return;
        }
        try {
            CompareDifference[] differences = CompareDifference.cloneDifferences((CompareDifference[])memento.getDifferences());
            this.updateModel(this.createModel(differences));
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
    }

    protected CompareModel createModel(CompareDifference[] differences) {
        return this.createModel(this.getCompareModel(), differences);
    }

    protected abstract CompareModel createModel(CompareModel var1, CompareDifference[] var2);

    public ResourceBundle getBundle() {
        return CompareResource.getBundle();
    }

    protected JScrollPane createHorizontalScrollPane(Component view) {
        JScrollPane scrollPane = new JScrollPane(view, 21, 30);
        this.initScrollPane(scrollPane);
        return scrollPane;
    }

    protected void initScrollPane(JScrollPane scrollPane) {
        scrollPane.setAutoscrolls(true);
        scrollPane.setWheelScrollingEnabled(false);
        scrollPane.setBorder(null);
        scrollPane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                JScrollBar source = (JScrollBar)ae.getSource();
                BaseCompareView.this.horizontalScrollTo(source, source.getValue());
            }
        });
        scrollPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mwe) {
                if (mwe.getScrollType() == 0) {
                    int totalScroll = mwe.getUnitsToScroll() * BaseCompareView.this._verticalScrollbar.getUnitIncrement();
                    BaseCompareView.this._verticalScrollbar.setValue(BaseCompareView.this._verticalScrollbar.getValue() + totalScroll);
                }
            }
        });
    }

    protected Collection getHorizontalScrollBars() {
        ArrayList<JScrollBar> c = new ArrayList<JScrollBar>();
        if (this._leftScrollPane != null) {
            c.add(this._leftScrollPane.getHorizontalScrollBar());
        }
        if (this._rightScrollPane != null) {
            c.add(this._rightScrollPane.getHorizontalScrollBar());
        }
        if (this._centerScrollPane != null) {
            c.add(this._centerScrollPane.getHorizontalScrollBar());
        }
        return c;
    }

    public JScrollBar getVerticalScrollbar() {
        return this._verticalScrollbar;
    }

    protected void horizontalScrollTo(Object source, int value) {
        Collection scrollBars = this.getHorizontalScrollBars();
        for (JScrollBar scrollBar : scrollBars) {
            if (scrollBar == source) continue;
            scrollBar.setValue(Math.min(scrollBar.getMaximum(), value));
        }
    }

    protected abstract void verticalScrollTo(int var1);

    public CompareModel getModel() {
        return this._compareModel;
    }

    protected void setCompareModel(CompareModel compareModel) {
        this._compareModel = compareModel;
    }

    public CompareModel getCompareModel() {
        return this._compareModel;
    }

    @Override
    public void addPositionListener(ChangeListener l) {
        this._positionChangeListeners.add(l);
    }

    @Override
    public void removePositionListener(ChangeListener l) {
        this._positionChangeListeners.remove(l);
    }

    protected void firePositionChanged() {
        ChangeEvent ce = new ChangeEvent(this);
        ChangeListener[] l = this._positionChangeListeners.toArray(new ChangeListener[0]);
        for (int i = l.length - 1; i >= 0; --i) {
            l[i].stateChanged(ce);
        }
    }

    @Override
    public boolean hasNavigableDifferences() {
        return this.getModel().getDifferenceCount() > 0;
    }

    @Override
    public boolean hasNavigableConflicts() {
        for (CompareDifference compareDifference : this.getModel().getDifferences()) {
            if (!compareDifference.isConflict() || compareDifference.isResolved()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addStatusListener(ChangeListener l) {
        this._statusListeners.add(l);
    }

    @Override
    public void removeStatusListener(ChangeListener l) {
        this._statusListeners.remove(l);
    }

    protected void fireStatusChanged() {
        ChangeEvent ce = new ChangeEvent(this);
        Iterator itr = this._statusListeners.iterator();
        while (itr.hasNext()) {
            ((ChangeListener)itr.next()).stateChanged(ce);
        }
    }

    protected boolean isViewFocusOwner() {
        return true;
    }

    @Override
    public Action[] getEditActions() {
        Action[] actions = this._getEditActions();
        ArrayList<Action> c = new ArrayList<Action>();
        if (actions != null) {
            c.addAll(Arrays.asList(actions));
        }
        LocateInOverviewAction locateInOverviewAction = null;
        if (this.getCurrentDifference() != null) {
            if (this.getLeftOverview() != null && this.getOverviewLeftEditor() != null && this.getOverviewLeftEditor().isFocusOwner()) {
                locateInOverviewAction = new LocateInOverviewAction(this.getCurrentDifference(), this.getLeftOverview());
            }
            if (this.getRightOverview() != null && this.getOverviewRightEditor() != null && this.getOverviewRightEditor().isFocusOwner()) {
                locateInOverviewAction = new LocateInOverviewAction(this.getCurrentDifference(), this.getRightOverview());
            }
        }
        if (locateInOverviewAction != null) {
            if (!c.isEmpty()) {
                c.add(null);
            }
            c.add(locateInOverviewAction);
        }
        return c.toArray(new Action[0]);
    }

    public Action[] getLowPriorityEditActions() {
        Action[] actions = this._getLowPriorityEditActions();
        ArrayList<Action> c = new ArrayList<Action>();
        if (actions != null) {
            c.addAll(Arrays.asList(actions));
        }
        return c.toArray(new Action[0]);
    }

    private Action[] _getEditActions() {
        if (!this.isViewFocusOwner()) {
            return null;
        }
        ContributorKind contributor = this.getCurrentContributorKind();
        return this.getEditActions(this.getCurrentDifference(), contributor, this.getAdjacentContributorKind(contributor));
    }

    private Action[] _getLowPriorityEditActions() {
        if (!this.isViewFocusOwner()) {
            return null;
        }
        ContributorKind contributor = this.getCurrentContributorKind();
        return this.getLowPriorityEditActions(this.getCurrentDifference(), contributor, this.getAdjacentContributorKind(contributor));
    }

    protected abstract CompareDifference getCurrentDifference();

    protected abstract ContributorKind getCurrentContributorKind();

    protected ContributorKind getAdjacentContributorKind(ContributorKind contributorKind) {
        return this.getAdjacentContributorKind(contributorKind, null);
    }

    protected ContributorKind getAdjacentContributorKind(ContributorKind contributorKind, ContributorBias bias) {
        if (this.getCompareMode() == CompareMode.TWO_WAY_COMPARE) {
            if (contributorKind == ContributorKind.FIRST) {
                return bias == ContributorBias.LEFT ? null : ContributorKind.SECOND;
            }
            if (contributorKind == ContributorKind.SECOND) {
                return bias == ContributorBias.RIGHT ? null : ContributorKind.FIRST;
            }
            assert (false);
        } else {
            if (contributorKind == ContributorKind.FIRST) {
                return bias == ContributorBias.LEFT ? null : ContributorKind.ANCESTOR;
            }
            if (contributorKind == ContributorKind.SECOND) {
                return bias == ContributorBias.RIGHT ? null : ContributorKind.ANCESTOR;
            }
            if (contributorKind == ContributorKind.ANCESTOR) {
                return bias == ContributorBias.RIGHT ? ContributorKind.SECOND : ContributorKind.FIRST;
            }
            assert (false);
        }
        return null;
    }

    protected CompareContributor getContributor(ContributorKind contributorKind) {
        return this.getCompareModel().getContributor(contributorKind);
    }

    public CompareContributor getFocusContributor() {
        return this.getContributor(this.getCurrentContributorKind());
    }

    protected void updateOnEdit() {
        if (this._disposed) {
            return;
        }
        if (this.getExecutor().getQueue().size() >= 1) {
            return;
        }
        this.getExecutor().submit(new Runnable(){
            private boolean _expired;
            private CompareContributor _first;
            private CompareContributor _second;
            private CompareType _type;
            {
                this._first = BaseCompareView.this.getContributor(ContributorKind.FIRST);
                this._second = BaseCompareView.this.getContributor(ContributorKind.SECOND);
                this._type = BaseCompareView.this.getCompareModel().getType();
            }

            @Override
            public final void run() {
                final CompareModel compareModel = this.doInBackground();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        if (BaseCompareView.this._disposed || _expired) {
                            return;
                        }
                        if (BaseCompareView.this.getContributor(ContributorKind.FIRST) != _first || BaseCompareView.this.getContributor(ContributorKind.SECOND) != _second) {
                            return;
                        }
                        try {
                            BaseCompareView.this.updateModel(compareModel);
                        }
                        catch (ExpiredTextBufferException expiredTextBufferException) {
                            // empty catch block
                        }
                    }
                });
            }

            private final CompareModel doInBackground() {
                CompareModel newModel = BaseCompareView.this.getCompareModel();
                try {
                    if (BaseCompareView.this.getCompareMode() == CompareMode.TWO_WAY_COMPARE) {
                        if (this._first instanceof ExpirableContributor) {
                            ((ExpirableContributor)this._first).reset();
                        }
                        if (this._second instanceof ExpirableContributor) {
                            ((ExpirableContributor)this._second).reset();
                        }
                        newModel = CompareModelFactory.createCompareModel((CompareContributor)this._first, (CompareContributor)this._second, (CompareType)this._type);
                    }
                    return newModel;
                }
                catch (ExpiredTextBufferException etbe) {
                    this._expired = true;
                    return null;
                }
                catch (CompareFailedException cfe) {
                    cfe.printStackTrace();
                    return newModel;
                }
            }
        });
    }

    protected void markResolved(CompareDifference difference) {
        ViewMemento undoMemento = this.createMemento();
        difference.setResolved(true);
        this.updateModel(this.getCompareModel());
        ViewMemento redoMemento = this.createMemento();
        this.fireViewEditEvent(new ViewEditEvent(this, 1, null, new ViewEdit(null, this.getBundle().getString("RESOLVE_ACTION_NAME"), this, undoMemento, redoMemento)));
    }

    protected void markAllResolved(CompareModel compareModel) {
        ViewMemento undoMemento = this.createMemento();
        CompareDifference[] differences = compareModel.getDifferences();
        for (int i = 0; i < differences.length; ++i) {
            differences[i].setResolved(true);
        }
        this.updateModel(this.getCompareModel());
        ViewMemento redoMemento = this.createMemento();
        this.fireViewEditEvent(new ViewEditEvent(this, 1, null, new ViewEdit(null, this.getBundle().getString("RESOLVE_ALL_ACTION_NAME"), this, undoMemento, redoMemento)));
    }

    protected Action createMarkResolvedAction(CompareDifference difference) {
        return new MarkResolvedAction(difference);
    }

    protected Action createMarkAllResolvedAction(CompareModel compareModel) {
        return new MarkAllResolvedAction(compareModel);
    }

    private void _showEditPopup(CompareDifference db, Component invoker, ContributorKind contributor, ContributorKind adjacentContributor, Point mousePos) {
        Action[] editActions = this.getEditActions(db, contributor, adjacentContributor);
        if (editActions == null || editActions.length == 0) {
            return;
        }
        final JPopupMenu popupMenu = new JPopupMenu();
        for (int i = 0; i < editActions.length; ++i) {
            if (editActions[i] == null) {
                popupMenu.addSeparator();
                continue;
            }
            popupMenu.add(editActions[i]);
        }
        PopupMenuListener pmListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                popupMenu.removePopupMenuListener(this);
                popupMenu.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
        popupMenu.addPopupMenuListener(pmListener);
        MenuUtils.showPopupMenu((JPopupMenu)popupMenu, (Component)invoker, (int)mousePos.x, (int)mousePos.y);
    }

    public void moveTo(ContributorKind kind, int startPos, int endPos) {
    }

    public void moveToLine(ContributorKind kind, int line, boolean highLight) {
    }

    public Rectangle getPanelBounds(ContributorKind kind) {
        if (kind == ContributorKind.FIRST && this._leftScrollPane != null) {
            Point pt = this._leftScrollPane.getLocationOnScreen();
            return new Rectangle(pt, this._leftScrollPane.getSize());
        }
        if (kind == ContributorKind.SECOND && this._rightScrollPane != null) {
            Point pt = this._rightScrollPane.getLocationOnScreen();
            return new Rectangle(pt, this._rightScrollPane.getSize());
        }
        if (kind == ContributorKind.ANCESTOR && this._centerScrollPane != null) {
            Point pt = this._centerScrollPane.getLocationOnScreen();
            return new Rectangle(pt, this._centerScrollPane.getSize());
        }
        return null;
    }

    public boolean hasCurrentDifference() {
        return this.getCurrentDifference() != null;
    }

    public void acceptLeftThenRightSide() {
        BaseCompareDifference difference = (BaseCompareDifference)this.getCurrentDifference();
        this.replaceBlock(difference, ContributorKind.FIRST, ContributorKind.ANCESTOR);
        this.insertBlockCopy(difference, ContributorKind.SECOND, ContributorKind.ANCESTOR);
        this.updateOnEdit();
    }

    public void acceptRightThenLeftSide() {
        BaseCompareDifference difference = (BaseCompareDifference)this.getCurrentDifference();
        this.replaceBlock(difference, ContributorKind.SECOND, ContributorKind.ANCESTOR);
        this.insertBlockCopy(difference, ContributorKind.FIRST, ContributorKind.ANCESTOR);
        this.updateOnEdit();
    }

    @Override
    public boolean goToInitialDifference() {
        if (this.getCompareModel().getDifferences().length == 0) {
            return false;
        }
        this.goToDifference(this.getCompareModel().getDifferences()[0], false);
        return true;
    }

    @Override
    public boolean hasPreviousDifference() {
        return this.getPreviousDifference() != null;
    }

    @Override
    public boolean hasNextDifference() {
        return this.getNextDifference() != null;
    }

    @Override
    public boolean goToFirstDifference() {
        if (this.getCompareModel().getDifferences().length == 0) {
            return false;
        }
        this.goToDifference(this.getCompareModel().getDifferences()[0]);
        return true;
    }

    @Override
    public boolean goToLastDifference() {
        if (this.getCompareModel().getDifferences().length == 0) {
            return false;
        }
        this.goToDifference(this.getCompareModel().getDifferences()[this.getCompareModel().getDifferences().length - 1]);
        return true;
    }

    @Override
    public boolean goToPreviousDifference() {
        CompareDifference block = this.getPreviousDifference();
        if (block != null) {
            this.goToDifference(block);
            return true;
        }
        return false;
    }

    @Override
    public boolean goToNextDifference() {
        CompareDifference block = this.getNextDifference();
        if (block != null) {
            this.goToDifference(block);
            return true;
        }
        return false;
    }

    protected void goToDifference(CompareDifference block) {
        this.goToDifference(block, !this.isOverviewFocusOwner());
    }

    protected boolean isOverviewFocusOwner() {
        boolean overviewHasFocus = false;
        if (this.getLeftOverview() != null && this.getLeftOverview().isFocusOwner()) {
            overviewHasFocus = true;
        }
        if (this.getRightOverview() != null && this.getRightOverview().isFocusOwner()) {
            overviewHasFocus = true;
        }
        return overviewHasFocus;
    }

    protected abstract CompareDifference getPreviousDifference();

    protected abstract CompareDifference getNextDifference();

    protected abstract void goToDifference(CompareDifference var1, boolean var2);

    @Override
    public boolean hasPreviousConflict() {
        return this.getPreviousConflict() != null;
    }

    @Override
    public boolean hasNextConflict() {
        return this.getNextConflict() != null;
    }

    @Override
    public boolean goToFirstConflict() {
        for (CompareDifference compareDifference : this.getCompareModel().getDifferences()) {
            if (!compareDifference.isConflict() || compareDifference.isResolved()) continue;
            this.goToDifference(compareDifference);
            return true;
        }
        return false;
    }

    @Override
    public boolean goToLastConflict() {
        CompareDifference[] compareDifferences = this.getCompareModel().getDifferences();
        for (int i = compareDifferences.length - 1; i >= 0; --i) {
            if (!compareDifferences[i].isConflict() || compareDifferences[i].isResolved()) continue;
            this.goToDifference(compareDifferences[i]);
            return true;
        }
        return false;
    }

    @Override
    public boolean goToPreviousConflict() {
        CompareDifference block = this.getPreviousConflict();
        if (block != null) {
            this.goToDifference(block);
            return true;
        }
        return false;
    }

    @Override
    public boolean goToNextConflict() {
        CompareDifference block = this.getNextConflict();
        if (block != null) {
            this.goToDifference(block);
            return true;
        }
        return false;
    }

    protected abstract CompareDifference getPreviousConflict();

    protected abstract CompareDifference getNextConflict();

    protected boolean isEditable(ContributorKind contributor) {
        try {
            return !this.isEditLocked() && this.getContributor(contributor) instanceof EditableContributor && ((EditableContributor)this.getContributor(contributor)).isEditable();
        }
        catch (ExpiredTextBufferException etbe) {
            return false;
        }
    }

    protected boolean canReadElement(CompareDifference difference, ContributorKind contributorKind) {
        return true;
    }

    protected boolean canWriteElement(CompareDifference difference, ContributorKind contributorKind) {
        return true;
    }

    protected boolean hasDefaultEditAction(CompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        if (difference == null || contributor == null) {
            return false;
        }
        if (((BaseCompareDifference)difference).getKind() == 0) {
            return false;
        }
        if (contributor == ContributorKind.ANCESTOR && adjacentContributor == ContributorKind.FIRST) {
            return false;
        }
        return this.isEditable(adjacentContributor) || this.isEditable(contributor);
    }

    protected Action getDefaultEditAction(CompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        BaseCompareDifference baseDifference = (BaseCompareDifference)difference;
        if (!this.hasDefaultEditAction(difference, contributor, adjacentContributor)) {
            return null;
        }
        if (this.canReadElement(difference, contributor) && this.canWriteElement(difference, adjacentContributor) && this.isEditable(adjacentContributor)) {
            if (baseDifference.isChange(contributor, adjacentContributor)) {
                return this.createReplaceBlockAction(baseDifference, contributor, adjacentContributor);
            }
            if (baseDifference.hasContribution(contributor) && (!baseDifference.hasContribution(adjacentContributor) || this.getCompareModel() != null && this.getCompareModel().getType() == CompareType.TEXT)) {
                return this.createInsertBlockAction(baseDifference, contributor, adjacentContributor);
            }
        }
        if (this.canWriteElement(difference, contributor) && this.isEditable(contributor)) {
            if (baseDifference.hasContribution(contributor)) {
                return this.createDeleteBlockAction(baseDifference, contributor, adjacentContributor);
            }
            if (!baseDifference.hasContribution(contributor) && difference.isConflict() && !difference.isResolved()) {
                return this.createMarkResolvedAction(difference);
            }
        }
        return null;
    }

    protected Action createReplaceBlockAction(BaseCompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        return new ReplaceBlockAction(difference, contributor, adjacentContributor);
    }

    protected Action createInsertBlockAction(BaseCompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        return new InsertBlockAction(difference, contributor, adjacentContributor);
    }

    protected Action createDeleteBlockAction(BaseCompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        return new DeleteBlockAction(contributor, difference);
    }

    protected abstract void replaceBlock(BaseCompareDifference var1, ContributorKind var2, ContributorKind var3);

    protected abstract void insertBlockCopy(BaseCompareDifference var1, ContributorKind var2, ContributorKind var3);

    protected abstract void deleteBlock(BaseCompareDifference var1, ContributorKind var2);

    protected Action[] getEditActions(CompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        ArrayList<Action> actions = new ArrayList<Action>();
        BaseCompareDifference baseDifference = (BaseCompareDifference)difference;
        if (baseDifference != null && baseDifference.getKind() != 0) {
            if (this.canWriteElement(difference, contributor) && this.isEditable(contributor) && baseDifference.hasContribution(contributor)) {
                actions.add(this.createDeleteBlockAction(baseDifference, contributor, adjacentContributor));
            }
            if (this.canReadElement(difference, contributor) && this.canWriteElement(difference, adjacentContributor) && adjacentContributor != null && this.isEditable(adjacentContributor) && baseDifference.hasContribution(contributor)) {
                actions.add(null);
                if (baseDifference.isChange(contributor, adjacentContributor)) {
                    actions.add(this.createReplaceBlockAction(baseDifference, contributor, adjacentContributor));
                }
                if (!baseDifference.hasContribution(adjacentContributor) || this.getCompareModel() != null && this.getCompareModel().getType() == CompareType.TEXT) {
                    actions.add(this.createInsertBlockAction(baseDifference, contributor, adjacentContributor));
                }
            }
            this.sanitizeActionDividers(actions);
            if (adjacentContributor != null && (this.isEditable(contributor) || this.isEditable(adjacentContributor))) {
                int conflicts;
                actions.add(null);
                if (difference.isConflict() && !difference.isResolved()) {
                    actions.add(this.createMarkResolvedAction(difference));
                }
                if ((conflicts = this.getCompareModel().getConflictCount()) > 0 && this.getCompareModel().getResolvedCount() < conflicts) {
                    actions.add(this.createMarkAllResolvedAction(this.getCompareModel()));
                }
            }
            this.sanitizeActionDividers(actions);
        }
        return actions.toArray(new Action[0]);
    }

    protected Action[] getLowPriorityEditActions(CompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        ArrayList<ApplyAllChangesAction> actions = new ArrayList<ApplyAllChangesAction>();
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE && contributor != ContributorKind.ANCESTOR) {
            actions.add(null);
            actions.add(new ApplyAllChangesAction(contributor));
        }
        this.sanitizeActionDividers(actions);
        return actions.toArray(new Action[0]);
    }

    private final void sanitizeActionDividers(List actions) {
        if (actions.size() > 0 && actions.get(actions.size() - 1) == null) {
            actions.remove(actions.size() - 1);
        }
        if (actions.size() > 0 && actions.get(0) == null) {
            actions.remove(0);
        }
    }

    public Icon getDefaultEditActionIcon(BaseCompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor, boolean isAncestor) {
        if (!this.hasDefaultEditAction((CompareDifference)difference, contributor, adjacentContributor)) {
            return null;
        }
        if (this.canReadElement((CompareDifference)difference, contributor) && this.canWriteElement((CompareDifference)difference, adjacentContributor) && this.isEditable(adjacentContributor) && (difference.isChange(contributor, adjacentContributor) || !difference.hasContribution(adjacentContributor) || this.getCompareModel() != null && this.getCompareModel().getType() == CompareType.TEXT) && difference.hasContribution(contributor)) {
            if (isAncestor) {
                if (this._editLeftIcon == null) {
                    this._editLeftIcon = new ImageIcon(CompareResource.class.getResource("/oracle/javatools/icons/images/editright.gif"));
                }
                return this._editLeftIcon;
            }
            if (this._editRightIcon == null) {
                this._editRightIcon = new ImageIcon(CompareResource.class.getResource("/oracle/javatools/icons/images/editleft.gif"));
            }
            return this._editRightIcon;
        }
        if (this.canWriteElement((CompareDifference)difference, contributor) && this.isEditable(contributor)) {
            if (difference.hasContribution(contributor)) {
                if (this._editRemoveIcon == null) {
                    this._editRemoveIcon = new ImageIcon(CompareResource.class.getResource("/oracle/javatools/icons/images/editremove.gif"));
                }
                return this._editRemoveIcon;
            }
            if (!difference.hasContribution(contributor) && difference.isConflict() && !difference.isResolved()) {
                if (this._editAcceptIcon == null) {
                    this._editAcceptIcon = OracleIcons.getIcon((String)"gutter/checkmark_status.png");
                }
                return this._editAcceptIcon;
            }
        }
        return null;
    }

    @Override
    public Component getHorizontalScrollComponent() {
        if (this._horizontalScrollPanel == null) {
            this._horizontalScrollPanel = new JPanel();
        }
        return this._horizontalScrollPanel;
    }

    public void dispose() {
        if (this.getCompareModel() != null) {
            this.removeContributor();
            this.detachContributorChangeListeners();
        }
        this.shutdownExecutor(false);
        this._disposed = true;
    }

    private void removeContributor() {
        ContributorCache.getInstance().remove(this.getModel().getContributor(ContributorKind.FIRST));
        ContributorCache.getInstance().remove(this.getModel().getContributor(ContributorKind.SECOND));
        ContributorCache.getInstance().remove(this.getModel().getContributor(ContributorKind.ANCESTOR));
    }

    private final void shutdownExecutor(boolean wait) {
        if (this._executor == null) {
            return;
        }
        this._executor.shutdownNow();
        if (wait) {
            try {
                this._executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._executor = null;
    }

    @Override
    public void addPopupManager(ComparePopupManager popupManager) {
        this._popupManager = popupManager;
    }

    @Override
    public void removePopupManager(ComparePopupManager popupManager) {
        this._popupManager = null;
    }

    protected final ComparePopupManager getPopupManager() {
        return this._popupManager;
    }

    public CompareViewDecoration[] getDecorations() {
        return this._decorations.toArray(new CompareViewDecoration[0]);
    }

    public CompareViewAnnotate[] getAnnotations() {
        return this._annotations.toArray(new CompareViewAnnotate[0]);
    }

    static {
        _decorationClasses = new ArrayList<Thunk<Class<? extends CompareViewDecoration>>>();
        _annotateClasses = new ArrayList<Thunk<Class<? extends CompareViewAnnotate>>>();
        new ColorConstants();
    }

    private class ContributorListener
    implements PropertyChangeListener,
    ChangeListener,
    AncestorListener {
        private Timer _editTimer;

        private ContributorListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String propName = pce.getPropertyName();
            if ("modified".equals(propName) || "editable".equals(propName)) {
                BaseCompareView.this.updateTitles();
            }
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.updateOnEditLater();
        }

        private void updateOnEditLater() {
            if (this._editTimer == null) {
                this._editTimer = new Timer(500, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ContributorListener.this.updateOnEditImmediately();
                        ContributorListener.this._editTimer.stop();
                    }
                });
                this._editTimer.setRepeats(false);
                this._editTimer.setCoalesce(true);
            }
            if (this._editTimer.isRunning()) {
                this._editTimer.restart();
            } else {
                this._editTimer.start();
            }
        }

        private void updateOnEditImmediately() {
            if (BaseCompareView.this.getGUI().isDisplayable()) {
                BaseCompareView.this.updateOnEdit();
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            this.updateOnEditImmediately();
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }
    }

    protected class CustomFocusTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        private final List<Component> _components;

        public CustomFocusTraversalPolicy(List<Component> components) {
            this._components = components;
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            int i = this._components.indexOf(aComponent);
            return i >= 0 && i < this._components.size() - 1 ? this._components.get(i + 1) : null;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            int i = this._components.indexOf(aComponent);
            return i > 0 && i < this._components.size() ? this._components.get(i - 1) : null;
        }
    }

    private class LocateInOverviewAction
    extends AbstractAction {
        private final CompareDifference _difference;
        private final Component _overviewComponent;

        public LocateInOverviewAction(CompareDifference difference, Component overviewComponent) {
            super(BaseCompareView.this.getBundle().getString("LOCATE_IN_OVERVIEW_ACTION_NAME"));
            this._difference = difference;
            this._overviewComponent = overviewComponent;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            BaseCompareView.this.goToDifference(this._difference);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LocateInOverviewAction.this._overviewComponent.requestFocusInWindow();
                }
            });
        }
    }

    public static enum ContributorBias {
        LEFT,
        RIGHT;

    }

    private class MarkResolvedAction
    extends AbstractAction {
        private final CompareDifference _difference;

        public MarkResolvedAction(CompareDifference difference) {
            super(BaseCompareView.this.getBundle().getString("RESOLVE_ACTION_NAME"));
            this._difference = difference;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this._difference.isResolved()) {
                return;
            }
            BaseCompareView.this.markResolved(this._difference);
            BaseCompareView.this.updateOnEdit();
        }
    }

    private class MarkAllResolvedAction
    extends AbstractAction {
        private final CompareModel _compareModel;

        public MarkAllResolvedAction(CompareModel compareModel) {
            super(BaseCompareView.this.getBundle().getString("RESOLVE_ALL_ACTION_NAME"));
            this._compareModel = compareModel;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this._compareModel.getResolvedCount() >= this._compareModel.getConflictCount()) {
                return;
            }
            BaseCompareView.this.markAllResolved(this._compareModel);
            BaseCompareView.this.updateOnEdit();
        }
    }

    private class ReplaceBlockAction
    extends AbstractAction {
        private final BaseCompareDifference _difference;
        private final ContributorKind _sourceContributor;
        private final ContributorKind _destContributor;

        public ReplaceBlockAction(BaseCompareDifference difference, ContributorKind sourceContributor, ContributorKind destContributor) {
            super(BaseCompareView.this.getBundle().getString("REPLACE_ACTION_NAME"));
            this._difference = difference;
            this._sourceContributor = sourceContributor;
            this._destContributor = destContributor;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            BaseCompareView.this.replaceBlock(this._difference, this._sourceContributor, this._destContributor);
            BaseCompareView.this.updateOnEdit();
        }
    }

    private class InsertBlockAction
    extends AbstractAction {
        private final BaseCompareDifference _difference;
        private final ContributorKind _sourceContributor;
        private final ContributorKind _destContributor;

        public InsertBlockAction(BaseCompareDifference difference, ContributorKind sourceContributor, ContributorKind destContributor) {
            super(BaseCompareView.this.getBundle().getString("INSERT_ACTION_NAME"));
            this._difference = difference;
            this._sourceContributor = sourceContributor;
            this._destContributor = destContributor;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            BaseCompareView.this.insertBlockCopy(this._difference, this._sourceContributor, this._destContributor);
            BaseCompareView.this.updateOnEdit();
        }
    }

    private class DeleteBlockAction
    extends AbstractAction {
        private final BaseCompareDifference _difference;
        private final ContributorKind _contributor;

        public DeleteBlockAction(ContributorKind contributor, BaseCompareDifference difference) {
            super(BaseCompareView.this.getBundle().getString("REMOVE_ACTION_NAME"));
            this._contributor = contributor;
            this._difference = difference;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            BaseCompareView.this.deleteBlock(this._difference, this._contributor);
            BaseCompareView.this.updateOnEdit();
        }
    }

    private class ApplyAllChangesAction
    extends AbstractAction {
        private final ContributorKind _fromContributor;

        public ApplyAllChangesAction(ContributorKind fromContributor) {
            super(BaseCompareView.this.getBundle().getString("APPLY_ALL_DIFFERENCES_ACTION_NAME"));
            this._fromContributor = fromContributor;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!MessageDialog.confirm(BaseCompareView.this.getGUI(), CompareResource.get("CONFIRM_APPLY_ALL_CHANGES"), CompareResource.get("CONFIRM_APPLY_ALL_CHANGES_TITLE"), null)) {
                return;
            }
            for (CompareDifference difference : BaseCompareView.this.getCompareModel().getDifferences()) {
                BaseCompareDifference baseDifference = (BaseCompareDifference)difference;
                if (baseDifference.getKind() != 2) continue;
                BaseCompareView.this.replaceBlock(baseDifference, this._fromContributor, ContributorKind.ANCESTOR);
            }
            BaseCompareView.this.updateOnEdit();
        }
    }

    protected class CentralGutterMouseHandler
    extends MouseAdapter {
        private void performDefaultEditAction(DiffGutter gutter, Point mousePos) {
            ContributorKind adjacentContributor;
            CompareDifference db = gutter.getBlockAtPoint(mousePos);
            if (db == null) {
                return;
            }
            ContributorKind contributor = gutter.getContributorAtPoint(mousePos);
            Action action = BaseCompareView.this.getDefaultEditAction(db, contributor, adjacentContributor = gutter.getOtherContributorKind(contributor));
            if (action != null) {
                action.actionPerformed(new ActionEvent(this, 1001, (String)action.getValue("ActionCommandKey")));
            }
        }

        private void showEditPopup(DiffGutter gutter, Point mousePos) {
            CompareDifference db = gutter.getBlockAtPoint(mousePos);
            if (db == null) {
                return;
            }
            ContributorKind contributor = gutter.getContributorAtPoint(mousePos);
            ContributorKind adjacentContributor = gutter.getOtherContributorKind(contributor);
            BaseCompareView.this._showEditPopup(db, gutter, contributor, adjacentContributor, mousePos);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            DiffGutter gutter = (DiffGutter)me.getSource();
            if (me.isPopupTrigger()) {
                this.showEditPopup(gutter, me.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            DiffGutter gutter = (DiffGutter)me.getSource();
            if (me.getClickCount() == 1) {
                if (me.isPopupTrigger()) {
                    this.showEditPopup(gutter, me.getPoint());
                } else if (me.getButton() == 1) {
                    this.performDefaultEditAction(gutter, me.getPoint());
                }
            }
        }
    }

    public abstract class PositionListener
    implements FocusListener {
        private final Timer _positionTimer = new Timer(250, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent ae) {
                PositionListener positionListener = PositionListener.this;
                synchronized (positionListener) {
                    BaseCompareView.this.firePositionChanged();
                    PositionListener.this._positionTimer.stop();
                }
            }
        });

        public PositionListener() {
            this._positionTimer.setRepeats(false);
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.resetTimer();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.resetTimer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resetTimer() {
            PositionListener positionListener = this;
            synchronized (positionListener) {
                this._positionTimer.restart();
            }
            BaseCompareView.this.updateOverviews();
        }
    }
}

