/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMPTZ;
import oracle.xdb.XMLType;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.scalable.PageManager;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xquery.ThreadSerialNum;
import oracle.xquery.XQException;
import oracle.xquery.exec.BindVar;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.OXQueryItem;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQPrintDriver;
import oracle.xquery.exec.XQueryUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XDBConnExpr
extends Expr {
    private ArrayList bindVars = null;
    private String sqlQuery = null;
    private String xquery = null;
    private Connection conn = null;
    private PreparedStatement pstmt = null;
    private ResultSet rset = null;
    static final int QMXTIG_FLAG_FRAGMENT = 32;
    static final int QMXTIG_FLAG_NO_DOC_WRAP = 0x400000;
    static final int QMXQDM_SEQ_ITMTFLAG_LEN = 2;
    static final int QMXQDM_SEQ_ITMTYPE_LEN = 1;
    static final int QMXQDM_SEQ_ITM_SIZE = 4;
    static final int QMXQDM_ITM_FLAG_NRNG = 1;
    static final int QMXQDM_ITM_FLAG_ATOMIC = 2;
    static final int QMXQDM_ITM_FLAG_NODE = 4;
    static final int QMXQDM_ITM_FLAG_ATTR = 8;
    static final int QMXQDM_ITM_FLAG_QNAME = 16;
    static final int DTYCHR = 1;
    static final int DTYNUM = 2;
    static final int DTYIBFLOAT = 100;
    static final int DTYIBDOUBLE = 101;
    static final int DTYSTZ = 181;
    static final int DTYESTZ = 188;
    static final int DTYBIN = 23;
    static final int DTYIDS = 183;
    static final int DTYEIDS = 190;
    static final int DTYIYM = 182;
    static final int DTYEIYM = 189;
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int SIZE_TIMESTAMPTZ = 13;
    private static int OFFSET_HOUR = 20;
    private static int OFFSET_MINUTE = 60;
    private static byte REGIONIDBIT = (byte)-128;

    public XDBConnExpr(Connection connection, String string) {
        this.conn = connection;
        this.xquery = string.replaceAll("'", "''");
    }

    public void setContextItem(OXMLItem oXMLItem) {
        if (this.bindVars == null) {
            this.bindVars = new ArrayList();
        }
        BindVar bindVar = new BindVar(null, oXMLItem);
        this.bindVars.add(bindVar);
    }

    public void setString(QName qName, String string, QueryState queryState) {
        if (this.bindVars == null) {
            this.bindVars = new ArrayList();
        }
        BindVar bindVar = new BindVar(qName, string, queryState);
        this.bindVars.add(bindVar);
    }

    public void setFloat(QName qName, float f, QueryState queryState) {
        if (this.bindVars == null) {
            this.bindVars = new ArrayList();
        }
        BindVar bindVar = new BindVar(qName, f, queryState);
        this.bindVars.add(bindVar);
    }

    public void setInt(QName qName, int n, QueryState queryState) {
        if (this.bindVars == null) {
            this.bindVars = new ArrayList();
        }
        BindVar bindVar = new BindVar(qName, n, queryState);
        this.bindVars.add(bindVar);
    }

    public void setBoolean(QName qName, boolean bl, QueryState queryState) {
        if (this.bindVars == null) {
            this.bindVars = new ArrayList();
        }
        BindVar bindVar = new BindVar(qName, bl, queryState);
        this.bindVars.add(bindVar);
    }

    public void setNode(QName qName, XMLNode xMLNode, QueryState queryState) {
        if (this.bindVars == null) {
            this.bindVars = new ArrayList();
        }
        BindVar bindVar = new BindVar(qName, xMLNode, queryState);
        this.bindVars.add(bindVar);
    }

    public void setItem(QName qName, OXMLItem oXMLItem) {
        if (this.bindVars == null) {
            this.bindVars = new ArrayList();
        }
        BindVar bindVar = new BindVar(qName, oXMLItem);
        this.bindVars.add(bindVar);
    }

    private void prepareQuery() {
        if (this.sqlQuery != null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(this.xquery.length() + 100);
        stringBuffer.append("select value(v) from table(xqsequence(xmlquery('");
        stringBuffer.append(this.xquery);
        stringBuffer.append("' ");
        if (this.bindVars != null) {
            int n = this.bindVars.size();
            if (n > 0) {
                stringBuffer.append(" passing ");
            }
            for (int i = 0; i < n; ++i) {
                QName qName = ((BindVar)this.bindVars.get((int)i)).bindName;
                stringBuffer.append(" ? as \"");
                if (qName == null) {
                    stringBuffer.append(".");
                } else {
                    stringBuffer.append(XQueryUtils.getQNameString(qName));
                }
                stringBuffer.append("\"");
                if (i + 1 >= n) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(" returning sequence))) v");
        this.sqlQuery = stringBuffer.toString();
    }

    private void prepare() {
        this.prepareQuery();
        try {
            this.pstmt = this.conn.prepareStatement(this.sqlQuery);
            if (this.bindVars != null) {
                int n = this.bindVars.size();
                block12: for (int i = 0; i < n; ++i) {
                    OXMLItem oXMLItem = ((BindVar)this.bindVars.get((int)i)).itemVal;
                    switch (oXMLItem.getPrimitiveType()) {
                        case 90: {
                            Object object;
                            XMLNode xMLNode = oXMLItem.getNode();
                            XMLType xMLType = null;
                            if (xMLNode.getNodeType() == 9) {
                                xMLType = XMLType.createXML((Connection)this.conn, (Document)((XMLDocument)xMLNode));
                            } else {
                                object = new StringWriter();
                                XQPrintDriver xQPrintDriver = new XQPrintDriver(new PrintWriter((Writer)object));
                                xQPrintDriver.printNode(xMLNode);
                                xQPrintDriver.flush();
                                xMLType = XMLType.createXML((Connection)this.conn, (String)((StringWriter)object).toString());
                            }
                            ((OraclePreparedStatement)this.pstmt).setOPAQUE(i + 1, (OPAQUE)xMLType);
                            continue block12;
                        }
                        case 1: {
                            this.pstmt.setString(i + 1, oXMLItem.getString());
                            continue block12;
                        }
                        case 3: 
                        case 4: {
                            this.pstmt.setDouble(i + 1, oXMLItem.getDouble());
                            continue block12;
                        }
                        case 5: 
                        case 22: {
                            if (oXMLItem.withinRange()) {
                                this.pstmt.setInt(i + 1, oXMLItem.getInt());
                                continue block12;
                            }
                            this.pstmt.setBigDecimal(i + 1, oXMLItem.getDecimal());
                            continue block12;
                        }
                        case 2: {
                            this.pstmt.setBoolean(i + 1, oXMLItem.getBoolean());
                            continue block12;
                        }
                        case 7: {
                            GregorianCalendar gregorianCalendar;
                            SimpleTimeZone simpleTimeZone;
                            Cloneable cloneable;
                            Object object = oXMLItem.getCalendar();
                            if (oXMLItem.hasTimeZone()) {
                                TimeZone timeZone = ((GregorianCalendar)object).getTimeZone();
                                int n2 = ((SimpleTimeZone)timeZone).getRawOffset();
                                long l = ((Calendar)object).getTimeInMillis();
                                Timestamp timestamp = new Timestamp(l);
                                int n3 = TimeZone.getDefault().getOffset(l);
                                long l2 = l - (long)n3 + (long)n2;
                                cloneable = new Timestamp(l2);
                                if (n2 == 0) {
                                    simpleTimeZone = new SimpleTimeZone(0, "");
                                    gregorianCalendar = new GregorianCalendar(simpleTimeZone);
                                } else {
                                    gregorianCalendar = new GregorianCalendar(timeZone);
                                }
                                simpleTimeZone = new TIMESTAMPTZ(this.conn, cloneable, (Calendar)gregorianCalendar);
                                ((OraclePreparedStatement)this.pstmt).setTIMESTAMPTZ(i + 1, (TIMESTAMPTZ)simpleTimeZone);
                                continue block12;
                            }
                            long l = ((Calendar)object).getTimeInMillis();
                            TimeZone timeZone = ((GregorianCalendar)object).getTimeZone();
                            int n4 = ((SimpleTimeZone)timeZone).getRawOffset();
                            int n5 = TimeZone.getDefault().getOffset(l);
                            long l3 = l - (long)n5 + (long)n4;
                            Timestamp timestamp = new Timestamp(l3);
                            cloneable = new SimpleTimeZone(0, "");
                            gregorianCalendar = new GregorianCalendar((TimeZone)cloneable);
                            simpleTimeZone = new TIMESTAMPTZ(this.conn, timestamp, (Calendar)gregorianCalendar);
                            ((OraclePreparedStatement)this.pstmt).setTIMESTAMPTZ(i + 1, (TIMESTAMPTZ)simpleTimeZone);
                            continue block12;
                        }
                        default: {
                            throw new XQException("unsupported bind type");
                        }
                    }
                }
            }
            this.rset = this.pstmt.executeQuery();
        }
        catch (Exception exception) {
            if (this.pstmt != null) {
                try {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (exception instanceof XQException) {
                throw (XQException)exception;
            }
            throw new XQException(exception);
        }
    }

    private void getXMLTypeItem(QueryState queryState, String string, OXMLItem oXMLItem, PageManager pageManager, XMLType xMLType) throws Exception {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setSecureProcessing();
        dOMParser.setPreserveWhitespace(false);
        if (pageManager != null) {
            dOMParser.setAttribute("oracle.xml.parser.DOMParser.PartialDOM", (Object)Boolean.TRUE);
            dOMParser.setAttribute("oracle.xml.parser.DOMParser.PageManager", (Object)pageManager);
        }
        XMLDocument xMLDocument = null;
        int n = xMLType.getThinFlag();
        if ((n & 0x20) == 32) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("<BEG>");
            stringBuffer.append(string);
            stringBuffer.append("</BEG>");
            dOMParser.parse((Reader)new StringReader(stringBuffer.toString()));
            XMLDocument xMLDocument2 = dOMParser.getDocument();
            if ((n & 0x400000) == 0x400000) {
                xMLDocument = (XMLNode)xMLDocument2.getDocumentElement().getFirstChild();
            } else {
                DocumentFragment documentFragment = xMLDocument2.createDocumentFragment();
                NodeList nodeList = xMLDocument2.getDocumentElement().getChildNodes();
                for (int i = nodeList.getLength(); i > 0; --i) {
                    documentFragment.appendChild(nodeList.item(0));
                }
                xMLDocument = (XMLNode)documentFragment;
            }
        } else {
            dOMParser.parse((Reader)new StringReader(string));
            xMLDocument = dOMParser.getDocument();
        }
        oXMLItem.setNode((XMLNode)xMLDocument);
    }

    @Override
    public ExprResultIterator getIterator(QueryState queryState) {
        return new XDBConnIterator(this, queryState);
    }

    @Override
    public OXMLSequence Evaluate(QueryState queryState) {
        return this.EvaluateUsingIterator(queryState);
    }

    @Override
    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)XDBConnExpr.getDoc().createElement("XDBConnExpr");
        XMLNode xMLNode = (XMLNode)XDBConnExpr.getDoc().createTextNode(this.sqlQuery);
        xMLElement.appendChild((Node)xMLNode);
        return xMLElement;
    }

    @Override
    public void acceptVisitor(Visitor visitor) {
    }

    public void cleanup() {
        this.bindVars = null;
    }

    private void processXQDMImage(byte[] byArray, XMLType xMLType, XDBConnIterator xDBConnIterator, OXMLItem oXMLItem) throws Exception {
        int n = 0;
        int n2 = XQueryUtils.twoBytesToInt(byArray, n);
        n += 2;
        if ((n2 & 2) == 2 || (n2 & 8) == 8) {
            int n3 = XQueryUtils.unsignedByteToInt(byArray[n]);
            int n4 = XQueryUtils.unsignedByteToInt(byArray[++n]);
            int n5 = XQueryUtils.fourBytesToInt(byArray, ++n);
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, n += 4, byArray2, 0, n5);
            this.setOXMLItem(byArray2, n3, n4, xMLType, oXMLItem);
            n += n5;
            if ((n2 & 8) == 8) {
                QName qName = xMLType.getXQDMQName();
                XMLDocument xMLDocument = new XMLDocument();
                Attr attr = xMLDocument.createAttributeNS(qName.getNamespaceURI(), XQueryUtils.getQNameString(qName));
                attr.setValue(oXMLItem.getLexicalValue());
                ((OXQueryItem)oXMLItem).reset();
                oXMLItem.setNode((XMLNode)attr);
            }
        } else if ((n2 & 4) == 4) {
            this.getXMLTypeItem(xDBConnIterator.qryState, xMLType.getXQDMString(), oXMLItem, xDBConnIterator.pgm, xMLType);
        }
    }

    private void setOXMLItem(byte[] byArray, int n, int n2, XMLType xMLType, OXMLItem oXMLItem) {
        try {
            switch (n2) {
                case 1: {
                    if (n == 19) {
                        QName qName = xMLType.getXQDMQName();
                        oXMLItem.setQName(OXMLSequenceType.TQNAME, qName);
                        break;
                    }
                    String string = xMLType.getXQDMString();
                    this.processString(string, n, oXMLItem);
                    break;
                }
                case 2: {
                    NUMBER nUMBER = new NUMBER(byArray);
                    this.processNUMBER(nUMBER, n, oXMLItem);
                    break;
                }
                case 100: {
                    BINARY_FLOAT bINARY_FLOAT = new BINARY_FLOAT(byArray);
                    String string = bINARY_FLOAT.stringValue();
                    if (string.equals("Infinity")) {
                        string = "INF";
                    } else if (string.equals("-Infinity")) {
                        string = "-INF";
                    }
                    oXMLItem.setString(OXMLSequenceType.TSTRING, string);
                    oXMLItem.convert(OXMLSequenceType.TFLOAT);
                    break;
                }
                case 101: {
                    BINARY_DOUBLE bINARY_DOUBLE = new BINARY_DOUBLE(byArray);
                    String string = bINARY_DOUBLE.stringValue();
                    if (string.equals("Infinity")) {
                        string = "INF";
                    } else if (string.equals("-Infinity")) {
                        string = "-INF";
                    }
                    oXMLItem.setString(OXMLSequenceType.TSTRING, string);
                    oXMLItem.convert(OXMLSequenceType.TDOUBLE);
                    break;
                }
                case 181: 
                case 188: {
                    this.processTIMESTAMPTZ(byArray, n, n2, oXMLItem);
                    break;
                }
                case 23: {
                    RAW rAW = new RAW(byArray);
                    String string = rAW.stringValue();
                    if (n == 17) {
                        oXMLItem.setString(OXMLSequenceType.TBASE64BINARY, string);
                        break;
                    }
                    if (n == 16) {
                        oXMLItem.setString(OXMLSequenceType.THEXBINARY, string);
                        break;
                    }
                    if (n != 3) break;
                    oXMLItem.setBoolean(OXMLSequenceType.TBOOLEAN, Integer.valueOf(string) == 1);
                    break;
                }
                case 183: {
                    if (n == 51) {
                        INTERVALDS iNTERVALDS = new INTERVALDS(byArray);
                        break;
                    }
                }
                case 190: {
                    if (n == 51) {
                        int n3 = 0;
                        int n4 = XQueryUtils.fourBytesToIntReverse(byArray, n3);
                        double d = (double)(n4 * 24) * 3600.0;
                        int n5 = XQueryUtils.fourBytesToIntReverse(byArray, n3 += 4);
                        d += (double)(n5 * 3600);
                        int n6 = XQueryUtils.fourBytesToIntReverse(byArray, n3 += 4);
                        d += (double)(n6 * 60);
                        int n7 = XQueryUtils.fourBytesToIntReverse(byArray, n3 += 4);
                        d += (double)n7;
                        int n8 = XQueryUtils.fourBytesToIntReverse(byArray, n3 += 4);
                        oXMLItem.setDuration(OXMLSequenceType.TDTDURATION, 0, d += (double)n8 / 1.0E9);
                        break;
                    }
                }
                case 182: {
                    if (n == 52) {
                        INTERVALYM iNTERVALYM = new INTERVALYM(byArray);
                        break;
                    }
                }
                case 189: {
                    if (n != 52) break;
                    int n9 = 0;
                    int n10 = XQueryUtils.fourBytesToIntReverse(byArray, n9);
                    n10 *= 12;
                    oXMLItem.setDuration(OXMLSequenceType.TYMDURATION, n10 += byArray[n9 += 4], 0.0);
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new XQException(sQLException);
        }
    }

    private static int getHighOrderbits(int n) {
        return (n & 0x7F) << 6;
    }

    private static int getLowOrderbits(int n) {
        return (n & 0xFC) >> 2;
    }

    private static int getJavaYear(int n, int n2) {
        return (n - 100) * 100 + (n2 - 100);
    }

    private GregorianCalendar buildCalendar(byte[] byArray) throws SQLException {
        Object object;
        int n;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
        gregorianCalendar.setLenient(false);
        int n2 = XDBConnExpr.getJavaYear(byArray[0], byArray[1]);
        if (n2 < 0) {
            gregorianCalendar.set(0, 0);
            n2 = -n2;
        }
        gregorianCalendar.set(1, n2);
        gregorianCalendar.set(2, byArray[2] - 1);
        gregorianCalendar.set(5, byArray[3]);
        gregorianCalendar.set(11, byArray[4] - 1);
        gregorianCalendar.set(12, byArray[5] - 1);
        gregorianCalendar.set(13, byArray[6] - 1);
        int n3 = XQueryUtils.fourBytesToInt(byArray, 7);
        gregorianCalendar.set(14, n3 / 1000000);
        int n4 = 0;
        int n5 = 0;
        if ((byArray[11] & REGIONIDBIT) != 0) {
            n = XDBConnExpr.getHighOrderbits(byArray[11]);
            object = ((OracleConnection)this.conn).getTIMEZONETAB();
            if (object.checkID(n += XDBConnExpr.getLowOrderbits(byArray[12]))) {
                object.updateTable(this.conn, n);
            }
            int n6 = object.getOffset((Calendar)gregorianCalendar, n);
            n4 = n6 / HOUR_MILLISECOND;
            n5 = n6 % HOUR_MILLISECOND / MINUTE_MILLISECOND;
        } else {
            n4 = byArray[11] - OFFSET_HOUR;
            n5 = byArray[12] - OFFSET_MINUTE;
        }
        n = n4 * 60;
        n += n5;
        object = new SimpleTimeZone(n *= 60000, "");
        gregorianCalendar.setTimeZone((TimeZone)object);
        gregorianCalendar.getTime();
        gregorianCalendar.add(11, n4);
        gregorianCalendar.add(12, n5);
        return gregorianCalendar;
    }

    private GregorianCalendar buildCalendarESTZ(byte[] byArray) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
        gregorianCalendar.setLenient(false);
        int n = 0;
        int n2 = XQueryUtils.twoBytesToIntReverse(byArray, n);
        if (n2 > Short.MAX_VALUE) {
            gregorianCalendar.set(0, 0);
            n2 = 65536 - n2;
        }
        gregorianCalendar.set(1, n2);
        int n3 = XQueryUtils.unsignedByteToInt(byArray[n += 2]);
        gregorianCalendar.set(2, n3 - 1);
        int n4 = XQueryUtils.unsignedByteToInt(byArray[++n]);
        gregorianCalendar.set(5, n4);
        int n5 = XQueryUtils.unsignedByteToInt(byArray[++n]);
        gregorianCalendar.set(11, n5);
        int n6 = XQueryUtils.unsignedByteToInt(byArray[++n]);
        gregorianCalendar.set(12, n6);
        int n7 = XQueryUtils.unsignedByteToInt(byArray[++n]);
        gregorianCalendar.set(13, n7);
        ++n;
        int n8 = XQueryUtils.fourBytesToIntReverse(byArray, ++n);
        gregorianCalendar.set(14, n8 / 1000000);
        byte by = byArray[n += 4];
        byte by2 = byArray[++n];
        int n9 = by * 60;
        n9 += by2;
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n9 *= 60000, "");
        gregorianCalendar.setTimeZone(simpleTimeZone);
        gregorianCalendar.getTime();
        gregorianCalendar.add(11, by);
        gregorianCalendar.add(12, by2);
        return gregorianCalendar;
    }

    private void processTIMESTAMPTZ(byte[] byArray, int n, int n2, OXMLItem oXMLItem) throws SQLException {
        GregorianCalendar gregorianCalendar = null;
        gregorianCalendar = n2 == 181 ? this.buildCalendar(byArray) : this.buildCalendarESTZ(byArray);
        switch (n) {
            case 8: {
                oXMLItem.setCalendar(OXMLSequenceType.TDATETIME, true, gregorianCalendar);
                break;
            }
            case 10: {
                XDBConnExpr.removeTimeInfo(gregorianCalendar);
                gregorianCalendar.getTime();
                oXMLItem.setCalendar(OXMLSequenceType.TDATE, true, gregorianCalendar);
                break;
            }
            case 9: {
                gregorianCalendar.set(1, 2000);
                gregorianCalendar.set(2, 0);
                gregorianCalendar.set(5, 1);
                gregorianCalendar.getTime();
                oXMLItem.setCalendar(OXMLSequenceType.TTIME, true, gregorianCalendar);
                break;
            }
            case 11: {
                gregorianCalendar.set(1, 2000);
                gregorianCalendar.set(2, 0);
                XDBConnExpr.removeTimeInfo(gregorianCalendar);
                gregorianCalendar.getTime();
                oXMLItem.setCalendar(OXMLSequenceType.TGDAY, true, gregorianCalendar);
                break;
            }
            case 12: {
                gregorianCalendar.set(1, 2000);
                gregorianCalendar.set(5, 1);
                XDBConnExpr.removeTimeInfo(gregorianCalendar);
                gregorianCalendar.getTime();
                oXMLItem.setCalendar(OXMLSequenceType.TGMONTH, true, gregorianCalendar);
                break;
            }
            case 13: {
                gregorianCalendar.set(2, 0);
                gregorianCalendar.set(5, 1);
                XDBConnExpr.removeTimeInfo(gregorianCalendar);
                gregorianCalendar.getTime();
                oXMLItem.setCalendar(OXMLSequenceType.TGYEAR, true, gregorianCalendar);
                break;
            }
            case 14: {
                gregorianCalendar.set(5, 1);
                XDBConnExpr.removeTimeInfo(gregorianCalendar);
                gregorianCalendar.getTime();
                oXMLItem.setCalendar(OXMLSequenceType.TGYEARMONTH, true, gregorianCalendar);
                break;
            }
            case 15: {
                gregorianCalendar.set(1, 2000);
                XDBConnExpr.removeTimeInfo(gregorianCalendar);
                gregorianCalendar.getTime();
                oXMLItem.setCalendar(OXMLSequenceType.TGMONTHDAY, true, gregorianCalendar);
            }
        }
    }

    private static void removeTimeInfo(GregorianCalendar gregorianCalendar) {
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(9, 0);
        gregorianCalendar.set(10, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
    }

    private void processNUMBER(NUMBER nUMBER, int n, OXMLItem oXMLItem) throws SQLException {
        switch (n) {
            case 4: {
                this.setNumericValue(nUMBER, OXMLSequenceType.TDECIMAL, oXMLItem);
                break;
            }
            case 33: {
                this.setNumericValue(nUMBER, OXMLSequenceType.TINTEGER, oXMLItem);
                break;
            }
            case 34: {
                this.setNumericValue(nUMBER, FNUtil.TNPINTEGER, oXMLItem);
                break;
            }
            case 35: {
                this.setNumericValue(nUMBER, FNUtil.TNINTEGER, oXMLItem);
                break;
            }
            case 36: {
                this.setNumericValue(nUMBER, FNUtil.TLONG, oXMLItem);
                break;
            }
            case 37: {
                this.setNumericValue(nUMBER, FNUtil.TINT, oXMLItem);
                break;
            }
            case 38: {
                this.setNumericValue(nUMBER, FNUtil.TSHORT, oXMLItem);
                break;
            }
            case 39: {
                this.setNumericValue(nUMBER, FNUtil.TBYTE, oXMLItem);
                break;
            }
            case 40: {
                this.setNumericValue(nUMBER, FNUtil.TNNINTEGER, oXMLItem);
                break;
            }
            case 41: {
                this.setNumericValue(nUMBER, FNUtil.TULONG, oXMLItem);
                break;
            }
            case 42: {
                this.setNumericValue(nUMBER, FNUtil.TUINT, oXMLItem);
                break;
            }
            case 43: {
                this.setNumericValue(nUMBER, FNUtil.TUSHORT, oXMLItem);
                break;
            }
            case 44: {
                this.setNumericValue(nUMBER, FNUtil.TUBYTE, oXMLItem);
                break;
            }
            case 45: {
                this.setNumericValue(nUMBER, FNUtil.TPINTEGER, oXMLItem);
            }
        }
    }

    private void setNumericValue(NUMBER nUMBER, OXMLSequenceType oXMLSequenceType, OXMLItem oXMLItem) throws SQLException {
        if (nUMBER.isInt()) {
            try {
                oXMLItem.setInt(oXMLSequenceType, nUMBER.intValue());
            }
            catch (SQLException sQLException) {
                oXMLItem.setDecimal(oXMLSequenceType, nUMBER.bigDecimalValue());
            }
        } else {
            oXMLItem.setDecimal(oXMLSequenceType, nUMBER.bigDecimalValue());
        }
    }

    private void processString(String string, int n, OXMLItem oXMLItem) {
        switch (n) {
            case 2: {
                oXMLItem.setString(OXMLSequenceType.TSTRING, string);
                break;
            }
            case 50: {
                oXMLItem.setUntypedLexical(string);
                break;
            }
            case 18: {
                oXMLItem.setString(OXMLSequenceType.TANYURI, string);
                break;
            }
            case 21: {
                oXMLItem.setString(FNUtil.TNSTRING, string);
                break;
            }
            case 22: {
                oXMLItem.setString(FNUtil.TTOKEN, string);
                break;
            }
            case 23: {
                oXMLItem.setString(FNUtil.TLANGUAGE, string);
                break;
            }
            case 24: {
                oXMLItem.setString(FNUtil.TNMTOKEN, string);
                break;
            }
            case 25: {
                oXMLItem.setString(FNUtil.TNMTOKENS, string);
                break;
            }
            case 26: {
                oXMLItem.setString(FNUtil.TNAME, string);
                break;
            }
            case 27: {
                oXMLItem.setString(FNUtil.TNCNAME, string);
                break;
            }
            case 28: {
                oXMLItem.setString(FNUtil.TID, string);
                break;
            }
            case 29: {
                oXMLItem.setString(FNUtil.TIDREF, string);
                break;
            }
            case 30: {
                oXMLItem.setString(FNUtil.TIDREFS, string);
                break;
            }
            case 31: {
                oXMLItem.setString(FNUtil.TENTITY, string);
                break;
            }
            case 32: {
                oXMLItem.setString(FNUtil.TENTITIES, string);
            }
        }
    }

    class XDBConnIterator
    implements ExprResultIterator {
        XDBConnExpr myExpr;
        boolean eof;
        QueryState qryState;
        PageManager pgm;

        public XDBConnIterator(XDBConnExpr xDBConnExpr2, QueryState queryState) {
            this.myExpr = xDBConnExpr2;
            this.eof = true;
            this.qryState = queryState;
            this.pgm = null;
        }

        @Override
        public void Restart() {
            this.eof = false;
            this.myExpr.prepare();
        }

        @Override
        public OXMLItem Fetch() {
            if (this.eof) {
                return null;
            }
            try {
                if (XDBConnExpr.this.rset.next()) {
                    OXMLItem oXMLItem = this.qryState.createItem();
                    XMLType xMLType = (XMLType)XDBConnExpr.this.rset.getObject(1);
                    if (xMLType == null) {
                        this.Close();
                        return null;
                    }
                    byte[] byArray = xMLType.getXQDMBytes();
                    if (byArray != null) {
                        XDBConnExpr.this.processXQDMImage(byArray, xMLType, this, oXMLItem);
                    } else {
                        if (this.pgm == null) {
                            this.pgm = this.getPageManager();
                        }
                        String string = xMLType.getStringVal();
                        this.myExpr.getXMLTypeItem(this.qryState, string, oXMLItem, this.pgm, xMLType);
                    }
                    return oXMLItem;
                }
                this.Close();
                return null;
            }
            catch (Exception exception) {
                this.Close();
                throw new XQException(exception);
            }
        }

        @Override
        public void Close() {
            this.eof = true;
            if (this.myExpr.pstmt != null) {
                try {
                    XDBConnExpr.this.pstmt.close();
                    XDBConnExpr.this.pstmt = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.pgm != null) {
                this.pgm.close();
            }
            this.pgm = null;
        }

        private PageManager getPageManager() {
            PageManager pageManager = null;
            if (this.qryState.getLazyDom()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("XDBConnExpr_");
                stringBuffer.append(ThreadSerialNum.getNextNum());
                String string = stringBuffer.toString();
                pageManager = this.qryState.getPageManagerPool().getPageManager(string);
                this.qryState.addToPgmHT(string, pageManager);
            }
            return pageManager;
        }
    }
}

