/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.macros.MacroHandler;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ideimpl.macros.MacroDefinition;
import oracle.ideimpl.macros.MacroDefinitions;
import oracle.ideimpl.macros.MacrosArb;
import oracle.ideimpl.macros.Scope;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Log;

public class UserMacroHandler
implements MacroHandler {
    private static UserMacroHandler instance = new UserMacroHandler();
    private static boolean initialized = false;
    private String lruProject;
    private String lruWorkspace;
    private static Map<String, MacroDefinition> currentlyVisibleMacros = new HashMap<String, MacroDefinition>();
    private static Log MACRO_LOG = new Log("MacroUtils");

    private UserMacroHandler() {
    }

    public static synchronized UserMacroHandler getInstance() {
        if (!initialized) {
            UserMacroHandler.loadGlobalMacros();
            initialized = true;
        }
        return instance;
    }

    @Override
    public String getDescription(Context context, String name) {
        this.loadVisibleMacrosForContext(context);
        if (currentlyVisibleMacros.containsKey(name)) {
            return currentlyVisibleMacros.get(name).getDescription();
        }
        return MacrosArb.format("MACRO_UNDEFINED_OR_NOT_VISIBLE_MESSAGE", name);
    }

    @Override
    public String getValue(Context context, String name) {
        this.loadVisibleMacrosForContext(context);
        if (currentlyVisibleMacros.containsKey(name)) {
            return currentlyVisibleMacros.get(name).getValue();
        }
        return null;
    }

    @Override
    public List<String> getNames(Context context) {
        this.loadVisibleMacrosForContext(context);
        return new ArrayList<String>(currentlyVisibleMacros.keySet());
    }

    public List<MacroDefinition> getUserDefinedMacrosForScopes(Context context, EnumSet<Scope> scopes) {
        Project project;
        ArrayList<MacroDefinition> visibleMacros = new ArrayList<MacroDefinition>();
        if (scopes.contains((Object)Scope.USER)) {
            project = context.getProject();
            List<MacroDefinition> userMacros = this.loadUserMacros(project);
            if (userMacros == null) {
                MACRO_LOG.trace("UserMacroHandler.getUserDefinedMacrosForScopes - no user-private macros");
            } else {
                MACRO_LOG.trace("UserMacroHandler.getUserDefinedMacrosForScopess adding " + userMacros.size() + " user-private macros");
                visibleMacros.addAll(userMacros);
            }
        }
        if (scopes.contains((Object)Scope.PROJECT)) {
            project = context.getProject();
            List<MacroDefinition> projectMacros = this.loadProjectMacros(project);
            if (projectMacros == null) {
                MACRO_LOG.trace("UserMacroHandler.getUserDefinedMacrosForScopes - no project macros");
            } else {
                MACRO_LOG.trace("UserMacroHandler.getUserDefinedMacrosForScopes adding " + projectMacros.size() + " project macros");
                visibleMacros.addAll(projectMacros);
            }
        }
        if (scopes.contains((Object)Scope.WORKSPACE)) {
            Workspace workspace;
            project = context.getProject();
            List<MacroDefinition> workspaceMacros = this.loadWorkspaceMacros(project, workspace = context.getWorkspace());
            if (workspaceMacros == null) {
                MACRO_LOG.trace("UserMacroHandler.getUserDefinedMacrosForScopes - no workspace macros");
            } else {
                MACRO_LOG.trace("UserMacroHandler.getUserDefinedMacrosForScopes " + workspaceMacros.size() + " workspace macros");
                visibleMacros.addAll(workspaceMacros);
            }
        }
        if (scopes.contains((Object)Scope.GLOBAL)) {
            List<MacroDefinition> globalMacros = UserMacroHandler.loadGlobalMacros();
            if (globalMacros == null) {
                MACRO_LOG.trace("UserMacroHandler.getUserDefinedMacrosForScopes - no global macros");
            } else {
                MACRO_LOG.trace("UserMacroHandler.getUserDefinedMacrosForScopes " + globalMacros.size() + " global macros");
                visibleMacros.addAll(globalMacros);
            }
        }
        return visibleMacros;
    }

    public void setUserDefinedMacros(Context context, List<MacroDefinition> allMacros) {
        ArrayList<MacroDefinition> userMacros = new ArrayList<MacroDefinition>();
        ArrayList<MacroDefinition> projectMacros = new ArrayList<MacroDefinition>();
        ArrayList<MacroDefinition> workspaceMacros = new ArrayList<MacroDefinition>();
        ArrayList<MacroDefinition> globalMacros = new ArrayList<MacroDefinition>();
        MACRO_LOG.trace("UserMacroHandler.setUserDefinedMacros() persisting " + allMacros.size() + " macros");
        block6: for (MacroDefinition md : allMacros) {
            switch (md.getScope()) {
                case USER: {
                    userMacros.add(md);
                    MACRO_LOG.trace("UserMacroHandler.setUserDefinedMacros() adding " + md.getName() + " to user macros");
                    continue block6;
                }
                case PROJECT: {
                    projectMacros.add(md);
                    MACRO_LOG.trace("UserMacroHandler.setUserDefinedMacros() adding " + md.getName() + " to project macros");
                    continue block6;
                }
                case WORKSPACE: {
                    workspaceMacros.add(md);
                    MACRO_LOG.trace("UserMacroHandler.setUserDefinedMacros() adding " + md.getName() + " to workspace macros");
                    continue block6;
                }
                case GLOBAL: {
                    globalMacros.add(md);
                    MACRO_LOG.trace("UserMacroHandler.setUserDefinedMacros() adding " + md.getName() + " to global macros");
                    continue block6;
                }
            }
            MACRO_LOG.trace("UserMacroHandler.setUserDefinedMacros() unexpected scope " + md.getScope());
        }
        Project project = context.getProject();
        if (userMacros.size() > 0) {
            HashStructure userProperties = project.getUserPropertiesOnly();
            PropertyData userPropertyStorage = new PropertyData(userProperties);
            MacroDefinitions userMDL = MacroDefinitions.getInstance(userPropertyStorage);
            for (MacroDefinition md : userMacros) {
                userMDL.addMacroDefinition(md);
            }
            MACRO_LOG.trace("UserMacroHandler.setUserDefinedMacros() saved " + userMacros.size() + " user macros");
        }
        if (projectMacros.size() > 0) {
            HashStructure sharedProperties = project.getSharedPropertiesOnly();
            PropertyData projectShared = new PropertyData(sharedProperties);
            MacroDefinitions projectMDL = MacroDefinitions.getInstance(projectShared);
            for (MacroDefinition md : projectMacros) {
                projectMDL.addMacroDefinition(md);
            }
            MACRO_LOG.trace("UserMacroHandler.setUserDefinedMacros() saved " + projectMacros.size() + " project macros");
        }
        if (workspaceMacros.size() > 0) {
            Workspace workspace = context.getWorkspace();
            PropertyData wsSharedPropertyStorage = new PropertyData(workspace.getSharedPropertiesOnly());
            MacroDefinitions workspaceMDL = MacroDefinitions.getInstance(wsSharedPropertyStorage);
            for (MacroDefinition md : workspaceMacros) {
                workspaceMDL.addMacroDefinition(md);
            }
            MACRO_LOG.trace("UserMacroHandler.setUserDefinedMacros() saved " + workspaceMacros.size() + " workspace macros");
        }
        if (globalMacros.size() > 0) {
            MacroDefinitions globalMDL = MacroDefinitions.getInstance((PropertyStorage)Preferences.getPreferences());
            for (MacroDefinition md : globalMacros) {
                globalMDL.addMacroDefinition(md);
            }
            MACRO_LOG.trace("UserMacroHandler.setUserDefinedMacros() saved " + globalMacros.size() + " global macros");
        }
    }

    private void loadVisibleMacrosForContext(Context context) {
        if (context == null) {
            return;
        }
        MACRO_LOG.trace("UserMacroHandler.loadVisibleMacrosForContext, at start " + currentlyVisibleMacros.size() + " macros visible");
        if (context.getProject() != null && !Project.getDefaultName().equals(this.lruProject)) {
            if (context.getBoolean("isEditingWorkspaceSharedProperties")) {
                this.clearProjectFromCurrentlyVisible();
                MACRO_LOG.trace("UserMacroHandler.loadVisibleMacrosForContext, after clearProject " + currentlyVisibleMacros.size() + " macros visible");
            } else {
                this.loadProjectMacros(context.getProject());
                MACRO_LOG.trace("UserMacroHandler.loadVisibleMacrosForContext, after loadProject " + currentlyVisibleMacros.size() + " macros visible");
            }
        }
        if (context.getWorkspace() != null && !context.getWorkspace().getLongLabel().equals(this.lruWorkspace)) {
            this.loadWorkspaceMacros(context.getProject(), context.getWorkspace());
            MACRO_LOG.trace("UserMacroHandler.loadVisibleMacrosForContext, after loadProject " + currentlyVisibleMacros.size() + " macros visible");
        }
        if (context.getBoolean("isEditingCustomUserProperties")) {
            this.loadUserMacros(context.getProject());
            MACRO_LOG.trace("UserMacroHandler.loadVisibleMacrosForContext, after loadUser " + currentlyVisibleMacros.size() + " macros visible");
        } else {
            this.clearUserFromCurrentlyVisible();
            MACRO_LOG.trace("UserMacroHandler.loadVisibleMacrosForContext, after clearUser " + currentlyVisibleMacros.size() + " macros visible");
        }
    }

    @Override
    public List<String> getPathMacroNames(Context context) {
        this.loadVisibleMacrosForContext(context);
        ArrayList<String> result = new ArrayList<String>();
        for (MacroDefinition def : currentlyVisibleMacros.values()) {
            if (!def.isLocation()) continue;
            result.add(def.getName());
        }
        return result;
    }

    @Override
    public String getQualifier() {
        return "user";
    }

    @Override
    public String getQualifierDescription() {
        return MacrosArb.get("USER_DEFINED_MACROS");
    }

    private List<MacroDefinition> loadUserMacros(Project project) {
        this.clearUserFromCurrentlyVisible();
        ArrayList<MacroDefinition> users = new ArrayList<MacroDefinition>();
        HashStructure userProperties = project.getUserPropertiesOnly();
        PropertyData userPropertyStorage = new PropertyData(userProperties);
        MacroDefinitions userMacros = MacroDefinitions.getInstance(userPropertyStorage);
        HashStructure list = userMacros.getMacroDefinitions();
        if (list != null) {
            for (String key : list.keySet()) {
                MacroDefinition def = new MacroDefinition(list.getHashStructure(key));
                MACRO_LOG.trace("UserMacroHandler.loadUserMacros adding " + def.getName() + " to visible macros");
                currentlyVisibleMacros.put(def.getName(), def);
                users.add(def);
            }
        }
        return users;
    }

    private List<MacroDefinition> loadProjectMacros(Project project) {
        this.clearProjectFromCurrentlyVisible();
        ArrayList<MacroDefinition> projects = new ArrayList<MacroDefinition>();
        HashStructure sharedProperties = project.getSharedPropertiesOnly();
        PropertyData sharedPropertyStorage = new PropertyData(sharedProperties);
        MacroDefinitions projectMacros = MacroDefinitions.getInstance(sharedPropertyStorage);
        HashStructure list = projectMacros.getMacroDefinitions();
        if (list != null) {
            for (String key : list.keySet()) {
                MacroDefinition def = new MacroDefinition(list.getHashStructure(key));
                MACRO_LOG.trace("UserMacroHandler.loadProjectMacros adding " + def.getName() + " to visible macros");
                currentlyVisibleMacros.put(def.getName(), def);
                projects.add(def);
            }
        }
        this.lruProject = project.getLongLabel();
        return projects;
    }

    private List<MacroDefinition> loadWorkspaceMacros(Project project, Workspace workspace) {
        HashStructure workspaceProperties = workspace.getSharedPropertiesOnly();
        PropertyData workspaceSharedPropertyStorage = new PropertyData(workspaceProperties);
        this.clearWorkspaceFromCurrentlyVisible();
        ArrayList<MacroDefinition> workspaces = new ArrayList<MacroDefinition>();
        MacroDefinitions workspaceMacros = MacroDefinitions.getInstance(workspaceSharedPropertyStorage);
        HashStructure list = workspaceMacros.getMacroDefinitions();
        if (list != null) {
            for (String key : list.keySet()) {
                MacroDefinition def = new MacroDefinition(list.getHashStructure(key));
                MACRO_LOG.trace("UserMacroHandler.loadWorkspaceMacros adding " + def.getName() + " to visible macros");
                currentlyVisibleMacros.put(def.getName(), def);
                workspaces.add(def);
            }
        }
        this.lruWorkspace = workspace.getLongLabel();
        return workspaces;
    }

    private static List<MacroDefinition> loadGlobalMacros() {
        UserMacroHandler.clearGlobalsFromCurrentlyVisible();
        ArrayList<MacroDefinition> globals = new ArrayList<MacroDefinition>();
        MacroDefinitions globalMacros = MacroDefinitions.getInstance((PropertyStorage)Preferences.getPreferences());
        HashStructure list = globalMacros.getMacroDefinitions();
        if (list != null) {
            for (String key : list.keySet()) {
                MacroDefinition def = new MacroDefinition(list.getHashStructure(key));
                MACRO_LOG.trace("UserMacroHandler.loadGlobalMacros adding " + def.getName() + " to visible macros");
                currentlyVisibleMacros.put(def.getName(), def);
                globals.add(def);
            }
        }
        return globals;
    }

    private static void clearGlobalsFromCurrentlyVisible() {
        Iterator<MacroDefinition> iter = currentlyVisibleMacros.values().iterator();
        while (iter.hasNext()) {
            MacroDefinition def = iter.next();
            if (def.getScope() != Scope.GLOBAL) continue;
            iter.remove();
        }
    }

    private void clearUserFromCurrentlyVisible() {
        Iterator<MacroDefinition> iter = currentlyVisibleMacros.values().iterator();
        while (iter.hasNext()) {
            MacroDefinition def = iter.next();
            if (def.getScope() != Scope.USER) continue;
            iter.remove();
        }
    }

    private void clearProjectFromCurrentlyVisible() {
        Iterator<MacroDefinition> iter = currentlyVisibleMacros.values().iterator();
        while (iter.hasNext()) {
            MacroDefinition def = iter.next();
            if (def.getScope() != Scope.PROJECT) continue;
            iter.remove();
        }
    }

    private void clearWorkspaceFromCurrentlyVisible() {
        Iterator<MacroDefinition> iter = currentlyVisibleMacros.values().iterator();
        while (iter.hasNext()) {
            MacroDefinition def = iter.next();
            if (def.getScope() != Scope.WORKSPACE) continue;
            iter.remove();
        }
    }

    @Override
    public boolean requiresContext(String name) {
        return false;
    }

    private static class PropertyData
    implements PropertyStorage {
        private HashStructure propertyData;

        public PropertyData(HashStructure hash) {
            if (hash == null) {
                throw new IllegalArgumentException("The HashStructure cannot be null.");
            }
            this.propertyData = hash;
        }

        public HashStructure getProperties() {
            return this.propertyData;
        }
    }
}

