/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.markers.Markable;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerAttributesHandler;
import oracle.ide.markers.MarkerException;
import oracle.ide.markers.annotations.MarkerAttribute;
import oracle.ide.model.IconProvider;
import oracle.ide.model.LabelProvider;
import oracle.ideimpl.markers.MarkerAttributesHandlerChain;
import oracle.ideimpl.markers.MarkerRankCalculator;
import oracle.ideimpl.markers.MarkerStore;
import oracle.javatools.data.HashStructure;
import oracle.javatools.status.Issue;
import oracle.javatools.util.Filter;
import oracle.javatools.util.ModelUtil;

public final class MarkerImpl
implements Marker,
InvocationHandler {
    private static final String ATTR_ID = "id";
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String ATTR_LAST_UPDATED = "lastUpdated";
    private static final String ATTR_MARKABLE_URL = "markableURL";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_EVENTS = "events";
    private static final String ARG_MUST_NOT_BE_NULL_MSG = "{0} must not be null";
    private static final Object STR_ATTR_NAMES = "Attribute Names";
    private static final String DELETED_MSG = "Marker has been deleted";
    private static final String ALREADY_MARKABLE_MSG = "Markable has already been set";
    private static final boolean UPDATE_ONLY = false;
    private static final boolean REPLACE_ALL = true;
    private Markable markable;
    private AtomicBoolean deleted = new AtomicBoolean(false);
    private Marker proxy;
    private Set<Marker.EventDescription> events;
    private MarkerAttributesHandler attrHandler;
    private Long rank;
    private MarkerStore store;
    private final String id;
    private final Context context;
    private final Class<? extends Marker> type;
    private final long timestamp;

    private static IconProvider<Marker> getIconProvider(Marker marker) {
        return (IconProvider)AdapterManager.Factory.getAdapterManager().adapt((Object)marker, IconProvider.class);
    }

    private static LabelProvider<Marker> getLabelProvider(Marker marker) {
        return (LabelProvider)AdapterManager.Factory.getAdapterManager().adapt((Object)marker, LabelProvider.class);
    }

    public MarkerImpl(Class<? extends Marker> type, Context context) {
        this.context = MarkerImpl.copyContext(context);
        this.type = type;
        this.id = UUID.randomUUID().toString();
        this.timestamp = System.currentTimeMillis();
    }

    public void initialize(Marker marker) throws MarkerException {
        this.proxy = marker;
        this.attrHandler = MarkerAttributesHandlerChain.Factory.newMarkerAttributesHandlerChainFor(marker);
        HashMap<String, Object> initialAttrs = new HashMap<String, Object>();
        initialAttrs.put(ATTR_ID, this.id);
        initialAttrs.put(ATTR_TIMESTAMP, this.timestamp);
        initialAttrs.put(ATTR_TYPE, this.type.getName());
        this.attrHandler.update(this.proxy, initialAttrs, true);
    }

    @Override
    public synchronized Object getAttribute(String name) {
        return this.attrHandler.getAttribute(this.proxy, name);
    }

    @Override
    public synchronized int getAttribute(String name, int defaultVal) {
        return this.attrHandler.getAttribute(this.proxy, name, defaultVal);
    }

    @Override
    public synchronized long getAttribute(String name, long defaultVal) {
        return this.attrHandler.getAttribute(this.proxy, name, defaultVal);
    }

    @Override
    public synchronized float getAttribute(String name, float defaultVal) {
        return this.attrHandler.getAttribute(this.proxy, name, defaultVal);
    }

    @Override
    public synchronized double getAttribute(String name, double defaultVal) {
        return this.attrHandler.getAttribute(this.proxy, name, defaultVal);
    }

    @Override
    public synchronized boolean getAttribute(String name, boolean defaultVal) {
        return this.attrHandler.getAttribute(this.proxy, name, defaultVal);
    }

    @Override
    public synchronized Map<String, Object> getAttributes() {
        return this.attrHandler.getAttributes(this.proxy);
    }

    @Override
    public Map<String, Object> getAttributes(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException(MessageFormat.format(ARG_MUST_NOT_BE_NULL_MSG, STR_ATTR_NAMES));
        }
        return this.attrHandler.getAttributes(this.proxy, names);
    }

    @Override
    public Map<String, Object> getAttributes(Map<String, Object> defaults) {
        return this.attrHandler.getAttributes(this.proxy, defaults);
    }

    @Override
    public synchronized long timestamp() {
        return this.timestamp;
    }

    @Override
    public synchronized String id() {
        return this.id;
    }

    @Override
    public synchronized Markable markable() throws MarkerException {
        if (this.markable != null) {
            return this.markable;
        }
        return null;
    }

    @Override
    public void delete() throws MarkerException {
        Markable markable = this.markable();
        if (null == markable) {
            throw new MarkerException("Unable to delete: no markable");
        }
        markable.removeMarkers(new Marker[]{this.proxy});
        this.deleted.set(true);
    }

    @Override
    public boolean isDeleted() {
        return this.deleted.get();
    }

    public String getShortLabel() {
        String shortLabel = null;
        LabelProvider<Marker> provider = MarkerImpl.getLabelProvider(this.proxy);
        if (null != provider) {
            shortLabel = provider.labelFor((Object)this.proxy, LabelProvider.SHORT_LABEL);
        }
        return ModelUtil.hasLength(shortLabel) ? shortLabel : this.type.getSimpleName();
    }

    public String getLongLabel() {
        LabelProvider<Marker> provider = MarkerImpl.getLabelProvider(this.proxy);
        return provider != null ? provider.labelFor((Object)this.proxy, LabelProvider.LONG_LABEL) : "";
    }

    public Icon getIcon() {
        IconProvider<Marker> provider = MarkerImpl.getIconProvider(this.proxy);
        return provider != null ? provider.iconFor((Object)this.proxy, IconProvider._16_X_16, true) : null;
    }

    public String getToolTipText() {
        LabelProvider<Marker> provider = MarkerImpl.getLabelProvider(this.proxy);
        return provider != null ? provider.labelFor((Object)this.proxy, LabelProvider.TOOLTIP) : "";
    }

    @Override
    public synchronized void setMarkable(Markable markable) throws MarkerException {
        if (markable == null) {
            throw new IllegalArgumentException("Markable instance must not be null!");
        }
        if (this.markable != null && !this.markable.equals(markable)) {
            throw new MarkerException(new IllegalStateException(ALREADY_MARKABLE_MSG));
        }
        this.markable = markable;
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put(ATTR_MARKABLE_URL, markable.getUrl());
        this.attrHandler.update(this.proxy, updates, false);
        this.validate(this.getAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            MarkerImpl markerImpl = this;
            synchronized (markerImpl) {
                if (null == this.proxy && proxy instanceof Marker) {
                    this.proxy = (Marker)proxy;
                }
            }
            return method.invoke((Object)this, args);
        }
        catch (Exception e) {
            MarkerAttribute attribute = method.getAnnotation(MarkerAttribute.class);
            if (attribute != null) {
                if (args == null || args.length == 0) {
                    return this.getAttribute(method.getName());
                }
                try {
                    this.setAttribute(method.getName(), args[0]);
                }
                catch (MarkerException mex) {
                    throw new InvocationTargetException(mex);
                }
            } else {
                FeedbackManager.reportException((String)("Trying to invoke " + method.getName()), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public synchronized long lastUpdated() {
        return this.attrHandler.getAttribute(this.proxy, ATTR_LAST_UPDATED, this.timestamp());
    }

    @Override
    public synchronized void update(Map<String, Object> attributes, boolean replace) throws MarkerException {
        if (this.isDeleted()) {
            throw new MarkerException(new IllegalStateException(DELETED_MSG));
        }
        MarkerStore store = null;
        if (null != this.markable()) {
            store = this.getMarkerStore();
            if (null == store) {
                throw new MarkerException("Unable to access marker store");
            }
            this.validate(attributes);
        }
        this.attrHandler.update(this.proxy, attributes, replace);
        if (null != store) {
            store.updateMarkers(new Marker[]{this.proxy});
        }
    }

    @Override
    public synchronized Map<String, Object> removedAttributes() {
        return this.attrHandler.removedAttributes(this.proxy);
    }

    @Override
    public synchronized Map<String, Object> addedAttributes() {
        return this.attrHandler.addedAttributes(this.proxy);
    }

    @Override
    public synchronized Map<String, Object> modifiedAttributes() {
        return this.attrHandler.modifiedAttributes(this.proxy);
    }

    private void setAttribute(String name, Object value) throws MarkerException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(name, value);
        this.update(attributes, false);
    }

    private MarkerStore getMarkerStore() {
        if (null == this.store) {
            this.store = MarkerStore.Factory.getMarkerStore(this.markable);
        }
        return this.store;
    }

    private void validate(Map<String, Object> attributes) throws MarkerException {
        Set<MarkerAttribute> readOnlyAttrs = this.getAttributeDescriptions(new ReadOnlyAttributeFilter());
        for (MarkerAttribute attr : readOnlyAttrs) {
            if (!attributes.containsKey(attr.id())) continue;
            throw new MarkerException("Can not set read-only attribute: " + attr.id());
        }
        Set<MarkerAttribute> requiredAttrs = this.getAttributeDescriptions(new RequiredAttributeFilter());
        Map<String, Object> setAttrs = this.getAttributes();
        for (MarkerAttribute attr : requiredAttrs) {
            if (setAttrs.containsKey(attr.id()) || attributes.containsKey(attr.id())) continue;
            throw new MarkerException("Missing required attribute: " + attr.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<MarkerAttribute> getAttributeDescriptions(Filter<MarkerAttribute> filter) {
        Method[] methods;
        MarkerImpl markerImpl = this;
        synchronized (markerImpl) {
            if (null == this.proxy) {
                throw new IllegalStateException("Marker proxy has not been set");
            }
        }
        if (null == filter) {
            filter = Filter.Instances.acceptsAll();
        }
        HashSet<MarkerAttribute> attrs = new HashSet<MarkerAttribute>();
        Class<?> _class = this.proxy.getClass();
        for (Method method : methods = _class.getMethods()) {
            MarkerAttribute attr = method.getAnnotation(MarkerAttribute.class);
            if (null == attr || !filter.matches((Object)attr)) continue;
            attrs.add(attr);
        }
        return attrs;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Marker)) {
            return false;
        }
        return ModelUtil.areEqual((Object)this.id(), (Object)((Marker)object).id());
    }

    @Override
    public int hashCode() {
        int PRIME = 37;
        int result = super.hashCode();
        result = 37 * result + this.id().hashCode();
        return result;
    }

    @Override
    public Context context() {
        return this.context;
    }

    public String toString() {
        LabelProvider<Marker> provider = MarkerImpl.getLabelProvider(this.proxy);
        return null != provider ? provider.labelFor((Object)this.proxy, LabelProvider.TO_STRING) : super.toString();
    }

    @Override
    public boolean isFixable() {
        Issue issue = (Issue)AdapterManager.Factory.getAdapterManager().adapt((Object)this.proxy, Issue.class);
        return null != issue ? issue.hasTransforms() : false;
    }

    @Override
    public Set<Marker.EventDescription> getEvents() {
        if (null == this.events) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.events);
    }

    @Override
    public void addEvent(Marker.EventDescription event) {
        if (null == this.events) {
            this.events = new HashSet<Marker.EventDescription>();
        }
        if (!this.events.add(event)) {
            return;
        }
        try {
            HashMap<String, Object> updates = new HashMap<String, Object>();
            updates.put(ATTR_EVENTS, this.events);
            this.attrHandler.update(this.proxy, updates, false);
            MarkerStore store = this.getMarkerStore();
            if (null != store) {
                store.updateMarkers(new Marker[]{this.proxy});
            }
        }
        catch (MarkerException e) {
            FeedbackManager.reportException((Throwable)e);
        }
    }

    @Override
    public void removeEvent(Marker.EventDescription event) {
        if (null == this.events) {
            return;
        }
        if (!this.events.remove(event)) {
            return;
        }
        try {
            HashMap<String, Object> updates = new HashMap<String, Object>();
            updates.put(ATTR_EVENTS, this.events);
            this.attrHandler.update(this.proxy, updates, false);
            MarkerStore store = this.getMarkerStore();
            if (null != store) {
                store.updateMarkers(new Marker[]{this.proxy});
            }
        }
        catch (MarkerException e) {
            FeedbackManager.reportException((Throwable)e);
        }
    }

    @Override
    public int compareTo(Marker o) {
        long thatRank;
        int thatMajor;
        long thisRank = this.rank();
        int thisMajor = (int)thisRank & 0xFFFFFFFF;
        int diff = thisMajor - (thatMajor = (int)(thatRank = o.rank()) & 0xFFFFFFFF);
        if (0 != diff) {
            return diff;
        }
        int thisMinor = (int)(thisRank >> 32);
        int thatMinor = (int)(thatRank >> 32);
        diff = thisMinor - thatMinor;
        return diff;
    }

    private static Context copyContext(Context context) {
        Context copy = new Context(null, context.getWorkspace(), context.getProject(), context.getNode());
        copy.setElement(context.getElement());
        return copy;
    }

    public HashStructure getHashStructure() {
        return (HashStructure)AdapterManager.Factory.getAdapterManager().adapt((Object)this.attrHandler, HashStructure.class);
    }

    @Override
    public String notification() {
        throw new UnsupportedOperationException("notification() method not supported");
    }

    @Override
    public long rank() {
        if (null == this.rank) {
            this.rank = MarkerRankCalculator.calculateRank(this.proxy);
        }
        return this.rank;
    }

    static {
        AdapterManager.Factory.getAdapterManager().registerFactory(new AdapterFactory<Marker, Class<?>>(){

            public Class<?> adapt(Marker marker) {
                if (null == marker) {
                    return null;
                }
                Class<?> markerClass = marker.getClass();
                if (!Proxy.isProxyClass(markerClass)) {
                    return markerClass;
                }
                InvocationHandler handler = Proxy.getInvocationHandler(marker);
                if (handler instanceof MarkerImpl) {
                    return ((MarkerImpl)handler).type;
                }
                return handler.getClass();
            }
        });
    }

    private class ReadOnlyAttributeFilter
    implements Filter<MarkerAttribute> {
        private ReadOnlyAttributeFilter() {
        }

        public boolean matches(MarkerAttribute value) {
            return null != value ? value.readOnly() : false;
        }
    }

    private class RequiredAttributeFilter
    implements Filter<MarkerAttribute> {
        private RequiredAttributeFilter() {
        }

        public boolean matches(MarkerAttribute value) {
            return null != value ? value.required() : false;
        }
    }
}

