/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import java.lang.reflect.Proxy;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerTypeDescriptor;
import oracle.ide.markers.annotations.MarkerType;
import oracle.ide.model.LabelProvider;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.patterns.Operator;
import oracle.javatools.util.ClassHierarchy;

public class MarkerLabelProvider
implements LabelProvider<Marker>,
AdapterFactory<Marker, LabelProvider> {
    private static final Map<String, Operator<Marker, String>> OPERATORS = new HashMap<String, Operator<Marker, String>>();
    private static final Map<String, String[]> ALTERNATE_KEYS;

    public String labelFor(Marker marker, String key) {
        Operator<Marker, String> operator = OPERATORS.get(key);
        if (null != operator) {
            return (String)operator.operate((Object)marker);
        }
        Object attr = marker.getAttribute(key);
        if (null != attr) {
            return String.valueOf(attr);
        }
        attr = marker.getAttribute(key.toLowerCase());
        if (null != attr) {
            return String.valueOf(attr);
        }
        attr = marker.getAttribute(key.toUpperCase());
        if (null != attr) {
            return String.valueOf(attr);
        }
        String[] alternates = ALTERNATE_KEYS.get(key);
        if (null != alternates) {
            for (String alternate : alternates) {
                String label = this.labelFor(marker, alternate);
                if (null == label) continue;
                return label;
            }
        }
        return "";
    }

    public LabelProvider adapt(Marker marker) {
        return this;
    }

    static {
        OPERATORS.put("FILE", new FilenameOperator());
        OPERATORS.put("LOCATION", new LocationOperator());
        OPERATORS.put("PROJECT", new ProjectOperator());
        OPERATORS.put("timestamp", new DateTimeOperator("timestamp"));
        OPERATORS.put("lastUpdated", new DateTimeOperator("lastUpdated"));
        OPERATORS.put(SHORT_LABEL, new ShortLabelOperator());
        ALTERNATE_KEYS = new HashMap<String, String[]>();
        ALTERNATE_KEYS.put(LabelProvider.TO_STRING, new String[]{"description"});
    }

    private static class FilenameOperator
    implements Operator<Marker, String> {
        private FilenameOperator() {
        }

        public String operate(Marker marker) {
            URL url = this.getUrl(marker);
            return null != url ? URLFileSystem.getFileName((URL)url) : "";
        }

        protected URL getUrl(Marker marker) {
            try {
                return URLFactory.encodeURL((URL)marker.markable().getUrl());
            }
            catch (Exception me) {
                FeedbackManager.reportException((Throwable)me);
                return null;
            }
        }
    }

    private static class LocationOperator
    extends FilenameOperator {
        private LocationOperator() {
        }

        @Override
        public String operate(Marker marker) {
            URL url = this.getUrl(marker);
            return null != url ? URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)url)) : "";
        }
    }

    private static class ProjectOperator
    implements Operator<Marker, String> {
        private ProjectOperator() {
        }

        public String operate(Marker marker) {
            Context context = marker.context();
            if (null == context) {
                return "";
            }
            Project project = context.getProject();
            return null != project ? project.getShortLabel() : "";
        }
    }

    private static class DateTimeOperator
    implements Operator<Marker, String> {
        private final String attrName;

        public DateTimeOperator(String attrName) {
            this.attrName = attrName;
        }

        public String operate(Marker marker) {
            long timestamp = marker.getAttribute(this.attrName, 0L);
            Date date = new Date(timestamp);
            return DateFormat.getDateTimeInstance().format(date);
        }
    }

    private static class ShortLabelOperator
    implements Operator<Marker, String> {
        private ShortLabelOperator() {
        }

        public String operate(Marker marker) {
            List classes = ClassHierarchy.getClassOrder(marker.getClass());
            for (Class type : classes) {
                MarkerType markerType;
                if (Proxy.isProxyClass(type) || Proxy.class.isAssignableFrom(type)) continue;
                try {
                    MarkerTypeDescriptor descriptor = MarkerTypeDescriptor.Factory.getMarkerType(type);
                    if (null != descriptor) {
                        return descriptor.name();
                    }
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.FINE, "Exception thrown when trying to get MarkerTypeDescriptor for " + type, e);
                }
                if (null == (markerType = type.getAnnotation(MarkerType.class))) continue;
                return markerType.name();
            }
            return "";
        }
    }
}

