/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.diff;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import mb.p_raffrayi.TypeCheckingFailedException;
import mb.p_raffrayi.impl.diff.IDifferContext;
import mb.p_raffrayi.impl.diff.IDifferOps;
import mb.p_raffrayi.impl.diff.IScopeGraphDiffer;
import mb.p_raffrayi.impl.diff.ScopeDiff;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.diff.BiMap;
import mb.scopegraph.oopsla20.diff.Edge;
import mb.scopegraph.oopsla20.diff.ScopeGraphDiff;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.patching.IPatchCollection;
import org.metaborg.util.RefBool;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.Futures;
import org.metaborg.util.future.ICompletable;
import org.metaborg.util.future.ICompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.unit.Unit;

public class ScopeGraphDiffer<S, L, D>
implements IScopeGraphDiffer<S, L, D> {
    private static final ILogger logger = LoggerUtils.logger(ScopeGraphDiffer.class);
    private final IDifferContext<S, L, D> currentContext;
    private final IDifferContext<S, L, D> previousContext;
    private final IDifferOps<S, L, D> differOps;
    private final Set<L> edgeLabels;
    private final CompletableFuture<ScopeGraphDiff<S, L, D>> result = new CompletableFuture();
    private Throwable failure;
    private final BiMap.Transient<S> matchedScopes = BiMap.Transient.of();
    private final BiMap.Transient<Edge<S, L>> matchedEdges = BiMap.Transient.of();
    private final Multimap<Tuple2<S, L>, Edge<S, L>> addedEdges = HashMultimap.create();
    private final Multimap<Tuple2<S, L>, Edge<S, L>> matchedOutgoingEdges = HashMultimap.create();
    private final Multimap<Tuple2<S, L>, Edge<S, L>> removedEdges = HashMultimap.create();
    private final Map<S, Optional<D>> currentScopeData = new HashMap<S, Optional<D>>();
    private final Map<S, Optional<D>> previousScopeData = new HashMap<S, Optional<D>>();
    private final Set<S> addedScopes = new HashSet<S>();
    private final Set<S> removedScopes = new HashSet<S>();
    private final Set<S> seenCurrentScopes = new HashSet<S>();
    private final Set<S> openCurrentScopes = new HashSet<S>();
    private final Set<S> seenPreviousScopes = new HashSet<S>();
    private final Set<S> openPreviousScopes = new HashSet<S>();
    private final Multimap<S, L> completedPreviousEdges = HashMultimap.create();
    private final Multimap<S, ICompletable<Optional<S>>> previousScopeProcessedDelays = HashMultimap.create();
    private final Multimap<Tuple2<S, L>, ICompletable<Unit>> previousScopeCompletedDelays = HashMultimap.create();
    private final Multimap<Edge<S, L>, ICompletable<Unit>> currentEdgeCompleteDelays = HashMultimap.create();
    private final AtomicInteger pendingResults = new AtomicInteger(0);
    private final AtomicBoolean inFixedPoint = new AtomicBoolean(false);
    private final AtomicBoolean typeCheckerFinished = new AtomicBoolean(false);
    private final Queue<EdgeMatch> edgeMatches = new PriorityQueue<EdgeMatch>();

    public ScopeGraphDiffer(IDifferContext<S, L, D> context, IDifferContext<S, L, D> previousContext, IDifferOps<S, L, D> differOps, Set<L> edgeLabels) {
        this.currentContext = context;
        this.previousContext = previousContext;
        this.differOps = differOps;
        this.edgeLabels = edgeLabels;
    }

    @Override
    public IFuture<ScopeGraphDiff<S, L, D>> diff(List<S> currentRootScopes, List<S> previousRootScopes) {
        try {
            logger.debug("Start scope graph differ");
            if (currentRootScopes.size() != previousRootScopes.size()) {
                logger.error("Current and previous root scope number differ.");
                return CompletableFuture.completedExceptionally(new IllegalStateException("Current and previous root scope number differ."));
            }
            HashBiMap rootMatches = HashBiMap.create();
            int i = 0;
            while (i < currentRootScopes.size()) {
                rootMatches.put(currentRootScopes.get(i), previousRootScopes.get(i));
                ++i;
            }
            BiMap initialMatches = this.consistent((Map<S, S>)rootMatches).orElse(null);
            if (initialMatches == null) {
                logger.error("Current and previous root scope number differ.");
                return CompletableFuture.completedExceptionally(new IllegalStateException("Provided root scopes cannot be matched."));
            }
            ArrayList futures = new ArrayList();
            initialMatches.entrySet().forEach(e -> {
                Object current = e.getKey();
                Object previous = e.getValue();
                this.scheduleCurrentData(current);
                this.schedulePreviousData(previous);
                this.match(current, previous);
                CompletableFuture future = new CompletableFuture();
                this.consequences(current, previous).whenComplete((cOpt, ex) -> {
                    if (ex != null) {
                        this.failure((Throwable)ex);
                        return;
                    }
                    if (!cOpt.isPresent()) {
                        logger.error("Root match internally inconsistent: {} ~ {}.", current, previous);
                        future.completeExceptionally(new TypeCheckingFailedException("Root match internally inconsistent: " + current + " ~ " + previous));
                        return;
                    }
                    Optional<BiMap<S, S>> matchesOpt = this.consistent((Map)cOpt.get());
                    if (!matchesOpt.isPresent()) {
                        logger.error("Root match inconsistent: {} ~ {}.", current, previous);
                        future.completeExceptionally(new TypeCheckingFailedException("Root match inconsistent: " + current + " ~ " + previous));
                    }
                    matchesOpt.get().forEach(this::match);
                    future.complete(Unit.unit);
                });
                futures.add(future);
            });
            AggregateFuture.of(futures).whenComplete((__, ex) -> {
                if (ex != null) {
                    this.failure((Throwable)ex);
                }
                logger.debug("Scheduled initial matches");
                this.fixedpoint();
            });
        }
        catch (Throwable ex2) {
            logger.error("Differ initialization failed.", ex2);
            this.failure(ex2);
        }
        return this.result;
    }

    @Override
    public IFuture<ScopeGraphDiff<S, L, D>> diff(IScopeGraph.Immutable<S, L, D> scopeGraph, Collection<S> scopes, Collection<S> sharedScopes, IPatchCollection.Immutable<S> patches, Collection<S> openScopes, Multimap<S, EdgeOrData<L>> openEdges) {
        logger.debug("Initializing differ from initial graph.");
        logger.trace("* scopes:      {}.", scopes);
        logger.trace("* scopeGraph:  {}.", scopeGraph);
        logger.trace("* patches:     {}.", patches);
        logger.trace("* open scopes: {}.", openScopes);
        logger.trace("* open edges:  {}.", openEdges);
        try {
            S newScope;
            for (S oldScope : scopes) {
                newScope = patches.patch(oldScope);
                this.seenCurrentScopes.add(newScope);
                this.seenPreviousScopes.add(oldScope);
                this.matchedScopes.put(newScope, oldScope);
                logger.trace("Initial scope match: {] ~ {}.", newScope, oldScope);
            }
            for (S oldScope : scopes) {
                logger.trace("Matching initially matched edges for {}.", oldScope);
                if (!this.differOps.ownOrSharedScope(oldScope)) continue;
                newScope = patches.patch(oldScope);
                for (L lbl : this.edgeLabels) {
                    ImmutableSet oldTargets = ImmutableSet.copyOf(scopeGraph.getEdges(oldScope, lbl));
                    Set newTargets = oldTargets.stream().map(patches::patch).collect(Collectors.toSet());
                    for (Object oldTarget : oldTargets) {
                        Object newTarget = patches.patch(oldTarget);
                        Edge<S, L> oldEdge = new Edge<S, L>(oldScope, lbl, oldTarget);
                        Edge<S, L> newEdge = new Edge<S, L>(newScope, lbl, newTarget);
                        this.matchedEdges.put(newEdge, oldEdge);
                        this.matchedOutgoingEdges.put(Tuple2.of(oldScope, lbl), oldEdge);
                        logger.trace("Initial edge match: {} ~ {}.", newEdge, oldEdge);
                    }
                    if (openScopes.contains(oldScope) || openEdges.containsEntry(oldScope, EdgeOrData.edge(lbl)) || sharedScopes.contains(oldScope)) {
                        logger.trace("Edge {}/{} open, scheduling residual matches.", oldScope, lbl);
                        IFuture<Iterable<S>> currentResidualTargetsFuture = this.currentContext.getEdges(newScope, lbl).thenApply(targets -> CapsuleUtil.toSet(targets).__removeAll(newTargets));
                        IFuture<Iterable<S>> previousResidualTargetsFuture = this.previousContext.getEdges(oldScope, lbl).thenApply(arg_0 -> ScopeGraphDiffer.lambda$6((Set)oldTargets, arg_0));
                        this.future(this.finishEdgeMatches(newScope, oldScope, lbl, currentResidualTargetsFuture, previousResidualTargetsFuture));
                        continue;
                    }
                    logger.trace("Edge {}/{} not open, mark as completed.", oldScope, lbl);
                    this.completedPreviousEdges.put(oldScope, lbl);
                }
            }
            this.fixedpoint();
        }
        catch (Throwable ex) {
            logger.error("Differ initialization failed.", ex);
            this.failure(ex);
        }
        return this.result;
    }

    @Override
    public boolean matchScopes(BiMap.Immutable<S> scopes) {
        return this.matchScopes((Map<S, S>)scopes.asMap());
    }

    private boolean matchScopes(Map<S, S> scopes) {
        if (scopes.isEmpty()) {
            return true;
        }
        logger.debug("Matching scopes {}.", scopes);
        scopes.keySet().forEach(this::scheduleCurrentData);
        scopes.values().forEach(this::schedulePreviousData);
        BiMap newMatches = this.consistent(scopes).orElse(null);
        if (newMatches == null) {
            logger.trace("Scopes cannot match.");
            return false;
        }
        logger.trace("Matching {} succeeded.", scopes);
        for (Map.Entry entry : newMatches.entrySet()) {
            this.match(entry.getKey(), entry.getValue());
        }
        return true;
    }

    @Override
    public void typeCheckerFinished() {
        this.typeCheckerFinished.set(true);
        this.fixedpoint();
    }

    /*
     * Exception decompiling
     */
    private void fixedpoint() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <R> void diffK(K<R> k, R r, Throwable ex) {
        logger.trace("Continuing");
        try {
            k.k(r, ex);
            this.fixedpoint();
        }
        catch (Throwable e) {
            logger.error("Continuation terminated unexpectedly.", e);
            this.failure(e);
        }
        logger.trace("Finished continuation");
    }

    private Unit matchEdge(Edge<S, L> currentEdge, ImmutableMap<Edge<S, L>, BiMap<S, S>> previousEdges) {
        logger.debug("{}: matching with candidates {}", currentEdge, previousEdges);
        for (Map.Entry previousEdge : previousEdges.entrySet()) {
            if (this.matchScopes((Map)previousEdge.getValue())) {
                logger.trace("{}: matched with {}.", currentEdge, previousEdge);
                return this.match(currentEdge, (Edge)previousEdge.getKey());
            }
            logger.trace("{}: matching with {} failed.", currentEdge, previousEdge);
        }
        return this.added((S)currentEdge);
    }

    private Optional<BiMap<S, S>> consistent(Map<S, S> scopes) {
        HashBiMap newMatches = HashBiMap.create();
        for (Map.Entry<S, S> entry : scopes.entrySet()) {
            S previousScope;
            S currentScope = entry.getKey();
            if (!this.differOps.isMatchAllowed(currentScope, previousScope = entry.getValue())) {
                logger.trace("{} ~ {}: matching not allowed by context.", currentScope, previousScope);
                return Optional.empty();
            }
            if (!this.matchedScopes.canPut(currentScope, previousScope)) {
                logger.trace("{} ~ {}: matching not allowed: one or both is already matched.", currentScope, previousScope);
                return Optional.empty();
            }
            if (this.matchedScopes.containsEntry(currentScope, previousScope)) continue;
            newMatches.put(currentScope, previousScope);
        }
        logger.trace("Scopes {} match.", scopes);
        return Optional.of(newMatches);
    }

    private IFuture<Optional<BiMap<S, S>>> consequences(S currentScope, S previousScope) {
        HashBiMap matches = HashBiMap.create();
        return this.consequences(currentScope, previousScope, (BiMap<S, S>)matches).thenApply(arg_0 -> ScopeGraphDiffer.lambda$9((BiMap)matches, arg_0));
    }

    private IFuture<Boolean> consequences(S currentScope, S previousScope, BiMap<S, S> req) {
        if (!this.differOps.isMatchAllowed(currentScope, previousScope)) {
            return CompletableFuture.completedFuture(false);
        }
        if (previousScope.equals(req.get(currentScope))) {
            return CompletableFuture.completedFuture(true);
        }
        if (req.containsKey(currentScope) || req.containsValue(previousScope)) {
            return CompletableFuture.completedFuture(false);
        }
        req.put(currentScope, previousScope);
        if (this.differOps.ownScope(currentScope)) {
            return this.requiredScopeMatches(currentScope, previousScope, req);
        }
        if (this.removedScopes.contains(previousScope)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.matchedScopes.containsValue(previousScope)) {
            return CompletableFuture.completedFuture(this.matchedScopes.getValue(previousScope).equals(currentScope));
        }
        return this.waitFor(this.differOps.externalMatch(previousScope).thenApply(match -> {
            if (!match.isPresent()) {
                this.removed(previousScope);
                return false;
            }
            Object target = match.get();
            logger.trace("{} ~ {}: rec external match.", target, previousScope);
            this.match(target, previousScope);
            return target.equals(currentScope);
        }));
    }

    private IFuture<Boolean> requiredScopeMatches(S currentScope, S previousScope, BiMap<S, S> req) {
        IFuture<Optional> currentDatumFuture = this.waitFor(this.currentContext.datum(currentScope)).whenComplete((d, ex) -> logger.trace("{} (C): rec datum: {}.", currentScope, d));
        IFuture<Optional> previousDatumFuture = this.waitFor(this.previousContext.datum(previousScope)).whenComplete((d, ex) -> logger.trace("{} (P): rec datum: {}.", previousScope, d));
        return AggregateFuture.apply(currentDatumFuture, previousDatumFuture).thenCompose(r -> {
            logger.trace("{} ~ {}: decide match with data: {} ~ {}.", currentScope, previousScope, r._1(), r._2());
            Optional currentData = (Optional)r._1();
            Optional previousData = (Optional)r._2();
            if (currentData.isPresent() != previousData.isPresent()) {
                logger.trace("{} ~ {}: cannot match: different data availability.", currentScope, previousScope);
                return CompletableFuture.completedFuture(false);
            }
            if (currentData.isPresent() && previousData.isPresent()) {
                HashBiMap newMatches = HashBiMap.create();
                boolean dataMatch = this.differOps.matchDatums(currentData.get(), previousData.get()).map(arg_0 -> ScopeGraphDiffer.lambda$14(req, (BiMap)newMatches, arg_0)).orElse(false);
                if (!dataMatch) {
                    logger.trace("{} ~ {}: cannot match: data matches inconsistent with accumulated scope matches.", currentScope, previousScope);
                    return CompletableFuture.completedFuture(false);
                }
                logger.trace("{} ~ {}: data match, calculating consequent matches.", currentScope, previousScope);
                return Futures.reduce(Boolean.valueOf(true), newMatches.entrySet(), (aggMatches, match) -> aggMatches != false ? this.consequences(match.getKey(), match.getValue(), req) : CompletableFuture.completedFuture(false));
            }
            return CompletableFuture.completedFuture(true);
        });
    }

    private IFuture<Unit> scheduleEdgeMatches(S currentSource, S previousSource, L label) {
        logger.debug("{} ~ {}/{}: scheduling edge matches.", currentSource, previousSource, label);
        return this.finishEdgeMatches(currentSource, previousSource, label, this.currentContext.getEdges(currentSource, label), this.previousContext.getEdges(previousSource, label));
    }

    private IFuture<Unit> finishEdgeMatches(S currentSource, S previousSource, L label, IFuture<Iterable<S>> currentTargetsFuture, IFuture<Iterable<S>> previousTargetsFuture) {
        CompletableFuture<Unit> result = new CompletableFuture<Unit>();
        IFuture<Set> currentEdgesFuture = currentTargetsFuture.whenComplete((tgts, ex) -> logger.trace("{}/{} (C): rec targets: {}.", currentSource, label, tgts)).thenApply(currentTargetScopes -> Streams.stream((Iterable)currentTargetScopes).map(currentTarget -> new Edge<Object, Object>(currentSource, label, currentTarget)).collect(Collectors.toSet()));
        IFuture<Set> previousEdgesFuture = previousTargetsFuture.whenComplete((tgts, ex) -> logger.trace("{}/{} (P): rec targets: {}.", previousSource, label, tgts)).thenApply(previousTargetScopes -> Streams.stream((Iterable)previousTargetScopes).map(previousTarget -> new Edge<Object, Object>(previousSource, label, previousTarget)).collect(Collectors.toSet()));
        IFuture<Tuple2<Set, Set>> edgesFuture = AggregateFuture.apply(currentEdgesFuture, previousEdgesFuture);
        K<Tuple2> k = (res, ex) -> {
            if (ex != null) {
                result.completeExceptionally(ex);
                return Unit.unit;
            }
            Set currentEdges = (Set)res._1();
            Set previousEdges = (Set)res._2();
            this.scheduleRemovedEdges(previousSource, currentEdges, previousEdges).whenComplete((u, ex2) -> {
                logger.debug("{} ~ {}/{}: edge matches finished.", currentSource, previousSource, label);
                this.previousScopeComplete(previousSource, label);
                result.complete((Unit)u, (Throwable)ex2);
            });
            return this.processEdgeMatches(currentEdges, previousEdges);
        };
        this.future(edgesFuture, k);
        return result;
    }

    private Unit processEdgeMatches(Set<Edge<S, L>> currentEdges, Set<Edge<S, L>> previousEdges) {
        Iterator<Edge<S, L>> iterator = currentEdges.iterator();
        while (iterator.hasNext()) {
            Edge edge;
            Edge currentEdge = edge = iterator.next();
            IFuture matchesFuture = ScopeGraphDiffer.aggregateAll(previousEdges, previousEdge -> {
                CompletableFuture result = new CompletableFuture();
                this.consequences(edge.target, previousEdge.target).whenComplete((matchedScopes, ex) -> {
                    if (ex != null) {
                        logger.debug("Error computing consequences for {} ~ {}. Treat as not matchable.", edge.target, edge2.target);
                        logger.debug("* Error.", (Throwable)ex);
                        result.complete(Tuple2.of(previousEdge, Optional.empty()));
                    } else {
                        result.complete(Tuple2.of(previousEdge, matchedScopes));
                    }
                });
                return result;
            });
            K<List> k2 = (r, ex2) -> {
                if (ex2 != null) {
                    this.failure(ex2);
                    return Unit.unit;
                }
                logger.trace("{}: rec candidates: {}.", currentEdge, r);
                ImmutableMap.Builder _matchingPreviousEdges = ImmutableMap.builder();
                r.stream().filter(x -> ((Optional)x._2()).isPresent()).map(x -> Tuple2.of((Edge)x._1(), (BiMap)((Optional)x._2()).get())).map(x -> Tuple2.of((Edge)x._1(), this.consistent((Map)x._2()))).filter(x -> ((Optional)x._2()).isPresent()).forEach(x -> {
                    ImmutableMap.Builder builder2 = _matchingPreviousEdges.put((Object)((Edge)x._1()), (Object)((BiMap)((Optional)x._2()).get()));
                });
                ImmutableMap matchingPreviousEdges = _matchingPreviousEdges.build();
                if (logger.traceEnabled()) {
                    logger.trace("{}: possible candidates: {}.", currentEdge, matchingPreviousEdges);
                }
                return this.queue(new EdgeMatch(currentEdge, matchingPreviousEdges));
            };
            CompletableFuture matchesResult = new CompletableFuture();
            matchesFuture.whenComplete((u, ex2) -> {
                if (ex2 != null) {
                    logger.debug("Error matching edge " + currentEdge + " - treat it as added.", (Throwable)ex2);
                    matchesResult.complete(Collections.emptyList(), null);
                } else {
                    matchesResult.complete(u);
                }
            });
            this.future(matchesResult, k2);
        }
        return Unit.unit;
    }

    private IFuture<Unit> scheduleRemovedEdges(S previousScope, Set<Edge<S, L>> currentEdges, Set<Edge<S, L>> previousEdges) {
        CompletableFuture<Unit> result = new CompletableFuture<Unit>();
        IFuture allCurrentEdgesProcessed = ScopeGraphDiffer.aggregateAll(currentEdges, edge -> {
            CompletableFuture future = new CompletableFuture();
            if (!this.completeIfFailure(future)) {
                this.currentEdgeCompleteDelays.put(edge, future);
            }
            return future;
        });
        K<List> processPreviousEdges = (__, ex) -> {
            previousEdges.forEach(edge -> {
                if (this.isPreviousEdgeOpen((Edge<S, L>)edge)) {
                    this.removed((S)edge);
                }
            });
            logger.trace("{} (P): edge matches processed.", previousScope);
            result.complete(Unit.unit, ex);
            return Unit.unit;
        };
        this.future(allCurrentEdgesProcessed, processPreviousEdges);
        return result;
    }

    private void scheduleCurrentData(S currentScope) {
        if (this.differOps.ownScope(currentScope) && this.seenCurrentScopes.add(currentScope)) {
            logger.trace("{} (C): scheduling data.", currentScope);
            this.openCurrentScopes.add(currentScope);
            IFuture<Optional<D>> cd = this.currentContext.datum(currentScope);
            K<Optional> insertCS = (d, ex) -> {
                if (ex != null) {
                    logger.debug("Error retrieving current data.", ex);
                    d = this.currentContext.rawDatum(currentScope);
                }
                logger.trace("{} (C): data complete: {}.", currentScope, d);
                this.currentScopeData.put(currentScope, (Optional<D>)d);
                Collection dataScopes = (Collection)d.map(this.differOps::getScopes).orElse((Collection)CapsuleUtil.immutableSet());
                logger.trace("{} (C): scopes observed in datum: {}", currentScope, dataScopes);
                dataScopes.forEach(this::scheduleCurrentData);
                return Unit.unit;
            };
            this.future(cd, insertCS);
        }
    }

    private void schedulePreviousData(S previousScope) {
        if (this.differOps.ownScope(previousScope) && this.seenPreviousScopes.add(previousScope)) {
            logger.trace("{} (P): scheduling data.", previousScope);
            this.openPreviousScopes.add(previousScope);
            IFuture<Optional<D>> pd = this.previousContext.datum(previousScope);
            K<Optional> insertPS = (d, ex) -> {
                if (ex != null) {
                    logger.debug("Error retrieving previous data.", ex);
                    d = this.previousContext.rawDatum(previousScope);
                }
                logger.trace("{} (P): data complete: {}.", previousScope, d);
                this.previousScopeData.put(previousScope, (Optional<D>)d);
                Collection dataScopes = (Collection)d.map(this.differOps::getScopes).orElse((Collection)CapsuleUtil.immutableSet());
                logger.trace("{} (P): scopes observed in datum: {}", previousScope, dataScopes);
                dataScopes.forEach(this::schedulePreviousData);
                return Unit.unit;
            };
            this.future(pd, insertPS);
        }
    }

    private IFuture<Unit> visitAllEdges(IDifferContext<S, L, D> context, S scope, Action1<Edge<S, L>> visit) {
        IFuture<Unit> future = ScopeGraphDiffer.aggregateAll(this.edgeLabels, label -> {
            IFuture<Iterable<Object>> edgesFuture = context.getEdges(scope, label);
            K<Iterable> addEdges = (targets, ex) -> {
                targets.forEach(target -> visit.apply(new Edge<Object, Object>(scope, label, target)));
                return Unit.unit;
            };
            this.future(edgesFuture, addEdges);
            return edgesFuture.thenApply(__ -> Unit.unit);
        }).thenApply(__ -> Unit.unit);
        this.future(future);
        return future;
    }

    private IFuture<Unit> addAllEdges(S currentScope) {
        return this.visitAllEdges(this.currentContext, currentScope, this::added);
    }

    private IFuture<Unit> removeAllEdges(S previousScope) {
        return this.visitAllEdges(this.previousContext, previousScope, this::removed);
    }

    private void closeCurrentScope(S currentScope) {
        if (!this.differOps.ownScope(currentScope)) {
            return;
        }
        if (!this.seenCurrentScopes.contains(currentScope)) {
            throw new IllegalStateException("Closing unobserved scope: " + currentScope);
        }
        if (!this.matchedScopes.containsKey(currentScope) && !this.addedScopes.contains(currentScope)) {
            throw new IllegalStateException("Closing scope that is neither matched nor added: " + currentScope);
        }
        logger.trace("{} (C): closed for matching.", currentScope);
        if (!this.openCurrentScopes.remove(currentScope)) {
            throw new IllegalStateException("Closing scope that is already closed: " + currentScope);
        }
    }

    private void closePreviousScope(S previousScope) {
        if (!this.differOps.ownScope(previousScope)) {
            return;
        }
        if (!this.seenPreviousScopes.contains(previousScope)) {
            new IllegalStateException("Closing unobserved scope: " + previousScope);
        }
        if (!this.matchedScopes.containsValue(previousScope) && !this.removedScopes.contains(previousScope)) {
            throw new IllegalStateException("Closing scope that is neither matched nor removed: " + previousScope);
        }
        logger.trace("{} (P): closed for matching.", previousScope);
        if (!this.openPreviousScopes.remove(previousScope)) {
            throw new IllegalStateException("Closing scope that is already closed: " + previousScope);
        }
    }

    private Unit match(S currentScope, S previousScope) {
        if (this.matchedScopes.containsEntry(currentScope, previousScope)) {
            return Unit.unit;
        }
        this.assertCurrentScopeOpen(currentScope);
        this.assertPreviousScopeOpen(previousScope);
        logger.debug("{} ~ {}: matched.", currentScope, previousScope);
        this.matchedScopes.put(currentScope, previousScope);
        this.closeCurrentScope(currentScope);
        this.closePreviousScope(previousScope);
        if (this.differOps.ownOrSharedScope(currentScope)) {
            logger.trace("{} ~ {}: scheduling edge matches", currentScope, previousScope);
            for (L lbl : this.edgeLabels) {
                this.scheduleEdgeMatches(currentScope, previousScope, lbl);
            }
        }
        logger.trace("{} ~ {}: scheduling scope observations.", currentScope, previousScope);
        this.scheduleCurrentData(currentScope);
        this.schedulePreviousData(previousScope);
        this.previousScopeProcessed(previousScope, Optional.of(currentScope));
        return Unit.unit;
    }

    private Unit match(Edge<S, L> current, Edge<S, L> previous) {
        this.assertCurrentEdgeOpen(current);
        this.assertPreviousEdgeOpen(previous);
        logger.debug("{} ~ {}: matched.", current, previous);
        this.matchedEdges.put(current, previous);
        this.matchedOutgoingEdges.put(Tuple2.of(previous.source, previous.label), previous);
        this.scheduleCurrentData(current.target);
        this.schedulePreviousData(previous.target);
        this.currentEdgeComplete(current);
        return Unit.unit;
    }

    private Unit added(Edge<S, L> edge) {
        this.assertCurrentEdgeOpen(edge);
        logger.trace("{}: added.", edge);
        this.addedEdges.put(Tuple2.of(edge.source, edge.label), edge);
        this.currentEdgeComplete(edge);
        this.scheduleCurrentData(edge.target);
        return Unit.unit;
    }

    private Unit removed(Edge<S, L> edge) {
        this.assertPreviousEdgeOpen(edge);
        logger.trace("{}: removed.", edge);
        this.removedEdges.put(Tuple2.of(edge.source, edge.label), edge);
        this.schedulePreviousData(edge.target);
        return Unit.unit;
    }

    private Unit added(S currentScope) {
        this.assertCurrentScopeOpen(currentScope);
        this.scheduleCurrentData(currentScope);
        logger.trace("{} (C): added.", currentScope);
        this.addedScopes.add(currentScope);
        this.closeCurrentScope(currentScope);
        this.addAllEdges(currentScope);
        return Unit.unit;
    }

    private Unit removed(S previousScope) {
        if (this.removedScopes.contains(previousScope)) {
            return Unit.unit;
        }
        this.assertPreviousScopeOpen(previousScope);
        this.schedulePreviousData(previousScope);
        logger.trace("{} (P): removed.", previousScope);
        this.removedScopes.add(previousScope);
        this.closePreviousScope(previousScope);
        this.previousScopeProcessed(previousScope, Optional.empty());
        this.removeAllEdges(previousScope).whenComplete((__, ex) -> {
            if (ex != null) {
                this.failure((Throwable)ex);
            }
            for (L lbl : this.edgeLabels) {
                this.previousScopeComplete(previousScope, lbl);
            }
        });
        return Unit.unit;
    }

    private Unit queue(EdgeMatch match) {
        logger.trace("Queuing delayed match {}.", match);
        this.edgeMatches.add(match);
        return Unit.unit;
    }

    private <R> Unit future(IFuture<R> future, K<R> k) {
        RefBool executed = new RefBool(false);
        this.waitFor(future).handle((r, ex) -> {
            if (executed.get()) {
                throw new IllegalStateException("Continuation cannot be executed multiple times.");
            }
            executed.set(true);
            this.diffK(k, (Object)r, (Throwable)ex);
            return Unit.unit;
        });
        return Unit.unit;
    }

    private Unit future(IFuture<Unit> future) {
        K<Unit> k = (u, ex) -> {
            if (ex != null) {
                this.failure(ex);
            }
            return u;
        };
        return this.future(future, k);
    }

    private void tryFinalizeDiff() {
        do {
            if (this.pendingResults.get() != 0 || !this.typeCheckerFinished.get()) {
                return;
            }
            ImmutableSet.copyOf(this.openCurrentScopes).forEach(this::added);
            ImmutableSet.copyOf(this.openPreviousScopes).forEach(this::removed);
        } while (this.edgeMatches.isEmpty() && (!this.openCurrentScopes.isEmpty() || !this.openPreviousScopes.isEmpty()));
        logger.debug("Marked all open scopes as added/removed.");
        if (!this.edgeMatches.isEmpty()) {
            return;
        }
        if (this.openCurrentScopes.size() == 0 && this.openPreviousScopes.size() == 0 && this.pendingResults.get() == 0 && this.typeCheckerFinished.get() && !this.result.isDone() && this.edgeMatches.isEmpty()) {
            logger.debug("Finalizing diff.");
            Map.Transient addedScopes = CapsuleUtil.transientMap();
            this.currentScopeData.keySet().retainAll(this.addedScopes);
            this.currentScopeData.forEach((s, d) -> {
                Object object = addedScopes.__put(s, d.orElse(this.differOps.embed(s)));
            });
            Map.Transient removedScopes = CapsuleUtil.transientMap();
            this.previousScopeData.keySet().retainAll(this.removedScopes);
            this.previousScopeData.forEach((s, d) -> {
                Object object = removedScopes.__put(s, d.orElse(this.differOps.embed(s)));
            });
            Set.Transient addedEdges = CapsuleUtil.transientSet();
            this.addedEdges.asMap().values().forEach(x -> x.forEach(arg_0 -> ((Set.Transient)addedEdges).__insert(arg_0)));
            Set.Transient removedEdges = CapsuleUtil.transientSet();
            this.removedEdges.asMap().values().forEach(x -> x.forEach(arg_0 -> ((Set.Transient)removedEdges).__insert(arg_0)));
            this.previousScopeProcessedDelays.asMap().forEach((s, delays) -> delays.forEach(c -> c.complete(Optional.empty())));
            this.previousScopeProcessedDelays.clear();
            this.previousScopeCompletedDelays.asMap().forEach((s, delays) -> delays.forEach(c -> c.complete(Unit.unit)));
            this.previousScopeCompletedDelays.clear();
            this.currentEdgeCompleteDelays.asMap().forEach((edge, delays) -> delays.forEach(c -> c.complete(Unit.unit)));
            this.currentEdgeCompleteDelays.clear();
            ScopeGraphDiff result = new ScopeGraphDiff(this.matchedScopes.freeze(), this.matchedEdges.freeze(), addedScopes.freeze(), addedEdges.freeze(), removedScopes.freeze(), removedEdges.freeze());
            this.result.complete(result);
        }
    }

    @Override
    public IFuture<Optional<S>> match(S previousScope) {
        if (!this.previousContext.available(previousScope)) {
            logger.error("Scope {} is not available in previous context.", previousScope);
            return CompletableFuture.completedExceptionally(new IllegalStateException("Scope " + previousScope + " is not available in previous context."));
        }
        if (this.matchedScopes.containsValue(previousScope)) {
            S currentScope = this.matchedScopes.getValue(previousScope);
            logger.trace("Scope {} match present: {}. Return eagerly.", previousScope, currentScope);
            return CompletableFuture.completedFuture(Optional.of(currentScope));
        }
        if (this.removedScopes.contains(previousScope)) {
            logger.trace("Scope {} removed. Return eagerly.", previousScope);
            return CompletableFuture.completedFuture(Optional.empty());
        }
        CompletableFuture<Optional<S>> result = new CompletableFuture<Optional<S>>();
        if (!this.completeIfFailure(result)) {
            logger.trace("Scope {} not complete. Delaying return of its match.", previousScope);
            this.previousScopeProcessedDelays.put(previousScope, result);
        }
        return result;
    }

    @Override
    public IFuture<ScopeDiff<S, L, D>> scopeDiff(S previousScope, L label) {
        if (!this.previousContext.available(previousScope)) {
            logger.error("Scope {} is not available in previous context.", previousScope);
            return CompletableFuture.completedExceptionally(new IllegalStateException("Scope " + previousScope + " is not available in previous context."));
        }
        if (this.completedPreviousEdges.containsEntry(previousScope, label)) {
            logger.debug("{}/{} complete, returning scope diff.", previousScope, label);
            return CompletableFuture.completedFuture(this.buildScopeDiff(previousScope, label));
        }
        CompletableFuture<Unit> result = new CompletableFuture<Unit>();
        if (!this.completeIfFailure(result)) {
            logger.debug("{}/{} not complete, wait before returning scope diff.", previousScope, label);
            this.previousScopeCompletedDelays.put(Tuple2.of(previousScope, label), result);
        }
        return result.thenApply(__ -> this.buildScopeDiff(previousScope, label));
    }

    private ScopeDiff<S, L, D> buildScopeDiff(S previousScope, L label) {
        logger.debug("Building scope diff {}/{}.", previousScope, label);
        S currentScope = this.matchedScopes.getValue(previousScope);
        if (currentScope != null) {
            ScopeDiff diff = ScopeDiff.of(this.addedEdges.get(Tuple2.of(currentScope, label)), this.matchedOutgoingEdges.get(Tuple2.of(previousScope, label)), this.removedEdges.get(Tuple2.of(previousScope, label)));
            logger.trace("Scope diff for {}/{}: {}", previousScope, label, diff);
            return diff;
        }
        return ScopeDiff.builder().build();
    }

    private void previousScopeProcessed(S previousScope, Optional<S> match) {
        logger.trace("{}: PS complete.", previousScope);
        this.previousScopeProcessedDelays.removeAll(previousScope).forEach(c -> c.complete(match));
        logger.trace("{}: PS completion finished.", previousScope);
    }

    private void previousScopeComplete(S previousScope, L label) {
        logger.trace("{}: PSC complete.", previousScope);
        this.completedPreviousEdges.put(previousScope, label);
        this.previousScopeCompletedDelays.removeAll(Tuple2.of(previousScope, label)).forEach(c -> c.complete(Unit.unit));
        logger.trace("{}: PSC completion finished.", previousScope);
    }

    private void currentEdgeComplete(Edge<S, L> current) {
        logger.trace("{}: CE complete.", current);
        this.currentEdgeCompleteDelays.removeAll(current).forEach(c -> c.complete(Unit.unit));
        logger.trace("{}: CE completion finished.", current);
    }

    private void failure(Throwable ex) {
        this.failure = ex;
        this.result.completeExceptionally(ex);
        this.previousScopeProcessedDelays.asMap().forEach((s, delays) -> delays.forEach(d -> d.completeExceptionally(ex)));
        this.previousScopeCompletedDelays.asMap().forEach((s, delays) -> delays.forEach(d -> d.completeExceptionally(ex)));
        this.currentEdgeCompleteDelays.asMap().forEach((s, delays) -> delays.forEach(d -> d.completeExceptionally(ex)));
    }

    private boolean completeIfFailure(ICompletableFuture<?> future) {
        if (this.failure != null) {
            future.completeExceptionally(this.failure);
            return true;
        }
        return false;
    }

    private static <T, R> IFuture<List<R>> aggregateAll(Collection<T> items, Function1<T, IFuture<R>> mapper) {
        ArrayList<IFuture<R>> futures = new ArrayList<IFuture<R>>(items.size());
        for (T item : items) {
            futures.add(mapper.apply(item));
        }
        return AggregateFuture.of(futures);
    }

    private boolean successfullyCompleted() {
        return this.result.isDone() && this.failure == null;
    }

    private boolean isCurrentScopeOpen(S scope) {
        return !this.successfullyCompleted() && !this.matchedScopes.containsKey(scope) && !this.addedScopes.contains(scope);
    }

    private boolean isPreviousScopeOpen(S scope) {
        return !this.successfullyCompleted() && !this.matchedScopes.containsValue(scope) && !this.removedScopes.contains(scope);
    }

    private boolean isCurrentEdgeOpen(Edge<S, L> edge) {
        return !this.successfullyCompleted() && !this.matchedEdges.containsKey(edge) && !this.addedEdges.containsValue(edge);
    }

    private boolean isPreviousEdgeOpen(Edge<S, L> edge) {
        return !this.successfullyCompleted() && !this.matchedEdges.containsValue(edge) && !this.removedEdges.containsValue(edge);
    }

    private void assertCurrentScopeOpen(S scope) {
        if (!this.isCurrentScopeOpen(scope)) {
            String reason = this.successfullyCompleted() ? "closed because differ completed" : (this.addedScopes.contains(scope) ? "marked as added" : "matched to " + this.matchedScopes.getKey(scope));
            throw new IllegalStateException("Scope " + scope + " is already " + reason + ".");
        }
    }

    private void assertPreviousScopeOpen(S scope) {
        if (!this.isPreviousScopeOpen(scope)) {
            String reason = this.successfullyCompleted() ? "closed because differ completed" : (this.removedScopes.contains(scope) ? "marked as removed" : "matched to " + this.matchedScopes.getValue(scope));
            throw new IllegalStateException("Scope " + scope + " is already " + reason + ".");
        }
    }

    private void assertCurrentEdgeOpen(Edge<S, L> edge) {
        if (!this.isCurrentEdgeOpen(edge)) {
            String reason = this.successfullyCompleted() ? "closed because differ completed" : (this.addedEdges.containsValue(edge) ? "marked as added" : "matched to " + this.matchedEdges.getKey(edge));
            throw new IllegalStateException("Edge " + edge + " is already " + reason + ".");
        }
    }

    private void assertPreviousEdgeOpen(Edge<S, L> edge) {
        if (!this.isPreviousEdgeOpen(edge)) {
            String reason = this.successfullyCompleted() ? "closed because differ completed" : (this.removedEdges.containsValue(edge) ? "marked as removed" : "matched to " + this.matchedEdges.getValue(edge));
            throw new IllegalStateException("Edge " + edge + " is already " + reason + ".");
        }
    }

    private <U> IFuture<U> waitFor(IFuture<U> future) {
        this.pendingResults.incrementAndGet();
        return future.whenComplete((__, ex) -> {
            int n = this.pendingResults.decrementAndGet();
        });
    }

    private static /* synthetic */ Iterable lambda$6(Set set, Iterable targets) throws Throwable {
        return CapsuleUtil.toSet(targets).__removeAll(set);
    }

    private static /* synthetic */ Optional lambda$9(BiMap biMap, Boolean b) throws Throwable {
        return b != false ? Optional.of(biMap) : Optional.empty();
    }

    private static /* synthetic */ Boolean lambda$14(BiMap biMap, BiMap biMap2, BiMap.Immutable scopeMatches) {
        for (Map.Entry match : scopeMatches.asMap().entrySet()) {
            Object current = match.getKey();
            Object previous = match.getValue();
            if (previous.equals(biMap.get(current))) continue;
            if (biMap.containsKey(current) || biMap.containsValue(previous)) {
                return false;
            }
            biMap.put(current, previous);
            biMap2.put(current, previous);
        }
        return true;
    }

    private static class EdgeCompleted<S, L>
    implements IToken<S, L> {
        private final Edge<S, L> currentEdge;

        private EdgeCompleted(Edge<S, L> currentEdge) {
            this.currentEdge = currentEdge;
        }

        public static <S, L> EdgeCompleted<S, L> of(Edge<S, L> currentEdge) {
            return new EdgeCompleted<S, L>(currentEdge);
        }

        public String toString() {
            return "EdgeCompleted{" + this.currentEdge + "}";
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            EdgeCompleted other = (EdgeCompleted)obj;
            return other.currentEdge.equals(this.currentEdge);
        }

        public int hashCode() {
            return this.currentEdge.hashCode();
        }
    }

    private class EdgeMatch
    implements Comparable<EdgeMatch> {
        public final Edge<S, L> currentEdge;
        public final ImmutableMap<Edge<S, L>, BiMap<S, S>> previousEdges;

        public EdgeMatch(Edge<S, L> currentEdge, ImmutableMap<Edge<S, L>, BiMap<S, S>> previousEdges) {
            this.currentEdge = currentEdge;
            this.previousEdges = previousEdges;
        }

        @Override
        public int compareTo(EdgeMatch that) {
            return this.previousEdges.size() - that.previousEdges.size();
        }

        public String toString() {
            return this.currentEdge + " ~ " + this.previousEdges;
        }
    }

    private static interface IToken<S, L> {
    }

    @FunctionalInterface
    private static interface K<R> {
        public Unit k(R var1, Throwable var2);
    }

    private static class ScopeCompleted<S, L>
    implements IToken<S, L> {
        private final S previousScope;
        private final L label;

        private ScopeCompleted(S previousScope, L label) {
            this.previousScope = previousScope;
            this.label = label;
        }

        public static <S, L> ScopeCompleted<S, L> of(S previousScope, L label) {
            return new ScopeCompleted<S, L>(previousScope, label);
        }

        public String toString() {
            return "ScopeCompleted{" + this.previousScope + "/" + this.label + "}";
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ScopeCompleted other = (ScopeCompleted)obj;
            return other.previousScope.equals(this.previousScope) && other.label.equals(this.label);
        }

        public int hashCode() {
            return this.previousScope.hashCode();
        }
    }

    private static class ScopeProcessed<S, L>
    implements IToken<S, L> {
        private final S previousScope;

        private ScopeProcessed(S previousScope) {
            this.previousScope = previousScope;
        }

        public static <S, L> ScopeProcessed<S, L> of(S previousScope) {
            return new ScopeProcessed<S, L>(previousScope);
        }

        public String toString() {
            return "ScopeProcessed{" + this.previousScope + "}";
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ScopeProcessed other = (ScopeProcessed)obj;
            return other.previousScope.equals(this.previousScope);
        }

        public int hashCode() {
            return this.previousScope.hashCode();
        }
    }
}

