/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.plsql.old.PlsqlParser;
import oracle.javatools.parser.plsql.old.symbol.PackageSymbol;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeClassLoaderInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataArrayInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeFieldInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeLocation;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.probe.DebugProbeVariableContainer;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

final class DebugProbeClassInfo
extends DebugProbeVariableContainer
implements DebugClassInfo {
    DebugProbe dp;
    String name;
    boolean isPrimitive;
    boolean isObject;
    boolean isArray;
    int piLibunitType;
    String piOwner;
    String piName;
    private String sourceFilename;
    private String justPackage;
    private String packagePath;
    private String nameWithoutPackage;
    private List fieldNames;
    private Map fieldTypes;
    private int stoppedCount;
    private DebugProbeFieldInfo[] fields;

    private DebugProbeClassInfo(DebugProbe debugProbe, String string) {
        this.dp = debugProbe;
        this.name = string;
        this.stoppedCount = debugProbe.stoppedCount;
    }

    public boolean hasExpired() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        if (this.justPackage == null) {
            this.justPackage = DebugShared.getPackage((String)this.name);
        }
        return this.justPackage;
    }

    public String getPackagePath() {
        if (this.packagePath == null) {
            this.packagePath = DebugShared.getPackagePath((String)this.name);
        }
        return this.packagePath;
    }

    public String getNameWithoutPackage() {
        if (this.nameWithoutPackage == null) {
            this.nameWithoutPackage = DebugShared.getNameWithoutPackage((String)this.name);
        }
        return this.nameWithoutPackage;
    }

    public String getGenericSignature() {
        return null;
    }

    public int getAccess() {
        return 0;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isObject() {
        return this.isObject;
    }

    public boolean isNotYetLoadedType() {
        return false;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public int getSizeOfObject() {
        return 0;
    }

    public long countObjectsOfClass() {
        return 0L;
    }

    public int countMemoryOfClass() {
        return 0;
    }

    public DebugDataObjectInfo getClassObject() {
        return null;
    }

    public DebugDataObjectInfo getClassLoaderObject() {
        return null;
    }

    public DebugClassLoaderInfo getClassLoader() {
        if (!this.isPrimitive()) {
            return DebugProbeClassLoaderInfo.makeClassLoaderInfo(this.dp);
        }
        return null;
    }

    public String getPrimarySourceFilename() {
        return this.getSourceFilename();
    }

    public String getSourceFilename() {
        if (this.sourceFilename == null) {
            this.sourceFilename = this.piName != null ? this.piName + ".pls" : "";
        }
        return this.sourceFilename;
    }

    public DebugClassInfo getSuperClass(int n) {
        return null;
    }

    public int getMethodCount() {
        return 0;
    }

    public DebugMethodInfo[] getMethods() {
        return new DebugMethodInfo[0];
    }

    public int getStaticFieldCount() {
        return this.getStaticFieldCount(0, false);
    }

    public DebugFieldInfo[] getStaticFields() {
        return this.getStaticFields(0, false);
    }

    public DebugFieldInfo getStaticField(int n) {
        return this.getStaticField(0, false, n);
    }

    public int getStaticFieldCount(int n) {
        return this.getStaticFieldCount(n, false);
    }

    public DebugFieldInfo[] getStaticFields(int n) {
        return this.getStaticFields(n, false);
    }

    public DebugFieldInfo getStaticField(int n, int n2) {
        return this.getStaticField(n, false, n2);
    }

    public int getStaticFieldCount(int n, boolean bl) {
        this.lookForFields();
        if (n <= 0) {
            return this.fields.length;
        }
        return 0;
    }

    public DebugFieldInfo[] getStaticFields(int n, boolean bl) {
        this.lookForFields();
        if (n <= 0) {
            return this.fields;
        }
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getStaticField(int n, boolean bl, int n2) {
        this.lookForFields();
        if (n <= 0 && n2 >= 0 && n2 < this.fields.length) {
            return this.fields[n2];
        }
        return null;
    }

    public DebugFieldInfo getStaticField(String string) {
        DebugProbeValue debugProbeValue = this.dp.getFieldValue(this, string, null);
        if (debugProbeValue != null) {
            String string2 = this.figureOutFieldType(string);
            if (string2 != null) {
                debugProbeValue.setType(string2);
            }
            return new DebugProbeFieldInfo(this.dp, this, string, debugProbeValue, true);
        }
        return null;
    }

    public int getFieldCount(int n) {
        return 0;
    }

    public DebugFieldInfo[] getFields(int n) {
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getField(int n, int n2) {
        return null;
    }

    public int getFieldCount(int n, boolean bl) {
        return 0;
    }

    public DebugFieldInfo[] getFields(int n, boolean bl) {
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getField(int n, boolean bl, int n2) {
        return null;
    }

    public int getFieldCount(int n, boolean bl, boolean bl2) {
        return 0;
    }

    public DebugFieldInfo[] getFields(int n, boolean bl, boolean bl2) {
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getField(int n, boolean bl, boolean bl2, int n2) {
        return null;
    }

    public boolean isDebuggable() {
        return true;
    }

    public void setDebuggable(boolean bl) {
    }

    public boolean isObfuscated() {
        return false;
    }

    public boolean isCodeCoverage() {
        return false;
    }

    public void setCodeCoverage(boolean bl) {
    }

    public void discardCodeCoverage() {
    }

    public double getCodeCoverageRatio() {
        return 0.0;
    }

    public DebugClassInfo[] getInterfaces() {
        return new DebugClassInfo[0];
    }

    public DebugClassInfo[] getInterfaces(int n) {
        return new DebugClassInfo[0];
    }

    public int getLanguage() {
        return 2;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DebugProbeClassInfo) {
            DebugProbeClassInfo debugProbeClassInfo = (DebugProbeClassInfo)object;
            return ModelUtil.areEqual((Object)this.dp, (Object)debugProbeClassInfo.dp) && ModelUtil.areEqual((Object)this.name, (Object)debugProbeClassInfo.name);
        }
        return false;
    }

    private static String[] getClassNameParts(String string) {
        int n;
        String string2;
        String[] stringArray = new String[3];
        int n2 = string.indexOf(46);
        if (n2 != -1 && (string2 = string.substring(0, n2)).equals("$Oracle") && (n = string.indexOf(46, n2 + 1)) != -1) {
            stringArray[0] = string.substring(n2 + 1, n);
            int n3 = string.indexOf(46, n + 1);
            if (n3 != -1) {
                stringArray[1] = string.substring(n + 1, n3);
                stringArray[2] = string.substring(n3 + 1);
                return stringArray;
            }
        }
        return null;
    }

    static String makeClassName(int n, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("$Oracle.");
        stringBuffer.append(DebugProbeLocation.formatLibunitType(n));
        stringBuffer.append(".");
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    static DebugProbeClassInfo makePrimitiveClass(DebugProbe debugProbe, String string) {
        DebugProbeClassInfo debugProbeClassInfo = new DebugProbeClassInfo(debugProbe, string);
        debugProbeClassInfo.isPrimitive = true;
        debugProbeClassInfo.isObject = false;
        debugProbeClassInfo.isArray = false;
        return debugProbeClassInfo;
    }

    static DebugProbeClassInfo makeArrayClass(DebugProbe debugProbe, String string) {
        DebugProbeClassInfo debugProbeClassInfo = new DebugProbeClassInfo(debugProbe, string);
        debugProbeClassInfo.isPrimitive = false;
        debugProbeClassInfo.isObject = false;
        debugProbeClassInfo.isArray = true;
        return debugProbeClassInfo;
    }

    static DebugProbeClassInfo makeObjectClass(DebugProbe debugProbe, String string) {
        String[] stringArray = DebugProbeClassInfo.getClassNameParts(string);
        if (stringArray != null) {
            DebugProbeClassInfo debugProbeClassInfo = new DebugProbeClassInfo(debugProbe, string);
            debugProbeClassInfo.isPrimitive = false;
            debugProbeClassInfo.isObject = true;
            debugProbeClassInfo.isArray = false;
            debugProbeClassInfo.piLibunitType = DebugProbeLocation.parseLibunitType(stringArray[0]);
            debugProbeClassInfo.piOwner = stringArray[1];
            debugProbeClassInfo.piName = stringArray[2];
            return debugProbeClassInfo;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void lookForFields() {
        if (this.stoppedCount != this.dp.stoppedCount) {
            this.fields = null;
        }
        if (this.fields == null) {
            var1_1 = new ArrayList<Object>();
            if (this.fieldNames == null) {
                this.fieldNames = new ArrayList<E>();
                this.fieldTypes = new HashMap<K, V>();
                var2_2 = this.dp.getSource(this);
                if (var2_2 != null) {
                    try {
                        var3_4 = TextBufferFactory.createReadTextBuffer((String)var2_2);
                        var4_7 = PlsqlParser.parse((ReadTextBuffer)var3_4);
                        if (var4_7 == null || (var5_9 = var4_7.getPackages()) == null) ** GOTO lbl34
                        for (PackageSymbol var8_14 : var5_9) {
                            var9_15 = var8_14.getName();
                            if (var9_15 == null || !(var10_16 = var9_15.getValue()).equalsIgnoreCase(this.piName)) continue;
                            this.processTypes(var8_14.getTypes());
                            this.processVariables(var8_14.getVariables(), this.fieldNames, var1_1);
                        }
                    }
                    catch (Throwable var3_5) {
                        Assert.println((String)("exception during parsing: " + var3_5));
                        if (!(var3_5 instanceof ThreadDeath)) ** GOTO lbl34
                        throw (ThreadDeath)var3_5;
                    }
                }
            } else {
                var2_3 = this.fieldNames.size();
                for (var3_6 = 0; var3_6 < var2_3; ++var3_6) {
                    var4_8 = (String)this.fieldNames.get(var3_6);
                    var6_12 = this.getVariable(var4_8, var5_10 = (String)this.fieldTypes.get(var4_8));
                    if (var6_12 == null) continue;
                    var1_1.add(var6_12);
                }
            }
lbl34:
            // 6 sources

            this.fields = var1_1.toArray(new DebugProbeFieldInfo[var1_1.size()]);
            this.stoppedCount = this.dp.stoppedCount;
        }
    }

    private String figureOutFieldType(String string) {
        String string2 = null;
        boolean bl = false;
        String string3 = string;
        String string4 = DebugProbeDataArrayInfo.isTableElementName(string);
        if (string4 != null) {
            string3 = string4;
            bl = true;
        }
        this.lookForFields();
        DebugProbeFieldInfo debugProbeFieldInfo = DebugProbeClassInfo.lookForFieldNamed(string3, this.fields);
        if (debugProbeFieldInfo != null) {
            string2 = debugProbeFieldInfo.dpv.getType();
            String string5 = this.getTypeDefinition(string2);
            if (string5 != null) {
                string2 = string5;
            }
            if (bl) {
                string2 = DebugProbeDataArrayInfo.getTableElementType(string2);
            }
        }
        return string2;
    }

    private static DebugProbeFieldInfo lookForFieldNamed(String string, DebugProbeFieldInfo[] debugProbeFieldInfoArray) {
        if (string != null) {
            for (int i = debugProbeFieldInfoArray.length - 1; i >= 0; --i) {
                if (!string.equalsIgnoreCase(debugProbeFieldInfoArray[i].name)) continue;
                return debugProbeFieldInfoArray[i];
            }
        }
        return null;
    }

    @Override
    protected Object getVariable(String string, String string2) {
        this.fieldTypes.put(string, string2);
        DebugProbeValue debugProbeValue = this.dp.getFieldValue(this, string, string2);
        if (debugProbeValue != null) {
            return new DebugProbeFieldInfo(this.dp, this, string, debugProbeValue, true);
        }
        return null;
    }

    @Override
    void clearCachedData() {
        this.fields = null;
    }

    public boolean isEnum() {
        return false;
    }

    public DebugFieldInfo[] getEnumConstants() {
        return new DebugFieldInfo[0];
    }

    public int getConstantPoolCount() {
        return 0;
    }

    public byte[] getConstantPool() {
        return new byte[0];
    }
}

