/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.editor;

import java.sql.Connection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.plusplus.FileSystem;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.scriptrunner.commands.editor.Messages;

public class StoreCommand
extends CommandListener
implements IHelp {
    private static final String SET = "set";
    private static final String CREATE_PATTERN = "cre|create";
    private static final String APPEND_PATTERN = "app|append";
    private static final String REPLACE_PATTERN = "rep|replace";
    private static final String FILENAME_PATTERN = "cre|create|app|append|rep|replace";

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String suffix;
        String sqlpcmd = cmd.getSql().trim();
        String[] cmds = null;
        cmds = sqlpcmd.contains("'") ? sqlpcmd.split("'?( |$)(?=(([^']*'){2})*[^']*$)'?") : sqlpcmd.split("\"?( |$)(?=(([^\"]*\"){2})*[^\"]*$)\"?");
        Object filename = null;
        FileSystem.State fileCreate = FileSystem.State.CREATE;
        switch (cmds.length) {
            case 1: {
                this.writeMissingSet(ctx);
                ctx.write(Messages.getString("StoreCommand.1"));
                return true;
            }
            case 2: {
                if (cmds[1].toLowerCase().equals(SET)) {
                    ctx.write(Messages.getString("StoreCommand.6"));
                    ctx.write(Messages.getString("StoreCommand.1"));
                } else {
                    this.writeMissingSet(ctx);
                    ctx.write(Messages.getString("StoreCommand.1"));
                }
                return true;
            }
            case 3: {
                if (!cmds[1].toLowerCase().equals(SET)) {
                    this.writeMissingSet(ctx);
                    ctx.write(Messages.getString("StoreCommand.1"));
                    return true;
                }
                if (this.isReservedName(cmds[2])) {
                    this.writeReserved(ctx);
                    return true;
                }
                filename = ctx.prependCD(cmds[2]);
                break;
            }
            case 4: {
                if (!cmds[1].toLowerCase().equals(SET)) {
                    this.writeMissingSet(ctx);
                    ctx.write(Messages.getString("StoreCommand.1"));
                    return true;
                }
                if (!this.isReservedName(cmds[3])) {
                    this.writeIllegalStoreCommand(ctx);
                    ctx.write(Messages.getString("StoreCommand.1"));
                    return true;
                }
                if (this.isReservedName(cmds[2])) {
                    this.writeReserved(ctx);
                    return true;
                }
                filename = ctx.prependCD(cmds[2]);
                fileCreate = this.getMode(cmds[3]);
                break;
            }
            default: {
                this.writeIllegalStoreCommand(ctx);
                ctx.write(Messages.getString("StoreCommand.1"));
                return true;
            }
        }
        if (((String)filename).lastIndexOf(".") == -1 && !(suffix = (String)ctx.getProperty("script.runner.file.suffix")).equals("")) {
            filename = (String)filename + "." + suffix;
        }
        if (!fileCreate.equals((Object)FileSystem.State.BADMODE)) {
            ctx.write(ctx.save((String)filename, fileCreate.ordinal()));
        } else {
            ctx.write("SP2-0603: Illegal STORE command\n");
            ctx.write("Usage: STORE {SET} filename[.ext] [CRE[ATE]|REP[LACE]|APP[END]]\n");
        }
        return true;
    }

    private FileSystem.State getMode(String string) {
        if (string == null) {
            return FileSystem.State.UNKNOWN;
        }
        if (string.toLowerCase().trim().equals("cre") || string.toLowerCase().trim().equals("create") || string.toLowerCase().trim().equals("crea") || string.toLowerCase().trim().equals("creat")) {
            return FileSystem.State.CREATE;
        }
        if (string.toLowerCase().trim().equals("app") || string.toLowerCase().trim().equals("append") || string.toLowerCase().trim().equals("appe") || string.toLowerCase().trim().equals("appen")) {
            return FileSystem.State.APPEND;
        }
        if (string.toLowerCase().trim().equals("rep") || string.toLowerCase().trim().equals("replace") || string.toLowerCase().trim().equals("repl") || string.toLowerCase().trim().equals("repla") || string.toLowerCase().trim().equals("replac")) {
            return FileSystem.State.REPLACE;
        }
        return FileSystem.State.BADMODE;
    }

    private void writeIllegalStoreCommand(ScriptRunnerContext ctx) {
        ctx.write(Messages.getString("StoreCommand.8"));
    }

    private void writeReserved(ScriptRunnerContext ctx) {
        ctx.write(Messages.getString("StoreCommand.9"));
    }

    private boolean isReservedName(String string) {
        Pattern pattern = Pattern.compile(FILENAME_PATTERN);
        Matcher matcher = pattern.matcher(string);
        return matcher != null && matcher.find();
    }

    private void writeMissingSet(ScriptRunnerContext ctx) {
        ctx.write(Messages.getString("StoreCommand.10"));
    }

    private void writeHelp(ScriptRunnerContext ctx) {
        ctx.write(this.getHelp());
    }

    @Override
    public String getCommand() {
        return "STORE";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }
}

