/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import oracle.aurora.util.JRIExtensions;
import oracle.aurora.util.OrderedCollection;
import oracle.aurora.util.RuntimeExtensions;

public class ClassDescription {
    public Class cls;
    public int instSize;
    public Field[] nonPrimFields;
    protected static Hashtable classMap = new Hashtable(20);

    protected ClassDescription() {
    }

    public static ClassDescription describe(Class cls) {
        ClassDescription result = (ClassDescription)classMap.get(cls);
        if (result != null) {
            return result;
        }
        if (cls.isPrimitive() || cls.isArray()) {
            throw new RuntimeException("Class: " + cls.getName() + " is not a class type");
        }
        result = new ClassDescription();
        result.cls = cls;
        OrderedCollection foc = new OrderedCollection();
        result.instSize = RuntimeExtensions.getExtensions().classTypeOverhead;
        while (cls != null) {
            Field[] fields = cls.getDeclaredFields();
            for (int i = fields.length - 1; i >= 0; --i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                Class<?> fCls = fields[i].getType();
                result.instSize += JRIExtensions.getFieldSize(fCls);
                if (fCls.isPrimitive() || !JRIExtensions.canLoad() && !Modifier.isPublic(fields[i].getModifiers())) continue;
                foc.push(fields[i]);
            }
            cls = cls.getSuperclass();
        }
        result.nonPrimFields = (Field[])foc.getObjects(Field.class);
        return result;
    }

    public static ClassDescription describe(Object obj) {
        return ClassDescription.describe(obj.getClass());
    }

    public static Field[] getStaticNonPrimFields(Class cls) {
        Field[] flds = cls.getDeclaredFields();
        OrderedCollection foc = new OrderedCollection(flds.length);
        for (int i = 0; i < flds.length; ++i) {
            Field field = flds[i];
            if (!Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
            foc.append(field);
        }
        return (Field[])foc.getObjects(Field.class);
    }

    public static void main(String[] args) {
        Hashtable ht = new Hashtable();
        ClassDescription cd = ClassDescription.describe(ht);
        System.out.println("Class: " + cd.cls.getName() + ", instSize: " + cd.instSize + ", fields:");
        for (int i = 0; i < cd.nonPrimFields.length; ++i) {
            Field f = cd.nonPrimFields[i];
            System.out.println("  " + f.getType().getName() + " " + cd.nonPrimFields[i].getName());
        }
    }
}

