/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.template.flash;

import oracle.dss.util.xdo.common.log.Logger;

public class BitsReader {
    protected byte[] mData;
    protected int mBytePos;
    protected int mBitPos;

    public BitsReader(byte[] data, int bytePos, int bitPos) {
        this.mData = data;
        this.mBytePos = bytePos;
        this.mBitPos = bitPos;
    }

    public int readBits(int numBits) {
        if (numBits > 32) {
            Logger.log("readBits: numBits > 32.", 5);
            return 0;
        }
        int val = 0;
        int bitsLeft = numBits;
        while (bitsLeft > 0) {
            int numBitsInThisByte = 8 - this.mBitPos;
            if (numBitsInThisByte >= bitsLeft) {
                val = val << bitsLeft | BitsReader.readBits(this.mData[this.mBytePos], this.mBitPos, this.mBitPos + bitsLeft - 1);
                this.mBitPos += bitsLeft;
                if (this.mBitPos > 7) {
                    this.mBitPos = 0;
                    ++this.mBytePos;
                }
                bitsLeft = 0;
                continue;
            }
            val = val << numBitsInThisByte | BitsReader.readBits(this.mData[this.mBytePos], this.mBitPos, this.mBitPos + numBitsInThisByte - 1);
            this.mBitPos = 0;
            ++this.mBytePos;
            bitsLeft -= numBitsInThisByte;
        }
        return val;
    }

    public static int readBits(byte data, int startBit, int endBit) {
        if (startBit > 7 || endBit > 7) {
            Logger.log("readBits: position > 7.", 5);
            return 0;
        }
        int val = data;
        val = val >> 7 - endBit << 7 - endBit;
        val = (val << startBit & 0xFF) >>> startBit + 7 - endBit;
        return val;
    }

    public static int readBits(int data, int startBit, int endBit) {
        if (startBit > 31 || endBit > 31) {
            Logger.log("readBits: position > 31.", 5);
            return 0;
        }
        int val = data;
        val = val >> 31 - endBit << 31 - endBit;
        val = val << startBit >>> startBit + 31 - endBit;
        return val;
    }

    public void skipFilledBits() {
        if (this.mBitPos != 0) {
            this.mBitPos = 0;
            ++this.mBytePos;
        }
    }

    public int getBytePosition() {
        return this.mBytePos;
    }

    public int getBitPosition() {
        return this.mBitPos;
    }
}

