/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionInfo {
    public static final String BUILD_VERSION = "ComponentBuildVersion";
    public static final String COMPONENT_NUMBER = "ComponentNumber";
    public static final String RELEASE_DESCRIPTION = "ReleaseDescription";
    public static final String BUILD_MODE = "ComponentBuildMode";
    public static final String PACKAGE_NAME = "RuntimePackageName";
    public static final String SOURCE_URL = "RuntimeURL";
    private static final String VERSION_FILENAME = "version.txt";

    public static Properties getProperties(Class versionClass) {
        return VersionInfo.getProperties(versionClass.getPackage().getName());
    }

    public static Properties getProperties(Object versionObject) {
        return VersionInfo.getProperties(versionObject.getClass().getPackage().getName());
    }

    public static Properties getProperties(String versionPackage) {
        return VersionInfo.getProperties(versionPackage.replace('.', '/'), new Properties());
    }

    public static String getProperty(Class versionClass, String key) {
        Properties _props = VersionInfo.getProperties(versionClass);
        if (_props != null) {
            return (String)_props.get(key);
        }
        return null;
    }

    public static String getProperty(Object versionObject, String key) {
        Properties _props = VersionInfo.getProperties(versionObject);
        if (_props != null) {
            return (String)_props.get(key);
        }
        return null;
    }

    public static String getProperty(String versionPackage, String key) {
        Properties _props = VersionInfo.getProperties(versionPackage.replace('.', '/'), new Properties());
        if (_props != null) {
            return (String)_props.get(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getProperties(String packageName, Properties properties) {
        int _lastIndex;
        InputStream _stream = null;
        try {
            String _fullPath;
            if (packageName.indexOf("/") > 0) {
                packageName = "oracle/dss";
            }
            if ((_stream = VersionInfo.class.getResourceAsStream(_fullPath = "/" + packageName + "/version.txt")) != null) {
                properties.load(_stream);
                properties.put(PACKAGE_NAME, packageName.replace('/', '.'));
                properties.put(SOURCE_URL, VersionInfo.class.getResource(_fullPath));
                Properties properties2 = properties;
                return properties2;
            }
            _lastIndex = packageName.lastIndexOf(47);
            if (_lastIndex > 0) {
                Properties properties3 = VersionInfo.getProperties(packageName.substring(0, _lastIndex));
                return properties3;
            }
            Properties properties4 = null;
            return properties4;
        }
        catch (Exception e) {
            _lastIndex = packageName.lastIndexOf(47);
            if (_lastIndex > 0) {
                Properties properties5 = VersionInfo.getProperties(packageName.substring(0, _lastIndex - 1));
                return properties5;
            }
            Properties properties6 = null;
            return properties6;
        }
        finally {
            try {
                if (_stream != null) {
                    _stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

