/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeImpl;
import oracle.adfinternal.model.dvt.util.transform.Page;
import oracle.javatools.annotations.Concealed;
import oracle.javatools.mt.annotation.CodeSharingSafe;

@Concealed
class PagedEdgeTreeMap
extends HashMap<Page, List<EdgeTreeImpl>> {
    private static final long serialVersionUID = 1L;
    private final boolean m_notPaged;
    @CodeSharingSafe(value="StaticField")
    private static final Page m_singlePage = new Page(null);
    private int m_edgeCount = 0;

    public PagedEdgeTreeMap(boolean notPaged) {
        this.m_notPaged = notPaged;
    }

    public Object clone(boolean caching) throws CloneNotSupportedException {
        PagedEdgeTreeMap newMap = new PagedEdgeTreeMap(this.m_notPaged);
        List cubeVal = null;
        Page key = null;
        ArrayList<EdgeTreeImpl> newCubeVal = null;
        for (Map.Entry entry : this.entrySet()) {
            newCubeVal = new ArrayList<EdgeTreeImpl>();
            key = (Page)entry.getKey();
            cubeVal = (List)entry.getValue();
            for (EdgeTreeImpl tree : cubeVal) {
                newCubeVal.add(tree == null ? null : (EdgeTreeImpl)tree.clone(caching));
            }
            newMap.put((Page)key.clone(), (List<EdgeTreeImpl>)newCubeVal);
        }
        return newMap;
    }

    public int getEdgeCount() {
        return this.m_edgeCount;
    }

    @Override
    public List<EdgeTreeImpl> put(Page key, List<EdgeTreeImpl> trees) {
        if (trees != null && trees.size() > this.m_edgeCount) {
            this.m_edgeCount = trees.size();
        }
        return super.put(key, trees);
    }

    public List<EdgeTreeImpl> get(Page page) {
        if (this.m_notPaged) {
            return (List)super.get(m_singlePage);
        }
        return (List)super.get(page);
    }

    public boolean isNotPaged() {
        return this.m_notPaged;
    }
}

