/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.model.ColorProvider;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

public class PaletteItemUIColorProvider
implements ColorProvider<PaletteItemUI>,
AdapterFactory<PaletteItemUI, ColorProvider> {
    private final ColorProvider<PaletteItemUI> behavior = Themes.isThemed() ? new ThemedBehavior(Themes.getActiveTheme()) : new DefaultBehavior();

    public Color backgroundFor(PaletteItemUI obj, String key) {
        return this.behavior.backgroundFor((Object)obj, key);
    }

    public Color foregroundFor(PaletteItemUI obj, String key) {
        return this.behavior.foregroundFor((Object)obj, key);
    }

    public ColorProvider adapt(PaletteItemUI obj) {
        return this;
    }

    static class ThemedBehavior
    implements ColorProvider<PaletteItemUI> {
        private static final String PALETTE_ITEM = "paletteitem";
        private static final String BACKGROUND = "background";
        private static final String FOREGROUND = "foreground";
        private final Theme activeTheme;

        public ThemedBehavior(Theme theme) {
            this.activeTheme = theme;
        }

        public Color backgroundFor(PaletteItemUI obj, String key) {
            ThemeProperties properties = this.activeTheme.getStateProperties(PALETTE_ITEM, key);
            if (null == properties) {
                return null;
            }
            return properties.getColor(BACKGROUND);
        }

        public Color foregroundFor(PaletteItemUI obj, String key) {
            ThemeProperties properties = this.activeTheme.getStateProperties(PALETTE_ITEM, key);
            if (null == properties) {
                return null;
            }
            return properties.getColor(FOREGROUND);
        }
    }

    static class DefaultBehavior
    implements ColorProvider<PaletteItemUI> {
        private static final Map<String, String> BACKGROUND_KEYS = new HashMap<String, String>();
        private static final Map<String, String> FOREGROUND_KEYS;
        private final UIDefaults defaults = UIManager.getLookAndFeelDefaults();

        DefaultBehavior() {
        }

        public Color backgroundFor(PaletteItemUI obj, String key) {
            String bgKey = BACKGROUND_KEYS.get(key);
            if (null == bgKey) {
                return null;
            }
            return this.defaults.getColor(bgKey);
        }

        public Color foregroundFor(PaletteItemUI obj, String key) {
            String fgKey = FOREGROUND_KEYS.get(key);
            if (null == fgKey) {
                return null;
            }
            return this.defaults.getColor(fgKey);
        }

        static {
            BACKGROUND_KEYS.put("disabled", "MenuItem.background");
            BACKGROUND_KEYS.put("enabled", "MenuItem.background");
            BACKGROUND_KEYS.put("mouseover", "MenuItem.selectionBackground");
            BACKGROUND_KEYS.put("selected", "MenuItem.selectionBackground");
            FOREGROUND_KEYS = new HashMap<String, String>();
            FOREGROUND_KEYS.put("disabled", "MenuItem.disabledForeground");
            FOREGROUND_KEYS.put("enabled", "MenuItem.foreground");
            FOREGROUND_KEYS.put("mouseover", "MenuItem.selectionForeground");
            FOREGROUND_KEYS.put("selected", "MenuItem.selectionForeground");
        }
    }
}

