/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.quickdiff.reference;

import java.io.InputStream;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.quickdiff.QuickDiffMenuConstants;
import oracle.ide.quickdiff.QuickDiffReference;
import oracle.ide.quickdiff.QuickDiffReferenceProvider;
import oracle.ide.quickdiff.res.QuickDiffArb;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;

public class DelayedBufferReferenceProvider
extends QuickDiffReferenceProvider {
    public static final String ID = "DelayedBuffer";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return QuickDiffArb.getString(2);
    }

    @Override
    public float getMenuSection() {
        return QuickDiffMenuConstants.SECTION_IDE_REFERENCES;
    }

    @Override
    public QuickDiffReference createReference(final URL url) {
        return new QuickDiffReference(url){
            private final TextNode _node;
            private final Timer _timer;
            private TextBuffer _twoMinuteBuffer;
            private TextBuffer _oneMinuteBuffer;
            {
                super(url2);
                this._twoMinuteBuffer = null;
                this._oneMinuteBuffer = null;
                Node node = NodeFactory.find((URL)url);
                this._node = node instanceof TextNode ? (TextNode)node : null;
                int delay = 60000;
                this._timer = new Timer();
                this._timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        this.updateTextBuffers();
                        this.doNotifyObservers();
                    }
                }, delay, (long)delay);
                this.updateTextBuffers();
            }

            @Override
            protected synchronized TextCompareContributor createCompareContributor() throws Exception {
                final TextBuffer textBuffer = this._twoMinuteBuffer != null ? this._twoMinuteBuffer : this._oneMinuteBuffer;
                return new TextCompareContributor(){

                    public TextBuffer getTextBuffer() {
                        return textBuffer != null ? textBuffer : TextBufferFactory.createTextBuffer();
                    }
                };
            }

            @Override
            public InputStream openInputStream() {
                return null;
            }

            private synchronized void updateTextBuffers() {
                if (this._node == null) {
                    return;
                }
                TextBuffer copyEditorTextBuffer = TextBufferFactory.createTextBuffer();
                TextBuffer nodeTextBuffer = this._node.acquireTextBuffer();
                nodeTextBuffer.readLock();
                try {
                    copyEditorTextBuffer.append(nodeTextBuffer.getChars(0, nodeTextBuffer.getLength()));
                }
                finally {
                    nodeTextBuffer.readUnlock();
                }
                this._twoMinuteBuffer = this._oneMinuteBuffer;
                this._oneMinuteBuffer = copyEditorTextBuffer;
            }

            @Override
            public void dispose() {
                super.dispose();
                this._timer.cancel();
            }
        };
    }
}

