/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.autorest.ui.JEditorPaneScrollPaneWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.actions.SQLScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessorContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.rest.RestArb;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public abstract class ScriptRunnerTraversablePanel
extends DefaultTraversablePanel {
    public static final String KEY_DIALOG = "KEY_DIALOG";
    public static final String KEY_DBOBJECT = "KEY_DBOBJECT";
    public static final String KEY_CONN_NAME = "KEY_CONN_NAME";
    private transient ScriptProcessor scriptProcessor;
    protected BasicEditorPane scriptEditor;
    private boolean scriptEditingEnabled;
    private boolean closeOnError = false;
    private ScriptRunnerRaptorTask scriptRunnerTask = null;
    private String helpTopic = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() != 1) return;
        this.validateData(traversableContext);
        try {
            DBObject dBObject = (DBObject)traversableContext.get(KEY_DBOBJECT);
            JDialog jDialog = (JDialog)traversableContext.get(KEY_DIALOG);
            String string = dBObject.getConnectionName();
            Connection connection = Connections.getInstance().getConnection(string);
            Properties properties = Connections.getInstance().getConnectionInfo(string);
            this.scriptRunnerTask = new ScriptRunnerRaptorTask(jDialog, connection, string, properties);
            this.scriptRunnerTask.setCancellable(this.getScriptProcessor().isCancellable());
            this.scriptRunnerTask.getDescriptor().addListener((IRaptorTaskListener)new AbstractScriptRunnerRaptorTaskAdapter(jDialog));
            RaptorTaskManager.getInstance().addTask((RaptorTask)this.scriptRunnerTask);
            Boolean bl = (Boolean)this.scriptRunnerTask.getResult();
            traversableContext.put("SUCCESS_STATUS", (Object)bl);
            if (bl != null && bl.booleanValue()) return;
        }
        catch (Throwable throwable) {
            throw new TraversalException(throwable.getMessage());
        }
    }

    protected String getScriptForProcessing() {
        String string = null;
        string = this.scriptEditor.getText();
        return string;
    }

    protected ScriptProcessor getScriptProcessor() {
        if (this.scriptProcessor == null) {
            this.scriptProcessor = this.createScriptProcessor();
        }
        return this.scriptProcessor;
    }

    protected ScriptProcessor createScriptProcessor() {
        return new SQLScriptProcessor();
    }

    public String getScriptEditorTabName() {
        String string = this.getScriptProcessor().getScriptEditorTabName();
        return string;
    }

    protected JEditorPaneScrollPaneWrapper createScriptPane(String string) {
        JEditorPaneScrollPaneWrapper jEditorPaneScrollPaneWrapper = null;
        ScriptProcessor scriptProcessor = this.getScriptProcessor();
        if (scriptProcessor != null) {
            this.scriptEditor = this.getScriptProcessor().getEditorPane();
            if (string != null) {
                this.scriptEditor.setText(string);
            }
            this.scriptEditor.setEditable(this.scriptEditingEnabled);
            jEditorPaneScrollPaneWrapper = new JEditorPaneScrollPaneWrapper((JEditorPane)this.scriptEditor);
            jEditorPaneScrollPaneWrapper.setVerticalScrollBarPolicy(22);
            jEditorPaneScrollPaneWrapper.setHorizontalScrollBarPolicy(32);
        }
        return jEditorPaneScrollPaneWrapper;
    }

    public void setScriptEditingEnabled(boolean bl) {
        this.scriptEditingEnabled = bl;
    }

    public boolean isScriptEditingEnabled() {
        return this.scriptEditingEnabled;
    }

    public void setCloseOnError(boolean bl) {
        this.closeOnError = bl;
    }

    public boolean isCloseOnError() {
        return this.closeOnError;
    }

    protected void checkAllowApplyScript() throws IllegalStateException {
    }

    protected void onCommandComplete() {
    }

    private static void invokeOnDispatchThreadLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected abstract String getTitle();

    protected abstract void validateData(TraversableContext var1) throws TraversalException;

    protected String getScriptProcessorParameter(String string) {
        return null;
    }

    private class ScriptRunnerRaptorTask
    extends RaptorTask<Boolean> {
        final JDialog dialog;
        final Connection connection;
        final String cName;
        final Properties connectionProperties;
        private Boolean success;

        public ScriptRunnerRaptorTask(JDialog jDialog, Connection connection, String string, Properties properties) {
            super(UiResources.getString((String)"PERFORM_ACTION"), true, IRaptorTaskRunMode.MODAL);
            this.success = Boolean.FALSE;
            this.dialog = jDialog;
            this.connection = connection;
            this.cName = string;
            this.connectionProperties = properties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected Boolean doWork() throws TaskException {
            block15: {
                this.success = Boolean.FALSE;
                if (!ScriptRunnerTraversablePanel.this.isCloseOnError()) {
                    ScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(new Runnable(){

                        @Override
                        public void run() {
                            ScriptRunnerRaptorTask.this.dialog.setEnabled(false);
                            ScriptRunnerRaptorTask.this.dialog.setModalityType(Dialog.ModalityType.MODELESS);
                        }
                    });
                }
                ScriptRunnerTraversablePanel.this.checkAllowApplyScript();
                ScriptRunnerTraversablePanel.this.getScriptProcessor().processScript((ScriptProcessorContext)new ScriptProcessorContextImpl(this.dialog, this.connection, this.cName, this.connectionProperties, ScriptRunnerTraversablePanel.this.getScriptForProcessing()));
                ScriptRunnerTraversablePanel.this.onCommandComplete();
                String string = ScriptRunnerTraversablePanel.this.getScriptProcessor().getSuccessMessage();
                this.setMessage(string);
                this.success = Boolean.TRUE;
                try {
                    ScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(new Runnable(){

                        @Override
                        public void run() {
                            ScriptRunnerRaptorTask.this.dialog.setEnabled(true);
                            ScriptRunnerRaptorTask.this.dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
                        }
                    });
                }
                catch (Throwable throwable) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, throwable.getLocalizedMessage());
                }
                break block15;
                catch (Exception exception) {
                    try {
                        String string2 = null;
                        if (exception instanceof SQLException) {
                            SQLException sQLException = (SQLException)exception;
                            if (sQLException.getErrorCode() == 1403) {
                                ScriptRunnerTraversablePanel.this.helpTopic = "f1_rest_conn_nav_reqmts_html";
                                string2 = RestArb.format("ERROR_SCHEMA_NOT_ENABLED", Connections.getDisplayName((String)this.cName));
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, string2 + "\n\n" + sQLException.getLocalizedMessage());
                            } else {
                                string2 = ScriptRunnerTraversablePanel.this.getScriptProcessor().getFailureMessage(exception);
                            }
                        } else {
                            string2 = ScriptRunnerTraversablePanel.this.getScriptProcessor().getFailureMessage(exception);
                        }
                        this.setMessage(string2);
                        this.success = Boolean.FALSE;
                    }
                    catch (Throwable throwable) {
                        try {
                            ScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(new /* invalid duplicate definition of identical inner class */);
                        }
                        catch (Throwable throwable2) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, throwable2.getLocalizedMessage());
                        }
                        throw throwable;
                    }
                    try {
                        ScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Throwable throwable) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, throwable.getLocalizedMessage());
                    }
                }
            }
            return this.success;
        }

        public Boolean getSuccess() {
            return this.success;
        }
    }

    private class AbstractScriptRunnerRaptorTaskAdapter
    extends RaptorTaskAdapter {
        final JDialog dialog;

        public AbstractScriptRunnerRaptorTaskAdapter(JDialog jDialog) {
            this.dialog = jDialog;
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ScriptRunnerTraversablePanel.this.getScriptProcessor().cancel();
                    AbstractScriptRunnerRaptorTaskAdapter.this.dialog.setVisible(false);
                }
            };
            ScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(runnable);
        }

        public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String string;
                    if (!ScriptRunnerTraversablePanel.this.isCloseOnError()) {
                        AbstractScriptRunnerRaptorTaskAdapter.this.dialog.setEnabled(true);
                        AbstractScriptRunnerRaptorTaskAdapter.this.dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                        AbstractScriptRunnerRaptorTaskAdapter.this.dialog.setVisible(true);
                    }
                    if ((string = raptorTaskEvent.getTaskDescriptor().getMessage()) != null) {
                        MessageDialog.error((Component)AbstractScriptRunnerRaptorTaskAdapter.this.dialog, (Object)raptorTaskEvent.getTaskDescriptor().getMessage(), (String)RestArb.getString("REST_NAVIGATOR_LABEL"), (String)ScriptRunnerTraversablePanel.this.helpTopic);
                    }
                }
            };
            ScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(runnable);
        }

        public void taskFinished(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String string = raptorTaskEvent.getTaskDescriptor().getMessage();
                    if (string != null) {
                        boolean bl;
                        boolean bl2 = bl = ScriptRunnerTraversablePanel.this.scriptRunnerTask.getSuccess() == null ? false : ScriptRunnerTraversablePanel.this.scriptRunnerTask.getSuccess();
                        if (bl) {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)raptorTaskEvent.getTaskDescriptor().getMessage(), (String)UiResources.getString((String)"SUCCESS_TITLE"), null);
                        } else {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)raptorTaskEvent.getTaskDescriptor().getMessage(), (String)RestArb.getString("REST_NAVIGATOR_LABEL"), (String)ScriptRunnerTraversablePanel.this.helpTopic);
                        }
                    }
                }
            };
            ScriptRunnerTraversablePanel.invokeOnDispatchThreadLater(runnable);
        }
    }

    protected class ScriptProcessorContextImpl
    implements ScriptProcessorContext {
        private Component _parent;
        private Connection _connection;
        private String _cName;
        private Properties _connectionProperties;
        private String _script;

        ScriptProcessorContextImpl(Component component, Connection connection, String string, Properties properties, String string2) {
            this._parent = component;
            this._connection = connection;
            this._cName = string;
            this._connectionProperties = properties;
            this._script = string2;
        }

        public Component getParent() {
            return this._parent;
        }

        public String getConnectionName() {
            return this._cName;
        }

        public Connection getConnection() {
            return this._connection;
        }

        public Properties getConnectionProperties() {
            return this._connectionProperties;
        }

        public String getActionTitle() {
            return ScriptRunnerTraversablePanel.this.getTitle();
        }

        public String getScript() {
            return this._script;
        }

        public String getParameter(String string) {
            return ScriptRunnerTraversablePanel.this.getScriptProcessorParameter(string);
        }
    }
}

