/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.wizard;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.utils.RestLoadData;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rest.wizard.RestWizHandlerPanel;
import oracle.dbtools.rest.wizard.RestWizModulePanel;
import oracle.dbtools.rest.wizard.RestWizSummaryPanel;
import oracle.dbtools.rest.wizard.RestWizSummaryTabPanel;
import oracle.dbtools.rest.wizard.RestWizTemplatePanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Element;
import oracle.ide.util.Namespace;
import oracle.ide.view.View;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class RestWizard {
    public static final String TRANSITION_TEMPLATE = "Transition.Template";
    public static final String STATE_TEMPLATE = "State.Template";
    public static final String TRANSITION_HANDLER = "Transition.Handler";
    public static final String STATE_HANDLER = "State.Handler";
    public static final String TRANSITION_FINISH = "Transition.Finish";
    public static final String STATE_FINISH = "State.Finish";
    public static final String KEY_REST_MODULE = "REST_MODULE";
    public static final String KEY_REST_TEMPLATE = "REST_TEMPLATE";
    public static final String KEY_REST_HANDLER = "REST_HANDLER";
    public static final String KEY_MODULE_URI = "REST_MODULE_URI";
    public static final String KEY_EXISTING_NAMES = "REST_EXISTING_NAMES";
    public static final String KEY_EXISTING_URIS = "REST_EXISTING_URIS";
    public static final String KEY_MODULE_NAME = "REST_MODULE_NAME";
    public static final String KEY_EXISTING_URI_PREFIXES = "REST_EXISTING_URI_PREFIXES";
    public static final String KEY_MODULE_PAGINATION = "REST_MODULE_PAGINATION";
    public static final String KEY_SUCCESS_STATUS = "SUCCESS_STATUS";
    public static final String KEY_USE_ORDSAPI = "USE_ORDS_API";
    private static RestWizard INSTANCE;
    private static final int DEFAULT_PAGINATION_SIZE = 25;

    public static RestWizard getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RestWizard();
        }
        return INSTANCE;
    }

    public boolean launchCreatelModule(Context context) {
        DBFolderInstance dBFolderInstance;
        ObjectFolder objectFolder;
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject == null || !dBObject.getObjectType().equals("REST_MODULE_FOLDER")) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (dBObject.getNode() instanceof ObjectFolder) {
            objectFolder = (ObjectFolder)dBObject.getNode();
            dBFolderInstance = objectFolder.getFolderInstance();
            try {
                List list = dBFolderInstance.listChildren();
                for (DBChildInstance dBChildInstance : list) {
                    String string;
                    String string2 = (String)dBChildInstance.getProperty("NAME");
                    if (string2 != null) {
                        arrayList.add(string2);
                    }
                    if ((string = (String)dBChildInstance.getProperty("URI_PREFIX")) == null) continue;
                    arrayList2.add(string);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        objectFolder = new Namespace();
        objectFolder.put(KEY_REST_MODULE, (Object)this.createRestModule());
        objectFolder.put(KEY_EXISTING_NAMES, arrayList);
        objectFolder.put(KEY_EXISTING_URI_PREFIXES, arrayList2);
        objectFolder.put("KEY_DBOBJECT", (Object)dBObject);
        objectFolder.put(KEY_USE_ORDSAPI, (Object)true);
        dBFolderInstance = RestWizard.getFSMforModule();
        boolean bl = this.launchWizard((FSM)dBFolderInstance, (Namespace)objectFolder, true);
        if (bl) {
            Boolean bl2 = (Boolean)objectFolder.get(KEY_SUCCESS_STATUS);
            if (bl2.booleanValue()) {
                this.refreshFolder(context);
            }
            return bl2;
        }
        return false;
    }

    public boolean launchCreateTemplate(Context context) {
        Object object;
        Enumeration enumeration;
        NavigatorTreeNode navigatorTreeNode;
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject == null || !dBObject.getObjectType().equals(KEY_REST_MODULE)) {
            return false;
        }
        Map map = dBObject.getDictionary();
        String string = (String)map.get("URI_PREFIX");
        String string2 = (String)map.get("NAME");
        List<String> list = RestUtils.getChildrenNames(context);
        if (list == null || list.isEmpty()) {
            navigatorTreeNode = RestUtils.findTreeNode(context);
            RestLoadData.retreiveRestTemplateUris(navigatorTreeNode, list, null);
            enumeration = navigatorTreeNode.children();
            while (enumeration.hasMoreElements()) {
                NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
                object = navigatorTreeNode2.getElement();
                DBObject dBObject2 = new DBObject((Element)object);
                Map map2 = dBObject2.getDictionary();
                String string3 = null;
                if (!map2.containsKey("URI_TEMPLATE") || RestUtils.nullOrEmpty(string3 = (String)map2.get("URI_TEMPLATE"))) continue;
                list.add(string3);
            }
        }
        navigatorTreeNode = new Namespace();
        navigatorTreeNode.put(KEY_REST_TEMPLATE, (Object)new RestTemplate());
        navigatorTreeNode.put(KEY_EXISTING_URIS, list);
        navigatorTreeNode.put(KEY_MODULE_URI, (Object)string);
        navigatorTreeNode.put(KEY_MODULE_NAME, (Object)string2);
        navigatorTreeNode.put("KEY_DBOBJECT", (Object)dBObject);
        navigatorTreeNode.put(KEY_USE_ORDSAPI, (Object)true);
        enumeration = RestWizard.getFSMforTemplate();
        boolean bl = this.launchWizard((FSM)enumeration, (Namespace)navigatorTreeNode, true);
        if (bl) {
            object = (Boolean)navigatorTreeNode.get(KEY_SUCCESS_STATUS);
            if (((Boolean)object).booleanValue()) {
                this.refreshNode(context);
            }
            return (Boolean)object;
        }
        return false;
    }

    public RestModule launchCreateRESTfulModule(List<String> list, List<String> list2) {
        Namespace namespace = new Namespace();
        namespace.put(KEY_REST_MODULE, (Object)this.createRestModule());
        namespace.put(KEY_EXISTING_NAMES, list);
        namespace.put(KEY_EXISTING_URI_PREFIXES, list2);
        namespace.put(KEY_USE_ORDSAPI, (Object)false);
        FSM fSM = RestWizard.getFSMforRESTfulModule();
        boolean bl = this.launchWizard(fSM, namespace);
        if (bl) {
            return (RestModule)namespace.get(KEY_REST_MODULE);
        }
        return null;
    }

    public RestTemplate launchCreateRESTfulTemplate(List<String> list, String string, long l) {
        Namespace namespace = new Namespace();
        namespace.put(KEY_REST_TEMPLATE, (Object)new RestTemplate());
        namespace.put(KEY_EXISTING_URIS, list);
        namespace.put(KEY_MODULE_URI, (Object)string);
        namespace.put(KEY_MODULE_PAGINATION, (Object)new Long(l));
        namespace.put(KEY_USE_ORDSAPI, (Object)false);
        FSM fSM = RestWizard.getFSMforRESTfulTemplate();
        boolean bl = this.launchWizard(fSM, namespace);
        if (bl) {
            return (RestTemplate)namespace.get(KEY_REST_TEMPLATE);
        }
        return null;
    }

    public boolean launchWizard(FSM fSM, Namespace namespace) {
        return this.launchWizard(fSM, namespace, false);
    }

    public boolean launchWizard(FSM fSM, Namespace namespace, boolean bl) {
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        fSMWizard.setWizardTitle(RestArb.getString("WIZ_TITLE"));
        fSMWizard.setLogoImage(RestArb.getImage("WIZ_LOGO_IMAGE"));
        fSMWizard.setRoadmapVisible(true);
        fSMWizard.setSize(800, 800);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        if (bl) {
            namespace.put("KEY_DIALOG", (Object)wizardDialog);
        }
        boolean bl2 = WizardLauncher.runDialog((JDialog)wizardDialog);
        return bl2;
    }

    private static FSM getFSMforModule() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(RestArb.getString("WIZ_STEP_REST_MODULE"), RestWizModulePanel.class, "f1_rest_module_html");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_TEMPLATE, (Object)STATE_TEMPLATE);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step2 = new Step(RestArb.getString("WIZ_STEP_REST_TEMPLATE"), RestWizTemplatePanel.class, "f1_rest_template_html");
        fSMBuilder.newState((Object)STATE_TEMPLATE, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step3 = new Step(RestArb.getString("WIZ_STEP_SUMMARY"), RestWizSummaryTabPanel.class, "f1_rest_summary_html");
        fSMBuilder.newFinalState((Object)STATE_FINISH, step3);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    private static FSM getFSMforRESTfulModule() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(RestArb.getString("WIZ_STEP_REST_MODULE"), RestWizModulePanel.class, "f1_rest_module_html");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_TEMPLATE, (Object)STATE_TEMPLATE);
        fSMBuilder.addStateTrans((Object)TRANSITION_HANDLER, (Object)STATE_HANDLER);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step2 = new Step(RestArb.getString("WIZ_STEP_REST_TEMPLATE"), RestWizTemplatePanel.class, "f1_rest_template_html");
        fSMBuilder.newState((Object)STATE_TEMPLATE, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_HANDLER, (Object)STATE_HANDLER);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step3 = new Step(RestArb.getString("WIZ_STEP_REST_HANDLER"), RestWizHandlerPanel.class, "f1_rest_handler_html");
        fSMBuilder.newState((Object)STATE_HANDLER, step3, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step4 = new Step(RestArb.getString("WIZ_STEP_SUMMARY"), RestWizSummaryPanel.class, "f1_rest_summary_html");
        fSMBuilder.newFinalState((Object)STATE_FINISH, step4);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    private static FSM getFSMforRESTfulTemplate() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(RestArb.getString("WIZ_STEP_REST_TEMPLATE"), RestWizTemplatePanel.class, "f1_rest_template_html");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_HANDLER, (Object)STATE_HANDLER);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step2 = new Step(RestArb.getString("WIZ_STEP_REST_HANDLER"), RestWizHandlerPanel.class, "f1_rest_handler_html");
        fSMBuilder.newState((Object)STATE_HANDLER, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step3 = new Step(RestArb.getString("WIZ_STEP_SUMMARY"), RestWizSummaryPanel.class, "f1_rest_summary_html");
        fSMBuilder.newFinalState((Object)STATE_FINISH, step3);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    private static FSM getFSMforTemplate() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(RestArb.getString("WIZ_STEP_REST_TEMPLATE"), RestWizTemplatePanel.class, "f1_rest_template_html");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step2 = new Step(RestArb.getString("WIZ_STEP_SUMMARY"), RestWizSummaryTabPanel.class, "f1_rest_summary_html");
        fSMBuilder.newFinalState((Object)STATE_FINISH, step2);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    private void refreshFolder(Context context) {
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        if (navigatorTreeNode != null) {
            View view = context.getView();
            NavigatorTree navigatorTree = null;
            if (view instanceof NavigatorWindow) {
                navigatorTree = ((NavigatorWindow)view).getTree();
            } else {
                NavigatorWindow navigatorWindow = DBNavigatorManager.getInstance().getNavigatorWindow();
                if (navigatorWindow != null) {
                    navigatorTree = navigatorWindow.getTree();
                }
            }
            if (navigatorTree != null) {
                navigatorTreeNode = navigatorTreeNode.findAncestorTreeNode(ObjectFolder.class, false);
                navigatorTree.refresh(navigatorTreeNode);
            }
        }
    }

    private void refreshNode(Context context) {
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        if (navigatorTreeNode != null) {
            View view = context.getView();
            NavigatorTree navigatorTree = null;
            if (view instanceof NavigatorWindow) {
                navigatorTree = ((NavigatorWindow)view).getTree();
            } else {
                NavigatorWindow navigatorWindow = DBNavigatorManager.getInstance().getNavigatorWindow();
                if (navigatorWindow != null) {
                    navigatorTree = navigatorWindow.getTree();
                }
            }
            if (navigatorTree != null) {
                navigatorTree.refresh(navigatorTreeNode);
            }
        }
    }

    private RestModule createRestModule() {
        RestModule restModule = new RestModule();
        restModule.setPaginationSize(25L);
        return restModule;
    }
}

