/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.awt.event.ActionEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.bali.xml.model.creatable.XmlCreationContext;
import oracle.bali.xml.model.creatable.XmlCreationResult;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.util.XmlCreationAction;
import oracle.bali.xml.util.XmlModelUtils;
import org.w3c.dom.Node;

public class XmlCreatableAction
extends AbstractAction {
    private static final String _CREATE_COMMAND = "create";
    private boolean _iconInitialized = false;
    private XmlCreationContext _context;
    private List<XmlCreatable> _creatables;
    private static final Logger _LOGGER = Logger.getLogger(XmlCreationAction.class.getName());

    public XmlCreatableAction(XmlCreationContext context, XmlCreatable creatable) {
        this._init(context, Collections.singletonList(creatable));
    }

    public XmlCreatableAction(XmlCreationContext context, List<XmlCreatable> creatables) {
        this._init(context, Collections.unmodifiableList(creatables));
    }

    public static List createActions(XmlCreationContext context, List<List<XmlCreatable>> creatableLists) {
        ArrayList<XmlCreatableAction> actions = new ArrayList<XmlCreatableAction>(creatableLists.size());
        for (List<XmlCreatable> creatables : creatableLists) {
            actions.add(new XmlCreatableAction(context, creatables));
        }
        return actions;
    }

    public static Collection<XmlCreatableAction> createLazyActionCollectionFromCollection(final XmlCreationContext context, final Collection<XmlCreatable> creatables) {
        return new AbstractCollection(){

            @Override
            public int size() {
                return creatables.size();
            }

            @Override
            public Iterator iterator() {
                return new Itor();
            }

            class Itor
            implements Iterator {
                private final Iterator<XmlCreatable> _realItor;

                Itor() {
                    this._realItor = creatables.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this._realItor.hasNext();
                }

                public Object next() {
                    XmlCreatable creatable = this._realItor.next();
                    return new XmlCreatableAction(context, creatable);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            XmlModelUtils.setModalDialogRunning(true);
            if (this.getLastCreatable() != null) {
                final List<XmlCreatable> creatables = this.getCreatables();
                final int keyCount = creatables.size();
                AbstractModel model = this._context.getModel();
                String transDescFormat = model.getTranslatedString("INSERT_DESCRIPTION_FORMAT");
                String transDescription = FastMessageFormat.formatMessage(transDescFormat, this.getValue("Name").toString());
                new FixedNameTransactionTask(transDescription){

                    @Override
                    protected void performTask(AbstractModel model) throws XmlCommitException {
                        DomPosition position = XmlCreatableAction.this._context.getDomPosition();
                        int i = 0;
                        while (true) {
                            XmlCreatable currCreatable = (XmlCreatable)creatables.get(i);
                            XmlCreationResult result = currCreatable.createAtPosition(XmlCreatableAction.this._context, position, null);
                            if (++i >= keyCount) break;
                            if (result == null || result.getCreatedNodes() == null || result.getCreatedNodes().size() <= 0) continue;
                            List<Node> nodes = result.getCreatedNodes();
                            Node lastNode = nodes.get(nodes.size() - 1);
                            position = DomPositionFactory.createInsideOrAfterPosition((Node)lastNode);
                        }
                    }
                }.run(model);
            } else {
                _LOGGER.log(Level.WARNING, "Can't create element because no XmlKey for {0}", this);
            }
        }
        finally {
            XmlModelUtils.setModalDialogRunning(false);
        }
    }

    public List<XmlCreatable> getCreatables() {
        return this._creatables;
    }

    public XmlCreatable getLastCreatable() {
        List<XmlCreatable> creatables = this.getCreatables();
        int size = creatables.size();
        if (size == 0) {
            return null;
        }
        return creatables.get(size - 1);
    }

    @Override
    public Object getValue(String key) {
        Object value = super.getValue(key);
        if ("SmallIcon".equals(key) && !this._iconInitialized) {
            value = this._createIcon();
            this._iconInitialized = true;
        }
        return value;
    }

    public String toString() {
        return (String)this.getValue("Name");
    }

    private Icon _createIcon() {
        XmlCreatable lastCreatable = this.getLastCreatable();
        if (lastCreatable != null) {
            Icon smallIcon = lastCreatable.getSmallIcon(this._context);
            if (smallIcon != null) {
                this.putValue("SmallIcon", smallIcon);
            }
            return smallIcon;
        }
        return null;
    }

    private void _init(XmlCreationContext context, List<XmlCreatable> creatables) {
        this.putValue("ActionCommandKey", _CREATE_COMMAND);
        this._context = context;
        this._creatables = creatables;
        XmlCreatable lastCreatable = this.getLastCreatable();
        this.setEnabled(lastCreatable != null);
        String name = lastCreatable.getShortDisplayName(this._context);
        this.putValue("Name", name);
        char mnemonic = Character.toUpperCase(name.charAt(0));
        this.putValue("MnemonicKey", mnemonic);
    }
}

