/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.bali.share.collection.OptimisticHashMap;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.beanmodel.versioning.VersionManager;
import oracle.bali.xml.dom.CustomizationLayer;
import oracle.bali.xml.dom.DomCommitException;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelEvent;
import oracle.bali.xml.dom.DomModelHolder;
import oracle.bali.xml.dom.DomModelListener;
import oracle.bali.xml.dom.DomMutationListener;
import oracle.bali.xml.dom.DomParseProblem;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.NodeCustomizationDetails;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.resolver.GrammarResolverEvent;
import oracle.bali.xml.grammar.resolver.GrammarResolverListener;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.DomNodeXmlKey;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.MetadataSchemaRegistry;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.grammar.GrammarMetadataProvider;
import oracle.bali.xml.metadata.grammar.GrammarUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.ModelSelection;
import oracle.bali.xml.model.ModelValidationContext;
import oracle.bali.xml.model.PrecommitOptions;
import oracle.bali.xml.model.PrecommitResults;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.SetChangeEvent;
import oracle.bali.xml.model.SetChangeListener;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlDomCommitException;
import oracle.bali.xml.model.XmlInvalidOnCommitException;
import oracle.bali.xml.model.XmlMetadataEvaluator;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlNoDocumentOnCommitException;
import oracle.bali.xml.model.XmlReadOnlyException;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.action.ActionManager;
import oracle.bali.xml.model.annotation.AnnotationCommitException;
import oracle.bali.xml.model.annotation.AnnotationModel;
import oracle.bali.xml.model.annotation.AnnotationModelEvent;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.dependency.ValidationResult;
import oracle.bali.xml.model.event.NamespacesInDocumentChangeEvent;
import oracle.bali.xml.model.event.NamespacesInDocumentListener;
import oracle.bali.xml.model.event.XmlContextLifecycleListener;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.model.grammar.InstanceGrammarListener;
import oracle.bali.xml.model.id.IdGenerationContext;
import oracle.bali.xml.model.id.IdGenerationPlugin;
import oracle.bali.xml.model.id.IdGenerationTask;
import oracle.bali.xml.model.listenerImpl.EventDeliveryTask;
import oracle.bali.xml.model.message.AbstractDelegatingIssueList;
import oracle.bali.xml.model.message.DomParseProblemMessage;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.model.message.SimpleXmlModelMessageIssueList;
import oracle.bali.xml.model.message.ValidationHandler;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.model.message.XmlModelMessageIssueList;
import oracle.bali.xml.model.message.XmlModelMessageLog;
import oracle.bali.xml.model.misc.GrammarBasedWhitespaceHandler;
import oracle.bali.xml.model.resource.PaternalResourceBundle;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.bali.xml.model.traversal.MutableTraversalData;
import oracle.bali.xml.model.traversal.TraversalData;
import oracle.bali.xml.model.traversal.TraversalHandler;
import oracle.bali.xml.model.traversal.XmlTraversalHandler;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.util.CollectionUtils;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.DomPositionRef;
import oracle.bali.xml.util.DomPositionRefFactory;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.bali.xml.validator.ValidationContext;
import oracle.bali.xml.validator.Validator;
import oracle.bali.xml.validator.prospective.ProspectiveValidationContext;
import oracle.bali.xml.validator.prospective.ProspectiveValidator;
import oracle.javatools.logging.LogUtils;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlModel
extends AbstractModel {
    public static final String DOC_CHANGE_COUNT_PROPERTY = "docChangeCount";
    public static final String VALIDATION_ISSUES = "validationIssues";
    public static final String ISSUE_LIST = "XmlModelIssueList";
    public static final String URL_MAP = "XmlModelURLMap";
    public static final String ANNOTATION_MODEL_CHANGED_PROPERTY = "annotationModelChanged";
    private static final Object _NO_GRAMMAR_FOR_KEY = new Object();
    private volatile boolean _isValidStatusCurrent = false;
    private long _timestamp = System.currentTimeMillis();
    private Map<String, Set<String>> _namespacesInDoc = Collections.emptyMap();
    private XmlContext _context;
    private ActionManager _actionManager;
    private ResourceBundle _bundle;
    private MetadataProvider _metadataProvider;
    private ModelSelection _selection;
    private XmlMetadataResolver _metadataResolver;
    private ProspectiveValidationContext _prospectiveValidationContext;
    private volatile TraversalData _traversalData;
    private Object _traversalDataBuildLock = new Object();
    private XmlModelMessageIssueList _validationIssues = new ValidationHandler(this, MessageCategory.GRAMMAR_VALIDITY);
    private volatile boolean _firstValidationRequested = false;
    private DefaultPrefixLookup _prefixLookup;
    private final ConcurrentHashMap<String, ValidationResult> _cacheUrlMap = new ConcurrentHashMap(10, 0.75f, 4);
    private final List<TraversalHandler> _traversalHandlers = new CopyOnWriteArrayList<TraversalHandler>();
    private final TraversalHandler _xmlTraversalHandler = new XmlTraversalHandler();
    private final SafeListenerManager _undoListeners = new SafeListenerManager();
    private final SafeListenerManager _namespacesInDocumentListeners = new SafeListenerManager();
    private final OptimisticHashMap _grammarComponents = new OptimisticHashMap();
    private final ConcurrentHashMap<Node, XmlKey> _nodeToKeyCache = new ConcurrentHashMap(53, 0.75f, 4);
    private final ConcurrentHashMap<XmlKey, ConcurrentHashMap<QualifiedName, XmlKey>> _elementXmlKeyCache = new ConcurrentHashMap(53, 0.75f, 10);
    private final ConcurrentHashMap<XmlKey, ConcurrentHashMap<QualifiedName, XmlKey>> _attributeXmlKeyCache = new ConcurrentHashMap(53, 0.75f, 10);
    private final GrammarResolverListener _grammarListener = new GrammarListener();
    private final LinkedList _nestedEvents = new LinkedList();
    private WhitespaceHandler _whitespaceHandler;
    private SelectionStateRef _preTransactionSelectionState = new SelectionStateRef();
    private XmlModelEvent _currChangeEvent;
    private boolean _deliveringInvalidateEvents;
    private XmlModelEvent _nestedChangeEvent;
    private int _nestedListenerIndex = -1;
    private int _transactionDepth = 0;
    private int _lastDomChangeCount = 0;
    private XmlModelMessageLog _messageLog = XmlModelMessageLog.createEmptyMessageLog();
    private DomModel _domModel = null;
    private volatile boolean _inUndo = false;
    private volatile boolean _inRedo = false;
    private boolean _hadBlockingErrorsBeforeOuterTxn = true;
    private IdGenerationPlugin _idGenerationPlugin;

    public XmlModel() {
        this(null);
    }

    public XmlModel(MetadataProvider provider) {
        this._metadataProvider = provider;
        this._selection = new ModelSelection(this);
        this.addTraversalHandler(this._xmlTraversalHandler);
    }

    @Override
    public final XmlModel getBaseModel() {
        return this;
    }

    @Override
    public final XmlContext getContext() {
        return this._context;
    }

    public final long getTimestamp() {
        return this._timestamp;
    }

    @Override
    public final DomModel getDomModel() {
        if (this._domModel == null) {
            this._whitespaceHandler = this.createWhitespaceHandler();
            if (this._whitespaceHandler == null) {
                this._whitespaceHandler = new GrammarBasedWhitespaceHandler(this);
            }
            this._domModel = this._context.createDomModel(this);
        }
        return this._domModel;
    }

    @Override
    public final Document getDocument() {
        return this.getDomModel().getDocument();
    }

    public final void destroyDocument() {
        this.getDomModel().destroyDocument();
    }

    public final boolean isDocumentValid() {
        boolean isValid = true;
        this.acquireReadLock();
        try {
            this._validateDocument();
            isValid = this._validationIssues.getErrorCount() == 0 && this._validationIssues.getIncompleteCount() == 0;
        }
        finally {
            this.releaseReadLock();
        }
        return isValid;
    }

    public final XmlModelMessageIssueList getValidationIssues() {
        this._validateDocument();
        return this._validationIssues;
    }

    public final int getDocChangeCount() {
        return this.getDomModel().getDocChangeCount();
    }

    public final boolean isInTransaction() {
        return this._transactionDepth != 0;
    }

    @Override
    public final void startTransaction(TransactionOptions transOptions) {
        this.__requestStartTransaction(this, transOptions);
        if (this.__getTransactionDepth() == 1) {
            this._hadBlockingErrorsBeforeOuterTxn = this.__checkForTransactionBlockingErrors();
        }
    }

    @Override
    public final boolean commitTransaction() throws XmlCommitException {
        return this.commitTransaction(true);
    }

    public final boolean commitTransaction(boolean exceptionIfInvalid) throws XmlCommitException {
        Boolean shouldThrow = exceptionIfInvalid;
        if (shouldThrow.booleanValue() && this.__getTransactionDepth() == 1) {
            shouldThrow = !this._hadBlockingErrorsBeforeOuterTxn;
        }
        return this.__requestCommitTransaction(this, shouldThrow);
    }

    @Override
    public final void rollbackTransaction() {
        this.__requestRollbackTransaction(this);
    }

    @Override
    public final XmlMetadataResolver getXmlMetadataResolver() {
        return this._metadataResolver;
    }

    public final boolean initializeNewNode(Node node, XmlKey xmlKey) {
        String value;
        boolean required;
        SimpleType simpleType;
        boolean allRequiredAttributeHaveValue = true;
        if (node.getNodeType() != 1) {
            return this.initializeNewNodeHook(node, xmlKey, allRequiredAttributeHaveValue);
        }
        XmlMetadataResolver resolver = this.getXmlMetadataResolver();
        GrammarComponent gc = resolver.getGrammarComponent(xmlKey);
        if (gc == null || !(gc instanceof ElementDef)) {
            return this.initializeNewNodeHook(node, xmlKey, allRequiredAttributeHaveValue);
        }
        XmlContext context = this.getContext();
        ElementDef grammarElement = (ElementDef)gc;
        Element domElement = (Element)node;
        if (this.getXmlMetadataResolver().isTextDisplayedAsAttribute(xmlKey) && (simpleType = TypeUtils.getSimpleTypeAncestor((Type)grammarElement.getType())) != null) {
            try {
                String domElementString = DomUtils.getTextNodeValue((Node)domElement);
                if (domElementString == null) {
                    domElementString = "";
                }
                simpleType.validateValue(domElementString);
            }
            catch (GrammarException e) {
                allRequiredAttributeHaveValue = false;
            }
        }
        Collection grammarAttributes = grammarElement.getAttributeDefs();
        for (AttributeDef attribute : grammarAttributes) {
            String attrNamespace = attribute.getTargetNamespace();
            String attrLocalName = attribute.getName();
            XmlKey attrKey = DerivedXmlKey.createAttributeKey((GrammarResolver)context.getGrammarResolver(), (XmlKey)xmlKey, (QualifiedName)attribute.getQualifiedName()).intern();
            required = this.getXmlMetadataResolver().isRequired(attrKey, xmlKey);
            if ("".equals(attrNamespace)) {
                attrNamespace = null;
            }
            if (!this.shouldInsertInitialValue(node, attrKey)) continue;
            value = this.createAttributeValue(attrKey);
            if (value == null && required) {
                if (attribute.getFixedValue() != null) {
                    value = attribute.getFixedValue();
                } else if (attribute.getDefaultValue() != null) {
                    value = attribute.getDefaultValue();
                }
            }
            if (value != null) {
                DomUtils.setAttribute((Element)domElement, (String)attrNamespace, (String)attrLocalName, (String)value);
                continue;
            }
            if (!required) continue;
            allRequiredAttributeHaveValue = false;
        }
        Collection grammarElements = grammarElement.getElementDefs();
        for (ElementDef child : grammarElements) {
            XmlKey childKey = DerivedXmlKey.createElementKey((GrammarResolver)context.getGrammarResolver(), (XmlKey)xmlKey, (QualifiedName)child.getQualifiedName()).intern();
            if (!this.getXmlMetadataResolver().getVirtualAttributeKeys(xmlKey).contains(childKey)) continue;
            required = this.getXmlMetadataResolver().isRequired(childKey, xmlKey);
            if (!this.shouldInsertInitialValue(node, childKey)) continue;
            value = this.createValue(childKey);
            if (value == null && required && child.getFixedValue() != null) {
                value = child.getFixedValue();
            }
            if (value != null) {
                Element childNode = DomUtils.createElementNode((Document)node.getOwnerDocument(), (QualifiedName)child.getQualifiedName());
                DomUtils.setTextNodeValue((Node)childNode, (String)value);
                DomPosition position = this.findValidInsertionPosition(childKey, childNode, DomPositionFactory.inside((Node)node), xmlKey);
                DomUtils.insertNodeAtPosition((DomPosition)position, (Node)childNode);
                continue;
            }
            if (!required) continue;
            allRequiredAttributeHaveValue = false;
        }
        boolean ok = !allRequiredAttributeHaveValue ? false : this.allRequiredAttributesHaveValueHook(node, xmlKey);
        return this.initializeNewNodeHook(node, xmlKey, ok);
    }

    protected boolean initializeNewNodeHook(Node node, XmlKey key, boolean wasOk) {
        return wasOk;
    }

    public final int getTextOffset(DomPosition pos) {
        return this.getDomModel().getTextOffset(pos);
    }

    public Node surroundSelection(XmlKey surroundingKey) throws XmlCommitException {
        this.__verifyWriteLock();
        if (surroundingKey == null || surroundingKey.getNodeType() != 1) {
            throw new IllegalArgumentException("Invalid key passed to surround");
        }
        if (this.getSelection().isEmpty()) {
            return null;
        }
        return this.surroundSelectionImpl(surroundingKey);
    }

    @Override
    public Node remapNode(List oldNodePath) {
        Document currDocument = this.getDocument();
        if (currDocument == null) {
            return null;
        }
        int pathNodeCount = oldNodePath.size();
        if (pathNodeCount == 0) {
            return null;
        }
        int lastNodeIndex = pathNodeCount - 1;
        Node lastNode = (Node)oldNodePath.get(lastNodeIndex);
        Document nodeDocument = lastNode.getOwnerDocument();
        if (nodeDocument == currDocument) {
            if (DomUtils.isInDocumentHierarchy((Node)lastNode)) {
                return lastNode;
            }
            ListIterator backwardsIterator = oldNodePath.listIterator(lastNodeIndex);
            while (backwardsIterator.hasPrevious()) {
                Node currNode = (Node)backwardsIterator.previous();
                if (!DomUtils.isInDocumentHierarchy((Node)currNode)) continue;
                return currNode;
            }
            return null;
        }
        Node lastEqualNewNode = currDocument;
        Node currNewNode = lastEqualNewNode;
        for (Node currOldNode : oldNodePath) {
            String oldLocalName;
            String newLocalName;
            int oldIndex = DomUtils.getChildIndex((Node)currOldNode);
            if ((currNewNode = currNewNode.getChildNodes().item(oldIndex)) == null) break;
            short newNodeType = currNewNode.getNodeType();
            if (currOldNode.getNodeType() != newNodeType || newNodeType == 1 && !(newLocalName = DomUtils.getLocalName((Node)currNewNode)).equals(oldLocalName = DomUtils.getLocalName((Node)currOldNode))) break;
            lastEqualNewNode = currNewNode;
        }
        return lastEqualNewNode;
    }

    @Override
    public Object getService(Object selector) {
        return this.getContext().getService(selector);
    }

    public WhitespaceHandler getWhitespaceHandler() {
        assert (this._whitespaceHandler != null);
        return this._whitespaceHandler;
    }

    @Override
    public Selection getSelection() {
        return this._selection;
    }

    @Override
    public String getTranslatedString(String key) {
        ResourceBundle bundle = this.getBundle();
        if (bundle != null) {
            try {
                String translatedString = bundle.getString(key);
                return translatedString;
            }
            catch (MissingResourceException e) {
                this.getLogger().log(Level.SEVERE, "Could not find resource key:" + key + " in bundle:" + bundle);
            }
        }
        return "??" + key + "??";
    }

    @Override
    public Action getAction(String commandString) {
        Action modelAction = this._actionManager.getAction(commandString);
        if (modelAction != null) {
            return modelAction;
        }
        return this.getContext().getAction(commandString);
    }

    @Override
    public TreeWalker createTreeWalker() {
        Document modelDocument = this.getDocument();
        return DomUtils.createTreeWalker((Node)modelDocument.getDocumentElement(), (int)-1, null, null);
    }

    @Override
    public TreeTraversal getTreeTraversal() {
        return DocumentTreeTraversal.INSTANCE;
    }

    public ValidationResult getCachedURLValidationResult(URL url) {
        this.__verifyLock();
        return this._cacheUrlMap.get(url.toExternalForm());
    }

    public void removeCachedURLValidationResult(URL url) {
        this.__verifyLock();
        this._cacheUrlMap.remove(url.toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraversalData getTraversalData() {
        this.__verifyLock();
        TraversalData returnData = this._traversalData;
        if (returnData == null) {
            Object object = this._traversalDataBuildLock;
            synchronized (object) {
                returnData = this._traversalData;
                if (returnData == null) {
                    this._traversalData = returnData = this._rebuildTraversalData();
                }
            }
        }
        return returnData;
    }

    @Override
    public XmlKey getNodeXmlKey(Node node) {
        XmlKey key = this._nodeToKeyCache.get(node);
        if (key == null) {
            this.__verifyLock();
            key = DomNodeXmlKey.createImmutableXmlKey((GrammarResolver)this.getContext().getGrammarResolver(), (Node)node);
            if (this.isInModelDocumentHierarchy(node)) {
                this._nodeToKeyCache.put(node, key);
            }
        }
        return key;
    }

    public final XmlKey getElementKey(XmlKey baseKey, QualifiedName elementQName) {
        XmlKey key;
        ConcurrentHashMap newQNameMap;
        ConcurrentHashMap<Object, Object> qNameMap = this._elementXmlKeyCache.get(baseKey);
        if (qNameMap == null && (qNameMap = this._elementXmlKeyCache.putIfAbsent(baseKey, newQNameMap = new ConcurrentHashMap(4, 0.75f, 3))) == null) {
            qNameMap = newQNameMap;
        }
        if ((key = qNameMap.get(elementQName)) != null) {
            return key;
        }
        key = DerivedXmlKey.createElementKey((GrammarResolver)this._context.getGrammarResolver(), (XmlKey)baseKey, (QualifiedName)elementQName);
        qNameMap.put(elementQName, key);
        return key;
    }

    public final XmlKey getAttributeKey(XmlKey baseKey, QualifiedName attributeQName) {
        XmlKey key;
        ConcurrentHashMap newQNameMap;
        ConcurrentHashMap<Object, Object> qNameMap = this._attributeXmlKeyCache.get(baseKey);
        if (qNameMap == null && (qNameMap = this._attributeXmlKeyCache.putIfAbsent(baseKey, newQNameMap = new ConcurrentHashMap(4, 0.75f, 3))) == null) {
            qNameMap = newQNameMap;
        }
        if ((key = qNameMap.get(attributeQName)) != null) {
            return key;
        }
        key = DerivedXmlKey.createAttributeKey((GrammarResolver)this._context.getGrammarResolver(), (XmlKey)baseKey, (QualifiedName)attributeQName);
        qNameMap.put(attributeQName, key);
        return key;
    }

    public GrammarComponent getGrammarComponent(XmlKey key) {
        if (key == null) {
            return null;
        }
        Object cachedValue = this._grammarComponents.get((Object)key);
        if (_NO_GRAMMAR_FOR_KEY == cachedValue) {
            return null;
        }
        GrammarComponent grammarComp = (GrammarComponent)cachedValue;
        if (grammarComp == null) {
            if (grammarComp == null) {
                GrammarResolver resolver = this.getContext().getGrammarResolver();
                grammarComp = GrammarUtils.getGrammarComponent((GrammarResolver)resolver, (XmlKey)key);
            }
            Object cacheValue = grammarComp != null ? grammarComp : _NO_GRAMMAR_FOR_KEY;
            this._grammarComponents.put((Object)key, cacheValue);
        }
        return grammarComp;
    }

    @Override
    public final Collection deleteNodes(String transactionName, final Collection nodes, final boolean updateSelection) throws XmlCommitException {
        if (nodes == null) {
            throw new IllegalArgumentException("null nodes");
        }
        if (nodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        final Collection[] ret = new Collection[1];
        new FixedNameTransactionTask(transactionName){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                TreeTraversal traversal = XmlModel.this.getTreeTraversal();
                LinkedHashSet<DomPosition> laterSelectionCandidates = null;
                if (updateSelection) {
                    laterSelectionCandidates = new LinkedHashSet<DomPosition>();
                    for (Node node : nodes) {
                        Node prev = traversal.getPreviousSibling(node);
                        Node next = traversal.getNextSibling(node);
                        if (prev != null) {
                            laterSelectionCandidates.add(DomPositionFactory.after((Node)prev));
                        }
                        if (next == null) continue;
                        laterSelectionCandidates.add(DomPositionFactory.before((Node)next));
                    }
                }
                ArrayList nodesToDelete = nodes;
                if (nodes.size() > 1) {
                    ArrayList nodesSorted = new ArrayList(nodesToDelete);
                    DomUtils.sortByDepth((TreeTraversal)XmlModel.this.getTreeTraversal(), nodesSorted, (boolean)true);
                    nodesToDelete = nodesSorted;
                }
                ret[0] = XmlModel.this.deleteNodesImpl(nodesToDelete);
                if (laterSelectionCandidates != null) {
                    for (DomPosition candidatePos : laterSelectionCandidates) {
                        if (!XmlModel.this.isInModelDocumentHierarchy(candidatePos)) continue;
                        XmlModel.this.getSelection().set(candidatePos.getTargetNode());
                        XmlModel.this.getSelection().setCursorLocation(candidatePos);
                    }
                }
            }
        }.runThrowingXCE(this);
        return ret[0];
    }

    @Override
    public final Collection deleteNodes(String transactionName, final DomRange range, final boolean updateSelection) throws XmlCommitException {
        if (range == null) {
            throw new IllegalArgumentException("null range");
        }
        if (range.isEmptyRange()) {
            return null;
        }
        final Collection[] ret = new Collection[1];
        new FixedNameTransactionTask(transactionName){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                if (range.isInsideAttributeValue()) {
                    XmlModel.this.deleteInsideAttributeValueImpl(range);
                    ret[0] = Collections.EMPTY_LIST;
                } else {
                    Collection nodes;
                    DomPosition start = XmlModel.this.getTextPositionIfPossible(range.getStart());
                    DomPosition end = XmlModel.this.getTextPositionIfPossible(range.getEnd());
                    Node startNode = start.getTargetNode();
                    if (start.hasTextOffset() && end.hasTextOffset() && startNode == end.getTargetNode()) {
                        int startOffset = start.getTextOffset();
                        int endOffset = end.getTextOffset();
                        int textLength = ((Text)startNode).getLength();
                        if (startOffset != 0 || endOffset != textLength) {
                            XmlModel.this.deleteFromTextNode((CharacterData)startNode, startOffset, endOffset - startOffset);
                            ret[0] = Collections.singleton(startNode);
                            return;
                        }
                    }
                    if ((nodes = XmlModel.this.getNodesForDeletion(range, updateSelection)) != null && !nodes.isEmpty()) {
                        ret[0] = XmlModel.this.deleteNodesImpl(nodes);
                    }
                }
            }
        }.runThrowingXCE(this);
        return ret[0];
    }

    protected void deleteInsideAttributeValueImpl(DomRange range) {
        DomPosition start = range.getStart();
        Element owner = (Element)start.getTargetNode();
        Attr attr = DomUtils.getAttribute((Element)owner, (QualifiedName)start.getAttributeQName());
        int offset1 = start.getTextOffset();
        int offset2 = range.getEnd().getTextOffset();
        int len = offset2 - offset1;
        String oldValue = attr.getNodeValue();
        StringBuffer buf = new StringBuffer(oldValue.length() - len);
        buf.append(oldValue.substring(0, offset1));
        buf.append(oldValue.substring(offset2));
        attr.setValue(buf.toString());
    }

    protected Collection deleteNodesImpl(Collection nodes) {
        Document modelDoc = this.getDocument();
        TreeTraversal traversal = this.getTreeTraversal();
        ArrayList deleted = new ArrayList(nodes.size());
        for (Node node : nodes) {
            if (DomUtils.getOwnerDocument((Node)node) != modelDoc) {
                throw new IllegalArgumentException("node has wrong owner doc: " + node);
            }
            if (!DomUtils.isInDocumentHierarchy((TreeTraversal)traversal, (Node)node)) continue;
            this.deleteNodeImpl(node, deleted);
        }
        return deleted;
    }

    protected void deleteNodeImpl(Node node, Collection deleted) {
        if (this.getXmlMetadataResolver().isDeletable(node)) {
            Node parent = this.getTreeTraversal().getParentNode(node);
            parent.removeChild(node);
            deleted.add(node);
        }
    }

    @Override
    public final Collection insertNodes(final DomPosition location, String transactionName, final Collection nodes, final boolean updateSelection) throws XmlCommitException {
        if (location == null || nodes == null) {
            throw new IllegalArgumentException("nodes or location null!");
        }
        if (location.hasAttributeQName()) {
            throw new IllegalArgumentException("can't insert node into attribute!");
        }
        if (nodes.isEmpty()) {
            return null;
        }
        final Collection[] ret = new Collection[1];
        new FixedNameTransactionTask(transactionName){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                Document modelDoc = model.getDocument();
                if (!XmlModel.this.isInModelDocumentHierarchy(location)) {
                    throw new IllegalArgumentException("import location target is of wrong owner doc or not in hierarchy!  location=" + location + " locationTargetDoc=" + DomUtils.getOwnerDocument((Node)location.getTargetNode()) + " modelDoc=" + modelDoc);
                }
                Collection rightDocNodes = DomUtils.getNodesForOwnerDoc((Document)modelDoc, (Collection)nodes);
                Collection output = XmlModel.this.insertNodesImpl(location, rightDocNodes, updateSelection);
                if (output == null || output.isEmpty()) {
                    ret[0] = null;
                } else {
                    ret[0] = output;
                    if (!output.isEmpty()) {
                        XmlModel.this.postProcessInsertedNodes(output);
                    }
                }
            }
        }.runThrowingXCE(this);
        return ret[0];
    }

    protected boolean insertIntoAttributeValue(Collection nodes, DomPosition location) {
        Attr attr;
        if (DomUtils.isAllNodeType((Collection)nodes, (int)3) && (attr = DomUtils.getAttribute((Element)((Element)location.getTargetNode()), (QualifiedName)location.getAttributeQName())) != null) {
            String origValue = attr.getNodeValue();
            int offset = location.getTextOffset();
            StringBuffer buf = new StringBuffer(200);
            buf.append(origValue.substring(0, offset));
            for (Text text : nodes) {
                buf.append(text.getNodeValue());
            }
            buf.append(origValue.substring(offset));
            attr.setNodeValue(buf.toString());
            return true;
        }
        return false;
    }

    protected Collection insertNodesImpl(DomPosition location, Collection nodes, boolean updateSelection) throws XmlCommitException {
        DomPosition textLikeIfPossible;
        Node sourceNode;
        boolean done = false;
        LinkedList<Node> created = new LinkedList<Node>();
        if (nodes.size() == 1 && DomUtils.isText((Node)(sourceNode = (Node)nodes.iterator().next())) && (textLikeIfPossible = this.getTextPositionIfPossible(location)) != null && textLikeIfPossible.hasTextOffset()) {
            Node textTarget = textLikeIfPossible.getTargetNode();
            this.insertIntoTextNode((CharacterData)textTarget, textLikeIfPossible.getTextOffset(), sourceNode.getNodeValue());
            created.add(textTarget);
            done = true;
        }
        if (!done) {
            DomPosition nextLoc = location = this.splitAtPositionIfNeeded(location, true);
            for (Node node : nodes) {
                nextLoc = this.insertNodeImpl(nextLoc, node, created);
            }
        }
        if (updateSelection) {
            this.selectInsertedNodes(created);
        }
        return created;
    }

    protected DomPosition insertNodeImpl(DomPosition location, Node node, Collection created) throws XmlCommitException {
        DomPosition preferredPos = this.findValidInsertionPosition(null, node, location, null);
        if (preferredPos == null) {
            return location;
        }
        created.add(node);
        this.fixPrefixes(preferredPos.getContainerNode(), node);
        DomUtils.insertNodeAtPosition((DomPosition)preferredPos, (Node)node);
        if (preferredPos == location) {
            return DomPositionFactory.after((Node)node);
        }
        return location;
    }

    protected void postProcessInsertedNodes(Collection nodes) throws XmlCommitException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transferable createTransferable() {
        this.acquireReadLock();
        try {
            if (!this.getXmlMetadataResolver().isSelectionTransferable()) {
                Transferable transferable = null;
                return transferable;
            }
            Selection sel = this.getSelection();
            if (sel.hasRangeSelection()) {
                DomRange range = sel.getRangeSelection();
                if (range.isEmptyRange()) {
                    Transferable transferable = null;
                    return transferable;
                }
                if (range.isInsideAttributeValue()) {
                    Transferable transferable = this.createTransferableForAttrValueRange(range);
                    return transferable;
                }
                Transferable transferable = this.createTransferableForRange(range);
                return transferable;
            }
            Transferable transferable = this.createTransferableForNodes(sel.getSelectedNodes());
            return transferable;
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected Transferable createTransferableForAttrValueRange(DomRange range) {
        return null;
    }

    protected final Transferable createTransferableForRange(DomRange range) {
        List nodes = DomUtils.cloneRangeToList((TreeTraversal)this.getTreeTraversal(), (DomRange)range);
        return XmlTransferUtils.createDomNodesTransferable(this, nodes, range, this.getXmlMetadataResolver().isSelectionDeletable());
    }

    protected final Transferable createTransferableForNodes(Iterator nodeItor) {
        LinkedList<Node> list = new LinkedList<Node>();
        while (nodeItor.hasNext()) {
            Node node = (Node)nodeItor.next();
            if (!this.getXmlMetadataResolver().isTransferable(node)) continue;
            list.add(node);
        }
        if (list.isEmpty()) {
            return null;
        }
        return XmlTransferUtils.createDomNodesTransferable(this, list, this.getXmlMetadataResolver().isSelectionDeletable());
    }

    @Override
    public boolean isReadOnly() {
        return this.getDomModel().isReadOnly();
    }

    public final NodeCustomizationDetails getCustomizationDetails(Node node) {
        return this.getDomModel().getCustomizationDetails(node);
    }

    public final CustomizationLayer getTipCustomizationLayer() {
        return this.getDomModel().getTipCustomizationLayer();
    }

    @Override
    protected final boolean isImmutable(Node node) {
        if (this.isReadOnly()) {
            return true;
        }
        if (node == null) {
            return false;
        }
        return this.getDomModel().isImmutable(node);
    }

    @Override
    protected final boolean isDeletable(Node node) {
        if (node == null) {
            return false;
        }
        return this.getDomModel().isDeletable(node);
    }

    @Override
    protected final boolean canAddChild(DomPosition position) {
        if (position == null) {
            return false;
        }
        return this.getDomModel().canAddChild(position);
    }

    @Override
    protected final boolean canAddAttribute(Element parent, XmlKey attrKey) {
        if (parent == null || attrKey.getNodeType() != 2) {
            return false;
        }
        QualifiedName attrName = attrKey.getAttributeQName();
        if (attrName != null) {
            return this.getDomModel().canAddAttribute(parent, attrName.getNamespace(), attrName.getName());
        }
        return false;
    }

    @Override
    protected final boolean isValueModifiable(Node node) {
        if (node == null) {
            return false;
        }
        return this.getDomModel().isValueModifiable(node);
    }

    public final void fixPrefixes(Node parent, Node subtree) {
        this.fixPrefixes(parent, subtree, this.getDefaultPrefixLookup());
    }

    public void fixPrefixes(Node parent, Node subtree, DefaultPrefixLookup defaultPrefixLookup) {
        if (defaultPrefixLookup == null) {
            defaultPrefixLookup = this.getDefaultPrefixLookup();
        }
        boolean declarePrefixesOnRoot = !this.getDomModel().prefersSmallestPossibleChangeRoot();
        NamespaceUtils.fixPrefixes((Node)parent, (Node)subtree, (DefaultPrefixLookup)defaultPrefixLookup, (boolean)declarePrefixesOnRoot);
    }

    public DefaultPrefixLookup getDefaultPrefixLookup() {
        return this._prefixLookup;
    }

    public Map<String, Set<String>> getNamespacesInDoc() {
        this.__verifyLock();
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (String key : this._namespacesInDoc.keySet()) {
            map.put(key, new HashSet(this._namespacesInDoc.get(key)));
        }
        return map;
    }

    @Override
    public DomPosition convertInsertionPosition(DomPosition origPosition) {
        DomPosition betterPos = origPosition;
        if (betterPos != null) {
            Node target = betterPos.getTargetNode();
            if (DomUtils.isDocument((Node)target)) {
                betterPos = betterPos.getInsidePosition();
            } else if (betterPos.isInside() && !betterPos.hasAttributeQName() && !betterPos.hasTextOffset() && !this.getXmlMetadataResolver().canAddChild(betterPos)) {
                betterPos = betterPos.getAfterPosition();
            }
        }
        return betterPos;
    }

    public DomPosition findValidInsertionPosition(XmlKey keyToInsert, Node nodeToInsert, DomPosition requestedPosition, XmlKey containerKey) {
        Set validPositions = ProspectiveValidator.findValidInsertionPositions((ProspectiveValidationContext)this._prospectiveValidationContext, (XmlKey)keyToInsert, (Node)nodeToInsert, (DomPosition)requestedPosition, (XmlKey)containerKey);
        return ProspectiveValidator.chooseBestPosition((ProspectiveValidationContext)this._prospectiveValidationContext, (XmlKey)keyToInsert, (Node)nodeToInsert, (DomPosition)requestedPosition, (XmlKey)containerKey, (Set)validPositions);
    }

    public String createAttributeValue(XmlKey attrKey) {
        if (attrKey == null || attrKey.getAttributeQName() == null) {
            return null;
        }
        return this.createValue(attrKey);
    }

    public String createValue(XmlKey key) {
        XmlMetadataResolver resolver = this.getXmlMetadataResolver();
        String initialValue = resolver.getInitialValue(key);
        if (initialValue != null) {
            if (!initialValue.contains("{0}")) {
                return initialValue;
            }
            return this.getInitialValue(key, initialValue);
        }
        return null;
    }

    public XmlModelMessageLog getXmlModelInternalMessageLog() {
        this.__verifyLock();
        return this._messageLog;
    }

    void __sendIssueListEvent(final IssueList issueList) {
        new NonDomMutationTransactionTask(){

            @Override
            protected void performTask(AbstractModel model) {
                XmlModel.this._addPropertyChangeToCurrentChangeEvent(new PropertyChange(XmlModel.ISSUE_LIST, null, issueList));
            }
        }.run(this);
    }

    public void addNamespacesInDocumentListener(NamespacesInDocumentListener listener) {
        this._namespacesInDocumentListeners.addListener(listener);
    }

    public void removeNamespacesInDocumentListener(NamespacesInDocumentListener listener) {
        this._namespacesInDocumentListeners.removeListener(listener);
    }

    public void cacheURLValidationResult(URL url, ValidationResult result) {
        this.__verifyWriteLock();
        this._cacheUrlMap.put(url.toExternalForm(), result);
        this._addPropertyChangeToCurrentChangeEvent(new PropertyChange(URL_MAP, null, this._cacheUrlMap));
    }

    public void addTraversalHandler(TraversalHandler handler) {
        this._traversalHandlers.add(handler);
        this._clearTraversalData();
    }

    public boolean removeTraversalHandler(TraversalHandler handler) {
        boolean removed = this._traversalHandlers.remove(handler);
        if (removed) {
            this._clearTraversalData();
        }
        return removed;
    }

    @Override
    public final void acquireReadLock() {
        if (this.getDomModel().getLockStatus() == 0) {
            this.getContext().__onLockRequest();
        }
        this.getDomModel().acquireReadLock();
        this.getContext().getAnnotationModel().acquireReadLock();
    }

    @Override
    public final void releaseReadLock() {
        this.getDomModel().releaseReadLock();
        this.getContext().getAnnotationModel().releaseReadLock();
    }

    public String getInitialValue(XmlKey key, String initialValue) {
        String elementLocalName = key.getElementQName().getName();
        initialValue = initialValue.replaceAll("\\{localName\\}", elementLocalName);
        Integer i = XmlModelUtils.getUniqueInteger(this, key);
        initialValue = initialValue.replaceAll("\\{0\\}", i.toString());
        return initialValue;
    }

    protected List getViewExtraContextMenus(XmlView view, DomPosition viewPosition) {
        if (view == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getContext().getDefaultExtraContextMenus(view, viewPosition);
    }

    protected void contextAttached() {
    }

    protected void postAttachmentHook() {
        this.initActions();
    }

    protected void postCreationHook() {
    }

    protected void initActions() {
        Action gotoDeclaration;
        XmlContext context = this.getContext();
        Action gotoSource = context.createModelAction("gotosource", this);
        if (gotoSource != null) {
            this.addAction(gotoSource);
        }
        if ((gotoDeclaration = context.createModelAction("gotodeclaration", this)) != null) {
            this.addAction(gotoDeclaration);
        }
    }

    protected void addAction(Action action) {
        this._actionManager.manageAction(action);
    }

    protected void addCurrentPropertiesToEvent(Map propertyChanges, boolean isAdding) {
        super.addCurrentPropertiesToEvent(propertyChanges, isAdding);
        this._validateDocument();
        propertyChanges.put(VALIDATION_ISSUES, new PropertyChange(VALIDATION_ISSUES, new ValidationHandler(this, MessageCategory.GRAMMAR_VALIDITY), this._validationIssues));
        propertyChanges.put(ISSUE_LIST, new PropertyChange(ISSUE_LIST, null, this.getXmlModelInternalMessageLog()));
    }

    protected void copiedNodeFilter(Node copiedNode, Node parentNode, Node beforeNode) {
    }

    protected final ResourceBundle getBundle() {
        return this._bundle;
    }

    protected XmlMetadataResolver createMetadataResolver(MetadataProvider provider) {
        XmlMetadataEvaluator evaluator = new XmlMetadataEvaluator(provider, this._context.getGrammarProvider(), this._context.getGrammarResolver(), this);
        return new XmlMetadataResolver((MetadataEvaluator)evaluator, this);
    }

    protected ResourceBundle createBundle() throws MissingResourceException {
        return this.getContext().getBundle();
    }

    protected ResourceBundle createBundle(String bundleName) throws MissingResourceException {
        XmlContext context = this.getContext();
        return new PaternalResourceBundle(new ResourceBundle[]{ResourceBundle.getBundle(bundleName, context.getLocale()), context.getBundle()});
    }

    protected WhitespaceHandler createWhitespaceHandler() {
        return null;
    }

    protected void handleModelInvalidateEvent(XmlModelEvent event) {
        if (this._doesEventInvalidateXmlKeyCache(event)) {
            this._nodeToKeyCache.clear();
        }
    }

    private boolean _doesEventInvalidateXmlKeyCache(XmlModelEvent event) {
        if (event.matchesFlags(6)) {
            return true;
        }
        return XmlModelUtils.fixedAttributeMightHaveChanged(event);
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
    }

    protected boolean shouldInsertInitialValue(Node ownerNode, XmlKey key) {
        if (key.getNodeType() == 2) {
            QualifiedName qn = key.getAttributeQName();
            NamedNodeMap attrs = ownerNode.getAttributes();
            Node attr = attrs.getNamedItemNS(qn.getNamespace(), qn.getName());
            return attr == null || attr.getNodeValue() == null;
        }
        if (key.getNodeType() == 1) {
            QualifiedName qn = key.getElementQName();
            Node child = DomUtils.getNamedChild((Node)ownerNode, (String)qn.getNamespace(), (String)qn.getName());
            return child == null ? true : DomUtils.getTextNodeValue((Node)child) == null;
        }
        return false;
    }

    protected Node determineValidationRoot() {
        return this.getDocument();
    }

    protected void setValidationFeatures(ValidationContext validationContext) {
    }

    protected Node surroundSelectionImpl(XmlKey surroundingKey) throws XmlCommitException {
        return XmlModelUtils.surroundSelection(this, surroundingKey);
    }

    @Override
    protected void commentOutImpl(DomRange range, boolean escapeDashDash) {
        this.getDomModel().commentOut(range, escapeDashDash);
    }

    @Override
    protected void uncommentImpl(DomRange range) {
        this.getDomModel().uncomment(range);
    }

    @Override
    protected void mergeTextNodesImpl(Text a, Text b) {
        AbstractModel.MapperForMergeTextNodes mapper = new AbstractModel.MapperForMergeTextNodes(a, b);
        this.getDomModel().mergeTextNodes(a, b);
        mapper.applyMappings();
    }

    @Override
    protected Text splitTextNodeImpl(Text orig, int offset) {
        AbstractModel.MapperForSplitTextNode mapper = new AbstractModel.MapperForSplitTextNode(orig, offset);
        Text created = this.getDomModel().splitTextNode(orig, offset);
        mapper.setCreated(created);
        mapper.applyMappings();
        return created;
    }

    protected boolean allRequiredAttributesHaveValueHook(Node node, XmlKey key) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void __attachContext(XmlContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context passed to XmlModel");
        }
        if (this._context != null) {
            throw new IllegalStateException("Cannot attach a context twice");
        }
        this._context = context;
        this._context.addLifecycleListener(new XmlContextLifecycleListener(){

            @Override
            public void preContextDisposal(XmlContext context) {
                XmlModel.this._context.getGrammarResolver().removeGrammarResolverListener(XmlModel.this._grammarListener);
            }
        });
        this._actionManager = new ActionManager(context);
        ResourceBundle bundle = null;
        try {
            bundle = this.createBundle();
        }
        catch (MissingResourceException e) {
            this.getLogger().log(Level.WARNING, "No resource bundle for model", e);
        }
        this._bundle = bundle;
        GrammarResolver grammarResolver = context.getGrammarResolver();
        if (this._metadataProvider == null) {
            this._metadataProvider = new GrammarMetadataProvider(grammarResolver);
        }
        grammarResolver.addGrammarResolverListener(this._grammarListener);
        DomModel domModel = this.getDomModel();
        this._metadataResolver = this.createMetadataResolver(this._metadataProvider);
        this.acquireReadLock();
        try {
            this._prefixLookup = new MetadataBasedPrefixLookup(this._metadataResolver);
            DeferredParseIssueList parseIssues = new DeferredParseIssueList();
            this._updateParseIssuesInMessageLog(parseIssues);
        }
        finally {
            this.releaseReadLock();
        }
        DomListener listener = new DomListener();
        domModel.addDomChangeListener(listener);
        domModel.addUndoableEditListener(listener);
        domModel.addDomMutationListener(listener);
        this.acquireReadLock();
        try {
            this._lastDomChangeCount = domModel.getDocChangeCount();
        }
        finally {
            this.releaseReadLock();
        }
        this._selection.__attachToDomModel();
        this._selection.addSelectionChangeListener(listener);
        this._selection.addPropertyChangeListener(listener);
        this._prospectiveValidationContext = new XmlModelProspectiveValidationContext();
        this.addModelListener(new NamespaceSetChecker());
        this.addGrammarModelListener();
        VersionManager versionManager = this._context.getVersionManager();
        if (versionManager != null) {
            versionManager.attachToModel(this);
        }
    }

    protected void addGrammarModelListener() {
        this.addModelListener(new InstanceGrammarListener());
    }

    void __initializationComplete() {
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            LogUtils.log((Logger)log, (Level)Level.FINER, (String)"__initComplete on model {0}, context {1}, thread {2}", (Object[])new Object[]{this, this._context, Thread.currentThread()}, (Throwable)new Throwable("stack trace"));
        }
        this._validateDocument();
        AnnotationModel annotationModel = this.getContext().getAnnotationModel();
        annotationModel.acquireWriteLock();
        try {
            this.markAsFullyInstantiatedAndDeliverInitialEvent();
        }
        finally {
            annotationModel.releaseWriteLock();
        }
    }

    final void __addUndoableEditListener(UndoableEditListener l) {
        this._undoListeners.addListener(l);
    }

    final void __removeUndoableEditListener(UndoableEditListener l) {
        this._undoListeners.removeListener(l);
    }

    @Override
    final void __acquireWriteLock() {
        this.getDomModel().acquireWriteLock();
    }

    @Override
    final void __releaseWriteLock() {
        this.getDomModel().releaseWriteLock();
    }

    @Override
    final void __verifyLock() {
        this.getDomModel().verifyLock();
    }

    @Override
    final void __verifyWriteLock() {
        this.getDomModel().verifyWriteLock();
    }

    final int __getTransactionDepth() {
        return this._transactionDepth;
    }

    final void __requestStartTransaction(AbstractModel requestingModel, TransactionOptions transOptions) {
        assert (requestingModel.getBaseModel() == this) : "requestingModel " + requestingModel + " doesn't belong to " + this;
        this.getContext().__startTransaction(requestingModel, transOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void __startTransaction(TransactionOptions transOptions) {
        block25: {
            if (this.getDomModel().getLockStatus() == 0) {
                this.getContext().__onLockRequest();
            }
            String description = transOptions.getDescription();
            this._transactionLog("start ", description);
            this.acquireReadLock();
            try {
                if (this._transactionDepth == 0) {
                    this._preTransactionSelectionState = new SelectionStateRef(this.getSelection());
                }
            }
            catch (IllegalArgumentException iae) {
                this.getLogger().log(Level.WARNING, "Exception creating pre-txn state", iae);
                this._preTransactionSelectionState = new SelectionStateRef();
            }
            finally {
                this.releaseReadLock();
            }
            this.getDomModel().startTransaction(transOptions);
            boolean rollbackDomModelTransaction = true;
            try {
                if (this._deliveringInvalidateEvents) {
                    throw new IllegalStateException("Illegal starting of transaction while delivering invalidate events");
                }
                if (this.isDeliveringHelloGoodbyeEvents()) {
                    throw new IllegalStateException("Illegal starting of transaction while delivering listenerAttached/listenerDetached events");
                }
                if (transOptions.isInEditCut()) {
                    this._addPropertyChangeToCurrentChangeEvent(new PropertyChange("InEditCut", null, transOptions.isInEditCut()));
                }
                if (transOptions.isInEditPaste()) {
                    this._addPropertyChangeToCurrentChangeEvent(new PropertyChange("InEditPaste", null, transOptions.isInEditPaste()));
                }
                ++this._transactionDepth;
                boolean ok = false;
                try {
                    this.getSelection().__startTransaction();
                    ok = true;
                }
                finally {
                    if (!ok) {
                        --this._transactionDepth;
                    }
                }
                if (!ok) break block25;
                ok = false;
                try {
                    this.getContext().getAnnotationModel().startTransaction(transOptions);
                    ok = true;
                    rollbackDomModelTransaction = false;
                }
                finally {
                    if (!ok) {
                        --this._transactionDepth;
                        this.getSelection().__rollbackTransaction();
                    }
                }
            }
            finally {
                if (rollbackDomModelTransaction) {
                    this.getDomModel().rollbackTransaction();
                }
            }
        }
    }

    final PrecommitResults __precommitTransaction(PrecommitOptions precommitOptions) {
        DomCommitException domException;
        Node changeTarget;
        if (this._transactionDepth == 0) {
            throw new IllegalStateException("No transaction open on:" + this);
        }
        if (this._deliveringInvalidateEvents) {
            throw new IllegalStateException("No starting transaction while delivering invalidate events");
        }
        boolean validationSucceeded = true;
        DomModel domModel = this.getDomModel();
        if (domModel.isInTopLevelTransaction() && (changeTarget = domModel.getChangeTarget()) != null) {
            List<XmlModelMessage> blockingErrors;
            NodeChangeDetails nodeChangeDetails;
            if (this.isReadOnly()) {
                return PrecommitResults.createFailedResult(new XmlReadOnlyException(this));
            }
            if (this.getIdGenerationPlugin() != null && this.getDomModel().hasModifications() && (nodeChangeDetails = this.getDomModel().getNodeChangeDetails()) != null) {
                IdGenerationTask.run(new IdGenerationContext(this, nodeChangeDetails), this.getIdGenerationPlugin());
            }
            if (!(validationSucceeded = (blockingErrors = this._getTransactionBlockingErrors()).isEmpty())) {
                XmlCommitException validationException = null;
                validationException = this.getDocument() == null ? new XmlNoDocumentOnCommitException(this) : new XmlInvalidOnCommitException(this, blockingErrors, true);
                if (precommitOptions.requiresValidModel()) {
                    return PrecommitResults.createFailedResult(validationException);
                }
            }
        }
        if ((domException = domModel.precommitTransaction()) != null) {
            return PrecommitResults.createFailedResult(new XmlDomCommitException(this, domException));
        }
        AnnotationCommitException fatalException = this.getContext().getAnnotationModel().precommitTransaction(precommitOptions);
        if (fatalException != null) {
            return PrecommitResults.createFailedResult(fatalException);
        }
        return PrecommitResults.createSuccesfulResult(validationSucceeded);
    }

    final PrecommitResults __requestPrecommitTransaction(AbstractModel requestingModel, PrecommitOptions precommitOptions) {
        assert (requestingModel.getBaseModel() == this) : "requestingModel " + requestingModel + " doesn't belong to " + this;
        return this.getContext().__precommitTransaction(requestingModel, precommitOptions);
    }

    protected final IdGenerationPlugin getIdGenerationPlugin() {
        if (this._idGenerationPlugin == null) {
            this._idGenerationPlugin = this.createIdGenerationPlugin();
        }
        return this._idGenerationPlugin;
    }

    public final void setIdGenerationPlugin(IdGenerationPlugin idGenerationPlugin) {
        this._idGenerationPlugin = idGenerationPlugin;
    }

    protected IdGenerationPlugin createIdGenerationPlugin() {
        return null;
    }

    final boolean __requestCommitTransaction(AbstractModel requestingModel, boolean exceptionIfInvalid) throws XmlCommitException {
        assert (requestingModel.getBaseModel() == this) : "requestingModel " + requestingModel + " doesn't belong to " + this;
        return this.getContext().__commitTransaction(requestingModel, exceptionIfInvalid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void __commitTransaction() {
        TransactionToken transToken = null;
        if (this._transactionDepth == 1 && (transToken = this.getContext().getTransactionToken()) == null && (transToken = this.getContext().createTransactionToken()) != null) {
            this.getContext().setTransactionToken(transToken);
        }
        --this._transactionDepth;
        DomModel domModel = this.getDomModel();
        AnnotationModel annotationModel = this.getContext().getAnnotationModel();
        this.__acquireWriteLock();
        boolean success = false;
        try {
            annotationModel.acquireWriteLock();
            try {
                annotationModel.commitTransaction(transToken);
                this.getSelection().commitTransaction();
                domModel.commitTransaction();
                this._deliverCurrentChangeEvents();
                this._transactionLog("commit OK; isValid=", this._validationIssues.getErrorCount() == 0);
                success = true;
                annotationModel.releaseWriteLock();
            }
            catch (Throwable innerE) {
                try {
                    this._transactionLog("commit threw exception", null, innerE);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    annotationModel.releaseWriteLock();
                }
            }
        }
        catch (Throwable e) {
            this._transactionLog("commit threw exception", null, e);
        }
        finally {
            if (!success) {
                this.getContext().__setAbortFlag(this);
            }
            this.__releaseWriteLock();
        }
    }

    final void __rollbackTransaction() {
        if (this._transactionDepth == 0) {
            throw new IllegalStateException("No transaction open on:" + this);
        }
        --this._transactionDepth;
        this.getContext().getAnnotationModel().rollbackTransaction();
        this.getSelection().__rollbackTransaction();
        this._resetValidationStatus(true);
        if (this._transactionDepth == 0) {
            this._currChangeEvent = null;
        }
        DomModel dom = this.getDomModel();
        dom.rollbackTransaction();
        this._transactionLog("rollback");
    }

    final void __requestRollbackTransaction(AbstractModel requestingModel) {
        assert (requestingModel.getBaseModel() == this) : "requestingModel " + requestingModel + " doesn't belong to " + this;
        this.getContext().__rollbackTransaction(requestingModel);
    }

    final void __deliverPendingXmlModelEventIfNeeded() {
        this.__acquireWriteLock();
        try {
            this._deliverCurrentChangeEvents();
        }
        finally {
            this.__releaseWriteLock();
        }
    }

    final void __propogateAnnotationModelChangedEvent(AnnotationModelEvent annEvent) {
        this.__verifyWriteLock();
        if (this.isFullyInstantiated()) {
            PropertyChange change = new PropertyChange(ANNOTATION_MODEL_CHANGED_PROPERTY, null, annEvent);
            this._addPropertyChangeToCurrentChangeEvent(change);
            if (!this.getDomModel().isInTransaction()) {
                this._deliverCurrentChangeEvents();
            }
        }
    }

    private void _deliverCurrentChangeEvents() {
        this.__verifyWriteLock();
        AnnotationModel annotationModel = this.getContext().getAnnotationModel();
        annotationModel.acquireWriteLock();
        try {
            this.getListenerManager().executeEventDeliveryTask(new ModelChangeEventTask());
        }
        finally {
            annotationModel.releaseWriteLock();
        }
    }

    private void _transactionLog(Object msg) {
        this._transactionLog(msg, null);
    }

    private void _transactionLog(Object msg, Object msg2) {
        this._transactionLog(msg, msg2, null);
    }

    private void _transactionLog(Object msg, Object msg2, Throwable t) {
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            StringBuffer buf = new StringBuffer("XmlModel transaction: ");
            for (int i = 0; i < this._transactionDepth * 2; ++i) {
                buf.append(' ');
            }
            buf.append(msg);
            if (msg2 != null) {
                buf.append(msg2);
            }
            buf.append(" txnDepth=" + this._transactionDepth);
            buf.append(" curEvent=" + this._currChangeEvent);
            log.log(Level.FINER, buf.toString(), t);
        }
    }

    private PropertyChange _createMessageLogPropertyChange() {
        return new PropertyChange(ISSUE_LIST, null, this.getXmlModelInternalMessageLog());
    }

    private TraversalData _rebuildTraversalData() {
        MutableTraversalData data = new MutableTraversalData();
        this._handleNode(this.getTreeTraversal(), this.getDocument(), data);
        return data;
    }

    private void _handleNode(TreeTraversal traversal, Node node, MutableTraversalData data) {
        this._handleStartNode(node, data);
        Node child = traversal.getFirstChild(node);
        while (child != null) {
            this._handleNode(traversal, child, data);
            child = traversal.getNextSibling(child);
        }
        this._handleEndNode(node, data);
    }

    private void _handleStartNode(Node node, MutableTraversalData data) {
        for (TraversalHandler handler : this._traversalHandlers) {
            handler.handleStartNode(this, node, data);
        }
    }

    private void _handleEndNode(Node node, MutableTraversalData data) {
        for (TraversalHandler handler : this._traversalHandlers) {
            handler.handleEndNode(this, node, data);
        }
    }

    private void _validateDocument() {
        this.acquireReadLock();
        try {
            this._validateSubtree(this.determineValidationRoot());
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void _validateSubtree(Node validationRoot) {
        XmlModelMessageIssueList oldValidationIssues = this._validationIssues;
        if (!this._isValidStatusCurrent) {
            boolean createDeferred = false;
            if (!this._firstValidationRequested) {
                this._firstValidationRequested = true;
                createDeferred = true;
            }
            if (this._validationIssues instanceof DeferredValidationIssueList) {
                DeferredValidationIssueList deferredList = (DeferredValidationIssueList)this._validationIssues;
                boolean bl = createDeferred = !deferredList.hasDelegateBeenCreated();
            }
            if (createDeferred) {
                this._validationIssues = new DeferredValidationIssueList();
            } else {
                ValidationHandler validationHandler = new ValidationHandler(this, MessageCategory.GRAMMAR_VALIDITY);
                this._validationIssues = validationHandler;
                this._validateSubtreeHelper(validationHandler, validationRoot);
            }
        }
        this._updateModelValidity(oldValidationIssues, this._validationIssues);
    }

    private void _validateSubtreeHelper(ValidationHandler validationHandler, Node validationRoot) {
        if (this.getDocument() == null) {
            try {
                validationHandler.fatalError(new SAXParseException(this.getTranslatedString("XML_MODEL_INVALID.NO_ROOT_REASON"), null));
            }
            catch (SAXException saxe) {
                throw new RuntimeException(saxe);
            }
        } else {
            boolean isValid = true;
            if (validationRoot != null) {
                ModelValidationContext validationContext = new ModelValidationContext(this, this._nodeToKeyCache, validationHandler);
                this.setValidationFeatures((ValidationContext)validationContext);
                long validationTimePre = System.currentTimeMillis();
                isValid = Validator.validateSubtree((ValidationContext)validationContext, (Node)validationRoot);
                long validationTimePost = System.currentTimeMillis();
                this.getLogger().log(Level.FINER, "XmlModel Validation Completed For: " + this.getContext() + " : " + (validationTimePost - validationTimePre) + "ms");
            }
        }
    }

    private void _updateCurrentChangeEvent(Node changeRoot, int changeFlags, Map propertyChanges, Set selectionsAdded, Set selectionsRemoved, List domChanges, NodeChangeDetails details) {
        XmlModelEvent newEvent;
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            LogUtils.log((Logger)log, (Level)Level.FINER, (String)"XmlModel event update: oldEvent={0} root={1} flags={2}", (Object[])new Object[]{this._currChangeEvent, changeRoot, changeFlags}, (Throwable)new RuntimeException("stack trace"));
        }
        if ((newEvent = new XmlModelEvent(this, changeRoot, changeFlags, propertyChanges, selectionsAdded, selectionsRemoved, domChanges, details)).isDomTreeChanged() || newEvent.isDomDocumentChanged()) {
            this._clearTraversalData();
        }
        if (this._currChangeEvent == null) {
            this._currChangeEvent = newEvent;
        } else {
            this._currChangeEvent.addModelEvent(newEvent);
        }
    }

    private void _addPropertyChangeToCurrentChangeEvent(PropertyChange newChange) {
        if (newChange == null) {
            return;
        }
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            LogUtils.log((Logger)log, (Level)Level.FINER, (String)"XmlModel event add propchange: oldEvent={0} newchange={1}", (Object[])new Object[]{this._currChangeEvent, newChange}, (Throwable)new RuntimeException("stack trace"));
        }
        Map<String, PropertyChange> newChangeMap = Collections.singletonMap(newChange.getPropertyName(), newChange);
        if (this._currChangeEvent != null) {
            this._currChangeEvent.addPropertyChanges(newChangeMap);
        } else {
            this._currChangeEvent = new XmlModelEvent(this);
            this._currChangeEvent.addPropertyChanges(newChangeMap);
        }
    }

    private void _deliverUndoableEditEvent(UndoableEditEvent undoEvent) {
        Iterator itor = this._undoListeners.iterator();
        while (itor.hasNext()) {
            try {
                ((UndoableEditListener)itor.next()).undoableEditHappened(undoEvent);
            }
            catch (Throwable e) {
                this.getLogger().log(Level.WARNING, "Unexpected exception when delivering UndoableEditEvent", e);
            }
        }
    }

    private void _updateModelValidity(XmlModelMessageIssueList oldValidationIssues, XmlModelMessageIssueList newValidationIssues) {
        this._isValidStatusCurrent = true;
        this._messageLog = XmlModelMessageLog.createUpdatedMessageLog(this._messageLog, MessageCategory.GRAMMAR_VALIDITY, newValidationIssues);
        if (oldValidationIssues != newValidationIssues) {
            this._addPropertyChangeToCurrentChangeEvent(new PropertyChange(VALIDATION_ISSUES, oldValidationIssues, newValidationIssues));
        }
    }

    private void _resetValidationStatus(boolean clearCurrValidationState) {
        Logger log;
        this._isValidStatusCurrent = false;
        if (clearCurrValidationState) {
            this._validationIssues = new ValidationHandler(this, MessageCategory.GRAMMAR_VALIDITY);
        }
        if ((log = this.getLogger()).isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, "XmlModel reset validation status", new RuntimeException("stack trace"));
        }
    }

    private void _clearTraversalData() {
        this._traversalData = null;
    }

    private void _updateParseIssuesInMessageLog(XmlModelMessageIssueList parseIssueList) {
        this._messageLog = XmlModelMessageLog.createUpdatedMessageLog(this._messageLog, MessageCategory.PARSING, parseIssueList);
    }

    private XmlModelMessageIssueList _convertParseProblemsToParseIssuesList(List<DomParseProblem> parseProblems) {
        SimpleXmlModelMessageIssueList parseIssueList = new SimpleXmlModelMessageIssueList();
        if (parseProblems != null) {
            Iterator<DomParseProblem> itor = parseProblems.iterator();
            while (itor.hasNext()) {
                parseIssueList.addMessage(new DomParseProblemMessage(this, itor.next()));
            }
        }
        return parseIssueList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean __checkForTransactionBlockingErrors() {
        block5: {
            this.acquireReadLock();
            try {
                this._validateDocument();
                if (!this._validationIssues.hasErrors()) break block5;
                for (XmlModelMessage message : this._validationIssues.getMessages()) {
                    if (message.getSeverity() != Severity.ERROR || message.couldBeResolvedByAddingNodes()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.releaseReadLock();
            }
        }
        return false;
    }

    private List<XmlModelMessage> _getTransactionBlockingErrors() {
        this._validateDocument();
        if (this._validationIssues.hasErrors()) {
            ArrayList<XmlModelMessage> blockers = new ArrayList<XmlModelMessage>(this._validationIssues.getErrorCount());
            for (XmlModelMessage message : this.getValidationIssues().getMessages()) {
                if (message.getSeverity() != Severity.ERROR || message.couldBeResolvedByAddingNodes()) continue;
                blockers.add(message);
            }
            return blockers;
        }
        return Collections.emptyList();
    }

    static {
        MetadataSchemaRegistry.getInstance().registerSchema(XmlMetadataResolver.class.getResource("metadata/XmlModelMetadata.xsd"));
    }

    private class GrammarListener
    implements GrammarResolverListener {
        private GrammarListener() {
        }

        public void grammarResolverChanged(GrammarResolverEvent e) {
            XmlModel.this._grammarComponents.clear();
            XmlModel.this._elementXmlKeyCache.clear();
            XmlModel.this._attributeXmlKeyCache.clear();
            XmlModel.this._clearTraversalData();
            if (!XmlModel.this.isInTransaction()) {
                XmlModel.this.getDomModel().forceReparse();
            }
        }
    }

    private static class SelectionStateRef {
        private final DomPositionRef _cursor;
        private final NodeRef[] _selectedNodeRefs;
        private final DomPositionRef _rangeStart;
        private final DomPositionRef _rangeEnd;

        public SelectionStateRef() {
            this._cursor = null;
            this._selectedNodeRefs = null;
            this._rangeStart = null;
            this._rangeEnd = null;
        }

        public SelectionStateRef(Selection sel) {
            this._cursor = DomPositionRefFactory.get(sel.getCursorLocation());
            if (sel.hasRangeSelection()) {
                this._selectedNodeRefs = null;
                DomRange range = sel.getRangeSelection();
                this._rangeStart = DomPositionRefFactory.get(range.getStart());
                this._rangeEnd = DomPositionRefFactory.get(range.getEnd());
            } else {
                this._selectedNodeRefs = new NodeRef[sel.size()];
                int i = 0;
                Iterator<Node> itor = sel.getSelectedNodes();
                while (itor.hasNext()) {
                    Node node = itor.next();
                    this._selectedNodeRefs[i] = NodeRefFactory.getNodeRef((Node)node);
                    ++i;
                }
                this._rangeStart = null;
                this._rangeEnd = null;
            }
        }

        public void restore(Selection sel) {
            Document doc = sel.getSelectionDocument();
            if (this._cursor != null) {
                sel.setCursorLocation(this._cursor.getCorrespondingPosition(doc));
            }
            if (this._selectedNodeRefs != null && this._selectedNodeRefs.length > 0) {
                ArrayList<Node> nodes = new ArrayList<Node>(this._selectedNodeRefs.length);
                for (int i = 0; i < this._selectedNodeRefs.length; ++i) {
                    nodes.add(this._selectedNodeRefs[i].getCorrespondingNode(doc));
                }
                sel.set(nodes);
            }
            if (this._rangeStart != null && this._rangeEnd != null) {
                DomRange range = sel.createDomRange(this._rangeStart.getCorrespondingPosition(doc), this._rangeEnd.getCorrespondingPosition(doc));
                sel.setRangeSelection(range);
            }
        }
    }

    private class MetadataBasedPrefixLookup
    implements DefaultPrefixLookup {
        private XmlMetadataResolver _resolver;

        public MetadataBasedPrefixLookup(XmlMetadataResolver resolver) {
            this._resolver = resolver;
        }

        public String getDefaultPrefix(String namespace) {
            XmlKey nsKey = ImmutableXmlKey.createNamespaceKey((String)namespace);
            if (this._resolver.isPreferNamespaceDeclarations(nsKey)) {
                return null;
            }
            return this._resolver.getPreferredPrefix(nsKey);
        }
    }

    private class DeferredParseIssueList
    extends AbstractDelegatingIssueList
    implements XmlModelMessageIssueList {
        @Override
        public boolean hasErrors() {
            return ((XmlModelMessageIssueList)this.getDelegate()).hasErrors();
        }

        @Override
        public boolean hasWarnings() {
            return ((XmlModelMessageIssueList)this.getDelegate()).hasWarnings();
        }

        @Override
        public boolean hasIncompletes() {
            return ((XmlModelMessageIssueList)this.getDelegate()).hasIncompletes();
        }

        @Override
        public List<XmlModelMessage> getMessages() {
            return ((XmlModelMessageIssueList)this.getDelegate()).getMessages();
        }

        @Override
        protected IssueList getDelegateImpl() {
            XmlModel.this.getDomModel().verifyLock();
            List parseProblems = XmlModel.this.getDomModel().getCurrentDomParseProblems();
            XmlModelMessageIssueList parseIssues = XmlModel.this._convertParseProblemsToParseIssuesList(parseProblems);
            return parseIssues;
        }
    }

    private class DomListener
    implements DomModelListener,
    PropertyChangeListener,
    SetChangeListener,
    UndoableEditListener,
    DomMutationListener {
        private transient boolean _openBufferSelectionTransaction;

        private DomListener() {
        }

        @Override
        public void setChanged(SetChangeEvent event) {
            XmlModel.this._updateCurrentChangeEvent(null, 0, null, event.getAddedObjects(), event.getRemovedObjects(), null, null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            XmlModel.this._addPropertyChangeToCurrentChangeEvent(new PropertyChange(event));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modelChanged(DomModelEvent changeEvent) {
            PropertyChange domProblemsChange;
            boolean eventHadDomProblems;
            if (!XmlModel.this.isFullyInstantiated()) {
                return;
            }
            if (changeEvent.isTextBufferModified() && !this._openBufferSelectionTransaction) {
                XmlModel.this.getSelection().__startTransaction();
                this._openBufferSelectionTransaction = true;
            }
            boolean bl = eventHadDomProblems = (domProblemsChange = changeEvent.getPropertyChange("parseProblems")) != null;
            if (eventHadDomProblems) {
                List parseProbs = (List)domProblemsChange.getNewValue();
                XmlModelMessageIssueList parseIssues = XmlModel.this._convertParseProblemsToParseIssuesList(parseProbs);
                XmlModel.this._updateParseIssuesInMessageLog(parseIssues);
                Logger log = XmlModel.this.getLogger();
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "XmlModel WFCheck change: {0}", domProblemsChange);
                }
            }
            DomModel domModel = XmlModel.this.getDomModel();
            XmlModel.this._timestamp = System.currentTimeMillis();
            int oldCount = XmlModel.this._lastDomChangeCount;
            XmlModel.this._lastDomChangeCount = domModel.getDocChangeCount();
            PropertyChange documentChange = changeEvent.getPropertyChange("documentChanged");
            if (documentChange != null) {
                Document newDocument = (Document)documentChange.getNewValue();
                XmlModel.this._resetValidationStatus(false);
                XmlModel.this._validateSubtree(newDocument);
            }
            if (changeEvent.isDomTreeChanged()) {
                XmlModel.this._addPropertyChangeToCurrentChangeEvent(new PropertyChange(XmlModel.DOC_CHANGE_COUNT_PROPERTY, IntegerUtils.getInteger((int)oldCount), IntegerUtils.getInteger((int)XmlModel.this._lastDomChangeCount)));
            }
            XmlModel.this._updateCurrentChangeEvent(changeEvent.getChangeRoot(), changeEvent.getChangeFlags(), null, null, null, changeEvent.getDomChanges(), changeEvent.getNodeChangeDetails());
            XmlModel.this._addPropertyChangeToCurrentChangeEvent(changeEvent.getDocumentPropertyChange());
            if (changeEvent.getReadOnlyPropertyChange() != null) {
                XmlModel.this._addPropertyChangeToCurrentChangeEvent(new PropertyChange("readOnly", null, XmlModel.this.isReadOnly()));
            }
            XmlModel.this.__acquireWriteLock();
            try {
                if (!domModel.isInTransaction()) {
                    if (!changeEvent.isTextBufferModified()) {
                        if (this._openBufferSelectionTransaction) {
                            XmlModel.this.getSelection().commitTransaction();
                            this._openBufferSelectionTransaction = false;
                        }
                        XmlModel.this._deliverCurrentChangeEvents();
                    } else if (XmlModel.this._currChangeEvent.getChangeFlags() != 0) {
                        XmlModel.this._deliverCurrentChangeEvents();
                    }
                }
            }
            finally {
                XmlModel.this.__releaseWriteLock();
            }
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent domUndoableEditEvent) {
            if (XmlModel.this._inUndo || XmlModel.this._inRedo) {
                LogUtils.log((Logger)XmlModel.this.getLogger(), (Level)Level.SEVERE, (String)"Got undoable edit while in undo/redo! This can't work, see bug 3981855. Dropping second edit, but undo stack is in inconsistent state.\nnew edit={0}", (Object)domUndoableEditEvent.getEdit().getPresentationName(), (Throwable)new Throwable("stack trace where edit was sent from"));
                return;
            }
            UndoableEditEvent modelUndoableEditEvent = new UndoableEditEvent(XmlModel.this, new DomUndoableEditWrapper(XmlModel.this, domUndoableEditEvent.getEdit()));
            XmlModel.this._deliverUndoableEditEvent(modelUndoableEditEvent);
        }

        @Override
        public void domMutated(DomModel domModel, DomChange change, MutationEvent mEvent) {
            XmlModel.this._resetValidationStatus(false);
        }
    }

    private class XmlModelProspectiveValidationContext
    extends ProspectiveValidationContext {
        public XmlKey getNodeXmlKey(Node node) {
            return XmlModel.this.getNodeXmlKey(node);
        }

        public GrammarComponent getGrammarComponent(XmlKey xmlKey) {
            return XmlModel.this.getGrammarComponent(xmlKey);
        }

        public Comparator getInsertionComparator(Node node) {
            return XmlModel.this.getXmlMetadataResolver().getInsertionComparator(node);
        }

        public GrammarResolver getGrammarResolver() {
            return XmlModel.this.getContext().getGrammarResolver();
        }
    }

    private class NamespaceSetChecker
    extends XmlModelAdapter {
        private NamespaceSetChecker() {
        }

        @Override
        public void modelChanged(XmlModelEvent event) {
            if (event.matchesFlags(2) || event.getDomDocumentPropertyChange() != null || XmlModel.this._namespacesInDoc == Collections.EMPTY_MAP) {
                this._scanEntireDocument(false);
            } else if (event.matchesFlags(1)) {
                Node root = event.getChangeRoot();
                if (root != null) {
                    Map namespacesInSubtree = DomUtils.getNamespacesMapInSubtree((Node)root);
                    HashSet<String> namespacesInSubtreeKeys = new HashSet<String>(namespacesInSubtree.keySet());
                    for (String key : namespacesInSubtree.keySet()) {
                        Set prefixes = (Set)namespacesInSubtree.get(key);
                        if (XmlModel.this._namespacesInDoc.containsKey(key)) {
                            XmlModel.this._namespacesInDoc.get(key).addAll(prefixes);
                            namespacesInSubtreeKeys.remove(key);
                            continue;
                        }
                        XmlModel.this._namespacesInDoc.put(key, prefixes);
                    }
                    this._fire(namespacesInSubtreeKeys, Collections.EMPTY_SET, false);
                } else {
                    this._scanEntireDocument(false);
                }
            }
        }

        @Override
        public void listenerAttached(XmlModelEvent event) {
            this._scanEntireDocument(true);
        }

        private void _scanEntireDocument(boolean initialParse) {
            Document doc = XmlModel.this.getDocument();
            if (doc != null) {
                Set<String> oldSet = XmlModel.this._namespacesInDoc.keySet();
                XmlModel.this._namespacesInDoc = DomUtils.getNamespacesMapInSubtree((Node)doc);
                HashSet<String> added = new HashSet<String>();
                HashSet<String> removed = new HashSet<String>();
                CollectionUtils.computeAddRemoveSets(oldSet, XmlModel.this._namespacesInDoc.keySet(), added, removed);
                this._fire(added, removed, initialParse);
            }
        }

        private void _fire(Set<String> addedNamespaces, Set<String> removedNamespaces, boolean initialParse) {
            Iterator itor;
            Logger log = XmlModel.this.getLogger();
            if (!initialParse && addedNamespaces.isEmpty() && removedNamespaces.isEmpty()) {
                return;
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "NamespaceSetChange: added={0} removed={1}", new Object[]{addedNamespaces, removedNamespaces});
            }
            if (!(itor = XmlModel.this._namespacesInDocumentListeners.iterator()).hasNext()) {
                return;
            }
            NamespacesInDocumentChangeEvent event = new NamespacesInDocumentChangeEvent(XmlModel.this, addedNamespaces, removedNamespaces);
            while (itor.hasNext()) {
                NamespacesInDocumentListener listener = (NamespacesInDocumentListener)itor.next();
                try {
                    if (initialParse) {
                        listener.initialNamespacesInDocument(event);
                        continue;
                    }
                    listener.namespacesInDocumentChanged(event);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    if (!log.isLoggable(Level.SEVERE)) continue;
                    LogRecord record = new LogRecord(Level.SEVERE, "Namespace change listener {0} threw exception during  event delivery. model={1} added={2} removed={3}");
                    record.setThrown(t);
                    record.setParameters(new Object[]{listener, XmlModel.this, addedNamespaces, removedNamespaces});
                    log.log(record);
                }
            }
        }
    }

    private class ModelChangeEventTask
    extends EventDeliveryTask {
        private ModelChangeEventTask() {
        }

        @Override
        public void execute(List<XmlModelListener> attachedListeners, List<XmlModelListener> pendingAddListeners, List<XmlModelListener> pendingRemoveListeners) {
            XmlModel.this.__verifyWriteLock();
            if (XmlModel.this._deliveringInvalidateEvents) {
                throw new IllegalStateException("No spawning XmlModelEvents during invalidation phase");
            }
            if (XmlModel.this._transactionDepth > 0) {
                return;
            }
            DomModel domModel = XmlModel.this.getDomModel();
            XmlModelEvent changeEvent = XmlModel.this._currChangeEvent;
            XmlModel.this._currChangeEvent = null;
            if (changeEvent == null) {
                changeEvent = new XmlModelEvent(XmlModel.this);
            }
            if (changeEvent.getChangeFlags() == 0) {
                this._deliverModelChangeEventHelper(changeEvent, attachedListeners, pendingRemoveListeners);
                return;
            }
            changeEvent.setInUndo(XmlModel.this._inUndo);
            changeEvent.setInRedo(XmlModel.this._inRedo);
            if (changeEvent.isDomTreeChanged()) {
                PropertyChange pc = XmlModel.this._createMessageLogPropertyChange();
                changeEvent.addPropertyChanges(Collections.singletonMap(pc.getPropertyName(), pc));
            }
            XmlModel.this.getLogger().log(Level.FINER, "XmlModel deliver: {0}", changeEvent);
            if (domModel.isInTransaction()) {
                String desc = domModel.getTransactionDescription();
                if (desc == null) {
                    desc = "[No transaction description provided]";
                }
                XmlModel.this.getLogger().log(Level.SEVERE, "Unexpected event:" + changeEvent + " with open DomModel transaction " + desc + "; depth=" + XmlModel.this._transactionDepth, new IllegalStateException());
                XmlModel.this._currChangeEvent = changeEvent;
                return;
            }
            XmlModel.this._deliveringInvalidateEvents = true;
            try {
                XmlModel.this.handleModelInvalidateEvent(changeEvent);
            }
            catch (Throwable e) {
                XmlModel.this.getLogger().log(Level.INFO, "Unexpected throwable", e);
            }
            this.deliverEventHelper(attachedListeners, changeEvent, (short)2);
            XmlModel.this._deliveringInvalidateEvents = false;
            try {
                XmlModel.this.handleModelChangeEvent(changeEvent);
            }
            catch (Throwable e) {
                XmlModel.this.getLogger().log(Level.INFO, "Unexpected throwable", e);
            }
            this._deliverModelChangeEventHelper(changeEvent, attachedListeners, pendingRemoveListeners);
        }

        private void _deliverModelChangeEventHelper(XmlModelEvent changeEvent, List<XmlModelListener> attachedListeners, List<XmlModelListener> pendingRemoveListeners) {
            XmlModel.this.__verifyWriteLock();
            if (!attachedListeners.isEmpty()) {
                int nextEventIndex;
                if (XmlModel.this._nestedChangeEvent != null) {
                    nextEventIndex = XmlModel.this._nestedListenerIndex + 1;
                    XmlModel.this._nestedEvents.addFirst(XmlModel.this._nestedChangeEvent.clone());
                    XmlModel.this._nestedEvents.addFirst(IntegerUtils.getInteger((int)XmlModel.this._nestedListenerIndex));
                } else {
                    nextEventIndex = attachedListeners.size();
                }
                XmlModelEvent currChangeEvent = changeEvent;
                int currListenerIndex = 0;
                for (XmlModelListener currListener : attachedListeners) {
                    if (currListenerIndex == nextEventIndex) {
                        XmlModel.this._nestedEvents.removeFirst();
                        XmlModelEvent lastChangeEvent = (XmlModelEvent)XmlModel.this._nestedEvents.removeFirst();
                        lastChangeEvent.addModelEvent(currChangeEvent);
                        currChangeEvent = lastChangeEvent;
                        currChangeEvent.prepareForDelivery();
                        nextEventIndex = XmlModel.this._nestedEvents.size() > 0 ? (Integer)XmlModel.this._nestedEvents.getFirst() + 1 : attachedListeners.size();
                    }
                    XmlModel.this._nestedChangeEvent = currChangeEvent;
                    XmlModel.this._nestedListenerIndex = currListenerIndex;
                    try {
                        if (!pendingRemoveListeners.contains(currListener)) {
                            if (currChangeEvent.getChangeFlags() == 0) {
                                currListener.noChange(currChangeEvent);
                            } else {
                                currListener.modelChanged(currChangeEvent);
                            }
                        }
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        XmlModel.this.getLogger().log(Level.WARNING, "Unexpected exception notifying model listener: " + currListener, t);
                    }
                    ++currListenerIndex;
                    if (XmlModel.this._nestedListenerIndex != -1) continue;
                    break;
                }
            }
            XmlModel.this._nestedChangeEvent = null;
            XmlModel.this._nestedListenerIndex = -1;
        }
    }

    private class DeferredValidationIssueList
    extends AbstractDelegatingIssueList
    implements XmlModelMessageIssueList {
        @Override
        public boolean hasErrors() {
            return ((XmlModelMessageIssueList)this.getDelegate()).hasErrors();
        }

        @Override
        public boolean hasWarnings() {
            return ((XmlModelMessageIssueList)this.getDelegate()).hasWarnings();
        }

        @Override
        public boolean hasIncompletes() {
            return ((XmlModelMessageIssueList)this.getDelegate()).hasIncompletes();
        }

        @Override
        public List<XmlModelMessage> getMessages() {
            return ((XmlModelMessageIssueList)this.getDelegate()).getMessages();
        }

        @Override
        protected IssueList getDelegateImpl() {
            XmlModel.this.getDomModel().verifyLock();
            ValidationHandler validationHandler = new ValidationHandler(XmlModel.this, MessageCategory.GRAMMAR_VALIDITY);
            Node validationRoot = XmlModel.this.determineValidationRoot();
            XmlModel.this._validateSubtreeHelper(validationHandler, validationRoot);
            return validationHandler;
        }
    }

    private static class DomUndoableEditWrapper
    implements UndoableEdit,
    DomModelHolder {
        private final UndoableEdit _domEdit;
        private final SelectionStateRef _selectionStatePostUndo;
        private SelectionStateRef _selectionStatePostRedo;
        private final boolean _isSourceModel;

        public DomUndoableEditWrapper(XmlModel model, UndoableEdit domEdit) {
            if (domEdit == null) {
                throw new IllegalArgumentException("DOM UndoableEdit required");
            }
            this._domEdit = domEdit;
            this._selectionStatePostUndo = model._preTransactionSelectionState;
            this._selectionStatePostRedo = new SelectionStateRef(model.getSelection());
            this._isSourceModel = model == model.getContext().getSourceModel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undo() throws CannotUndoException {
            XmlModel model = this._getModel();
            if (model == null) {
                this._domEdit.undo();
            } else {
                model.__acquireWriteLock();
                try {
                    block8: {
                        model._inUndo = true;
                        Selection modelSelection = model.getSelection();
                        modelSelection.__startTransaction();
                        try {
                            this._domEdit.undo();
                            this._selectionStatePostUndo.restore(modelSelection);
                            modelSelection.commitTransaction();
                        }
                        catch (Throwable t) {
                            modelSelection.__rollbackTransaction();
                            if (t instanceof Error) {
                                throw (Error)t;
                            }
                            if (!(t instanceof RuntimeException)) break block8;
                            throw (RuntimeException)t;
                        }
                    }
                    model._validateDocument();
                    model._deliverCurrentChangeEvents();
                }
                finally {
                    model._inUndo = false;
                    model.__releaseWriteLock();
                }
            }
        }

        @Override
        public boolean canUndo() {
            return this._domEdit.canUndo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redo() throws CannotRedoException {
            XmlModel model = this._getModel();
            if (model == null) {
                this._domEdit.redo();
            } else {
                model.__acquireWriteLock();
                try {
                    model._inRedo = true;
                    Selection modelSelection = model.getSelection();
                    modelSelection.__startTransaction();
                    boolean transactionCommitted = false;
                    try {
                        this._domEdit.redo();
                        this._selectionStatePostRedo.restore(modelSelection);
                        modelSelection.commitTransaction();
                        transactionCommitted = true;
                    }
                    finally {
                        if (!transactionCommitted) {
                            modelSelection.__rollbackTransaction();
                        }
                    }
                    model._validateDocument();
                    model._deliverCurrentChangeEvents();
                }
                finally {
                    model._inRedo = false;
                    model.__releaseWriteLock();
                }
            }
        }

        @Override
        public boolean canRedo() {
            return this._domEdit.canRedo();
        }

        @Override
        public void die() {
            this._domEdit.die();
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            if (anEdit instanceof DomUndoableEditWrapper) {
                DomUndoableEditWrapper other = (DomUndoableEditWrapper)anEdit;
                if (this._domEdit.addEdit(other._domEdit)) {
                    this._selectionStatePostRedo = other._selectionStatePostRedo;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean replaceEdit(UndoableEdit anEdit) {
            return false;
        }

        @Override
        public boolean isSignificant() {
            return this._domEdit.isSignificant();
        }

        @Override
        public String getPresentationName() {
            return this._domEdit.getPresentationName();
        }

        @Override
        public String getUndoPresentationName() {
            return this._domEdit.getUndoPresentationName();
        }

        @Override
        public String getRedoPresentationName() {
            return this._domEdit.getRedoPresentationName();
        }

        public String toString() {
            return "DomEditWrapper:\n  " + this._domEdit.toString() + "\n  model=" + this._getModel();
        }

        @Override
        public DomModel getDomModel() {
            if (this._domEdit instanceof DomModelHolder) {
                return ((DomModelHolder)((Object)this._domEdit)).getDomModel();
            }
            return null;
        }

        private XmlModel _getModel() {
            DomModel dom = this.getDomModel();
            if (dom != null && dom.getContext() instanceof XmlContext) {
                XmlContext context = (XmlContext)dom.getContext();
                if (this._isSourceModel) {
                    return context.getSourceModel();
                }
                return context.getModel();
            }
            return null;
        }
    }
}

