/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.beanmodel.BeanBaseRegistry;
import oracle.bali.xml.beanmodel.versioning.VersionManager;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.buffer.parser.DocumentScanner;
import oracle.bali.xml.dom.buffer.parser.XmlDocumentScanner;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.instance.XmlInstanceGrammarProvider;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.NullMetadataProvider;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.PrecommitOptions;
import oracle.bali.xml.model.PrecommitResults;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContextReference;
import oracle.bali.xml.model.XmlContextSetupHook;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.XmlViewFactory;
import oracle.bali.xml.model.action.ActionManager;
import oracle.bali.xml.model.action.ClearAction;
import oracle.bali.xml.model.action.CopyAction;
import oracle.bali.xml.model.action.CutAction;
import oracle.bali.xml.model.action.DuplicateAction;
import oracle.bali.xml.model.action.PasteAction;
import oracle.bali.xml.model.annotation.AnnotationGrammar;
import oracle.bali.xml.model.annotation.AnnotationMetadataResolver;
import oracle.bali.xml.model.annotation.AnnotationModel;
import oracle.bali.xml.model.annotation.AnnotationModelEvent;
import oracle.bali.xml.model.annotation.AnnotationModelListener;
import oracle.bali.xml.model.annotation.impl.NullAnnotationGrammar;
import oracle.bali.xml.model.annotation.impl.NullAnnotationModel;
import oracle.bali.xml.model.datatransfer.AugmentingClipboardManager;
import oracle.bali.xml.model.datatransfer.operation.OperationManager;
import oracle.bali.xml.model.datatransfer.operation.StandardOperationFactory;
import oracle.bali.xml.model.event.XmlContextLifecycleListener;
import oracle.bali.xml.model.listenerImpl.XmlModelListenerManager;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.bali.xml.model.view.IdentityView;
import oracle.bali.xml.preference.Preference;
import oracle.bali.xml.preference.XmlPreferenceManager;
import oracle.bali.xml.preference.XmlTransientPreferencesManager;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.MultiUndoableEdit;
import oracle.bali.xml.share.NoOpUndoableEdit;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.share.clipboard.ClipboardManager;
import oracle.bali.xml.share.clipboard.StandaloneClipboardManager;
import oracle.bali.xml.util.ContextualActionProvider;
import oracle.bali.xml.util.NodeCreator;
import oracle.bali.xml.util.NodeCustomizer;
import oracle.bali.xml.util.XmlCustomizeAction;
import oracle.javatools.datatransfer.DataTransferPluginRegistry;
import oracle.javatools.logging.LogUtils;
import oracle.javatools.status.IssueList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class XmlContext
extends DomModelContext {
    public static final String CUT_COMMAND = "cut";
    public static final String COPY_COMMAND = "copy";
    public static final String PASTE_COMMAND = "paste";
    public static final String PASTE_SPECIAL_COMMAND = "paste_special";
    public static final String DUPLICATE_COMMAND = "duplicate";
    public static final String CLEAR_COMMAND = "clear";
    public static final String REFRESH_COMMAND = "refresh";
    public static final String GOTO_SOURCE_COMMAND = "gotosource";
    public static final String GOTO_DECLARATION_COMMAND = "gotodeclaration";
    public static final String GOTO_PROPERTIES_COMMAND = "gotoproperties";
    public static final String UNDO_COMMAND = "undo";
    public static final String REDO_COMMAND = "redo";
    public static final String NEXT_NODE_COMMAND = "nextNode";
    public static final String PREV_NODE_COMMAND = "prevNode";
    public static final String NEXT_INSERTION_POS_COMMAND = "nextInsertionPos";
    public static final String PREV_INSERTION_POS_COMMAND = "prevInsertionPos";
    public static final String NEXT_SIBLING_INSERTION_POS_COMMAND = "nextSiblingInsertionPos";
    public static final String PREV_SIBLING_INSERTION_POS_COMMAND = "prevSiblingInsertionPos";
    public static final String PARENT_INSERTION_POS_COMMAND = "parentInsertionPos";
    public static final String FIRST_CHILD_INSERTION_POS_COMMAND = "firstChildInsertionPos";
    public static final String CUSTOMIZE_NODE_COMMAND = "customizeNode";
    public static final String CONVERT_NODE_COMMAND = "convertNode";
    public static final String SURROUND_NODE_COMMAND = "surroundNode";
    public static final String SURROUND_NODE_JDEV_COMMAND = "surroundNodeJDev";
    public static final String SHOW_AS_TOP_COMMAND = "showAsTop";
    public static final String SELECT_TOP_COMMAND = "selectTop";
    public static final String COLLAPSE_ALL_BELOW_COMMAND = "collapseAllBelow";
    public static final String EXPAND_ALL_BELOW_COMMAND = "expandAllBelow";
    public static final String ACTION_MUTATES_MODEL_PROPERTY = "XmlContext.MUTATES_MODEL";
    public static final String ACTION_HIDE_WHEN_DISABLED_PROPERTY = "XmlContext._HIDE_WHEN_DISABLED";
    public static final String ACTIVE_VIEW_PROPERTY = "XmlContext.ACTIVE_VIEW";
    public static final String CLIPBOARD_FLAVORS_PROPERTY = "XmlContext.CLIPBOARD_FLAVORS";
    public static final String CONTEXT_SECTION_ID_ACTION_PROPERTY = "XmlContext.CONTEXT_SECTION_ID_ACTION_PROPERTY";
    public static final Float INSERTION_SECTION_ID_VALUE = Float.valueOf(5.0f);
    public static final Float GOTO_ELEMENT_SECTION_ID_VALUE = Float.valueOf(6.0f);
    public static final String CONTEXT_SECTION_WEIGHT = "XmlContext.CONTEXT_SECTION_WEIGHT";
    public static final Object BASE_TYPE_WEBAPP_ROOT = new String("webapp root");
    public static final String TRANSLATION_VALIDATION = "XMLEF_FEATURE.TRANSLATION_VALIDATION";
    private static final Object _UNSET_VALUE = new Object();
    private static final String _SAVE_TRANSACTION_STACKS_SYSTEM_PROPERTY = "oracle.bali.xml.transactionStacks";
    private static final ClipboardManager _STANDALONE_CLIPBOARD_MANAGER = new StandaloneClipboardManager();
    private static CopyOnWriteArrayList<XmlContextSetupHook> _sSetupHookList = new CopyOnWriteArrayList();
    private static Object _sSetupHookListLock = new Object();
    private static XmlContextSetupHook _NULL_SETUP_HOOK = new NullXmlContextSetupHook();
    private volatile int _alreadyNotifiedSetupHooksSize = -1;
    private final ListenerImpls _listenerImpls = new ListenerImpls();
    private final ActionManager _actionManager;
    private volatile boolean _isDisposed = false;
    private ResourceBundle _bundle;
    private XmlView _activeView;
    private IdentityView[] _identityViews = new IdentityView[8];
    private XmlModel _flattenedModel;
    private XmlModel _sourceModel;
    private AnnotationModel _annotationModel;
    private AnnotationGrammar _annotationGrammar;
    private AnnotationMetadataResolver _annotationMetadataResolver;
    private final AnnotationModelListener _annotationModelListener = new XmlContextAnnotationModelListener();
    private XmlPreferenceManager _preferenceManager;
    private GrammarProvider _grammarProvider;
    private GrammarResolver _grammarResolver;
    private PreferenceChangeListenersManager _prefChangeListenerManager;
    private TransactionToken _token = null;
    private VersionManager _versionManager;
    private List<BeanBaseRegistry> _beanRegistries = null;
    private final ClipboardManager _clipboardManager;
    private final Logger _logger;
    private final LinkedList<XmlViewFactory> _viewFactories;
    private final Set _propertyChangeListeners = new HashSet(5);
    private final Map _views = new HashMap();
    private final SafeListenerManager _lifecycleListeners = new SafeListenerManager();
    private final transient List _mappingList = new ArrayList(20);
    private transient ArrayList _propertyChangeListenersList = null;
    private transient ArrayList _transactionOwners = new ArrayList(10);
    private final SafeListenerManager _undoListeners = new SafeListenerManager();
    private final DataTransferPluginRegistry _dataTransferPluginRegistry = new DataTransferPluginRegistry();
    private final List _currUndoableEdits = new ArrayList(3);
    private final OperationManager _opManager = new OperationManager(this);
    private static transient boolean _sSaveTransactionStackTraces;
    private final Set<ContextualActionProvider> _globalContextualActionProviders = new CopyOnWriteArraySet<ContextualActionProvider>();
    private static final ThreadLocal<Map<XmlUsage, XmlView>> _sViewThreadLocalMap;

    public XmlContext() {
        this._logger = this.createLogger();
        this._viewFactories = new LinkedList();
        this._viewFactories.add(new XmlViewFactory());
        this._actionManager = new ActionManager(this);
        this._clipboardManager = new AugmentingClipboardManager(this, this.getUnderlyingClipboardManager());
    }

    public final void finishInitialization() {
        this._bundle = this.createBundle();
        this.initActions();
        this.initOperations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSetupHook(XmlContextSetupHook hook) {
        if (hook == null) {
            throw new IllegalArgumentException("registerSetupHook called with null hook");
        }
        Object object = _sSetupHookListLock;
        synchronized (object) {
            if (_sSetupHookList.contains(hook)) {
                XmlContext.logSetupHookRegistrationError(hook, "Illegal attempt to register the same XmlContextSetupHook instance twice: XmlContextSetupHook={0}");
                return;
            }
            _sSetupHookList.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterSetupHook(XmlContextSetupHook hook) {
        if (hook == null) {
            throw new IllegalArgumentException("unregisterSetupHook called with null hook");
        }
        Object object = _sSetupHookListLock;
        synchronized (object) {
            int index = _sSetupHookList.indexOf(hook, 0);
            if (index == -1) {
                XmlContext.logSetupHookRegistrationError(hook, "Illegal attempt to unregister an XmlContextSetupHook instance that was not registered: XmlContextSetupHook={0}");
                return;
            }
            _sSetupHookList.set(index, _NULL_SETUP_HOOK);
        }
    }

    private void _initializeModel(XmlModel model) {
        model.__attachContext(this);
        model.__acquireWriteLock();
        try {
            this._preferenceManager = this.createPreferenceManager(model.getClass().getName());
            this._prefChangeListenerManager = new PreferenceChangeListenersManager(this);
            model.__addUndoableEditListener(this._listenerImpls);
            model.contextAttached();
            model.postAttachmentHook();
            this.deliverSetupEventAtXmlContextCreation();
            model.__initializationComplete();
            model.postCreationHook();
        }
        finally {
            model.__releaseWriteLock();
        }
    }

    public final void setModel(XmlModel model) {
        try {
            this._flattenedModel = model;
            this._setSourceModel(model);
        }
        catch (RuntimeException e) {
            this._flattenedModel = null;
            throw e;
        }
        this.modelAttachmentComplete();
    }

    public final void setModels(XmlModel sourceModel, XmlModel flattenedModel) {
        if (sourceModel == flattenedModel) {
            this.setModel(sourceModel);
        } else {
            this._setSourceModel(sourceModel);
            this._setFlattenedModel(flattenedModel);
            this.modelAttachmentComplete();
        }
    }

    public final XmlModel getModel() {
        return this._flattenedModel;
    }

    public final XmlModel getSourceModel() {
        return this._sourceModel;
    }

    public XmlModel getRelatedXmlModel(URL url) {
        return null;
    }

    public XmlContextReference getXmlContextReference() {
        return new XmlContextReference(this);
    }

    public final void addUndoableEditListener(UndoableEditListener l) {
        this._undoListeners.addListener(l);
    }

    public final void removeUndoableEditListener(UndoableEditListener l) {
        this._undoListeners.removeListener(l);
    }

    @Override
    public final Node remapNode(Document targetDocument, Node node) {
        Document ownerDocument = node.getOwnerDocument();
        if (ownerDocument == targetDocument) {
            return node;
        }
        return this._mapNodeToDocument(targetDocument, node);
    }

    public final Node sourceToFlattened(Node sourceNode) {
        if (this._sourceModel == this._flattenedModel) {
            return sourceNode;
        }
        return this._mapNodeToDocument(this._flattenedModel.getDomModel().getDocument(), sourceNode);
    }

    public Node flattenedToSource(Node flattenedNode) {
        if (this._sourceModel == this._flattenedModel) {
            return flattenedNode;
        }
        return this._mapNodeToDocument(this._sourceModel.getDomModel().getDocument(), flattenedNode);
    }

    public OperationManager getOperationManager() {
        return this._opManager;
    }

    public final GrammarProvider getGrammarProvider() {
        if (this._grammarProvider == null) {
            this._grammarProvider = this.createGrammarProvider();
        }
        return this._grammarProvider;
    }

    public final GrammarResolver getGrammarResolver() {
        if (this._grammarResolver == null) {
            this._grammarResolver = this.createGrammarResolver();
        }
        return this._grammarResolver;
    }

    public DocumentScanner createDocumentScanner() {
        return new XmlDocumentScanner();
    }

    public final VersionManager getVersionManager() {
        if (this._versionManager == null) {
            this._versionManager = this.createVersionManager();
        }
        return this._versionManager;
    }

    public final List<BeanBaseRegistry> getBeanRegistries() {
        if (this._beanRegistries == null) {
            this._beanRegistries = this.createBeanRegistries();
        }
        return this._beanRegistries;
    }

    public final AnnotationModel getAnnotationModel() {
        if (this._annotationModel == null) {
            this._annotationModel = this.createAnnotationModel();
            this._annotationModel.addModelListener(this._annotationModelListener);
        }
        return this._annotationModel;
    }

    public final AnnotationGrammar getAnnotationGrammar() {
        if (this._annotationGrammar == null) {
            this._annotationGrammar = this.createAnnotationGrammar();
        }
        return this._annotationGrammar;
    }

    public final AnnotationMetadataResolver getAnnotationMetadataResolver() {
        if (this._annotationMetadataResolver == null) {
            this._annotationMetadataResolver = this.createAnnotationMetadataResolver();
        }
        return this._annotationMetadataResolver;
    }

    public IssueList getIssueList() {
        XmlModel model = this.getModel();
        if (model != null) {
            return model.getXmlModelInternalMessageLog();
        }
        return null;
    }

    public Action getAction(String command) {
        return this._actionManager.getAction(command);
    }

    public Action createModelAction(String command, AbstractModel model) {
        return null;
    }

    public Action[] getActions(String[] commands) {
        int commandCount = commands.length;
        Action[] actions = new Action[commandCount];
        for (int i = 0; i < commandCount; ++i) {
            actions[i] = this.getAction(commands[i]);
        }
        return actions;
    }

    public XmlPreferenceManager getPreferenceManager() {
        return this._preferenceManager;
    }

    public abstract URL getURLForRelativePath(String var1);

    public abstract String getRelativePathForURL(URL var1);

    public abstract URL getURL();

    public Object getPreferenceValue(Preference preference) {
        return this._preferenceManager.getPreferenceValue(preference);
    }

    public void setPreferenceValue(Preference preference, Object value) {
        this._preferenceManager.setPreferenceValue(preference, value);
        this.getPreferenceManager().storePreferenceManagerToDisk();
    }

    public Object getTransientPreferenceValue(Preference preference) {
        return XmlTransientPreferencesManager.getInstance().getPreferenceValue(preference);
    }

    public void addPreferenceChangeListener(PropertyChangeListener listener) {
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "PrefChange: added listener to {0}: {1}", new Object[]{this, listener});
        }
        this._prefChangeListenerManager.addListener(listener);
    }

    public void removePreferenceChangeListener(PropertyChangeListener listener) {
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "PrefChange: removed listener from {0}: {1}", new Object[]{this, listener});
        }
        this._prefChangeListenerManager.removeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        boolean isNew = this._propertyChangeListeners.add(listener);
        if (!isNew) {
            throw new IllegalStateException("No adding the same listener twice:" + listener);
        }
        this._propertyChangeListenersList = null;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        boolean wasPresent = this._propertyChangeListeners.remove(listener);
        if (!wasPresent) {
            throw new IllegalStateException("No removing listeners that were never added:" + listener);
        }
        this._propertyChangeListenersList = null;
    }

    @Override
    public Locale getLocale() {
        return Locale.getDefault();
    }

    public String getHelpTopic(Node node, XmlKey key) {
        return null;
    }

    public Set getCurrentTechnologyKeys() {
        return Collections.EMPTY_SET;
    }

    @Override
    public String getTranslatedString(String key) {
        ResourceBundle bundle = this.getBundle();
        if (bundle != null) {
            try {
                String translatedString = bundle.getString(key);
                return translatedString;
            }
            catch (MissingResourceException e) {
                this.getLogger().log(Level.SEVERE, "Could not find resource key:" + key + " in bundle:" + bundle);
            }
        }
        return "??" + key + "??";
    }

    public void ensureXmlModelIsSynchronized() {
        this.getModel().acquireReadLock();
        this.getModel().releaseReadLock();
    }

    public final AbstractModel getActiveAbstractModel() {
        XmlView view = this.getActiveView();
        if (view != null) {
            return view;
        }
        return this.getModel();
    }

    public XmlView getActiveView() {
        return this._activeView;
    }

    public void setActiveView(XmlView activeView) {
        XmlView oldView = this._activeView;
        this._activeView = activeView;
        this.firePropertyChange(ACTIVE_VIEW_PROPERTY, oldView, activeView);
    }

    public final XmlView getExistingView(XmlUsage usage) {
        return (XmlView)this._views.get(usage);
    }

    public final XmlView getView(final XmlUsage usage) {
        XmlView storedView;
        XmlView cachedView = this.getExistingView(usage);
        if (cachedView != null) {
            return cachedView;
        }
        Map<XmlUsage, XmlView> threadLocal = _sViewThreadLocalMap.get();
        if (threadLocal != null && (storedView = threadLocal.get(usage)) != null) {
            return storedView;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Map<XmlUsage, XmlView> threadLocal;
                XmlView createdView = XmlContext.this.getExistingView(usage);
                if (createdView != null) {
                    return;
                }
                Iterator<XmlViewFactory> factoryItor = XmlContext.this.getViewFactories().iterator();
                XmlModel targetModel = XmlContext.this.getModel();
                while (createdView == null && factoryItor.hasNext()) {
                    XmlViewFactory factory = factoryItor.next();
                    createdView = factory.createView(targetModel, usage);
                }
                if (createdView == null) {
                    createdView = XmlContext.this.__getIdentityView(targetModel);
                }
                if ((threadLocal = _sViewThreadLocalMap.get()) == null) {
                    threadLocal = new LinkedHashMap<XmlUsage, XmlView>();
                }
                threadLocal.put(usage, createdView);
                final XmlView view = createdView = XmlContext.this._initializeViewIfNecessary(targetModel, createdView);
                XmlContext.this.deliverLifecycleEvent(new LifecycleEventDeliverer(){

                    @Override
                    public void deliverToListener(XmlContextLifecycleListener listener) {
                        listener.postViewSetup(usage, view);
                    }
                });
                XmlContext.this._views.put(usage, view);
            }
        };
        XmlModelListenerManager.runUnderListenerLock(this.getModel(), runnable);
        return this.getExistingView(usage);
    }

    public void registerViewFactory(XmlViewFactory factory) {
        if (factory != null && !this._viewFactories.contains(factory)) {
            this._viewFactories.addFirst(factory);
        }
    }

    public final ClipboardManager getClipboardManager() {
        return this._clipboardManager;
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void showErrorMessage(String message) {
        this.showErrorMessage(message, null, null);
    }

    public void showErrorMessage(String message, String title, Throwable t) {
        this.getLogger().log(Level.WARNING, message, t);
    }

    public NodeCreator getDefaultNodeCreator(XmlKey key) {
        return null;
    }

    public NodeCustomizer getDefaultNodeCustomizer(XmlKey key) {
        return null;
    }

    public final void dispose() {
        if (this.isDisposed()) {
            this.getLogger().log(Level.WARNING, "Dispose cannot be called on a XmlContext that has already been disposed");
            return;
        }
        this.deliverLifecycleEvent(new LifecycleEventDeliverer(){

            @Override
            public void deliverToListener(XmlContextLifecycleListener listener) {
                listener.preContextDisposal(XmlContext.this);
            }
        });
        this.disposeImpl();
    }

    public final boolean isDisposed() {
        return this._isDisposed;
    }

    public final void addLifecycleListener(XmlContextLifecycleListener listener) {
        this._lifecycleListeners.addListener(listener);
    }

    public final void removeLifecycleListener(XmlContextLifecycleListener listener) {
        this._lifecycleListeners.removeListener(listener);
    }

    public final DataTransferPluginRegistry getDataTransferPluginRegistry() {
        return this._dataTransferPluginRegistry;
    }

    public final TransactionToken getTransactionToken() {
        this._sourceModel.__verifyLock();
        return this._token;
    }

    public final void setTransactionToken(TransactionToken token) {
        this._requireInTransaction();
        if (token != this._token) {
            if (!(token == null ^ this._token == null)) {
                throw new IllegalStateException("tried to change token from " + this._token + " to " + token);
            }
            this._token = token;
            if (this._token != null) {
                this._token.setOwnerIfUnset(this);
                String desc = !this._currUndoableEdits.isEmpty() ? ((UndoableEdit)this._currUndoableEdits.get(0)).getPresentationName() : this._sourceModel.getDomModel().getTransactionDescription();
                this._token.setNameIfUnset(desc);
            }
        }
    }

    public TransactionToken createTransactionToken() {
        return null;
    }

    public final PrecommitResults precommitTransaction(XmlModel model, PrecommitOptions precommitOptions) {
        if (model == null) {
            throw new IllegalArgumentException("precommitTransaction: model cannot be null");
        }
        return model.__precommitTransaction(precommitOptions);
    }

    public final void registerGlobalContextualActionProvider(ContextualActionProvider provider) {
        this._globalContextualActionProviders.add(provider);
    }

    public final Iterable<ContextualActionProvider> getGlobalContextualActionProviders() {
        return Collections.unmodifiableCollection(this._globalContextualActionProviders);
    }

    public final URL getBaseUrl(Object baseType, Node contextNode) {
        if (baseType == null) {
            throw new IllegalArgumentException("null base type");
        }
        return this.getBaseUrlImpl(baseType, contextNode);
    }

    public boolean supportsFeature(String feature) {
        return TRANSLATION_VALIDATION.equals(feature);
    }

    public void addNoOpUndoableEdit(String description) {
        if (this._sourceModel.getDomModel().isInTransaction()) {
            this._currUndoableEdits.add(new NoOpUndoableEdit(description));
        }
    }

    protected static void logSetupHookRegistrationError(XmlContextSetupHook hook, String message) {
        Logger logger = Logger.getLogger("oracle.bali.xml.model");
        if (logger.isLoggable(Level.WARNING)) {
            LogRecord record = new LogRecord(Level.WARNING, message);
            record.setParameters(new Object[]{hook});
            record.setThrown(new RuntimeException("stack trace"));
            logger.log(record);
        }
    }

    protected void deliverSetupEventAtXmlContextCreation() {
        int snapshotSize = _sSetupHookList.size();
        for (int i = 0; i < snapshotSize; ++i) {
            XmlContextSetupHook hook = _sSetupHookList.get(i);
            this.deliverSetupEventHelper(hook);
        }
        this._alreadyNotifiedSetupHooksSize = snapshotSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverSetupEventToHooksAddedAfterCreation() {
        if (this._alreadyNotifiedSetupHooksSize == _sSetupHookList.size()) {
            return;
        }
        this.getModel().__acquireWriteLock();
        try {
            int previousSize = this._alreadyNotifiedSetupHooksSize;
            int currentSize = _sSetupHookList.size();
            if (previousSize == -1) {
                throw new IllegalStateException("XmlContext has no associated index into the XmlContextSetupHook array, indicating thatsetup hooks were not called at creation time");
            }
            for (int i = previousSize; i < currentSize; ++i) {
                XmlContextSetupHook hook = _sSetupHookList.get(i);
                this.deliverSetupEventHelper(hook);
            }
            this._alreadyNotifiedSetupHooksSize = currentSize;
        }
        finally {
            this.getModel().__releaseWriteLock();
        }
    }

    protected final void deliverSetupEventHelper(XmlContextSetupHook hook) {
        try {
            hook.setup(this);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            LogRecord record = new LogRecord(Level.SEVERE, "Exception thrown when running setup hook {0} on context {1}!");
            record.setThrown(t);
            record.setParameters(new Object[]{hook, this});
            this._logger.log(record);
        }
    }

    protected List<XmlViewFactory> getViewFactories() {
        return this._viewFactories;
    }

    protected void modelAttachmentComplete() {
        this.getClipboardManager().addFlavorListener(this._listenerImpls);
    }

    protected void disposeImpl() {
        DomModel sourceDom = this.getModel().getDomModel();
        DomModel flatDom = this.getModel().getDomModel();
        sourceDom.dispose();
        if (flatDom != sourceDom) {
            flatDom.dispose();
        }
        this._prefChangeListenerManager.dispose();
        this.getClipboardManager().removeFlavorListener(this._listenerImpls);
        this.getModel().__removeUndoableEditListener(this._listenerImpls);
        if (this._annotationModel != null) {
            this._annotationModel.removeModelListener(this._annotationModelListener);
            this._annotationModel.dispose();
        }
        this._isDisposed = true;
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        Object newValue;
        Object oldValue;
        if (event.getPropertyName() != null && ((oldValue = event.getOldValue()) == (newValue = event.getNewValue()) || oldValue != null && oldValue.equals(newValue))) {
            return;
        }
        this._deliverPropertyChange(event);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && oldValue == newValue) {
            return;
        }
        this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
    }

    protected final DomModel createDomModel(XmlModel xmlModel) {
        return this.createSourceDomModel(xmlModel);
    }

    protected abstract DomModel createSourceDomModel(XmlModel var1);

    protected ResourceBundle getBundle() {
        return this._bundle;
    }

    protected ResourceBundle createBundle() {
        return this.createBundle("oracle.bali.xml.model.resource.XmlModelBundle");
    }

    protected void fireIssueListChange() {
        new NonDomMutationTransactionTask(){

            @Override
            protected void performTask(AbstractModel model) {
                ((XmlModel)model).__sendIssueListEvent(XmlContext.this.getIssueList());
            }
        }.run(this.getModel());
    }

    protected final ResourceBundle createBundle(String bundleName) {
        Locale locale = this.getLocale();
        try {
            return ResourceBundle.getBundle(bundleName, locale, this.getClass().getClassLoader());
        }
        catch (MissingResourceException e) {
            this.getLogger().log(Level.SEVERE, "Could not load Context Bundle:" + bundleName, e);
            return null;
        }
    }

    protected Logger createLogger() {
        Logger logger = Logger.getLogger("oracle.bali.xml.model");
        return logger;
    }

    protected GrammarProvider createGrammarProvider() {
        return new XmlInstanceGrammarProvider();
    }

    protected GrammarResolver createGrammarResolver() {
        return new GrammarResolver(this.getGrammarProvider());
    }

    protected VersionManager createVersionManager() {
        return null;
    }

    protected List<BeanBaseRegistry> createBeanRegistries() {
        return Collections.emptyList();
    }

    protected AnnotationModel createAnnotationModel() {
        return NullAnnotationModel.getInstance(this);
    }

    protected AnnotationGrammar createAnnotationGrammar() {
        return NullAnnotationGrammar.getInstance();
    }

    protected AnnotationMetadataResolver createAnnotationMetadataResolver() {
        return new AnnotationMetadataResolver(this.createAnnotationMetadataProvider());
    }

    protected MetadataProvider createAnnotationMetadataProvider() {
        return NullMetadataProvider.getInstance();
    }

    protected void addAction(Action action) {
        this._actionManager.manageAction(action);
    }

    protected ClipboardManager getUnderlyingClipboardManager() {
        return _STANDALONE_CLIPBOARD_MANAGER;
    }

    protected XmlPreferenceManager createPreferenceManager(String preferenceManagerName) {
        return new XmlPreferenceManager();
    }

    protected void initOperations() {
        this.getOperationManager().registerOperationFactory(new StandardOperationFactory());
    }

    protected void initActions() {
        this.addAction(this.getClearAction());
        this.addAction(new CutAction(this.getTranslatedString("CUT_ACTION")));
        this.addAction(new CopyAction(this.getTranslatedString("COPY_ACTION")));
        this.addAction(new DuplicateAction(this.getTranslatedString("DUPLICATE_ACTION")));
        this.addAction(new PasteAction(this.getTranslatedString("PASTE_ACTION")));
        this.addAction(new XmlCustomizeAction());
    }

    protected Action getClearAction() {
        return new ClearAction(this.getTranslatedString("CLEAR_ACTION"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deliverLifecycleEvent(LifecycleEventDeliverer deliverer) {
        block9: {
            if (!this._lifecycleListeners.isEmpty()) {
                Iterator itor = this._lifecycleListeners.iterator();
                this.getModel().acquireReadLock();
                block6: while (true) {
                    while (itor.hasNext()) {
                        XmlContextLifecycleListener listener = (XmlContextLifecycleListener)itor.next();
                        try {
                            deliverer.deliverToListener(listener);
                            continue block6;
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            LogUtils.log((Logger)this.getLogger(), (Level)Level.SEVERE, (String)"Exception dispatching lifecycle event to {0} for context {1}", (Object[])new Object[]{listener, this}, (Throwable)t);
                        }
                    }
                    break block9;
                    {
                        continue block6;
                        break;
                    }
                    break;
                }
                finally {
                    this.getModel().releaseReadLock();
                }
            }
        }
    }

    protected URL getBaseUrlImpl(Object baseType, Node contextNode) {
        return null;
    }

    protected List getDefaultExtraContextMenus(XmlView view, DomPosition viewPosition) {
        return Collections.emptyList();
    }

    final void __onLockRequest() {
        if (this.getModel().isFullyInstantiated() && !this.isDisposed()) {
            this.deliverSetupEventToHooksAddedAfterCreation();
        }
    }

    final void __startTransaction(AbstractModel transactionOwner, TransactionOptions transOptions) {
        this._sourceModel.__startTransaction(transOptions);
        if (this._sourceModel != this._flattenedModel) {
            try {
                this._flattenedModel.__startTransaction(transOptions);
            }
            catch (Throwable e) {
                this._sourceModel.__rollbackTransaction();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Exception starting flattenedModel transaction", e);
            }
        }
        if (this._transactionOwners.isEmpty()) {
            this._token = null;
        } else if (this._token != null) {
            this._token.setNameIfUnset(transOptions.getDescription());
        }
        this._pushTransactionOwner(transactionOwner);
    }

    final PrecommitResults __precommitTransaction(AbstractModel transactionOwner, PrecommitOptions precommitOptions) {
        this._checkTransactionOwner(transactionOwner);
        PrecommitResults results = this.precommitTransaction(this._sourceModel, precommitOptions);
        if (this._sourceModel != this._flattenedModel && results.precommitSucceeded()) {
            results = this.precommitTransaction(this._flattenedModel, precommitOptions);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean __commitTransaction(AbstractModel transactionOwner, boolean exceptionIfInvalid) throws XmlCommitException {
        PrecommitResults precommitResults = this.__precommitTransaction(transactionOwner, PrecommitOptions.getInstance(exceptionIfInvalid));
        if (!precommitResults.precommitSucceeded()) {
            XmlCommitException fatalException = precommitResults.getFatalException();
            if (fatalException.isValidationFailure()) {
                XmlModel exceptionModel = fatalException.getSource();
                String desc = exceptionModel.getDomModel().getTransactionDescription();
                String errorFormat = exceptionModel.getTranslatedString("XML_MODEL_INVALID.TRANSACTION_MESSAGE_FORMAT");
                String errorMessage = FastMessageFormat.formatMessage(errorFormat, desc);
                String descFormat = exceptionModel.getTranslatedString("XML_MODEL_INVALID.TRANSACTION_DESC_FORMAT");
                String descMessage = FastMessageFormat.formatMessage(descFormat, desc);
                this.showErrorMessage(errorMessage, descMessage, fatalException);
            }
            throw fatalException;
        }
        this._sourceModel.__acquireWriteLock();
        try {
            this._sourceModel.__commitTransaction();
            if (this._sourceModel != this._flattenedModel) {
                this._flattenedModel.__commitTransaction();
            }
            this._popTransactionOwner();
            if (!this._sourceModel.isInTransaction()) {
                this._deliverCurrUndoableEditEventIfNeeded();
            }
        }
        finally {
            this._sourceModel.__releaseWriteLock();
        }
        return precommitResults.validationSucceeded();
    }

    final void __rollbackTransaction(AbstractModel transactionOwner) {
        this._checkTransactionOwner(transactionOwner);
        this._sourceModel.__acquireWriteLock();
        try {
            this._sourceModel.__rollbackTransaction();
            if (this._sourceModel != this._flattenedModel) {
                this._flattenedModel.__rollbackTransaction();
            }
            this._popTransactionOwner();
            if (this._transactionOwners.isEmpty()) {
                this._token = null;
            }
        }
        finally {
            this._sourceModel.__releaseWriteLock();
        }
    }

    final XmlView __getIdentityView(XmlModel model) {
        return this.__getIdentityView(model, false, true);
    }

    final XmlView __getIdentityView(XmlModel model, boolean requiresValidModel, boolean validatesTransactions) {
        IdentityView identityView;
        int index = 0;
        if (model != this.getModel()) {
            if (model == this.getSourceModel()) {
                index += 4;
            } else {
                throw new IllegalArgumentException("Unknown model:" + model);
            }
        }
        if (requiresValidModel) {
            index += 2;
        }
        if (validatesTransactions) {
            ++index;
        }
        if ((identityView = this._identityViews[index]) == null) {
            this._identityViews[index] = identityView = new IdentityView(requiresValidModel, validatesTransactions);
        }
        return identityView;
    }

    void __setAbortFlag(XmlModel model) {
        model.acquireReadLock();
        try {
            TransactionToken token = this.getTransactionToken();
            if (token != null) {
                token.setAbortOnCompletion();
            }
        }
        finally {
            model.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node _mapNodeToDocument(Document targetDocument, Node sourceNode) {
        if (targetDocument == null) {
            return null;
        }
        List list = this._mappingList;
        synchronized (list) {
            List oldNodePath = DomUtils.getNodePath((Node)sourceNode, (List)this._mappingList);
            int pathNodeCount = oldNodePath.size();
            if (pathNodeCount == 0) {
                return null;
            }
            int lastNodeIndex = pathNodeCount - 1;
            Node lastNode = (Node)oldNodePath.get(lastNodeIndex);
            Document nodeDocument = lastNode.getOwnerDocument();
            if (nodeDocument == targetDocument) {
                if (DomUtils.isInDocumentHierarchy((Node)lastNode)) {
                    return lastNode;
                }
                ListIterator backwardsIterator = oldNodePath.listIterator(lastNodeIndex);
                while (backwardsIterator.hasPrevious()) {
                    Node currNode = (Node)backwardsIterator.previous();
                    if (!DomUtils.isInDocumentHierarchy((Node)currNode)) continue;
                    return currNode;
                }
                return null;
            }
            Node lastEqualNewNode = targetDocument;
            Node currNewNode = lastEqualNewNode;
            for (Node currOldNode : oldNodePath) {
                int oldIndex = DomUtils.getChildIndex((Node)currOldNode);
                if ((currNewNode = currNewNode.getChildNodes().item(oldIndex)) == null) break;
                short newNodeType = currNewNode.getNodeType();
                if (currOldNode.getNodeType() != newNodeType) break;
                if (newNodeType == 1) {
                    String oldLocalName;
                    String newLocalName = DomUtils.getLocalName((Node)currNewNode);
                    if (!newLocalName.equals(oldLocalName = DomUtils.getLocalName((Node)currOldNode))) break;
                    String newNamespaceURI = currNewNode.getNamespaceURI();
                    String oldNamespaceURI = currOldNode.getNamespaceURI();
                    if (newNamespaceURI == null) {
                        newNamespaceURI = "";
                    }
                    if (oldNamespaceURI == null) {
                        oldNamespaceURI = "";
                    }
                    if (!newNamespaceURI.equals(oldNamespaceURI)) break;
                }
                lastEqualNewNode = currNewNode;
            }
            return lastEqualNewNode;
        }
    }

    private void _deliverPropertyChange(PropertyChangeEvent event) {
        List listenersList = this._getPropertyChangeListenersList();
        int listenerCount = listenersList.size();
        for (int i = 0; i < listenerCount; ++i) {
            PropertyChangeListener currListener = (PropertyChangeListener)listenersList.get(i);
            try {
                currListener.propertyChange(event);
                continue;
            }
            catch (Throwable t) {
                this.getLogger().log(Level.INFO, "Unexpected throwable in listener:" + currListener, t);
            }
        }
    }

    private List _getPropertyChangeListenersList() {
        if (this._propertyChangeListenersList == null) {
            this._propertyChangeListenersList = new ArrayList(this._propertyChangeListeners);
        }
        return this._propertyChangeListenersList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlView _initializeViewIfNecessary(XmlModel baseModel, XmlView view) {
        if (view.getBaseModel() == null) {
            baseModel.acquireReadLock();
            try {
                view.__attachBaseModel(baseModel);
                view.baseModelAttached();
                view.postAttachmentHook();
                view.__initializationComplete();
                view.postCreationHook();
            }
            catch (Throwable e) {
                this.getLogger().log(Level.SEVERE, "View creation failed for " + view, e);
                view = null;
            }
            finally {
                baseModel.releaseReadLock();
            }
        }
        return view;
    }

    private final void _setFlattenedModel(XmlModel model) {
        block5: {
            if (this._bundle == null) {
                throw new IllegalStateException("finishInitialization() not called on constructed XmlContext instance");
            }
            if (model == null) {
                throw new IllegalArgumentException("No XmlModel specified");
            }
            if (this._flattenedModel != null) {
                throw new IllegalStateException("Can not set model on context twice!");
            }
            this._flattenedModel = model;
            try {
                this._initializeModel(model);
            }
            catch (Throwable t) {
                this._flattenedModel = null;
                LogRecord record = new LogRecord(Level.SEVERE, "Exception thrown when initializing model:" + model);
                record.setThrown(t);
                this.getLogger().log(record);
                if (!(t instanceof RuntimeException)) break block5;
                throw (RuntimeException)t;
            }
        }
    }

    private void _setSourceModel(XmlModel sourceModel) {
        block4: {
            if (sourceModel == null) {
                throw new IllegalArgumentException("No XmlModel specified");
            }
            if (this._sourceModel != null) {
                throw new IllegalStateException("Can not set model on context twice!");
            }
            this._sourceModel = sourceModel;
            try {
                this._initializeModel(sourceModel);
            }
            catch (Throwable t) {
                this._sourceModel = null;
                LogRecord record = new LogRecord(Level.SEVERE, "Exception thrown when initializing model:" + sourceModel);
                record.setThrown(t);
                this.getLogger().log(record);
                if (!(t instanceof RuntimeException)) break block4;
                throw (RuntimeException)t;
            }
        }
    }

    private void _deliverCurrUndoableEditEventIfNeeded() {
        this._sourceModel.__verifyWriteLock();
        if (!this._currUndoableEdits.isEmpty()) {
            UndoableEdit edit = MultiUndoableEdit.createEdit(this._currUndoableEdits);
            this._currUndoableEdits.clear();
            if (edit != null) {
                this._deliverUndoableEditEvent(new UndoableEditEvent(this, edit));
            }
        }
        TransactionToken.dispatch(this._token, this, true);
        this._token = null;
    }

    private void _deliverUndoableEditEvent(UndoableEditEvent undoEvent) {
        Iterator itor = this._undoListeners.iterator();
        while (itor.hasNext()) {
            try {
                ((UndoableEditListener)itor.next()).undoableEditHappened(undoEvent);
            }
            catch (Throwable e) {
                this.getLogger().log(Level.WARNING, "Unexpected exception when delivering UndoableEditEvent", e);
            }
        }
    }

    @Override
    protected void flushPendingEvents() {
        this._sourceModel.__acquireWriteLock();
        try {
            XmlModel sourceModel = this.getSourceModel();
            XmlModel flatModel = this.getModel();
            sourceModel.__deliverPendingXmlModelEventIfNeeded();
            if (sourceModel != flatModel) {
                flatModel.__deliverPendingXmlModelEventIfNeeded();
            }
            this._deliverCurrUndoableEditEventIfNeeded();
        }
        finally {
            this._sourceModel.__releaseWriteLock();
        }
    }

    private void _checkTransactionOwner(AbstractModel assumedOwner) {
        this._sourceModel.__verifyLock();
        int lastIndex = this._transactionOwners.size() - 1;
        if (_sSaveTransactionStackTraces) {
            --lastIndex;
        }
        AbstractModel expectedOwner = null;
        boolean expectedOwnerFound = true;
        if (lastIndex > -1) {
            expectedOwner = (AbstractModel)this._transactionOwners.get(lastIndex);
        } else {
            expectedOwnerFound = false;
        }
        if (assumedOwner != expectedOwner || !expectedOwnerFound) {
            String message = !expectedOwnerFound ? "No transaction open on:" + this : "Transaction owner mismatch for transaction. Expected transaction owner:" + expectedOwner + " not " + assumedOwner + ". ";
            Object logMessage = message;
            if (_sSaveTransactionStackTraces) {
                StringBuffer stackTraces = new StringBuffer(1000);
                for (int i = ++lastIndex; i >= 0; --i) {
                    Throwable currThrowable = (Throwable)this._transactionOwners.get(i);
                    AbstractModel currOwner = (AbstractModel)this._transactionOwners.get(--i);
                    stackTraces.append("\nOwner:");
                    stackTraces.append(currOwner);
                    stackTraces.append("\nStarted at:");
                    StackTraceElement[] elements = currThrowable.getStackTrace();
                    int traceCount = elements.length;
                    for (int traceIndex = 0; traceIndex < traceCount; ++traceIndex) {
                        stackTraces.append(elements[traceIndex]);
                        stackTraces.append('\n');
                    }
                }
                stackTraces.insert(0, (String)logMessage);
                logMessage = stackTraces.toString();
            } else {
                logMessage = (String)logMessage + "\nTo get stack traces of all current transactions, rerun the application with '-Doracle.bali.xml.transactionStacks=true'\n";
            }
            IllegalStateException exception = new IllegalStateException(message);
            this.getLogger().log(Level.SEVERE, (String)logMessage, exception);
            throw exception;
        }
    }

    private void _pushTransactionOwner(AbstractModel transactionOwner) {
        this._sourceModel.__verifyWriteLock();
        this._transactionOwners.add(transactionOwner);
        if (_sSaveTransactionStackTraces) {
            this._transactionOwners.add(new Exception("Transaction start stack trace"));
        }
    }

    private void _popTransactionOwner() {
        this._sourceModel.__verifyWriteLock();
        int lastIndex = this._transactionOwners.size() - 1;
        if (_sSaveTransactionStackTraces) {
            this._transactionOwners.remove(lastIndex);
            --lastIndex;
        }
        this._transactionOwners.remove(lastIndex);
    }

    private void _requireInTransaction() {
        this._sourceModel.__verifyWriteLock();
        if (!this._sourceModel.isInTransaction()) {
            throw new IllegalStateException("must be in transaction!");
        }
    }

    static {
        _sViewThreadLocalMap = new ThreadLocal();
        String saveTransactionStacks = System.getProperty(_SAVE_TRANSACTION_STACKS_SYSTEM_PROPERTY, "false");
        _sSaveTransactionStackTraces = saveTransactionStacks.equalsIgnoreCase("true");
    }

    private class ListenerImpls
    implements ChangeListener,
    UndoableEditListener {
        private ListenerImpls() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            XmlModel model = XmlContext.this.getSourceModel();
            if (model != null && !model.isInTransaction()) {
                XmlContext.this.firePropertyChange(XmlContext.CLIPBOARD_FLAVORS_PROPERTY, null, _UNSET_VALUE);
            }
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            Object undoSource = e.getSource();
            UndoableEdit edit = e.getEdit();
            if (undoSource == XmlContext.this._sourceModel || undoSource == XmlContext.this._flattenedModel) {
                XmlContext.this._currUndoableEdits.add(edit);
            } else assert (false) : "unexpected undo source for:" + e;
        }
    }

    private class XmlContextAnnotationModelListener
    implements AnnotationModelListener {
        private final Logger _LOGGER = Logger.getLogger(XmlContextAnnotationModelListener.class.getName());

        private XmlContextAnnotationModelListener() {
        }

        @Override
        public void annotationModelChanged(AnnotationModelEvent e) {
            XmlContext.this.getModel().__propogateAnnotationModelChangedEvent(e);
        }

        @Override
        public void annotationModelDisposed(AnnotationModelEvent e) {
            XmlModel model = XmlContext.this.getModel();
            model.__acquireWriteLock();
            try {
                if (model.isInTransaction()) {
                    this._LOGGER.log(Level.WARNING, "Annotation model disposed during an open transaction on the instance model");
                } else {
                    if (XmlContext.this._annotationModel != null) {
                        XmlContext.this._annotationModel.removeModelListener(this);
                    }
                    XmlContext.this._annotationModel = null;
                    XmlContext.this._annotationGrammar = null;
                    XmlContext.this._annotationMetadataResolver = null;
                }
            }
            finally {
                model.__releaseWriteLock();
            }
        }
    }

    private static class PreferenceChangeListenersManager
    implements PropertyChangeListener {
        private final SafeListenerManager _listeners = new SafeListenerManager();
        private final XmlPreferenceManager _prefManager;
        private final WeakReference _weakContext;
        private boolean _isAttached = false;
        private static final Logger _LOGGER = Logger.getLogger(PreferenceChangeListenersManager.class.getName());

        PreferenceChangeListenersManager(XmlContext context) {
            this._weakContext = new WeakReference<XmlContext>(context);
            this._prefManager = context.getPreferenceManager();
        }

        public synchronized void addListener(PropertyChangeListener pcl) {
            if (!this._isAttached) {
                this._prefManager.addPreferenceChangeListener(this);
                this._isAttached = true;
            }
            this._listeners.addListener(pcl);
            this._debugListeners();
        }

        public synchronized void removeListener(PropertyChangeListener pcl) {
            this._listeners.removeListener(pcl);
            if (this._listeners.isEmpty()) {
                this.dispose();
            }
            this._debugListeners();
        }

        public synchronized void dispose() {
            if (this._isAttached) {
                this._prefManager.removePreferenceChangeListener(this);
                this._isAttached = false;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XmlContext context = (XmlContext)this._weakContext.get();
            if (context == null) {
                this.dispose();
            } else {
                Iterator itor = this._listeners.iterator();
                while (itor.hasNext()) {
                    PropertyChangeListener pcl = (PropertyChangeListener)itor.next();
                    try {
                        pcl.propertyChange(evt);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        LogUtils.log((Logger)_LOGGER, (Level)Level.SEVERE, (String)"Exception notifiying preference listener {0}", (Object)pcl, (Throwable)t);
                    }
                }
            }
        }

        private void _debugListeners() {
            if (_LOGGER.isLoggable(Level.FINER)) {
                StringBuffer buf = new StringBuffer();
                Iterator itor = this._listeners.iterator();
                while (itor.hasNext()) {
                    buf.append(" ");
                    buf.append(itor.next());
                }
                _LOGGER.log(Level.FINER, "Preference listeners for {0}:{1}", new Object[]{this._weakContext.get(), buf});
            }
        }
    }

    protected static interface LifecycleEventDeliverer {
        public void deliverToListener(XmlContextLifecycleListener var1);
    }

    private static class NullXmlContextSetupHook
    implements XmlContextSetupHook {
        private NullXmlContextSetupHook() {
        }

        @Override
        public void setup(XmlContext context) {
        }
    }
}

