/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bali.xml.dom.DomParseProblem;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.grammar.schema.error.XmlErrorLog;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WellFormednessChecker {
    private final BufferDomModel _model;
    private static final Pattern _XDK_ERR_PATTERN = Pattern.compile("(<Line [0-9]+, Column [0-9]+>:)? ([^:]+): \\(([^)]+)\\) (.*)", 32);
    private static final Logger _LOGGER = Logger.getLogger(WellFormednessChecker.class.getName());
    private static final int _MAX_ENTITY_EXPANSION_COUNT = 256000;

    public static XmlErrorLog doWFCheck(Locale locale, InputSource source) {
        return WellFormednessChecker.doWFCheck(locale, source, null);
    }

    public static XmlErrorLog doWFCheck(Locale locale, InputSource source, TextBuffer buffer) {
        XmlErrorLog log = new XmlErrorLog();
        SAXParser parser = new SAXParser();
        try {
            parser.setLocale(locale);
        }
        catch (SAXException e) {
            _LOGGER.log(Level.WARNING, "SAXException encountered in SAXParser.setLocale", e);
        }
        parser.setDoctype(new DTD());
        parser.setValidationMode(0);
        parser.setErrorHandler((ErrorHandler)log);
        try {
            parser.setProperty("oracle.xdkjava.security.entityExpansionCountLimit", (Object)256000);
            parser.parse(source);
        }
        catch (IOException e) {
        }
        catch (XMLParseException e) {
        }
        catch (SAXException e) {
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            Object errorMsg = "Unexpected exception from XDK in WFCheck.";
            if (buffer != null) {
                errorMsg = (String)errorMsg + "\n Document contents: \n " + buffer.getString(0, buffer.getLength());
            }
            _LOGGER.log(Level.SEVERE, (String)errorMsg, t);
            SAXParseException spe = new SAXParseException(t.getMessage(), null);
            spe.initCause(t);
            try {
                log.fatalError(spe);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return log;
    }

    public WellFormednessChecker(BufferDomModel model) {
        this._model = model;
    }

    public List check() {
        Logger log = _LOGGER;
        if (log.isLoggable(Level.FINER)) {
            long before = System.currentTimeMillis();
            List ret = this._check();
            long after = System.currentTimeMillis();
            long delta = after - before;
            log.log(Level.FINER, "WFCheck completed in {0}ms", delta);
            return ret;
        }
        return this._check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List _check() {
        Reader reader = null;
        try {
            reader = TextBufferFactory.createReader((ReadTextBuffer)this._getBuffer());
            InputSource source = new InputSource(reader);
            XmlErrorLog log = WellFormednessChecker.doWFCheck(this._model.getContext().getDomModelContext().getLocale(), source, this._getBuffer());
            List list = this._processLog(log);
            return list;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    _LOGGER.log(Level.SEVERE, "IOException closing text buffer reader", e);
                }
            }
        }
    }

    private TextBuffer _getBuffer() {
        return this._model.getTextBuffer();
    }

    private LocatorManager _getLocatorManager() {
        return this._model.getLocatorManager();
    }

    private List _processLog(XmlErrorLog log) {
        XmlErrorLog.Error[] errors = log.getErrors();
        XmlErrorLog.Error[] fatals = log.getFatalErrors();
        XmlErrorLog.Error[] warnings = log.getWarnings();
        ArrayList list = new ArrayList(errors.length + fatals.length + warnings.length);
        this._appendErrors(list, errors, 2);
        this._appendErrors(list, fatals, 3);
        this._appendErrors(list, warnings, 1);
        return list;
    }

    private void _appendErrors(List list, XmlErrorLog.Error[] errors, int severity) {
        for (int i = 0; i < errors.length; ++i) {
            XmlErrorLog.Error err = errors[i];
            int offset = this._getOffset(err.getLine() - 1, err.getColumn() - 1, err);
            SimpleLocator locator = offset >= 0 ? this._createLocator(offset, offset) : null;
            String message = err.getMessage();
            String errCode = null;
            Matcher msgMatcher = _XDK_ERR_PATTERN.matcher(message);
            if (msgMatcher.matches()) {
                message = msgMatcher.group(4);
                errCode = msgMatcher.group(2);
            }
            WFError wferr = new WFError(severity, message, errCode, locator);
            list.add(wferr);
        }
    }

    private SimpleLocator _createLocator(int start, int end) {
        return this._getLocatorManager().createSimpleLocator(start, end, true);
    }

    private int _getOffset(int line, int col, XmlErrorLog.Error err) {
        if (line >= 0) {
            LineMap lineMap = this._getBuffer().getLineMap();
            int lineCount = lineMap.getLineCount();
            if (line >= lineCount) {
                return this._bogusOffsetLineColumn(err, line, col, "Line # > line count");
            }
            int offset = lineMap.getLineStartOffset(line);
            if (offset >= 0) {
                int lineEndOffset;
                boolean endOk;
                if (col > 0) {
                    offset += col;
                }
                boolean bl = endOk = offset <= (lineEndOffset = lineMap.getLineEndOffset(line)) || line == lineCount - 1 && offset + 1 == lineEndOffset;
                if (!endOk && line == lineCount - 1 && offset + 1 == lineEndOffset + 2) {
                    endOk = true;
                }
                if (!endOk && line == lineCount - 2 && offset + 1 == lineEndOffset + 2) {
                    endOk = true;
                }
                if (!endOk && offset == 16356) {
                    endOk = true;
                }
                if (!endOk) {
                    return this._bogusOffsetLineColumn(err, line, col, "Offset (" + offset + ") exceeds end of the line");
                }
                return offset;
            }
        }
        return -1;
    }

    private int _bogusOffsetLineColumn(XmlErrorLog.Error err, int line, int column, String detail) {
        TextBuffer buffer = this._getBuffer();
        int bufferSize = buffer.getLength();
        int lineMapCount = buffer.getLineMap().getLineCount();
        String bufferText = buffer.getString(0, bufferSize);
        _LOGGER.log(Level.WARNING, "Out of bounds error location detected: {0}. line={1} column={2} error={3} LineMap.count={4} bufferSize={5}", new Object[]{detail, String.valueOf(line), String.valueOf(column), err, String.valueOf(lineMapCount), String.valueOf(bufferSize)});
        return -1;
    }

    public class WFError
    extends DomParseProblem {
        private final int _severity;
        private final String _message;
        private final String _errCode;
        private SimpleLocator _locator;

        public WFError(int severity, String message, String errCode, SimpleLocator locator) {
            this._severity = severity;
            this._message = message;
            this._errCode = errCode;
            this._locator = locator;
        }

        @Override
        public String getMessage() {
            return this._message;
        }

        @Override
        public String getErrCode() {
            return this._errCode;
        }

        @Override
        public int getProblemTextEndOffset() {
            if (this._locator != null) {
                return this._locator.getEndOffset();
            }
            return super.getProblemTextEndOffset();
        }

        @Override
        public int getProblemTextStartOffset() {
            if (this._locator != null) {
                return this._locator.getStartOffset();
            }
            return super.getProblemTextStartOffset();
        }

        @Override
        public int getSeverity() {
            return this._severity;
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this._locator != null) {
                WellFormednessChecker.this._getLocatorManager().detach(this._locator);
            }
            this._locator = null;
        }

        @Override
        public int getLineNumber() {
            if (this._locator != null) {
                return this._locator.getLineNumber();
            }
            return -1;
        }

        @Override
        public int getColumnNumber() {
            if (this._locator != null) {
                return this._locator.getColumnNumber();
            }
            return -1;
        }

        @Override
        public String toString() {
            return "[" + this.getProblemTextStartOffset() + " - " + this.getProblemTextEndOffset() + "] " + this.getMessage() + " (severity " + this.getSeverity() + ")";
        }
    }
}

