/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextSyncConfiguration {
    private static final TextSyncConfiguration _DEFAULT = new TextSyncConfiguration();

    public static TextSyncConfiguration getDefault() {
        return _DEFAULT;
    }

    public String getStartTagBeginning(Element element) {
        return "<";
    }

    public String getStartTagName(Element element) {
        return element.getNodeName();
    }

    public String getStartTagEnd(Element element) {
        return ">";
    }

    public String getEndTag(Element element) {
        return "</" + element.getNodeName() + ">";
    }

    public boolean allowsAttributes(Element element) {
        return true;
    }

    public boolean allowsMinimizedForm(Element element) {
        return true;
    }

    public String getCommentStart(Comment comment) {
        return "<!--";
    }

    public String getCommentEnd(Comment comment) {
        return "-->";
    }

    public String getEntityToOutput(Node node, Character quoteStyle, char c) {
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                if (!DomUtils.isText((Node)node)) break;
                return "&gt;";
            }
            case '\"': {
                if (quoteStyle == null || c != quoteStyle.charValue()) break;
                return "&quot;";
            }
            case '\'': {
                if (quoteStyle == null || c != quoteStyle.charValue()) break;
                return "&apos;";
            }
        }
        return null;
    }

    public boolean omitAttributeName(Attr attr) {
        return false;
    }

    protected TextSyncConfiguration() {
    }
}

