/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.shutdown;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonException;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BaseTraversablePanel;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class MgmtInstTraversablePanel
extends BaseTraversablePanel {
    public static final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.host"), Messages.getString("TimesTenGrid.instanceColumn"), Messages.getString("TimesTenGrid.daemonstatus"), Messages.getString("TimesTenGrid.serverstatus"), Messages.getString("TimesTenGrid.role"), Messages.getString("TimesTenGrid.repAgentStatus")};
    private static final long serialVersionUID = 1L;
    private List<InstanceObject> mgmtInsts = new ArrayList<InstanceObject>();
    private boolean commandExecuted = false;

    public MgmtInstTraversablePanel() {
        super(false);
        this.initGUI();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.model = new MgmtInstancesModel();
        this._objTable = new JTable(this.model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                string = MgmtInstTraversablePanel.this._objTable.getValueAt(n, n2).toString();
                return string;
            }
        };
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this._objTable.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        TableColumnModel tableColumnModel = this._objTable.getColumnModel();
        tableColumnModel.getColumn(MgmtColIdx.HOST.getValue()).setCellRenderer(this.centerRenderer);
        tableColumnModel.getColumn(MgmtColIdx.INSTANCE.getValue()).setCellRenderer(this.centerRenderer);
        IconTextCellRenderer iconTextCellRenderer = new IconTextCellRenderer();
        tableColumnModel.getColumn(MgmtColIdx.DAEMON.getValue()).setCellRenderer(iconTextCellRenderer);
        tableColumnModel.getColumn(MgmtColIdx.SERVER.getValue()).setCellRenderer(iconTextCellRenderer);
        tableColumnModel.getColumn(MgmtColIdx.ROLE.getValue()).setCellRenderer(this.centerRenderer);
        tableColumnModel.getColumn(MgmtColIdx.REP_AGENT.getValue()).setCellRenderer(iconTextCellRenderer);
        this._objTable.setRowHeight(30);
        TableColumnSizer.setColumnsWidthToFit(this._objTable, true, true);
        this.add(new JScrollPane(this._objTable), new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.dataContext = traversableContext;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        this.mgmtInsts = this.currentGrid.getAllMgmtInstances();
        this.launchUpdater();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.refreshIntervalCmb.setSelectedIndex(0);
        this.shutdownAutoRefresh();
    }

    @Override
    protected void executeCommand() {
        try {
            InstanceObject instanceObject;
            String string;
            GridCommand gridCommand;
            if (this.mgmtInsts.size() > 1) {
                gridCommand = GridCommand.MGMT_STANDBY_STOP;
                boolean bl = false;
                InstanceObject instanceObject2 = this.getInstance(InstanceObject.ManagementInstanceRole.STANDBY);
                if (instanceObject2 == null || instanceObject2.isStatusAvailable() && !instanceObject2.getCSState() && !instanceObject2.getDaemonStatus()) {
                    bl = true;
                } else {
                    string = MessageFormat.format(Messages.getString("TimestenGrid.mgmtStandbyStop"), instanceObject2.getFullName());
                    this.worker.firePropertyChange("message", null, string);
                    this.printMessageInPanel(string);
                }
                if (!bl) {
                    try {
                        this.currentGrid.getExecutor().executeCommandGetJson(gridCommand, true);
                        if (this.currentGrid.getExecutor().getSSHChannel().getLastCommandExitStatus() == 0 && instanceObject2 != null) {
                            instanceObject2.setDaemonStatus(false);
                            instanceObject2.setCSState(false);
                            instanceObject2.setRepAgentStatus(Common.RepAgentStatus.DOWN);
                        }
                    }
                    catch (GridCommandException gridCommandException) {
                        logger.warning(gridCommandException.getMessage());
                        this.worker.firePropertyChange("message", null, gridCommandException.getMessage());
                        this.printMessageInPanel(gridCommandException.getMessage());
                    }
                    this.commandExecuted = true;
                }
            }
            if ((instanceObject = this.getInstance(InstanceObject.ManagementInstanceRole.ACTIVE)) == null) {
                throw new GridCommandException(Messages.getString("TimestenGrid.noActiveMgmtInst"));
            }
            string = MessageFormat.format(Messages.getString("TimestenGrid.mgmtActiveStop"), instanceObject.getFullName());
            this.worker.firePropertyChange("message", null, string);
            this.printMessageInPanel(string);
            gridCommand = GridCommand.MGMT_ACTIVE_STOP;
            this.currentGrid.getExecutor().executeCommandGetJson(gridCommand, true);
            if (this.currentGrid.getExecutor().getSSHChannel().getLastCommandExitStatus() == 0) {
                instanceObject.setDaemonStatus(false);
                instanceObject.setCSState(false);
                instanceObject.setRepAgentStatus(Common.RepAgentStatus.DOWN);
                this.commandExecuted = true;
            }
            this.currentGrid.disconnect();
        }
        catch (GridCommandException gridCommandException) {
            logger.severe(gridCommandException.getMessage());
            this.printMessageInPanel(gridCommandException.getMessage());
        }
    }

    @Override
    protected void updateStatus(boolean bl) throws GridCommandException, JsonException {
        InstanceObject instanceObject = this.currentGrid.getInstance(this.currentGrid.getExecutor().getWorkingHost().getHostName(), this.currentGrid.getExecutor().getWorkingHost().getInstanceName());
        if (this.commandExecuted && instanceObject != null && instanceObject.getDaemonStatus() || !this.commandExecuted) {
            GridCommand gridCommand = GridCommand.TT_STATUS_ALL;
            this.worker.firePropertyChange("message", null, Messages.getString("TimesTenGrid.getMgmtInstStatus"));
            ArrayList<GridCommandExecutor.ExecOutput> object = this.currentGrid.getExecutor().execCommand(this.mgmtInsts, gridCommand, false, BaseTraversablePanel.InstanceActionPanelInstanceType.MGMT.getExecMode(), 600);
            for (GridCommandExecutor.ExecOutput execOutput : object) {
                execOutput.setInstanceStatus();
            }
            this.currentGrid.updateMgmInstancesModel(this.currentGrid.getExecutor().executeCommandGetJson(GridCommand.MGMT_EXAMINE, true));
        }
        this.updateLastRefresh();
        this.allRight = true;
        for (InstanceObject instanceObject2 : this.mgmtInsts) {
            if (!instanceObject2.getDaemonStatus() || !instanceObject2.getCSState()) continue;
            this.allRight = false;
            break;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateGUIComponents();
        } else {
            SwingUtilities.invokeLater(() -> this.updateGUIComponents());
        }
        if (this.allRight && bl) {
            this.printMessageInPanel(Messages.getString("TimesTenGrid.mgmtInstStopped"));
        }
    }

    private void updateGUIComponents() {
        this.enableWizardButtons();
        this.actionBtn.setEnabled(!this.allRight);
        this.model.fireTableDataChanged();
    }

    @Override
    protected void enableWizardButtons() {
        this.dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(!this.allRight), Boolean.valueOf(false), Boolean.valueOf(this.allRight));
    }

    private InstanceObject getInstance(InstanceObject.ManagementInstanceRole managementInstanceRole) {
        for (InstanceObject instanceObject : this.mgmtInsts) {
            if (instanceObject.getType() != managementInstanceRole) continue;
            return instanceObject;
        }
        return null;
    }

    private class MgmtInstancesModel
    extends AbstractTableModel {
        private MgmtInstancesModel() {
        }

        @Override
        public int getRowCount() {
            return MgmtInstTraversablePanel.this.mgmtInsts.size();
        }

        @Override
        public int getColumnCount() {
            return HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == MgmtColIdx.HOST.getValue()) {
                return MgmtInstTraversablePanel.this.mgmtInsts.get(n).getHost().getName();
            }
            if (n2 == MgmtColIdx.INSTANCE.getValue()) {
                return MgmtInstTraversablePanel.this.mgmtInsts.get(n).getName();
            }
            if (n2 == MgmtColIdx.DAEMON.getValue()) {
                return MgmtInstTraversablePanel.this.mgmtInsts.get(n).getDaemonStatus();
            }
            if (n2 == MgmtColIdx.SERVER.getValue()) {
                return MgmtInstTraversablePanel.this.mgmtInsts.get(n).getCSState();
            }
            if (n2 == MgmtColIdx.ROLE.getValue()) {
                return MgmtInstTraversablePanel.this.mgmtInsts.get(n).getType();
            }
            if (n2 == MgmtColIdx.REP_AGENT.getValue()) {
                return MgmtInstTraversablePanel.this.mgmtInsts.get(n).getRepAgentStatus();
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    }

    public static enum MgmtColIdx {
        HOST(0),
        INSTANCE(1),
        DAEMON(2),
        SERVER(3),
        ROLE(4),
        REP_AGENT(5);

        private final int value;

        private MgmtColIdx(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }

    private class IconTextCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private IconTextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = false;
            if (n2 == MgmtColIdx.DAEMON.getValue() || n2 == MgmtColIdx.SERVER.getValue()) {
                bl3 = (Boolean)object;
                if (MgmtInstTraversablePanel.this.currentGrid.getAllMgmtInstances().get(n).isStatusAvailable()) {
                    jLabel.setText(bl3 ? Messages.getString("TimesTenGrid.up") : Messages.getString("TimesTenGrid.down"));
                    jLabel.setIcon(bl3 ? Common.UP_ICON : Common.DOWN_ICON);
                } else {
                    jLabel.setText(Messages.getString("TimesTen.common.unknown"));
                    jLabel.setIcon(null);
                }
            } else if (n2 == MgmtColIdx.REP_AGENT.getValue()) {
                Common.RepAgentStatus repAgentStatus = (Common.RepAgentStatus)((Object)object);
                jLabel.setText(repAgentStatus.toString());
                switch (repAgentStatus) {
                    case UP: {
                        jLabel.setIcon(Common.UP_ICON);
                        break;
                    }
                    case DOWN: {
                        jLabel.setIcon(Common.DOWN_ICON);
                        break;
                    }
                    default: {
                        jLabel.setText("");
                        jLabel.setIcon(null);
                        break;
                    }
                }
            } else {
                jLabel.setText(object.toString());
                jLabel.setIcon(null);
            }
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }
    }
}

