/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.editors.SummaryPanel;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpInfo;

public class InstallationEditor
extends TTBaseEditor
implements Controller {
    private SummaryPanel _summaryPanel;
    private HostObject currentHost;
    private InstallationObject currentInstallation;
    static List<String> INSTALLATION_SUMMARY = new ArrayList<String>();
    private static Logger logger;

    public InstallationEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this._summaryPanel = new SummaryPanel();
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.summary"), this._summaryPanel);
            this.helpInfo = new HelpInfo(TimesTenHelpID.INSTALLATION_EDITOR.toString());
            this.initialized = true;
        }
    }

    @Override
    public void updateContent() {
        this.currentHost = this.currentGrid.getHost(TTGridRootNode.getInstance().getCurrentHost());
        this.currentInstallation = this.currentHost.getInstallation(this.context.getNode().getShortLabel());
        this.updateContentHelper();
    }

    public List<String> getValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = INSTALLATION_SUMMARY.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add("");
        }
        arrayList.set(0, this.currentInstallation.getName());
        arrayList.set(1, this.currentInstallation.getLocation());
        arrayList.set(2, this.currentInstallation.getSource());
        arrayList.set(3, this.currentInstallation.getSourceRelease());
        return arrayList;
    }

    private void updateContentHelper() {
        ArrayList<String> arrayList = new ArrayList<String>(INSTALLATION_SUMMARY);
        List<String> list = this.getValues();
        this.context.setProperty("SummaryAttr", arrayList);
        this.context.setProperty("SummaryVals", list);
        this._summaryPanel.loadContent(this.context);
    }

    private void refreshInfo() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){
            StringBuilder errorMessage;
            {
                this.errorMessage = new StringBuilder("");
            }

            protected Void doWork() throws TaskException {
                JsonObject jsonObject = null;
                try {
                    jsonObject = InstallationEditor.this.currentGrid.getSynchronizedWithModel(true);
                    if (!InstallationEditor.this.currentGrid.updateHostModel(jsonObject, InstallationEditor.this.currentHost.getName())) {
                        throw new GridCommandException(Messages.getString("TimesTenGrid.installNotExistent"));
                    }
                }
                catch (JsonException | GridCommandException throwable) {
                    this.errorMessage.append(throwable.getMessage());
                }
                if (!this.errorMessage.toString().isEmpty()) {
                    logger.log(Level.SEVERE, this.errorMessage.toString());
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), this.errorMessage.toString());
                } else {
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            InstallationEditor.this.currentHost = InstallationEditor.this.currentGrid.getHost(InstallationEditor.this.currentHost.getName());
                            InstallationEditor.this.currentInstallation = InstallationEditor.this.currentHost.getInstallation(InstallationEditor.this.currentInstallation.getName());
                            InstallationEditor.this.updateContentHelper();
                        });
                    }
                    catch (InterruptedException | InvocationTargetException exception) {
                        logger.log(Level.SEVERE, "Exception while updating installation panels:" + exception.getMessage());
                    }
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(MessageFormat.format(Messages.getString("TimesTenGrid.updateInstallInfoTask"), this.context.getNode().getShortLabel()));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.context = context;
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == REFRESH_ID) {
            this.refreshInfo();
            return true;
        }
        return false;
    }

    static {
        INSTALLATION_SUMMARY.add(Messages.getString("TimesTen.common.name"));
        INSTALLATION_SUMMARY.add(Messages.getString("TimesTenGrid.location"));
        INSTALLATION_SUMMARY.add(Messages.getString("TimesTenGrid.source"));
        INSTALLATION_SUMMARY.add(Messages.getString("TimesTenGrid.release"));
        logger = Logger.getLogger(InstallationEditor.class.getName());
    }
}

